/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.io.Serializable;
import java.util.List;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.atompub.ValueAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlProperty
implements Property {
    public static final Serializable NULL = NoValue.NO_VALUE;
    private PropertyDefinition def;
    private Serializable value;
    private Object xmlValue;

    public XmlProperty(String id) {
        this.value = id;
    }

    public XmlProperty(String id, String xmlValue) {
        this.value = id;
        this.xmlValue = xmlValue;
    }

    public XmlProperty(String id, List<String> xmlValue) {
        this.value = id;
        this.xmlValue = xmlValue;
    }

    public XmlProperty(PropertyDefinition def) {
        this.def = def;
        this.value = NULL;
    }

    public XmlProperty(PropertyDefinition def, String xmlValue) {
        this.def = def;
        this.xmlValue = xmlValue;
        this.value = NULL;
    }

    public String getId() {
        return this.def == null ? (String)((Object)this.value) : this.def.getId();
    }

    public ValueAdapter getAdapter() {
        if (this.def == null) {
            throw new NullPointerException("No definition set for: " + this);
        }
        return ValueAdapter.getAdapter(this.def.getType());
    }

    @Override
    public Serializable getValue() {
        if (this.value == NULL) {
            if (this.xmlValue == null) {
                this.value = this.def.getDefaultValue();
            } else {
                ValueAdapter va = this.getAdapter();
                if (va == null) {
                    throw new IllegalArgumentException("Unknow property type: " + this.def.getType());
                }
                if (this.xmlValue instanceof String) {
                    if (this.def.isMultiValued()) {
                        Serializable[] ar = va.createArray(1);
                        ar[0] = va.readValue((String)this.xmlValue);
                        this.value = ar;
                    } else {
                        this.value = va.readValue((String)this.xmlValue);
                    }
                } else {
                    List list = (List)this.xmlValue;
                    if (this.def.isMultiValued()) {
                        if (this.def.getType() == PropertyType.STRING) {
                            this.value = list.toArray(va.createArray(list.size()));
                        } else {
                            Serializable[] ar = va.createArray(list.size());
                            for (int i = 0; i < ar.length; ++i) {
                                ar[i] = va.readValue((String)this.xmlValue);
                            }
                            this.value = ar;
                        }
                    } else {
                        throw new IllegalArgumentException("Multiple value set on a scalar property: " + this);
                    }
                }
            }
            this.xmlValue = null;
        }
        return this.value;
    }

    @Override
    public void setValue(Serializable value) {
        String error = this.def.validationError(value);
        if (error != null) {
            throw new IllegalArgumentException(this + " cannot receive value: " + value + ": " + error);
        }
        this.value = value;
    }

    public void _setValue(Serializable value) {
        this.value = value;
    }

    public Object getXmlValue() {
        return this.xmlValue;
    }

    public void setDefinition(PropertyDefinition def) {
        this.def = def;
        this.value = NULL;
    }

    @Override
    public PropertyDefinition getDefinition() {
        return this.def;
    }

    public boolean isValueLoaded() {
        return this.value != NULL;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getId() + "=" + (this.xmlValue == null ? this.value : this.xmlValue) + ')';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NoValue {
        NO_VALUE;

    }
}

