/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISCollection<T>
extends AbstractEntityCollectionAdapter<T> {
    protected final String type;
    protected final String name;
    protected final String id;
    protected final Repository repository;

    public CMISCollection(String type, String name, String id, Repository repository) {
        this.type = type;
        this.name = name;
        this.id = id;
        this.repository = repository;
    }

    public String getType() {
        return this.type;
    }

    public SPI getSPI(RequestContext request) {
        return this.repository.getSPI(this.getConnectionParams(request));
    }

    protected Map<String, Serializable> getConnectionParams(RequestContext request) {
        return null;
    }

    public static int getParameter(RequestContext request, String name, int def) {
        String value = request.getTarget().getParameter(name);
        return value == null ? def : Integer.parseInt(value);
    }

    public static boolean getParameter(RequestContext request, String name, boolean def) {
        String value = request.getTarget().getParameter(name);
        return value == null ? def : Boolean.parseBoolean(value);
    }

    @Override
    public void start(RequestContext request) throws ResponseContextException {
    }

    @Override
    public void end(RequestContext request, ResponseContext response) {
    }

    @Override
    public void compensate(RequestContext request, Throwable t) {
    }

    @Override
    public ResponseContext buildGetFeedResponse(Feed feed) {
        ResponseContext rc = super.buildGetFeedResponse(feed);
        rc.setContentType("application/atom+xml;type=feed");
        return rc;
    }

    @Override
    public ResponseContext extensionRequest(RequestContext request) {
        return ProviderHelper.notallowed(request, ProviderHelper.getDefaultMethods(request));
    }

    @Override
    public String getHref(RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("collection", this.name);
        params.put("id", this.id);
        if (this.repository != null) {
            params.put("repository", this.repository.getId());
        }
        return request.absoluteUrlFor(TargetType.TYPE_COLLECTION, params);
    }

    @Override
    public String[] getAccepts(RequestContext request) {
        return new String[0];
    }

    public String getServiceLink(RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.repository != null) {
            params.put("repository", this.repository.getId());
        }
        return request.absoluteUrlFor(TargetType.TYPE_SERVICE, params);
    }

    protected String getEntrylink(String entryType, String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entrytype", entryType);
        params.put("id", id);
        if (this.repository != null) {
            params.put("repository", this.repository.getId());
        }
        return request.absoluteUrlFor(TargetType.TYPE_ENTRY, params);
    }

    protected String getCollectionLink(String collection, String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("collection", collection);
        params.put("id", id);
        if (this.repository != null) {
            params.put("repository", this.repository.getId());
        }
        return request.absoluteUrlFor(TargetType.TYPE_COLLECTION, params);
    }

    public String getTypeLink(String tid, RequestContext request) {
        return this.getEntrylink("type", tid, request);
    }

    public String getObjectLink(String id, RequestContext request) {
        return this.getEntrylink("object", id, request);
    }

    public String getMediaLink(String id, RequestContext request) {
        return this.getEntrylink("file", id, request);
    }

    public String getTypeChildrenLink(String tid, RequestContext request) {
        return this.getCollectionLink("typechildren", tid, request);
    }

    public String getTypeDescendantsLink(String tid, RequestContext request) {
        return this.getCollectionLink("typedescendants", tid, request);
    }

    public String getChildrenLink(String fid, RequestContext request) {
        return this.getCollectionLink("children", fid, request);
    }

    public String getDescendantsLink(String fid, RequestContext request) {
        return this.getCollectionLink("descendants", fid, request);
    }

    public String getFolderTreeLink(String fid, RequestContext request) {
        return this.getCollectionLink("foldertree", fid, request);
    }

    public String getParentsLink(String fid, RequestContext request) {
        return this.getCollectionLink("parents", fid, request);
    }

    public String getCheckedOutLink(RequestContext request) {
        return this.getCollectionLink("checkedout", null, request);
    }
}

