/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import com.ctc.wstx.sr.BasicStreamReader;
import com.ctc.wstx.sr.NsInputElementStack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.DateTime;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.stax.FOMBuilder;
import org.apache.abdera.parser.stax.FOMDocument;
import org.apache.abdera.parser.stax.FOMEntry;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.util.EntityTag;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Type;
import org.apache.chemistry.Unfiling;
import org.apache.chemistry.VersioningState;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.abdera.ObjectElement;
import org.apache.chemistry.atompub.abdera.PathSegmentElement;
import org.apache.chemistry.atompub.server.CMISCollection;
import org.apache.chemistry.atompub.server.SizedMediaResponseContext;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.util.GregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISObjectsCollection
extends CMISCollection<ObjectEntry> {
    private static final Log log = LogFactory.getLog(CMISObjectsCollection.class);
    public static final String COLTYPE_PATH = "path";
    public static final String COLTYPE_CHILDREN = "children";
    public static final String COLTYPE_DESCENDANTS = "descendants";
    public static final String COLTYPE_FOLDER_TREE = "foldertree";
    public static final TargetType TARGET_TYPE_CMIS_DESCENDANTS = TargetType.get("CMISDESCENDANTS", true);
    public static final TargetType TARGET_TYPE_CMIS_FOLDER_TREE = TargetType.get("CMISFOLDERTREE", true);

    public CMISObjectsCollection(String type, String name, String id, Repository repository) {
        super(type, name, id, repository);
    }

    @Override
    public ResponseContext extensionRequest(RequestContext request) {
        TargetType type = request.getTarget().getType();
        if (type != TARGET_TYPE_CMIS_DESCENDANTS && type != TARGET_TYPE_CMIS_FOLDER_TREE) {
            return ProviderHelper.notsupported(request);
        }
        if (request.getMethod().equalsIgnoreCase("GET")) {
            return this.getFeed(request);
        }
        if (request.getMethod().equalsIgnoreCase("DELETE")) {
            return this.deleteEntry(request);
        }
        return ProviderHelper.notallowed(request, new String[]{"GET", "DELETE"});
    }

    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.declareNS("http://docs.oasis-open.org/ns/cmis/core/200908/", "cmis");
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(new Date());
        feed.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        if (this.id != null) {
            feed.addLink(this.getObjectLink(this.id, request), "via", "application/atom+xml;type=entry", null, null, -1L);
        }
        return feed;
    }

    @Override
    public String getId(RequestContext request) {
        return "urn:x-children:" + this.id;
    }

    @Override
    public String getAuthor(RequestContext request) {
        return "system";
    }

    @Override
    protected ResponseContext buildGetEntryResponse(RequestContext request, Entry entry) throws ResponseContextException {
        Document entryDoc = entry.getDocument();
        BaseResponseContext rc = new BaseResponseContext(entryDoc);
        rc.setEntityTag(ProviderHelper.calculateEntityTag(entry));
        return rc;
    }

    @Override
    protected Entry getEntryFromRequest(RequestContext request) throws ResponseContextException {
        Document entry;
        Parser parser = request.getAbdera().getParser();
        try {
            Document<Element> doc = request.getDocument(parser);
            this.fixMissingNamespace(doc);
            entry = (Document)doc.clone();
        }
        catch (Exception e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        return entry == null ? null : (Entry)entry.getRoot();
    }

    private void fixMissingNamespace(Document<Element> doc) {
        try {
            FOMDocument fomdoc = (FOMDocument)doc;
            FOMEntry fomentry = (FOMEntry)fomdoc.getOMDocumentElement();
            FOMBuilder fombuilder = (FOMBuilder)fomentry.builder;
            Field parserField = StAXBuilder.class.getDeclaredField("parser");
            parserField.setAccessible(true);
            BasicStreamReader parser = (BasicStreamReader)parserField.get(fombuilder);
            Field stackField = BasicStreamReader.class.getDeclaredField("mElementStack");
            stackField.setAccessible(true);
            NsInputElementStack stack = (NsInputElementStack)stackField.get(parser);
            if (stack.getNamespaceURI("cmisra") == null) {
                stack.addNsBinding("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            }
        }
        catch (Exception e) {
            throw new CMISRuntimeException(e);
        }
    }

    @Override
    public String getTitle(RequestContext request) {
        return this.name + " collection";
    }

    @Override
    protected String addEntryDetails(RequestContext request, Entry entry, IRI feedIri, ObjectEntry object) throws ResponseContextException {
        Text t;
        Factory factory = request.getAbdera().getFactory();
        String oid = object.getId();
        String typeId = object.getTypeId();
        entry.declareNS("http://docs.oasis-open.org/ns/cmis/core/200908/", "cmis");
        entry.setId(this.getId(object));
        entry.setTitle(this.getTitle(object));
        entry.setUpdated(this.getUpdated(object));
        List<Person> authors = this.getAuthors(object, request);
        if (authors != null) {
            for (Person a : authors) {
                entry.addAuthor(a);
            }
        }
        if ((t = this.getSummary(object, request)) != null) {
            entry.setSummaryElement(t);
        }
        entry.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        String link = this.getLink(object, feedIri, request);
        entry.addLink(link, "self", "application/atom+xml;type=entry", null, null, -1L);
        entry.addLink(link, "edit", "application/atom+xml;type=entry", null, null, -1L);
        entry.addLink(link, "alternate", "application/atom+xml;type=entry", null, null, -1L);
        entry.addLink(this.getTypeLink(typeId, request), "describedby", "application/atom+xml;type=entry", null, null, -1L);
        BaseType baseType = object.getBaseType();
        if (baseType == BaseType.FOLDER) {
            String pid = (String)((Object)object.getValue("cmis:parentId"));
            if (pid != null) {
                entry.addLink(this.getObjectLink(pid, request), "up", "application/atom+xml;type=entry", null, null, -1L);
            }
            entry.addLink(this.getChildrenLink(oid, request), "down", "application/atom+xml;type=feed", null, null, -1L);
            entry.addLink(this.getDescendantsLink(oid, request), "down", "application/cmistree+xml", null, null, -1L);
            entry.addLink(this.getFolderTreeLink(oid, request), "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed", null, null, -1L);
        } else if (baseType == BaseType.DOCUMENT) {
            entry.addLink(this.getMediaLink(oid, request), "edit-media");
            entry.addLink(this.getParentsLink(oid, request), "up", "application/atom+xml;type=feed", null, null, -1L);
        }
        Type objectType = this.repository.getType(typeId);
        entry.addExtension(new ObjectElement(factory, object, objectType));
        String pathSegment = object.getPathSegment();
        if (pathSegment != null) {
            entry.addExtension(new PathSegmentElement(factory, pathSegment));
        }
        return link;
    }

    protected PropertiesAndStream extractCMISProperties(RequestContext request, String typeId) throws ResponseContextException {
        DateTime updatedElement;
        InputStream stream;
        String mimeType;
        Type type;
        Map<Object, Object> properties;
        Object obb;
        boolean isNew = typeId == null;
        Entry entry = this.getEntryFromRequest(request);
        if (entry == null) {
            throw new ResponseContextException("Missing entry", 400);
        }
        if (!ProviderHelper.isValidEntry(entry)) {
            Content content;
            LinkedList<String> errors = new LinkedList<String>();
            if (entry.getId() == null || entry.getId().toString().trim().length() == 0) {
                errors.add("missing atom:id");
            }
            if (entry.getUpdated() == null) {
                errors.add("missing atom:updated");
            }
            if (entry.getAuthor() == null && entry.getSource() != null && entry.getSource().getAuthor() == null) {
                errors.add("missing atom:author");
            }
            if ((content = entry.getContentElement()) == null) {
                if (entry.getAlternateLink() == null) {
                    errors.add("missing atom:link rel=alternate");
                }
            } else if ((content.getSrc() != null || content.getContentType() == Content.Type.MEDIA) && entry.getSummaryElement() == null) {
                errors.add("missing atom:summary");
            }
            if (!errors.isEmpty()) {
                log.error("Invalid entry: " + StringUtils.join(errors, ", "));
            }
        }
        if ((obb = entry.getFirstChild(AtomPubCMIS.OBJECT)) == null) {
            obb = entry.getFirstChild(new QName("http://docs.oasis-open.org/ns/cmis/core/200908/", "object"));
        }
        if (obb == null) {
            properties = new HashMap<String, String>();
            if (isNew) {
                typeId = BaseType.DOCUMENT.getId();
                properties.put("cmis:objectTypeId", typeId);
            }
        } else {
            ObjectElement objectElement = new ObjectElement((Element)obb, this.repository);
            try {
                properties = objectElement.getProperties(typeId);
            }
            catch (Exception e) {
                throw new ResponseContextException(500, (Throwable)e);
            }
            String tid = (String)properties.get("cmis:objectTypeId");
            if (isNew) {
                typeId = tid;
            } else if (tid != null && !tid.equals(typeId)) {
                throw new ResponseContextException("Invalid type: " + tid, 500);
            }
        }
        if ((type = this.repository.getType(typeId)) == null) {
            throw new ResponseContextException("Unknown type: " + typeId, 500);
        }
        Object cmisContent = entry.getFirstChild(AtomPubCMIS.CONTENT);
        if (cmisContent != null) {
            Object el = cmisContent.getFirstChild(AtomPubCMIS.MEDIA_TYPE);
            if (el == null) {
                throw new ResponseContextException("missing cmisra:mediatype", 500);
            }
            mimeType = el.getText();
            el = cmisContent.getFirstChild(AtomPubCMIS.BASE64);
            if (el == null) {
                throw new ResponseContextException("missing cmisra:base64", 500);
            }
            byte[] b64 = el.getText().getBytes();
            stream = new ByteArrayInputStream(Base64.decodeBase64(b64));
        } else {
            Content content = entry.getContentElement();
            if (content != null) {
                Content.Type ct = content.getContentType();
                switch (ct) {
                    case TEXT: {
                        mimeType = "text/plain;charset=UTF-8";
                        break;
                    }
                    case HTML: {
                        mimeType = "text/html;charset=UTF-8";
                        break;
                    }
                    case XHTML: {
                        mimeType = "application/xhtml+xml";
                        break;
                    }
                    case XML: {
                        mimeType = "application/xml";
                        break;
                    }
                    case MEDIA: {
                        mimeType = content.getMimeType().toString();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)ct.toString());
                    }
                }
                try {
                    if (ct == Content.Type.MEDIA) {
                        stream = content.getDataHandler().getInputStream();
                    }
                    String value = content.getValue();
                    if (ct == Content.Type.TEXT && "".equals(value)) {
                        stream = null;
                    }
                    stream = new ByteArrayInputStream(value.getBytes("UTF-8"));
                }
                catch (IOException e1) {
                    throw new ResponseContextException("cannot get stream", 500);
                }
            } else {
                stream = null;
                mimeType = null;
            }
        }
        String title = entry.getTitle();
        properties.put("cmis:name", title);
        if (isNew && (updatedElement = entry.getUpdatedElement()) != null) {
            GregorianCalendar updated = GregorianCalendar.fromAtomPub(updatedElement.getText());
            properties.put("cmis:lastModificationDate", updated);
        }
        PropertiesAndStream res = new PropertiesAndStream();
        res.properties = properties;
        res.stream = stream;
        res.mimeType = mimeType;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext postEntry(RequestContext request) {
        SPI spi = this.getSPI(request);
        try {
            ObjectId objectId;
            boolean isMove;
            PropertiesAndStream posted = this.extractCMISProperties(request, null);
            ObjectId folderId = spi.newObjectId(this.id);
            String sourceFolderId = request.getTarget().getParameter("sourceFolderId");
            boolean bl = isMove = sourceFolderId != null;
            if (isMove) {
                String oid;
                if ("null".equals(sourceFolderId) || "".equals(sourceFolderId)) {
                    sourceFolderId = null;
                }
                if ((oid = (String)((Object)posted.properties.get("cmis:objectId"))) == null) {
                    throw new ResponseContextException("Missing id", 400);
                }
                objectId = spi.newObjectId(oid);
                ObjectId sourceFolder = sourceFolderId == null ? null : spi.newObjectId(sourceFolderId);
                objectId = spi.moveObject(objectId, folderId, sourceFolder);
            } else {
                String typeId = (String)((Object)posted.properties.get("cmis:objectTypeId"));
                BaseType baseType = this.repository.getType(typeId).getBaseType();
                switch (baseType) {
                    case DOCUMENT: {
                        String filename = (String)((Object)posted.properties.get("cmis:contentStreamFileName"));
                        if (filename == null) {
                            filename = (String)((Object)posted.properties.get("cmis:name"));
                        }
                        SimpleContentStream contentStream = posted.stream == null ? null : new SimpleContentStream(posted.stream, posted.mimeType, filename);
                        VersioningState versioningState = null;
                        objectId = spi.createDocument(posted.properties, folderId, contentStream, versioningState);
                        break;
                    }
                    case FOLDER: {
                        objectId = spi.createFolder(posted.properties, folderId);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("not implemented: " + (Object)((Object)baseType));
                    }
                }
            }
            Entry entry = request.getAbdera().getFactory().newEntry();
            ObjectEntry object = spi.getProperties(objectId, null);
            this.addEntryDetails(request, entry, (IRI)null, object);
            if (this.isMediaEntry(object, spi)) {
                this.addMediaContent((IRI)null, entry, object, request);
            } else {
                this.addContent(entry, object, request);
            }
            String link = this.getObjectLink(object.getId(), request);
            ResponseContext responseContext = this.buildCreateEntryResponse(link, entry);
            return responseContext;
        }
        catch (ResponseContextException e) {
            ResponseContext responseContext = this.createErrorResponse(e);
            return responseContext;
        }
        catch (ConstraintViolationException e) {
            ResponseContext responseContext = this.createErrorResponse(new ResponseContextException(400, (Throwable)e));
            return responseContext;
        }
        catch (CMISRuntimeException e) {
            ResponseContext responseContext = this.createErrorResponse(new ResponseContextException(500, (Throwable)e));
            return responseContext;
        }
        catch (Exception e) {
            ResponseContext responseContext = this.createErrorResponse(new ResponseContextException(500, (Throwable)e));
            return responseContext;
        }
        finally {
            spi.close();
        }
    }

    @Override
    public ObjectEntry postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext putEntry(RequestContext request) {
        ResponseContext responseContext;
        SPI spi = this.getSPI(request);
        try {
            String id = this.getResourceName(request);
            ObjectEntry object = spi.getProperties(spi.newObjectId(id), null);
            if (object == null) {
                EmptyResponseContext emptyResponseContext = new EmptyResponseContext(404);
                return emptyResponseContext;
            }
            PropertiesAndStream put = this.extractCMISProperties(request, object.getTypeId());
            String changeToken = null;
            spi.updateProperties(object, changeToken, put.properties);
            if (put.stream != null) {
                String filename = (String)((Object)put.properties.get("cmis:contentStreamFileName"));
                if (filename == null) {
                    filename = (String)((Object)object.getValue("cmis:contentStreamFileName"));
                }
                SimpleContentStream contentStream = put.stream == null ? null : new SimpleContentStream(put.stream, put.mimeType, filename);
                spi.setContentStream(object, contentStream, true);
            }
            Entry entry = request.getAbdera().getFactory().newEntry();
            object = spi.getProperties(object, null);
            this.addEntryDetails(request, entry, (IRI)null, object);
            if (this.isMediaEntry(object, spi)) {
                this.addMediaContent((IRI)null, entry, object, request);
            } else {
                this.addContent(entry, object, request);
            }
            ResponseContext responseContext2 = this.buildGetEntryResponse(request, entry);
            return responseContext2;
        }
        catch (ResponseContextException e) {
            responseContext = this.createErrorResponse(e);
            return responseContext;
        }
        catch (CMISRuntimeException e) {
            responseContext = this.createErrorResponse(new ResponseContextException(500, (Throwable)e));
            return responseContext;
        }
        catch (Exception e) {
            responseContext = this.createErrorResponse(new ResponseContextException(500, (Throwable)e));
            return responseContext;
        }
        finally {
            spi.close();
        }
    }

    @Override
    public void putEntry(ObjectEntry object, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            String oid = resourceName;
            ObjectId object = spi.newObjectId(oid);
            if (COLTYPE_DESCENDANTS.equals(this.getType()) || COLTYPE_FOLDER_TREE.equals(this.getType())) {
                String unfile = request.getTarget().getParameter("unfileObjects");
                Unfiling unfileObjects = unfile == null ? null : Unfiling.get(unfile);
                boolean continueOnFailure = CMISObjectsCollection.getParameter(request, "continueOnFailure", false);
                spi.deleteTree(object, unfileObjects, continueOnFailure);
            } else {
                boolean allVersions = CMISObjectsCollection.getParameter(request, "allVersions", false);
                spi.deleteObject(object, allVersions);
            }
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseContextException(404, (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new ResponseContextException(409, (Throwable)e);
        }
        catch (CMISRuntimeException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        catch (Exception e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        finally {
            spi.close();
        }
    }

    @Override
    public List<Person> getAuthors(ObjectEntry object, RequestContext request) {
        String author = null;
        try {
            author = (String)((Object)object.getValue("cmis:createdBy"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (author == null) {
            author = "system";
        }
        Person person = request.getAbdera().getFactory().newAuthor();
        person.setName(author);
        return Collections.singletonList(person);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext getMedia(RequestContext request) {
        ResponseContext responseContext;
        SPI spi = this.getSPI(request);
        try {
            String id = this.getResourceName(request);
            ObjectEntry object = this.getEntry(id, request, spi);
            if (object == null) {
                EmptyResponseContext emptyResponseContext = new EmptyResponseContext(404);
                return emptyResponseContext;
            }
            ContentStream contentStream = spi.getContentStream(object, null);
            if (contentStream == null) {
                EmptyResponseContext emptyResponseContext = new EmptyResponseContext(409, "No content");
                return emptyResponseContext;
            }
            InputStream stream = contentStream.getStream();
            if (stream == null) {
                EmptyResponseContext emptyResponseContext = new EmptyResponseContext(409, "No content");
                return emptyResponseContext;
            }
            Date updated = this.getUpdated(object);
            SizedMediaResponseContext ctx = new SizedMediaResponseContext(stream, updated, 200);
            ctx.setSize(this.getContentSize(object));
            ctx.setContentType(this.getContentType(object));
            ctx.setEntityTag(EntityTag.generate(id, AtomDate.format(updated)));
            SizedMediaResponseContext sizedMediaResponseContext = ctx;
            return sizedMediaResponseContext;
        }
        catch (ResponseContextException e) {
            responseContext = e.getResponseContext();
            return responseContext;
        }
        catch (ConstraintViolationException e) {
            responseContext = new EmptyResponseContext(409, "No content");
            return responseContext;
        }
        catch (IOException e) {
            responseContext = new EmptyResponseContext(500, e.toString());
            return responseContext;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
            responseContext = new EmptyResponseContext(400);
            return responseContext;
        }
        finally {
            spi.close();
        }
    }

    public boolean isMediaEntry(ObjectEntry object, SPI spi) throws ResponseContextException {
        return this.getContentType(object) != null && this.getContentSize(object) != -1L && spi.hasContentStream(object);
    }

    @Override
    protected String addMediaContent(IRI feedIri, Entry entry, ObjectEntry object, RequestContext request) throws ResponseContextException {
        String mediaLink = this.getMediaLink(object.getId(), request);
        entry.setContent(new IRI(mediaLink), this.getContentType(object));
        return mediaLink;
    }

    @Override
    public Object getContent(ObjectEntry object, RequestContext request) throws ResponseContextException {
        return null;
    }

    public long getContentSize(ObjectEntry object) {
        try {
            Integer value = (Integer)object.getValue("cmis:contentStreamLength");
            return value == null ? -1L : value.longValue();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    @Override
    public String getContentType(ObjectEntry object) {
        try {
            return (String)((Object)object.getValue("cmis:contentStreamMimeType"));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext getEntry(RequestContext request) {
        SPI spi = this.getSPI(request);
        try {
            String id = this.getResourceName(request);
            ObjectEntry object = this.getEntry(id, request, spi);
            if (object == null) {
                EmptyResponseContext emptyResponseContext = new EmptyResponseContext(404);
                return emptyResponseContext;
            }
            Entry entry = request.getAbdera().getFactory().newEntry();
            IRI feedIri = new IRI(this.getFeedIriForEntry(object, request));
            this.addEntryDetails(request, entry, feedIri, object);
            if (this.isMediaEntry(object, spi)) {
                this.addMediaContent(feedIri, entry, object, request);
            } else {
                this.addContent(entry, object, request);
            }
            ResponseContext responseContext = this.buildGetEntryResponse(request, entry);
            return responseContext;
        }
        catch (ResponseContextException e) {
            ResponseContext responseContext = this.createErrorResponse(e);
            return responseContext;
        }
        finally {
            spi.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectEntry getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            ObjectEntry objectEntry = this.getEntry(resourceName, request, spi);
            return objectEntry;
        }
        finally {
            spi.close();
        }
    }

    public ObjectEntry getEntry(String resourceName, RequestContext request, SPI spi) throws ResponseContextException {
        Target target = request.getTarget();
        String properties = target.getParameter("filter");
        boolean allowableActions = CMISObjectsCollection.getParameter(request, "includeAllowableActions", false);
        String incl = target.getParameter("includeRelationships");
        RelationshipDirection relationships = RelationshipDirection.fromInclusion(incl);
        Inclusion inclusion = new Inclusion(properties, null, relationships, allowableActions, false, false);
        if (COLTYPE_PATH.equals(this.getType()) || "".equals(resourceName)) {
            String path;
            if (COLTYPE_PATH.equals(this.getType())) {
                path = resourceName;
            } else {
                path = target.getParameter(COLTYPE_PATH);
                if (path == null) {
                    throw new ResponseContextException("Missing id and path", 500);
                }
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return spi.getObjectByPath(path, inclusion);
        }
        String id = resourceName;
        return spi.getProperties(spi.newObjectId(id), inclusion);
    }

    @Override
    public String getResourceName(RequestContext request) {
        String name = COLTYPE_PATH.equals(this.getType()) ? COLTYPE_PATH : "objectid";
        String resourceName = request.getTarget().getParameter(name);
        return UrlEncoding.decode(resourceName);
    }

    @Override
    protected String getLink(ObjectEntry object, IRI feedIri, RequestContext request) {
        return this.getObjectLink(object.getId(), request);
    }

    @Override
    public String getName(ObjectEntry object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId(ObjectEntry object) {
        return "urn:uuid:" + object.getId();
    }

    @Override
    public String getTitle(ObjectEntry object) {
        return (String)((Object)object.getValue("cmis:name"));
    }

    @Override
    public Date getUpdated(ObjectEntry object) {
        Date date = null;
        try {
            Calendar calendar = (Calendar)object.getValue("cmis:lastModificationDate");
            if (calendar != null) {
                date = calendar.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    @Override
    public Text getSummary(ObjectEntry object, RequestContext request) {
        String summary = null;
        try {
            summary = (String)((Object)object.getValue("description"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (summary == null) {
            summary = (String)((Object)object.getValue("cmis:name"));
        }
        Text text = request.getAbdera().getFactory().newSummary();
        text.setValue(summary);
        return text;
    }

    protected static class PropertiesAndStream {
        public Map<String, Serializable> properties;
        public InputStream stream;
        public String mimeType;

        protected PropertiesAndStream() {
        }
    }
}

