/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.abdera.parser.stax.StaxStreamWriter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.writer.StreamWriter;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryCapabilities;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.URITemplate;
import org.apache.chemistry.atompub.server.CMISCollection;
import org.apache.chemistry.atompub.server.CMISProvider;
import org.w3c.dom.Document;

public class CMISServiceResponse
extends StreamWriterResponseContext {
    public static final String ATOMPUB_VERSION_SUPPORTED = "1.0";
    protected final CMISProvider provider;
    protected final RequestContext request;

    public CMISServiceResponse(CMISProvider provider, RequestContext request) {
        super(request.getAbdera());
        this.provider = provider;
        this.request = request;
    }

    protected void writeTo(StreamWriter sw) throws IOException {
        RepositoryInfo info = this.provider.getRepository().getInfo();
        ((StaxStreamWriter)sw).startDocument("UTF-8", ATOMPUB_VERSION_SUPPORTED);
        sw.startService();
        ((StaxStreamWriter)sw).writeNamespace("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        ((StaxStreamWriter)sw).writeNamespace("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        for (WorkspaceInfo wi : this.provider.getWorkspaceManager(this.request).getWorkspaces(this.request)) {
            sw.startWorkspace();
            sw.writeTitle(wi.getTitle(this.request));
            RepositoryInfoWriter.write(sw, this.provider);
            CMISCollection typesCol = null;
            for (CollectionInfo ci : wi.getCollections(this.request)) {
                CMISCollection cmisCol = (CMISCollection)ci;
                String type = cmisCol.getType();
                if ("types".equals(type)) {
                    typesCol = cmisCol;
                }
                sw.startCollection(ci.getHref(this.request));
                sw.writeTitle(ci.getTitle(this.request));
                sw.writeAccepts(ci.getAccepts(this.request));
                sw.startElement(AtomPubCMIS.COLLECTION_TYPE);
                sw.writeElementText(type);
                sw.endElement();
                sw.endCollection();
            }
            sw.startElement(AtomPub.ATOM_LINK);
            sw.writeAttribute("rel", "http://docs.oasis-open.org/ns/cmis/link/200908/typedescendants");
            sw.writeAttribute("type", "application/cmistree+xml");
            String tdurl = typesCol.getTypeDescendantsLink(null, this.request);
            sw.writeAttribute("href", tdurl);
            sw.endElement();
            sw.startElement(AtomPub.ATOM_LINK);
            sw.writeAttribute("rel", "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree");
            sw.writeAttribute("type", "application/cmistree+xml");
            String fturl = typesCol.getFolderTreeLink(info.getRootFolderId().getId(), this.request);
            sw.writeAttribute("href", fturl);
            sw.endElement();
            for (URITemplate uritmpl : this.provider.getURITemplates(this.request)) {
                sw.startElement(AtomPubCMIS.URI_TEMPLATE);
                sw.startElement(AtomPubCMIS.TYPE);
                sw.writeElementText(uritmpl.type);
                sw.endElement();
                sw.startElement(AtomPubCMIS.MEDIA_TYPE);
                sw.writeElementText(uritmpl.mediaType);
                sw.endElement();
                sw.startElement(AtomPubCMIS.TEMPLATE);
                sw.writeElementText(uritmpl.template);
                sw.endElement();
                sw.endElement();
            }
            sw.endWorkspace();
        }
        sw.endService();
        sw.endDocument();
        sw.flush();
    }

    public static class RepositoryInfoWriter {
        public final StreamWriter sw;
        public final CMISProvider provider;

        public RepositoryInfoWriter(StreamWriter sw, CMISProvider provider) {
            this.sw = sw;
            this.provider = provider;
        }

        public static void write(StreamWriter sw, CMISProvider provider) throws IOException {
            new RepositoryInfoWriter(sw, provider).write();
        }

        public void write() throws IOException {
            Repository repository = this.provider.getRepository();
            RepositoryInfo info = repository.getInfo();
            RepositoryCapabilities cap = info.getCapabilities();
            this.sw.startElement(AtomPubCMIS.REPOSITORY_INFO);
            this.write(CMIS.REPOSITORY_ID, repository.getId());
            this.write(CMIS.REPOSITORY_NAME, repository.getName());
            this.write(CMIS.REPOSITORY_DESCRIPTION, info.getDescription());
            this.write(CMIS.VENDOR_NAME, info.getVendorName());
            this.write(CMIS.PRODUCT_NAME, info.getProductName());
            this.write(CMIS.PRODUCT_VERSION, info.getProductVersion());
            this.write(CMIS.ROOT_FOLDER_ID, info.getRootFolderId().getId());
            this.write(CMIS.LATEST_CHANGE_LOG_TOKEN, info.getLatestChangeLogToken());
            this.sw.startElement(CMIS.CAPABILITIES);
            this.write(CMIS.CAPABILITY_ACL, cap.getACLCapability().toString());
            this.write(CMIS.CAPABILITY_ALL_VERSIONS_SEARCHABLE, cap.isAllVersionsSearchable());
            this.write(CMIS.CAPABILITY_CHANGES, cap.getChangeCapability().toString());
            this.write(CMIS.CAPABILITY_CONTENT_STREAM_UPDATABILITY, cap.isContentStreamUpdatableAnytime() ? "anytime" : "pwconly");
            this.write(CMIS.CAPABILITY_CAN_GET_DESCENDANTS, cap.hasGetDescendants());
            this.write(CMIS.CAPABILITY_CAN_GET_FOLDER_TREE, cap.hasGetFolderTree());
            this.write(CMIS.CAPABILITY_MULTIFILING, cap.hasMultifiling());
            this.write(CMIS.CAPABILITY_PWC_SEARCHABLE, cap.isPWCSearchable());
            this.write(CMIS.CAPABILITY_PWC_UPDATABLE, cap.isPWCUpdatable());
            this.write(CMIS.CAPABILITY_QUERY, cap.getQueryCapability().toString());
            this.write(CMIS.CAPABILITY_RENDITIONS, cap.getRenditionCapability().toString());
            this.write(CMIS.CAPABILITY_UNFILING, cap.hasUnfiling());
            this.write(CMIS.CAPABILITY_VERSION_SPECIFIC_FILING, cap.hasVersionSpecificFiling());
            this.write(CMIS.CAPABILITY_JOIN, cap.getJoinCapability().toString());
            this.sw.endElement();
            this.write(CMIS.VERSION_SUPPORTED, CMISServiceResponse.ATOMPUB_VERSION_SUPPORTED);
            this.write(CMIS.CHANGES_INCOMPLETE, info.isChangeLogIncomplete());
            for (BaseType t : info.getChangeLogBaseTypes()) {
                this.write(CMIS.CHANGES_ON_TYPE, t.toString());
            }
            this.write(CMIS.REPOSITORY_SPECIFIC_INFORMATION, info.getRepositorySpecificInformation());
            this.sw.endElement();
        }

        protected void write(QName qname, String string) {
            this.sw.startElement(qname);
            this.sw.writeElementText(string);
            this.sw.endElement();
        }

        protected void write(QName qname, boolean bool) {
            this.sw.startElement(qname);
            this.sw.writeElementText(bool ? "true" : "false");
            this.sw.endElement();
        }

        private void write(QName qname, Document document) {
            if (document == null) {
                return;
            }
            this.sw.startElement(qname);
            this.sw.endElement();
        }
    }
}

