/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.Paging;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.abdera.PropertiesElement;
import org.apache.chemistry.atompub.server.CMISCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISTypesCollection
extends CMISCollection<Type> {
    protected boolean singleEntry;

    public CMISTypesCollection(String type, String id, Repository repository) {
        super(type, "typechildren", id, repository);
    }

    @Override
    protected Feed createFeedBase(RequestContext request) {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.declareNS("http://docs.oasis-open.org/ns/cmis/core/200908/", "cmis");
        feed.declareNS("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "cmisra");
        feed.declareNS("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addLink(request.getResolvedUri().toString(), "self");
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(new Date());
        return feed;
    }

    @Override
    public String getId(RequestContext request) {
        return "urn:x-id:types";
    }

    @Override
    public String getTitle(RequestContext request) {
        return "Types";
    }

    @Override
    public String getAuthor(RequestContext request) {
        return "system";
    }

    @Override
    public ResponseContext getEntry(RequestContext request) {
        this.singleEntry = true;
        return super.getEntry(request);
    }

    @Override
    public String addEntryDetails(RequestContext request, Entry entry, IRI feedIri, Type type) throws ResponseContextException {
        boolean includePropertyDefinitions = this.singleEntry || CMISTypesCollection.getParameter(request, "includePropertyDefinitions", false);
        Factory factory = request.getAbdera().getFactory();
        String tid = type.getId();
        String tpid = type.getParentId();
        entry.setId(this.getId(type));
        entry.setTitle(this.getTitle(type));
        entry.setUpdated(this.getUpdated(type));
        String summary = type.getDescription();
        if (summary != null && summary.length() != 0) {
            entry.setSummary(summary);
        }
        String link = this.getLink(type, feedIri, request);
        entry.addLink(link, "self");
        entry.addLink(link, "edit");
        entry.addLink(link, "alternate");
        if (tpid != null) {
            entry.addLink(this.getTypeLink(tpid, request), "up", "application/atom+xml;type=entry", null, null, -1L);
        }
        entry.addLink(this.getTypeChildrenLink(tid, request), "down", "application/atom+xml;type=feed", null, null, -1L);
        entry.addLink(this.getTypeDescendantsLink(tid, request), "down", "application/cmistree+xml", null, null, -1L);
        entry.addLink(this.getTypeLink(type.getBaseType().getId(), request), "describedby", "application/atom+xml;type=entry", null, null, -1L);
        Object te = factory.newElement(AtomPubCMIS.TYPE, entry);
        te.setAttributeValue(AtomPubCMIS.ID, tid);
        QName schemaType = CMIS.SCHEMA_TYPES.get((Object)type.getBaseType());
        te.setAttributeValue(AtomPub.XSI_TYPE, schemaType.getPrefix() + ':' + schemaType.getLocalPart());
        Object el = factory.newElement(CMIS.ID, (Base)te);
        el.setText(tid);
        el = factory.newElement(CMIS.LOCAL_NAME, (Base)te);
        el.setText(type.getLocalName());
        URI localNamespace = type.getLocalNamespace();
        if (localNamespace != null) {
            el = factory.newElement(CMIS.LOCAL_NAMESPACE, (Base)te);
            el.setText(localNamespace.toString());
        }
        el = factory.newElement(CMIS.QUERY_NAME, (Base)te);
        el.setText(type.getQueryName());
        el = factory.newElement(CMIS.DISPLAY_NAME, (Base)te);
        el.setText(type.getDisplayName());
        el = factory.newElement(CMIS.BASE_ID, (Base)te);
        el.setText(type.getBaseType().getId());
        el = factory.newElement(CMIS.PARENT_ID, (Base)te);
        el.setText(tpid == null ? "" : tpid);
        el = factory.newElement(CMIS.DESCRIPTION, (Base)te);
        el.setText(type.getDescription());
        el = factory.newElement(CMIS.CREATABLE, (Base)te);
        el.setText(Boolean.toString(type.isCreatable()));
        el = factory.newElement(CMIS.FILEABLE, (Base)te);
        el.setText(Boolean.toString(type.isFileable()));
        el = factory.newElement(CMIS.QUERYABLE, (Base)te);
        el.setText(Boolean.toString(type.isQueryable()));
        el = factory.newElement(CMIS.CONTROLLABLE_POLICY, (Base)te);
        el.setText(Boolean.toString(type.isControllablePolicy()));
        el = factory.newElement(CMIS.CONTROLLABLE_ACL, (Base)te);
        el.setText(Boolean.toString(type.isControllableACL()));
        el = factory.newElement(CMIS.FULLTEXT_INDEXED, (Base)te);
        el.setText(Boolean.toString(type.isFulltextIndexed()));
        el = factory.newElement(CMIS.INCLUDED_IN_SUPERTYPE_QUERY, (Base)te);
        el.setText(Boolean.toString(type.isIncludedInSuperTypeQuery()));
        el = factory.newElement(CMIS.VERSIONABLE, (Base)te);
        el.setText(Boolean.toString(type.isVersionable()));
        el = factory.newElement(CMIS.CONTENT_STREAM_ALLOWED, (Base)te);
        el.setText(type.getContentStreamAllowed().toString());
        if (includePropertyDefinitions) {
            block20: for (PropertyDefinition pd : type.getPropertyDefinitions()) {
                URI lns;
                QName qname;
                switch (pd.getType().ordinal()) {
                    case 1: {
                        qname = CMIS.PROPERTY_STRING_DEFINITION;
                        break;
                    }
                    case 2: {
                        qname = CMIS.PROPERTY_DECIMAL_DEFINITION;
                        break;
                    }
                    case 3: {
                        qname = CMIS.PROPERTY_INTEGER_DEFINITION;
                        break;
                    }
                    case 4: {
                        qname = CMIS.PROPERTY_BOOLEAN_DEFINITION;
                        break;
                    }
                    case 5: {
                        qname = CMIS.PROPERTY_DATETIME_DEFINITION;
                        break;
                    }
                    case 6: {
                        qname = CMIS.PROPERTY_URI_DEFINITION;
                        break;
                    }
                    case 7: {
                        qname = CMIS.PROPERTY_ID_DEFINITION;
                        break;
                    }
                    case 8: {
                        qname = CMIS.PROPERTY_HTML_DEFINITION;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)pd.getType().name());
                    }
                }
                Object def = factory.newElement(qname, (Base)te);
                el = factory.newElement(CMIS.ID, (Base)def);
                el.setText(pd.getId());
                String localName = pd.getLocalName();
                if (localName != null) {
                    el = factory.newElement(CMIS.LOCAL_NAME, (Base)def);
                    el.setText(localName);
                }
                if ((lns = pd.getLocalNamespace()) != null) {
                    el = factory.newElement(CMIS.LOCAL_NAMESPACE, (Base)def);
                    el.setText(lns.toString());
                }
                el = factory.newElement(CMIS.QUERY_NAME, (Base)def);
                el.setText(pd.getQueryName());
                el = factory.newElement(CMIS.DISPLAY_NAME, (Base)def);
                el.setText(pd.getDisplayName());
                el = factory.newElement(CMIS.DESCRIPTION, (Base)def);
                el.setText(pd.getDescription());
                el = factory.newElement(CMIS.PROPERTY_TYPE, (Base)def);
                el.setText(pd.getType().name());
                el = factory.newElement(CMIS.CARDINALITY, (Base)def);
                el.setText(pd.isMultiValued() ? "multi" : "single");
                el = factory.newElement(CMIS.UPDATABILITY, (Base)def);
                el.setText(pd.getUpdatability().toString());
                el = factory.newElement(CMIS.INHERITED, (Base)def);
                el.setText(pd.isInherited() ? "true" : "false");
                el = factory.newElement(CMIS.REQUIRED, (Base)def);
                el.setText(pd.isRequired() ? "true" : "false");
                el = factory.newElement(CMIS.QUERYABLE, (Base)def);
                el.setText(pd.isQueryable() ? "true" : "false");
                el = factory.newElement(CMIS.ORDERABLE, (Base)def);
                el.setText(pd.isOrderable() ? "true" : "false");
                Serializable defaultValue = pd.getDefaultValue();
                if (defaultValue != null) {
                    Object dv = factory.newElement(CMIS.DEFAULT_VALUE, (Base)def);
                    for (String s : PropertiesElement.getStringsForValue(defaultValue, pd.getType(), pd.isMultiValued())) {
                        el = factory.newElement(CMIS.VALUE, (Base)dv);
                        el.setText(s);
                    }
                }
                switch (pd.getType().ordinal()) {
                    case 1: {
                        continue block20;
                    }
                    case 2: {
                        continue block20;
                    }
                    case 3: {
                        continue block20;
                    }
                    case 4: {
                        continue block20;
                    }
                    case 5: {
                        continue block20;
                    }
                    case 6: {
                        continue block20;
                    }
                    case 7: {
                        continue block20;
                    }
                    case 8: {
                        continue block20;
                    }
                }
                throw new AssertionError((Object)pd.getType().name());
            }
        }
        return link;
    }

    @Override
    public Iterable<Type> getEntries(RequestContext request) throws ResponseContextException {
        boolean includePropertyDefinitions = CMISTypesCollection.getParameter(request, "includePropertyDefinitions", false);
        if ("descendants".equals(this.getType())) {
            int depth = CMISTypesCollection.getParameter(request, "depth", -1);
            return this.repository.getTypeDescendants(this.id, depth, includePropertyDefinitions);
        }
        int maxItems = CMISTypesCollection.getParameter(request, "maxItems", 0);
        int skipCount = CMISTypesCollection.getParameter(request, "skipCount", 0);
        return this.repository.getTypeChildren(this.id, includePropertyDefinitions, new Paging(maxItems, skipCount));
    }

    @Override
    public Type postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putEntry(Type type, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getContent(Type type, RequestContext request) throws ResponseContextException {
        return null;
    }

    @Override
    public Type getEntry(String typeId, RequestContext request) throws ResponseContextException {
        return this.repository.getType(typeId);
    }

    @Override
    public String getResourceName(RequestContext request) {
        String resourceName = request.getTarget().getParameter("typeid");
        return UrlEncoding.decode(resourceName);
    }

    @Override
    protected String getLink(Type type, IRI feedIri, RequestContext request) {
        return this.getTypeLink(type.getId(), request);
    }

    @Override
    public String getName(Type type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId(Type type) {
        return "urn:x-tid:" + type.getId();
    }

    @Override
    public String getTitle(Type type) {
        return type.getDisplayName();
    }

    @Override
    public Date getUpdated(Type type) {
        return new Date();
    }
}

