/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceManager;
import org.apache.chemistry.Repository;
import org.apache.chemistry.atompub.server.CMISCheckedOutCollection;
import org.apache.chemistry.atompub.server.CMISChildrenCollection;
import org.apache.chemistry.atompub.server.CMISCollectionForOther;
import org.apache.chemistry.atompub.server.CMISParentsCollection;
import org.apache.chemistry.atompub.server.CMISProvider;
import org.apache.chemistry.atompub.server.CMISQueryFeed;
import org.apache.chemistry.atompub.server.CMISTypesCollection;

public class CMISWorkspaceManager
extends AbstractWorkspaceManager {
    private final CMISProvider provider;

    public CMISWorkspaceManager(CMISProvider provider) {
        this.provider = provider;
    }

    public CollectionAdapter getCollectionAdapter(RequestContext request) {
        String spath;
        String path;
        String paths;
        Repository repository = this.provider.getRepository();
        String uri = request.getUri().toString();
        if (uri.indexOf(63) > 0) {
            uri = uri.substring(0, uri.lastIndexOf(63));
        }
        if ((paths = (path = (spath = request.getTargetBasePath()) == null ? uri : uri.substring(spath.length())) + '/').startsWith("/typechildren/")) {
            String param = request.getTarget().getParameter("typeid");
            String tid = UrlEncoding.decode(param);
            return new CMISTypesCollection("children", tid, repository);
        }
        if (paths.startsWith("/typedescendants/")) {
            String param = request.getTarget().getParameter("typeid");
            String tid = UrlEncoding.decode(param);
            return new CMISTypesCollection("descendants", tid, repository);
        }
        if (paths.startsWith("/type/")) {
            return new CMISTypesCollection(null, null, repository);
        }
        if (paths.startsWith("/children/")) {
            String param = request.getTarget().getParameter("objectid");
            String id = UrlEncoding.decode(param);
            return new CMISChildrenCollection(null, id, repository);
        }
        if (paths.startsWith("/descendants/")) {
            String param = request.getTarget().getParameter("objectid");
            String id = UrlEncoding.decode(param);
            return new CMISChildrenCollection("descendants", id, repository);
        }
        if (paths.startsWith("/foldertree/")) {
            String param = request.getTarget().getParameter("objectid");
            String id = UrlEncoding.decode(param);
            return new CMISChildrenCollection("foldertree", id, repository);
        }
        if (paths.startsWith("/parents/")) {
            String param = request.getTarget().getParameter("objectid");
            String id = UrlEncoding.decode(param);
            return new CMISParentsCollection(null, id, repository);
        }
        if (paths.startsWith("/object/")) {
            return new CMISChildrenCollection(null, null, repository);
        }
        if (paths.startsWith("/path/")) {
            return new CMISChildrenCollection("path", null, repository);
        }
        if (paths.startsWith("/file/")) {
            return new CMISChildrenCollection(null, null, repository);
        }
        if (paths.startsWith("/unfiled/")) {
            return new CMISCollectionForOther(null, "unfiled", null, repository);
        }
        if (paths.startsWith("/checkedout/")) {
            return new CMISCheckedOutCollection(repository);
        }
        if (paths.startsWith("/query/") || paths.startsWith("/query?")) {
            return new CMISQueryFeed(repository);
        }
        return null;
    }
}

