/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.servlet.AbderaServlet;
import org.apache.chemistry.Repository;
import org.apache.chemistry.atompub.server.CMISProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISServlet
extends AbderaServlet {
    private static final long serialVersionUID = 1L;
    private Repository repository;

    public CMISServlet() {
    }

    public CMISServlet(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void init() throws ServletException {
        if (this.repository == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration names = this.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                params.put(name, this.getInitParameter(name));
            }
            this.repository = this.createRepository(this.getServletContext(), params);
        }
        super.init();
    }

    private Repository createRepository(ServletContext context, Map<String, String> params) throws ServletException {
        String className = params.get("class");
        if (className == null) {
            String msg = "Repository factory expected in 'class' parameter.";
            throw new ServletException(msg);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected Provider createProvider() {
        CMISProvider provider = new CMISProvider(this.repository);
        Abdera abdera = new Abdera();
        HashMap<String, String> properties = new HashMap<String, String>();
        provider.init(abdera, properties);
        return provider;
    }
}

