/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.base;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseObject
implements CMISObject {
    @Override
    public Map<String, Property> getProperties() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (PropertyDefinition pd : this.getType().getPropertyDefinitions()) {
            String id = pd.getId();
            properties.put(id, this.getProperty(id));
        }
        return properties;
    }

    @Override
    public void setValue(String id, Serializable value) {
        this.getProperty(id).setValue(value);
    }

    @Override
    public void setValues(Map<String, Serializable> values) {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getString(String id) {
        return (String)((Object)this.getValue(id));
    }

    @Override
    public String[] getStrings(String id) {
        return (String[])this.getValue(id);
    }

    @Override
    public BigDecimal getDecimal(String id) {
        return (BigDecimal)this.getValue(id);
    }

    @Override
    public BigDecimal[] getDecimals(String id) {
        return (BigDecimal[])this.getValue(id);
    }

    @Override
    public Integer getInteger(String id) {
        return (Integer)this.getValue(id);
    }

    @Override
    public Integer[] getIntegers(String id) {
        return (Integer[])this.getValue(id);
    }

    @Override
    public Boolean getBoolean(String id) {
        return (Boolean)this.getValue(id);
    }

    @Override
    public Boolean[] getBooleans(String id) {
        return (Boolean[])this.getValue(id);
    }

    @Override
    public Calendar getDateTime(String id) {
        return (Calendar)this.getValue(id);
    }

    @Override
    public Calendar[] getDateTimes(String id) {
        return (Calendar[])this.getValue(id);
    }

    @Override
    public URI getURI(String id) {
        return (URI)this.getValue(id);
    }

    @Override
    public URI[] getURIs(String id) {
        return (URI[])this.getValue(id);
    }

    @Override
    public String getId(String id) {
        return (String)((Object)this.getValue(id));
    }

    @Override
    public String[] getIds(String id) {
        return (String[])this.getValue(id);
    }

    @Override
    public String getXML(String id) {
        return (String)((Object)this.getValue(id));
    }

    @Override
    public String[] getXMLs(String id) {
        return (String[])this.getValue(id);
    }

    @Override
    public String getHTML(String id) {
        return (String)((Object)this.getValue(id));
    }

    @Override
    public String[] getHTMLs(String id) {
        return (String[])this.getValue(id);
    }

    @Override
    public String getId() {
        return this.getString("cmis:objectId");
    }

    @Override
    public String getTypeId() {
        return this.getId("cmis:objectTypeId");
    }

    public String getBaseTypeId() {
        return this.getId("cmis:baseTypeId");
    }

    @Override
    public String getName() {
        return this.getString("cmis:name");
    }

    @Override
    public String getCreatedBy() {
        return this.getString("cmis:createdBy");
    }

    @Override
    public Calendar getCreationDate() {
        return this.getDateTime("cmis:creationDate");
    }

    @Override
    public String getLastModifiedBy() {
        return this.getString("cmis:lastModifiedBy");
    }

    @Override
    public Calendar getLastModificationDate() {
        return this.getDateTime("cmis:lastModificationDate");
    }

    @Override
    public String getChangeToken() {
        return this.getString("cmis:changeToken");
    }

    @Override
    public boolean isImmutable() {
        Boolean b = this.getBoolean("cmis:isImmutable");
        return b == null ? false : b;
    }

    @Override
    public boolean isLatestVersion() {
        Boolean b = this.getBoolean("cmis:isLatestVersion");
        return b == null ? false : b;
    }

    @Override
    public boolean isMajorVersion() {
        Boolean b = this.getBoolean("cmis:isMajorVersion");
        return b == null ? false : b;
    }

    @Override
    public boolean isLatestMajorVersion() {
        Boolean b = this.getBoolean("cmis:isLatestMajorVersion");
        return b == null ? false : b;
    }

    @Override
    public String getVersionLabel() {
        return this.getString("cmis:versionLabel");
    }

    @Override
    public String getVersionSeriesId() {
        return this.getId("cmis:versionSeriesId");
    }

    @Override
    public boolean isVersionSeriesCheckedOut() {
        Boolean b = this.getBoolean("cmis:isVersionSeriesCheckedOut");
        return b == null ? false : b;
    }

    @Override
    public String getVersionSeriesCheckedOutBy() {
        return this.getString("cmis:versionSeriesCheckedOutBy");
    }

    @Override
    public String getVersionSeriesCheckedOutId() {
        return this.getId("cmis:versionSeriesCheckedOutId");
    }

    @Override
    public String getCheckInComment() {
        return this.getString("cmis:checkinComment");
    }

    @Override
    public void setName(String value) {
        this.setValue("cmis:name", (Serializable)((Object)value));
    }
}

