/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.base;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.Paging;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryCapabilities;
import org.apache.chemistry.RepositoryEntry;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.Type;
import org.apache.chemistry.TypeManager;
import org.apache.chemistry.impl.simple.SimpleType;
import org.apache.chemistry.impl.simple.SimpleTypeManager;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRepository
implements Repository,
RepositoryInfo,
RepositoryCapabilities {
    public static final String ROOT_TYPE_ID = "chemistry:root";
    public static final String ROOT_FOLDER_NAME = "";
    public static final SimpleType ROOT_TYPE = new SimpleType("chemistry:root", BaseType.FOLDER.getId(), "chemistry:root", null, "chemistry:root", "Root Folder Type", BaseType.FOLDER, "", false, false, false, false, false, false, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.<PropertyDefinition>emptyList());
    public static final SimpleType DOCUMENT_TYPE = new SimpleType(BaseType.DOCUMENT.getId(), null, BaseType.DOCUMENT.getId(), null, BaseType.DOCUMENT.getId(), "Document Type", BaseType.DOCUMENT, "", true, true, true, true, true, true, true, true, ContentStreamPresence.ALLOWED, null, null, Collections.<PropertyDefinition>emptyList());
    public static final SimpleType FOLDER_TYPE = new SimpleType(BaseType.FOLDER.getId(), null, BaseType.FOLDER.getId(), null, BaseType.FOLDER.getId(), "Folder Type", BaseType.FOLDER, "", true, true, false, true, true, true, true, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.<PropertyDefinition>emptyList());
    public static final SimpleType RELATIONSHIP_TYPE = new SimpleType(BaseType.RELATIONSHIP.getId(), null, BaseType.RELATIONSHIP.getId(), null, BaseType.RELATIONSHIP.getId(), "Relationship Type", BaseType.RELATIONSHIP, "", true, true, false, false, false, true, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.<PropertyDefinition>emptyList());
    protected static final SimpleType POLICY_TYPE = new SimpleType(BaseType.POLICY.getId(), null, BaseType.POLICY.getId(), null, "Policy", "Policy Type", BaseType.POLICY, "", true, true, false, false, false, true, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.<PropertyDefinition>emptyList());
    protected final String name;
    protected final TypeManager typeManager = new SimpleTypeManager();

    protected BaseRepository(String name) {
        this.name = name;
    }

    protected static Collection<SimpleType> getDefaultTypes() {
        return Arrays.asList(DOCUMENT_TYPE, FOLDER_TYPE, RELATIONSHIP_TYPE, POLICY_TYPE, ROOT_TYPE);
    }

    protected void addTypes(Collection<SimpleType> types) {
        for (SimpleType type : types) {
            this.typeManager.addType(type);
        }
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RepositoryInfo getInfo() {
        return this;
    }

    @Override
    public String getVendorName() {
        return "Apache";
    }

    @Override
    public String getProductVersion() {
        return "0.5-SNAPSHOT";
    }

    @Override
    public String getVersionSupported() {
        return "1.0";
    }

    @Override
    public Document getRepositorySpecificInformation() {
        return null;
    }

    @Override
    public RepositoryCapabilities getCapabilities() {
        return this;
    }

    @Override
    public Collection<RepositoryEntry> getRelatedRepositories() {
        return Collections.emptySet();
    }

    @Override
    public void addType(Type type) {
        throw new UnsupportedOperationException("Cannot add types");
    }

    @Override
    public Type getType(String typeId) {
        return this.typeManager.getType(typeId);
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String id) {
        return this.typeManager.getPropertyDefinition(id);
    }

    @Override
    public Collection<Type> getTypes() {
        return this.typeManager.getTypes();
    }

    @Override
    public Collection<Type> getTypeDescendants(String typeId) {
        return this.typeManager.getTypeDescendants(typeId);
    }

    @Override
    public ListPage<Type> getTypeChildren(String typeId, boolean includePropertyDefinitions, Paging paging) {
        return this.typeManager.getTypeChildren(typeId, includePropertyDefinitions, paging);
    }

    @Override
    public Collection<Type> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        return this.typeManager.getTypeDescendants(typeId, depth, includePropertyDefinitions);
    }
}

