/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFulltext {
    private static final Pattern wordPattern = Pattern.compile("[\\s\\p{Punct}]+");
    private static final String UNACCENTED = "aaaaaaaceeeeiiii\u00f0nooooo\u00f7ouuuuy\u00fey";
    private static final String STOPWORDS = "a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org";
    private static final Set<String> stopWords = new HashSet<String>(SimpleFulltext.split("a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org", ' '));

    private SimpleFulltext() {
    }

    protected static Set<String> parseFulltext(Map<String, Serializable> data) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Serializable> es : data.entrySet()) {
            Serializable value = es.getValue();
            if (value instanceof String) {
                SimpleFulltext.parseFullText((String)((Object)value), set);
                continue;
            }
            if (!(value instanceof String[])) continue;
            for (String v : (String[])value) {
                SimpleFulltext.parseFullText(v, set);
            }
        }
        return set;
    }

    protected static void parseFullText(String string, Set<String> set) {
        if (string == null) {
            return;
        }
        for (String word : wordPattern.split(string)) {
            String w = SimpleFulltext.parseWord(word);
            if (w == null) continue;
            set.add(w);
        }
    }

    protected static boolean matchesFullText(Set<String> fulltextWords, String query) {
        if (fulltextWords == null || query == null) {
            return false;
        }
        Set<String> queryWords = SimpleFulltext.split(query, ' ');
        if (queryWords.isEmpty()) {
            return false;
        }
        for (String word : queryWords) {
            if (fulltextWords.contains(word)) continue;
            return false;
        }
        return true;
    }

    protected static final String parseWord(String string) {
        String word;
        int len = string.length();
        if (len < 3) {
            return null;
        }
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c == '\u00e6') {
                buf.append("ae");
                continue;
            }
            if (c >= '\u00e0' && c <= '\u00ff') {
                buf.append(UNACCENTED.charAt(c - 224));
                continue;
            }
            if (c == '\u0153') {
                buf.append("oe");
                continue;
            }
            buf.append(c);
        }
        int l = buf.length();
        if (l > 3 && buf.charAt(l - 1) == 's') {
            buf.setLength(l - 1);
        }
        if (stopWords.contains(word = buf.toString())) {
            return null;
        }
        return word;
    }

    protected static Set<String> split(String string, char sep) {
        int len = string.length();
        if (len == 0) {
            return Collections.emptySet();
        }
        int end = string.indexOf(sep);
        if (end == -1) {
            return Collections.singleton(string);
        }
        HashSet<String> set = new HashSet<String>();
        int start = 0;
        do {
            String segment = string.substring(start, end);
            set.add(segment);
        } while ((end = string.indexOf(sep, start = end + 1)) != -1);
        if (start < len) {
            set.add(string.substring(start));
        } else {
            set.add("");
        }
        return set;
    }
}

