/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ChangeInfo;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.impl.simple.SimpleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectEntry
implements ObjectEntry {
    protected final SimpleData data;
    protected ChangeInfo changeInfo;
    protected String path;
    protected String pathSegment;

    public SimpleObjectEntry(SimpleData data, Connection connection) {
        this.data = data;
        this.path = this.getPath(connection);
    }

    @Override
    public String getId() {
        return (String)this.data.get("cmis:objectId");
    }

    @Override
    public String getTypeId() {
        return (String)this.data.get("cmis:objectTypeId");
    }

    @Override
    public BaseType getBaseType() {
        String baseTypeId = (String)this.data.get("cmis:baseTypeId");
        return baseTypeId == null ? null : BaseType.get(baseTypeId);
    }

    @Override
    public ChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public void setChangeInfo(ChangeInfo changeInfo) {
        this.changeInfo = changeInfo;
    }

    @Override
    public String getPathSegment() {
        return this.pathSegment;
    }

    public void setPathSegment(String pathSegment) {
        this.pathSegment = pathSegment;
    }

    @Override
    public Map<String, Serializable> getValues() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(this.data);
        if (map.containsKey("cmis:path")) {
            map.put("cmis:path", this.getValue("cmis:path"));
        }
        return map;
    }

    @Override
    public Serializable getValue(String id) {
        if (id.equals("cmis:path")) {
            return this.path;
        }
        return (Serializable)this.data.get(id);
    }

    protected String getPath(Connection connection) {
        String parentPath;
        ObjectEntry parent;
        if (this.getBaseType() == BaseType.FOLDER) {
            if (this.getId() == null) {
                return null;
            }
            parent = connection.getSPI().getFolderParent(this, null);
        } else {
            Collection<ObjectEntry> parents = connection.getSPI().getObjectParents(this, null);
            if (parents.size() == 0) {
                parent = null;
            } else {
                if (parents.size() > 1) {
                    return null;
                }
                parent = parents.iterator().next();
            }
        }
        if (parent == null) {
            parentPath = "";
        } else {
            parentPath = (String)((Object)parent.getValue("cmis:path"));
            if (parentPath == null) {
                return null;
            }
            if (parentPath.equals("/")) {
                parentPath = "";
            }
        }
        String name = (String)((Object)this.getValue("cmis:name"));
        return parentPath + "/" + name;
    }

    @Override
    public void setValue(String id, Serializable value) {
        if (value == null) {
            this.data.remove(id);
        } else {
            this.data.put(id, value);
        }
    }

    @Override
    public void setValues(Map<String, Serializable> values) {
        for (String id : values.keySet()) {
            this.setValue(id, values.get(id));
        }
    }

    @Override
    public Map<QName, Boolean> getAllowableActions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ObjectEntry> getRelationships() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getTypeId() + ',' + this.getId() + ')';
    }
}

