/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryEntry;
import org.apache.chemistry.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRepositoryService
implements RepositoryService {
    private List<Repository> repositories;

    public SimpleRepositoryService(Repository repository) {
        this.repositories = Collections.singletonList(repository);
    }

    public SimpleRepositoryService(List<Repository> repositories) {
        if (repositories == null || repositories.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.repositories = new ArrayList<Repository>(repositories);
    }

    @Override
    public Repository getDefaultRepository() {
        return this.repositories.get(0);
    }

    @Override
    public Collection<RepositoryEntry> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    @Override
    public Repository getRepository(String repositoryId) {
        for (Repository repository : this.repositories) {
            if (!repository.getId().equals(repositoryId)) continue;
            return repository;
        }
        return null;
    }
}

