/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.test;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.Repository;
import org.apache.chemistry.Updatability;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimplePropertyDefinition;
import org.apache.chemistry.impl.simple.SimpleRepository;
import org.apache.chemistry.impl.simple.SimpleType;
import org.apache.chemistry.test.MainServlet;

public class BasicHelper {
    public static final String TEST_FILE_CONTENT = "This is a test file.\nTesting, testing...\n";

    private BasicHelper() {
    }

    public static Repository makeSimpleRepository(String rootId) throws Exception {
        SimplePropertyDefinition p1 = new SimplePropertyDefinition("title", "def:title", null, "title", "Title", "", false, PropertyType.STRING, false, null, false, false, (Serializable)((Object)"(no title)"), Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
        SimplePropertyDefinition p2 = new SimplePropertyDefinition("description", "def:description", null, "description", "Description", "", false, PropertyType.STRING, false, null, false, false, (Serializable)((Object)""), Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
        SimplePropertyDefinition p3 = new SimplePropertyDefinition("date", "def:date", null, "date", "Date", "", false, PropertyType.DATETIME, false, null, false, false, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
        SimpleType dt = new SimpleType("doc", BaseType.DOCUMENT.getId(), "doc", null, "Doc", "My Doc Type", BaseType.DOCUMENT, "", true, true, true, true, true, true, true, true, ContentStreamPresence.ALLOWED, null, null, Arrays.asList(p1, p2, p3));
        SimpleType ft = new SimpleType("fold", BaseType.FOLDER.getId(), "fold", null, "Fold", "My Folder Type", BaseType.FOLDER, "", true, true, true, true, true, true, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Arrays.asList(p1, p2));
        SimpleRepository repo = new SimpleRepository("test", Arrays.asList(dt, ft), rootId);
        return repo;
    }

    public static void populateRepository(Repository repo) throws Exception {
        Connection conn = repo.getConnection(null);
        Folder root = conn.getRootFolder();
        Folder folder1 = root.newFolder("fold");
        folder1.setName("folder 1");
        folder1.setValue("title", (Serializable)((Object)"The folder 1 description"));
        folder1.setValue("description", (Serializable)((Object)"folder 1 title"));
        folder1.save();
        Folder folder2 = folder1.newFolder("fold");
        folder2.setName("folder 2");
        folder2.setValue("title", (Serializable)((Object)"The folder 2 description"));
        folder2.setValue("description", (Serializable)((Object)"folder 2 title"));
        folder2.save();
        Document doc1 = folder1.newDocument("doc");
        doc1.setName("doc 1");
        doc1.setValue("title", (Serializable)((Object)"doc 1 title"));
        doc1.setValue("description", (Serializable)((Object)"The doc 1 descr"));
        doc1.save();
        Document doc2 = folder2.newDocument("doc");
        doc2.setName("doc 2");
        doc2.setValue("title", (Serializable)((Object)"doc 2 title"));
        doc2.setValue("description", (Serializable)((Object)"The doc 2 descr"));
        doc2.save();
        Document doc3 = folder2.newDocument("doc");
        doc3.setName("doc 3");
        SimpleContentStream cs = new SimpleContentStream(TEST_FILE_CONTENT.getBytes("UTF-8"), "text/plain", "doc3.txt");
        doc3.setContentStream(cs);
        doc3.save();
        Document doc4 = folder2.newDocument("doc");
        doc4.setName("dog.jpg");
        doc4.setValue("title", (Serializable)((Object)"A Dog"));
        doc4.setValue("description", (Serializable)((Object)"This is a small dog"));
        InputStream stream = MainServlet.class.getResourceAsStream("/dog.jpg");
        cs = new SimpleContentStream(stream, "image/jpeg", "dog.jpg");
        doc4.setContentStream(cs);
        doc4.save();
        conn.close();
    }
}

