/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GregorianCalendar
extends java.util.GregorianCalendar {
    private static final long serialVersionUID = 1L;
    private static final Pattern ATOMPUB_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(?:\\.(\\d+))?(?:[Zz]|([+-]\\d{2}:\\d{2}))");

    public static GregorianCalendar getInstance() {
        return new GregorianCalendar();
    }

    public static GregorianCalendar getInstance(TimeZone zone) {
        return new GregorianCalendar(zone);
    }

    public static GregorianCalendar fromAtomPub(String date) {
        Matcher m = ATOMPUB_PATTERN.matcher(date);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid date format: " + date);
        }
        String tz = m.group(8);
        GregorianCalendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT" + (tz == null ? "" : tz)));
        cal.set(1, Integer.parseInt(m.group(1)));
        cal.set(2, Integer.parseInt(m.group(2)) - 1);
        cal.set(5, Integer.parseInt(m.group(3)));
        cal.set(11, Integer.parseInt(m.group(4)));
        cal.set(12, Integer.parseInt(m.group(5)));
        cal.set(13, Integer.parseInt(m.group(6)));
        String decimals = m.group(7);
        int ms = decimals == null ? 0 : Integer.parseInt((decimals + "00").substring(0, 3));
        cal.set(14, ms);
        return cal;
    }

    public static String toAtomPub(Calendar cal) {
        StringBuilder buf = new StringBuilder(28);
        GregorianCalendar.toAtomPub(cal, buf);
        return buf.toString();
    }

    public static String toAtomPub(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        return GregorianCalendar.toAtomPub(cal);
    }

    protected static void toAtomPub(Calendar cal, StringBuilder buf) {
        buf.append(cal.get(1));
        buf.append('-');
        int f = cal.get(2);
        if (f < 9) {
            buf.append('0');
        }
        buf.append(f + 1);
        buf.append('-');
        f = cal.get(5);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append('T');
        f = cal.get(11);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append(':');
        f = cal.get(12);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append(':');
        f = cal.get(13);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append('.');
        f = cal.get(14);
        if (f < 100) {
            buf.append('0');
        }
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
        if (offset == 0) {
            buf.append('Z');
        } else {
            char sign;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            buf.append(sign);
            f = offset / 60;
            if (f < 10) {
                buf.append('0');
            }
            buf.append(f);
            buf.append(':');
            f = offset % 60;
            if (f < 10) {
                buf.append('0');
            }
            buf.append(f);
        }
    }

    public GregorianCalendar() {
    }

    public GregorianCalendar(TimeZone zone) {
        super(zone);
    }

    public GregorianCalendar(Locale aLocale) {
        super(aLocale);
    }

    public GregorianCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
    }

    public GregorianCalendar(int year, int month, int dayOfMonth) {
        super(year, month, dayOfMonth);
    }

    public GregorianCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        super(year, month, dayOfMonth, hourOfDay, minute);
    }

    public GregorianCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        super(year, month, dayOfMonth, hourOfDay, minute, second);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(47);
        buf.append("GregorianCalendar(");
        GregorianCalendar.toAtomPub(this, buf);
        buf.append(')');
        return buf.toString();
    }
}

