/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.xml.stax;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.FilteredChildrenNavigator;

public class StaxReader
extends StreamReaderDelegate {
    protected static final XMLInputFactory factory = XMLInputFactory.newInstance();
    protected int depth;
    protected String defNsUri;

    public static final XMLInputFactory getFactory() {
        return factory;
    }

    public static StaxReader newReader(InputStream in) throws XMLStreamException {
        return new StaxReader(factory.createXMLStreamReader(in));
    }

    public static StaxReader newReader(Reader reader) throws XMLStreamException {
        return new StaxReader(factory.createXMLStreamReader(reader));
    }

    public static StaxReader newReader(XMLStreamReader reader) throws XMLStreamException {
        return new StaxReader(reader);
    }

    public StaxReader(XMLStreamReader reader) {
        super(reader);
    }

    public int getDepth() {
        return this.depth;
    }

    public String getElementText() throws XMLStreamException {
        --this.depth;
        return super.getElementText();
    }

    public final int getElementDepth() throws XMLStreamException {
        return this.getEventType() == 2 ? this.depth + 1 : this.depth;
    }

    public final int getChildrenDepth() throws XMLStreamException {
        return this.getElementDepth() + 1;
    }

    public boolean fwd() throws XMLStreamException {
        if (!this.hasNext()) {
            return false;
        }
        int tok = this.next();
        if (tok == 1) {
            ++this.depth;
        } else if (tok == 2) {
            --this.depth;
        }
        return true;
    }

    public boolean fwdTag() throws XMLStreamException {
        while (this.hasNext() && this.fwd()) {
            if (this.getEventType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean fwdTag(String localName) throws XMLStreamException {
        while (this.hasNext() && this.fwd()) {
            if (this.getEventType() != 1 || !localName.equals(this.getLocalName())) continue;
            return true;
        }
        return false;
    }

    public boolean fwdTag(String nsUri, String localName) throws XMLStreamException {
        while (this.hasNext() && this.fwd()) {
            if (this.getEventType() != 1 || !localName.equals(this.getLocalName()) || !nsUri.equals(this.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    public boolean getFirstTag(QName name) throws XMLStreamException {
        if (this.getEventType() == 1 && this.getName().equals(name)) {
            return true;
        }
        return this.fwdTag(name);
    }

    public boolean getFirstTag(String localName) throws XMLStreamException {
        if (this.getEventType() == 1 && this.getLocalName().equals(localName)) {
            return true;
        }
        return this.fwdTag(localName);
    }

    public boolean getFirstTag(String nsUri, String localName) throws XMLStreamException {
        if (this.getEventType() == 1 && this.getLocalName().equals(localName) && this.getNamespaceURI().equals(nsUri)) {
            return true;
        }
        return this.fwdTag(nsUri, localName);
    }

    public boolean fwdTag(QName name) throws XMLStreamException {
        while (this.hasNext() && this.fwd()) {
            if (this.getEventType() != 1 || !name.equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean fwdSibling() throws XMLStreamException {
        int tok = this.getEventType();
        if (tok == 2) {
            return this.fwdSibling(this.depth + 1);
        }
        if (tok == 1) {
            return this.fwdSibling(this.depth);
        }
        throw new XMLStreamException("Ilegal state: current event must be START_ELEMENT or END_ELEMENT");
    }

    public boolean fwdSibling(int cdepth) throws XMLStreamException {
        while (this.hasNext() && this.fwd()) {
            if (this.depth < cdepth - 1) {
                return false;
            }
            if (this.depth > cdepth || this.getEventType() != 1 || this.depth != cdepth) continue;
            return true;
        }
        return false;
    }

    public boolean fwdSibling(String localName) throws XMLStreamException {
        while (this.fwdSibling()) {
            if (!localName.equals(this.getLocalName())) continue;
            return true;
        }
        return false;
    }

    public boolean fwdSibling(QName name) throws XMLStreamException {
        while (this.fwdSibling()) {
            if (!name.equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean fwdSibling(String nsUri, String localName) throws XMLStreamException {
        while (this.fwdSibling()) {
            if (!localName.equals(this.getLocalName()) || !nsUri.equals(this.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    public ChildrenNavigator getChildren() throws XMLStreamException {
        return new ChildrenNavigator(this, this.depth + 1);
    }

    public ChildrenNavigator getChildren(final String localName) throws XMLStreamException {
        return new FilteredChildrenNavigator(this, this.depth + 1){

            protected boolean accept() {
                return localName.equals(StaxReader.this.getLocalName());
            }
        };
    }

    public ChildrenNavigator getChildren(final String nsUri, final String localName) throws XMLStreamException {
        return new FilteredChildrenNavigator(this, this.depth + 1){

            protected boolean accept() {
                return localName.equals(StaxReader.this.getLocalName()) && nsUri.equals(StaxReader.this.getNamespaceURI());
            }
        };
    }

    public ChildrenNavigator getChildren(final QName name) throws XMLStreamException {
        return new FilteredChildrenNavigator(this, this.depth + 1){

            protected boolean accept() {
                return name.equals(StaxReader.this.getName());
            }
        };
    }

    public String getAttributeValue(String localName) {
        int cnt = this.getAttributeCount();
        for (int i = 0; i < cnt; ++i) {
            if (!localName.equals(this.getAttributeName(i).getLocalPart())) continue;
            return this.getAttributeValue(i);
        }
        return null;
    }

    public String getDefaultNamespaceURI() {
        if (this.defNsUri == null) {
            this.defNsUri = this.getNamespaceURI("");
            if (this.defNsUri == null) {
                this.defNsUri = "";
            }
        }
        return this.defNsUri;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        String val;
        if (namespaceURI == null || "".equals(namespaceURI)) {
            val = this.getAttributeValue(localName);
        } else {
            val = super.getAttributeValue(namespaceURI, localName);
            if (val == null && namespaceURI.equals(this.getDefaultNamespaceURI())) {
                val = this.getAttributeValue(localName);
            }
        }
        return val;
    }

    public String getAttributeValue(QName name) {
        return this.getAttributeValue(name.getNamespaceURI(), name.getLocalPart());
    }

    static {
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setXMLResolver(new XMLResolver(){

            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                return new ByteArrayInputStream(new byte[0]);
            }
        });
    }
}

