/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.CacheImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.LruCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.MapCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;

public class TypeDefinitionCacheImpl
implements TypeDefinitionCache {
    private static final long serialVersionUID = 1L;
    private Cache cache;

    @Override
    public void initialize(BindingSession session) {
        int typeCount;
        assert (session != null);
        int repCount = session.get("org.apache.chemistry.opencmis.binding.cache.repositories.size", 10);
        if (repCount < 1) {
            repCount = 10;
        }
        if ((typeCount = session.get("org.apache.chemistry.opencmis.binding.cache.types.size", 100)) < 1) {
            typeCount = 100;
        }
        this.cache = new CacheImpl("Type Definition Cache");
        this.cache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " " + "capacity" + "=" + repCount, LruCacheLevelImpl.class.getName() + " " + "maxEntries" + "=" + typeCount});
    }

    @Override
    public void put(String repositoryId, TypeDefinition typeDefinition) {
        if (typeDefinition == null || typeDefinition.getId() == null) {
            return;
        }
        this.cache.put(typeDefinition, repositoryId, typeDefinition.getId());
    }

    @Override
    public TypeDefinition get(String repositoryId, String typeId) {
        return (TypeDefinition)this.cache.get(repositoryId, typeId);
    }

    @Override
    public void remove(String repositoryId, String typeId) {
        this.cache.remove(repositoryId, typeId);
    }

    @Override
    public void remove(String repositoryId) {
        this.cache.remove(repositoryId);
    }

    @Override
    public void removeAll() {
        this.cache.removeAll();
    }

    public String toString() {
        return this.cache.toString();
    }
}

