/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.cwt.svg.SvgDocument;
import org.eclipse.nebula.cwt.v.IControlPainter;
import org.eclipse.nebula.cwt.v.VNative;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VControl {
    public static final boolean carbon = "carbon".equals(SWT.getPlatform());
    public static final boolean gtk = "gtk".equals(SWT.getPlatform());
    public static final boolean win32 = "win32".equals(SWT.getPlatform());
    private static final int[] Points_OK = new int[]{2, 6, 5, 9, 10, 3, 9, 2, 5, 7, 3, 5};
    private static final int[] Points_Cancel;
    private static final int[] Points_Left;
    private static final int[] Points_Right;
    private static final int[] Points_Up;
    private static final int[] Points_Down;
    private static final int[] Points_Add;
    private static final int[] Points_Subtract;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_SELECTED = 4;
    public static final int STATE_ENABLED = 16;
    public static final int STATE_MOUSE_DOWN = 32;
    Composite composite;
    VPanel parent;
    private int style;
    Menu menu;
    Image image;
    SvgDocument svg;
    String text;
    String tooltipText;
    int[] points;
    Color fill;
    Color foreground;
    Color background;
    private Cursor activeCursor;
    private Cursor inactiveCursor;
    GridData layoutData;
    private int state = 16;
    Rectangle bounds;
    int marginTop = 5;
    int marginBottom = 5;
    int marginLeft = 5;
    int marginRight = 5;
    int xAlign;
    int yAlign;
    boolean disposed = false;
    boolean square = false;
    int visibility = 100;
    boolean scaleImage = false;
    boolean customToolTip = false;
    IControlPainter painter;
    Map<String, Object> dataMap;
    Map<Integer, List<Listener>> listeners = new HashMap<Integer, List<Listener>>();
    private Set<Integer> eventTypes = new HashSet<Integer>();
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 15 && VControl.this == VTracker.getFocusControl()) {
                return;
            }
            VControl.this.handleEvent(event);
        }
    };
    private boolean activatable = true;

    static {
        int[] nArray = new int[24];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[5] = 7;
        nArray[6] = 1;
        nArray[7] = 8;
        nArray[8] = 4;
        nArray[9] = 5;
        nArray[10] = 7;
        nArray[11] = 8;
        nArray[12] = 8;
        nArray[13] = 7;
        nArray[14] = 5;
        nArray[15] = 4;
        nArray[16] = 8;
        nArray[17] = 1;
        nArray[18] = 7;
        nArray[20] = 4;
        nArray[21] = 3;
        nArray[22] = 1;
        Points_Cancel = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 9;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 9;
        nArray2[5] = 10;
        Points_Left = nArray2;
        int[] nArray3 = new int[6];
        nArray3[0] = 2;
        nArray3[2] = 7;
        nArray3[3] = 5;
        nArray3[4] = 2;
        nArray3[5] = 10;
        Points_Right = nArray3;
        int[] nArray4 = new int[6];
        nArray4[0] = 10;
        nArray4[1] = 8;
        nArray4[2] = 5;
        nArray4[3] = 3;
        nArray4[5] = 8;
        Points_Up = nArray4;
        int[] nArray5 = new int[6];
        nArray5[0] = 10;
        nArray5[1] = 2;
        nArray5[2] = 5;
        nArray5[3] = 7;
        nArray5[5] = 2;
        Points_Down = nArray5;
        Points_Add = new int[]{2, 4, 4, 4, 4, 2, 5, 2, 5, 4, 7, 4, 7, 5, 5, 5, 5, 7, 4, 7, 4, 5, 2, 5};
        Points_Subtract = new int[]{2, 4, 7, 4, 7, 5, 2, 5};
    }

    protected static final boolean containsControl(Control control, Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            Control[] children;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!child.isDisposed()) {
                    if (child == control) {
                        return true;
                    }
                    if (child instanceof Composite) {
                        return VControl.containsControl(control, (Composite)child);
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public VControl(VPanel panel, int style) {
        this.setParent(panel);
        this.style = style;
        this.bounds = new Rectangle(0, 0, 0, 0);
        if ((style & 0x20) != 0) {
            this.setPolygon(Points_OK);
            this.setForeground(Display.getDefault().getSystemColor(6));
        } else if ((style & 0x100) != 0) {
            this.setPolygon(Points_Cancel);
            this.setForeground(Display.getDefault().getSystemColor(4));
        } else if ((style & 4) != 0) {
            if ((style & 0x400) != 0) {
                this.setPolygon(Points_Down);
            } else if ((style & 0x4000) != 0) {
                this.setPolygon(Points_Left);
            } else if ((style & 0x20000) != 0) {
                this.setPolygon(Points_Right);
            } else if ((style & 0x80) != 0) {
                this.setPolygon(Points_Up);
            }
        } else if ((style & 0x80) != 0) {
            this.setPolygon(Points_Add);
        } else if ((style & 0x400) != 0) {
            this.setPolygon(Points_Subtract);
        }
        if (this.foreground == null) {
            this.setForeground(Display.getDefault().getSystemColor(21));
        }
        if (this.fill == null) {
            this.setFill(this.getForeground());
        }
    }

    void handleEvent(Event event) {
        event.data = this;
        this.filterEvent(event);
        if (this.listeners.containsKey(event.type)) {
            Listener[] la;
            Listener[] listenerArray = la = this.listeners.get(event.type).toArray(new Listener[this.listeners.get(event.type).size()]);
            int n = la.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.handleEvent(event);
                ++n2;
            }
        }
    }

    void activate() {
        if (this.activatable && this.hasState(16) && this.setState(2, true)) {
            this.setState(32, VTracker.isMouseDown());
            this.setCursor(this.activeCursor);
            this.attachListeners(false);
            if (this.redrawOnActivate()) {
                this.redraw();
            }
            this.notifyListeners(26);
        }
    }

    void addListener(int eventType) {
        this.eventTypes.add(eventType);
        if (this.hasState(2)) {
            this.composite.addListener(eventType, this.listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        if (!this.listeners.containsKey(eventType)) {
            this.listeners.put(eventType, new ArrayList());
        }
        this.listeners.get(eventType).add(listener);
        if (this.hasState(2)) {
            this.composite.addListener(eventType, listener);
        }
    }

    void attachListeners(boolean keyListeners) {
        HashSet<Integer> eventTypes = new HashSet<Integer>(this.eventTypes);
        eventTypes.addAll(this.listeners.keySet());
        for (Integer eventType : eventTypes) {
            if (!this.include(keyListeners, eventType)) continue;
            this.composite.addListener(eventType.intValue(), this.listener);
        }
    }

    void detachListeners(boolean keyListeners) {
        HashSet<Integer> eventTypes = new HashSet<Integer>(this.eventTypes);
        eventTypes.addAll(this.listeners.keySet());
        for (Integer eventType : eventTypes) {
            if (!this.include(keyListeners, eventType)) continue;
            this.composite.removeListener(eventType.intValue(), this.listener);
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = new Point(2, 2);
        if (this.image != null) {
            Rectangle r = this.image.getBounds();
            size.x = r.width;
            size.y = r.height;
        } else if (this.points != null) {
            if (this.points.length > 2) {
                int minX = this.points[0];
                int maxX = this.points[0];
                int minY = this.points[1];
                int maxY = this.points[1];
                int i = 2;
                while (i < this.points.length - 1) {
                    minX = Math.min(minX, this.points[i]);
                    maxX = Math.max(maxX, this.points[i]);
                    minY = Math.min(minY, this.points[i + 1]);
                    maxY = Math.max(maxY, this.points[i + 1]);
                    ++i;
                }
                size.x += maxX - minX;
                size.y += maxY - minY;
            } else {
                size.x += this.points[0];
                size.y += this.points[1];
            }
        }
        if (this.text != null) {
            GC gc = new GC((Drawable)this.composite);
            Point tSize = gc.textExtent(this.text);
            gc.dispose();
            size.x += tSize.x;
            size.y += tSize.y;
        }
        size.x += this.marginLeft + this.marginRight;
        size.y += this.marginTop + this.marginBottom;
        if (this.square) {
            size.x = size.y = Math.max(size.x, size.y);
        }
        return size;
    }

    public Menu createMenu() {
        this.menu = new Menu((Control)this.composite);
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (3 == event.type && event.button == 3) {
                    VControl.this.menu.setVisible(true);
                }
            }
        });
        return this.menu;
    }

    void deactivate() {
        if (this.setState(2, false)) {
            this.setState(32, false);
            this.setCursor(this.inactiveCursor);
            this.detachListeners(false);
            if (this.redrawOnDeactivate()) {
                this.redraw();
            }
            this.notifyListeners(27);
        }
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.notifyListeners(12, new Event());
            if (this == VTracker.getActiveControl()) {
                VTracker.instance().deactivate(this);
            }
            if (this == VTracker.getFocusControl()) {
                VTracker.instance().setFocusControl(null);
            }
            if (!this.composite.isDisposed()) {
                this.detachListeners(true);
                this.detachListeners(false);
            }
            this.setParent(null);
            if (this.painter != null) {
                this.painter.dispose();
            }
            this.listeners.clear();
            this.listeners = null;
            this.text = null;
            this.tooltipText = null;
            this.image = null;
            this.points = null;
        }
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        VPanel p = this.parent;
        while (p != null) {
            if (p.background != null) {
                return p.background;
            }
            p = p.parent;
        }
        return this.composite.getBackground();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public Rectangle getClientArea() {
        return new Rectangle(this.bounds.x + this.marginLeft, this.bounds.y + this.marginTop, this.bounds.width - (this.marginLeft + this.marginRight), this.bounds.height - (this.marginTop + this.marginBottom));
    }

    public Point getClientSize() {
        return new Point(this.bounds.width - (this.marginLeft + this.marginRight), this.bounds.height - (this.marginTop + this.marginBottom));
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Control getControl() {
        return this.composite;
    }

    public Object getData(Enum<?> name) {
        return this.getData(name.name());
    }

    public <T> T getData(Enum<?> name, Class<T> clazz) {
        return this.getData(name.name(), clazz);
    }

    public Object getData(String name) {
        if (this.dataMap != null) {
            return this.dataMap.get(name);
        }
        return null;
    }

    public <T> T getData(String name, Class<T> clazz) {
        if (this.dataMap != null) {
            return (T)this.dataMap.get(name);
        }
        return null;
    }

    public Display getDisplay() {
        return this.composite.getDisplay();
    }

    public boolean getEnabled() {
        return this.hasState(16);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Image getImage() {
        return this.image;
    }

    public GridData getLayoutData() {
        return this.layoutData != null ? this.layoutData : new GridData();
    }

    protected Listener[] getListeners(int eventType) {
        List<Listener> l = this.listeners.get(eventType);
        return l.toArray(new Listener[l.size()]);
    }

    public Point getLocation() {
        return new Point(this.bounds.x, this.bounds.y);
    }

    public Rectangle getMargins() {
        return new Rectangle(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
    }

    public Menu getMenu() {
        return this.menu;
    }

    public VPanel getParent() {
        return this.parent;
    }

    public Shell getShell() {
        return this.composite.getShell();
    }

    public Point getSize() {
        return new Point(this.bounds.width, this.bounds.height);
    }

    public int getState() {
        return this.state;
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        return this.tooltipText != null ? this.tooltipText : "";
    }

    public abstract Type getType();

    public int getVisibility() {
        return this.visibility;
    }

    public boolean getVisible() {
        return this.visibility > 0;
    }

    public Composite getWidget() {
        return this.getParent().getWidget();
    }

    protected void filterEvent(Event event) {
    }

    public boolean hasState(int state) {
        return (this.state & state) != 0;
    }

    public boolean hasStyle(int style) {
        return (this.style & style) != 0;
    }

    private boolean include(boolean key, int type) {
        if (type == 13) {
            return false;
        }
        if (key && (type == 1 || type == 2 || type == 31)) {
            return true;
        }
        return !key && type != 1 && type != 2 && type != 31;
    }

    public boolean isActivatable() {
        return this.activatable;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isEnabled() {
        return this.getEnabled() && (this.parent != null ? this.parent.isEnabled() : this.composite.isEnabled());
    }

    public boolean isSameWidgetAs(VControl control) {
        return control != null && this.getWidget() == control.getWidget();
    }

    public boolean isSameWidgetAs(Widget widget) {
        Composite w = this.getWidget();
        return w == widget || VControl.containsControl((Control)widget, w);
    }

    public boolean isSquare() {
        return this.square;
    }

    public boolean isVisible() {
        return this.getVisible() && this.composite.isVisible();
    }

    public void moveAbove(VControl control) {
        this.parent.move(this, null);
    }

    public void moveBelow(VControl control) {
        this.parent.move(null, this);
    }

    public void notifyListeners(int eventType) {
        this.notifyListeners(eventType, null);
    }

    public void notifyListeners(int eventType, Event event) {
        if (this.listeners.containsKey(eventType)) {
            if (event == null) {
                event = new Event();
            }
            event.data = this;
            event.type = eventType;
            if (this instanceof VNative && eventType == 16) {
                System.out.println("wtf");
            }
            Listener[] listenerArray = this.getListeners(eventType);
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.handleEvent(event);
                ++n2;
            }
        }
    }

    public final void paintControl(Event e) {
        if (this.painter != null && this.bounds.intersects(e.x, e.y, e.width, e.height) && this.isVisible()) {
            int fullH;
            int fullW;
            int alpha = e.gc.getAlpha();
            int fullX = this.bounds.x - 1;
            int fullY = this.bounds.y - 1;
            if (this.parent != null) {
                fullW = Math.min(this.parent.bounds.x + this.parent.bounds.width - this.bounds.x, this.bounds.x + this.bounds.width) + 1;
                fullH = Math.min(this.parent.bounds.y + this.parent.bounds.height - this.bounds.y, this.bounds.y + this.bounds.height) + 1;
            } else {
                fullW = this.bounds.width;
                fullH = this.bounds.height;
            }
            int clientX = fullX + this.marginLeft;
            int clientY = fullY + this.marginTop;
            int clientW = fullW - this.marginLeft - this.marginRight;
            int clientH = fullH - this.marginTop - this.marginBottom;
            e.gc.setClipping(fullX, fullY, fullW, fullH);
            this.setAlpha(e.gc);
            this.painter.paintBackground(this, e);
            if (clientW > 0 && clientH > 0) {
                e.gc.setClipping(clientX, clientY, clientW, clientH);
                this.setAlpha(e.gc);
                this.painter.paintContent(this, e);
            }
            e.gc.setClipping(fullX, fullY, fullW, fullH);
            this.setAlpha(e.gc);
            this.painter.paintBorders(this, e);
            if (!this.getEnabled()) {
                this.setAlpha(e.gc, 25);
                e.gc.setBackground(e.display.getSystemColor(22));
                e.gc.fillRectangle(fullX, fullY, fullW, fullH);
            }
            e.gc.setClipping(null);
            e.gc.setAlpha(alpha);
            if (this.listeners.containsKey(9)) {
                for (Listener listener : this.listeners.get(9)) {
                    listener.handleEvent(e);
                }
            }
        }
    }

    public void redraw() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.redraw(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, false);
        }
    }

    protected boolean redrawOnActivate() {
        return true;
    }

    protected boolean redrawOnDeactivate() {
        return true;
    }

    void removeListener(int eventType) {
        this.eventTypes.remove(eventType);
        if (this.hasState(2)) {
            this.composite.removeListener(eventType, this.listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (this.listeners.containsKey(eventType)) {
            this.listeners.get(eventType).remove(listener);
        }
        if (this.hasState(2)) {
            this.composite.removeListener(eventType, listener);
        }
    }

    public void setActivatable(boolean activatable) {
        this.activatable = activatable;
    }

    public void setActiveCursor(Cursor cursor) {
        this.activeCursor = cursor;
    }

    public void setAlignment(int x, int y) {
        this.xAlign = x;
        this.yAlign = y;
    }

    public void setAlpha(GC gc) {
        gc.setAlpha((int)(2.55 * (double)this.visibility));
    }

    public void setAlpha(GC gc, int alpha) {
        gc.setAlpha((int)((double)alpha * (double)this.visibility * 0.01));
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean moved = this.bounds.x != x || this.bounds.y != y;
        boolean resized = this.bounds.width != width || this.bounds.height != height;
        this.bounds.x = x;
        this.bounds.y = y;
        this.bounds.width = width;
        this.bounds.height = height;
        Point p = this.getDisplay().getCursorLocation();
        if (this.bounds.contains(this.toControl(p))) {
            this.activate();
        } else {
            this.deactivate();
        }
        if (moved) {
            this.notifyListeners(10, new Event());
        }
        if (resized) {
            this.notifyListeners(11, new Event());
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setCursor(Cursor cursor) {
        this.getComposite().setCursor(cursor);
    }

    public void setData(Enum<?> name, Object value) {
        this.setData(name.name(), value);
    }

    public void setData(String name, Object value) {
        if (value == null) {
            if (this.dataMap != null) {
                this.dataMap.remove(name);
                if (this.dataMap.isEmpty()) {
                    this.dataMap = null;
                }
            }
        } else {
            if (this.dataMap == null) {
                this.dataMap = new HashMap<String, Object>();
            }
            this.dataMap.put(name, value);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.setState(16, enabled)) {
            Control c;
            if (this instanceof VNative && (c = this.getControl()) != null) {
                c.setEnabled(enabled);
            }
            if (!enabled) {
                this.deactivate();
            }
            this.redraw();
        }
    }

    public void setFill(Color color) {
        this.fill = color;
    }

    public boolean setFocus() {
        return VTracker.instance().setFocusControl(this);
    }

    protected boolean setFocus(boolean focus) {
        if (!this.hasStyle(524288)) {
            if (focus) {
                this.attachListeners(true);
                this.notifyListeners(15);
            } else {
                this.notifyListeners(16);
                this.detachListeners(true);
            }
            return true;
        }
        return false;
    }

    public void setFont(Font font) {
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public void setImage(SvgDocument svg) {
        this.svg = svg;
        this.redraw();
    }

    public void setInactiveCursor(Cursor cursor) {
        this.inactiveCursor = cursor;
    }

    public void setLayoutData(GridData data) {
        this.layoutData = data;
    }

    public void setLocation(Point location) {
        if (location != null) {
            this.setLocation(location.x, location.y);
        }
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.bounds.width, this.bounds.height);
    }

    public void setMargins(int marginWidth, int marginHeight) {
        this.setMargins(marginWidth, marginWidth, marginHeight, marginHeight);
    }

    public void setMargins(int left, int right, int top, int bottom) {
        if (left >= 0) {
            this.marginLeft = left;
        }
        if (right >= 0) {
            this.marginRight = right;
        }
        if (top >= 0) {
            this.marginTop = top;
        }
        if (bottom >= 0) {
            this.marginBottom = bottom;
        }
    }

    public void setMargins(Rectangle margins) {
        this.setMargins(margins.x, margins.y, margins.width, margins.height);
    }

    public void setOval(int rx, int ry) {
        this.setPolygon(new int[]{rx, ry});
    }

    public void setOval(int rx, int ry, Color fillColor) {
        this.setPolygon(new int[]{rx, ry}, fillColor);
    }

    public void setPainter(IControlPainter painter) {
        this.painter = painter;
    }

    public void setParent(VPanel panel) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = panel;
        if (this.parent != null) {
            this.composite = this.parent.composite;
            this.parent.addChild(this);
        }
    }

    public void setPolygon(int[] points) {
        this.setPolygon(points, this.fill != null ? this.fill : (this.background != null ? this.background : this.getForeground()));
    }

    public void setPolygon(int[] points, Color fillColor) {
        if (points == null || points.length < 2 || points.length % 2 != 0) {
            return;
        }
        if (points.length == 2 && (points[0] < 1 || points[1] < 1)) {
            return;
        }
        this.points = points;
        this.setFill(fillColor);
        this.redraw();
    }

    public void setScaleImage(boolean scale) {
        this.scaleImage = scale;
    }

    public void setSize(Point size) {
        if (size != null) {
            this.setBounds(this.bounds.x, this.bounds.y, size.x, size.y);
        }
    }

    public void setSquare(boolean equal) {
        this.square = equal;
    }

    protected boolean setState(int state, boolean set) {
        if (set && !this.hasState(state)) {
            this.state |= state;
            return true;
        }
        if (!set && this.hasState(state)) {
            this.state &= ~state;
            return true;
        }
        return false;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public boolean setStyle(int style, boolean set) {
        if (set && !this.hasStyle(style)) {
            this.style |= style;
            return true;
        }
        if (!set && this.hasStyle(style)) {
            this.style &= ~style;
            return true;
        }
        return false;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public void setToolTipText(String text) {
        this.tooltipText = text;
    }

    void setVisibility(int visibility) {
        if (visibility > 100) {
            visibility = 100;
        } else if (visibility < 0) {
            visibility = 0;
        }
        this.visibility = visibility;
        if (!this.isVisible()) {
            if (this == VTracker.getFocusControl()) {
                VTracker.instance().setFocusControl(null);
            }
            VTracker.instance().deactivate(this);
        }
        this.redraw();
    }

    public void setVisible(boolean visible) {
        this.setVisibility(visible ? 100 : 0);
    }

    public void setVisible(boolean visible, int duration) {
        this.setVisible(visible, duration, null);
    }

    public void setVisible(final boolean visible, final int duration, final Runnable callback) {
        if (duration <= 0) {
            this.setVisible(visible);
        } else {
            new Thread(){

                public void run() {
                    do {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                if (!(this).VControl.this.disposed) {
                                    VControl.this.setVisibility((this).VControl.this.visibility + (visible ? 10 : -10));
                                    (this).VControl.this.composite.update();
                                }
                            }
                        });
                        if (VControl.this.disposed) continue;
                        try {
                            Thread.sleep(5 * duration / 100);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while (!VControl.this.disposed && VControl.this.visibility > 0 && VControl.this.visibility < 100);
                    if (!VControl.this.disposed && VControl.this.visibility != 0 && VControl.this.visibility != 100) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                if (!(this).VControl.this.disposed) {
                                    VControl.this.setVisible(visible);
                                    (this).VControl.this.composite.update();
                                }
                            }
                        });
                    }
                    if (callback != null) {
                        callback.run();
                    }
                }
            }.start();
        }
    }

    public Point toControl(Point point) {
        return this.getComposite().toControl(point);
    }

    public Point toControl(int x, int y) {
        return this.getComposite().toControl(x, y);
    }

    public Point toDisplay(Point point) {
        return this.getComposite().toDisplay(point);
    }

    public Point toDisplay(int x, int y) {
        return this.getComposite().toDisplay(x, y);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " {" + this.text + "}";
    }

    public void update() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Button,
        Custom,
        Label,
        Native,
        Panel,
        Text,
        Spacer;

    }
}

