/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.loading;

import java.net.URL;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.DefaultLoaderRepository;
import javax.management.loading.MLet;
import junit.framework.TestCase;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.server.ServerConstants;
import org.jboss.mx.util.AgentID;

public class LoaderRepositoryTEST
extends TestCase
implements ServerConstants {
    public LoaderRepositoryTEST(String s) {
        super(s);
    }

    public void testRemoveDuplicateURL() throws Exception {
        URL url = new URL("file:./output/etc/test/implementation/loading/MyMBeans.jar");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        LoaderRepository lr = (LoaderRepository)server.getClassLoaderRepository();
        try {
            lr.loadClass("test.implementation.loading.support.Trivial");
            LoaderRepositoryTEST.fail((String)"test.implementation.loading.support.Trivial is already visible");
        }
        catch (ClassNotFoundException expected) {
            // empty catch block
        }
        RepositoryClassLoader ucl1 = lr.newClassLoader(url, true);
        RepositoryClassLoader ucl2 = lr.newClassLoader(url, true);
        lr.loadClass("test.implementation.loading.support.Trivial");
        ucl1.unregister();
        lr.loadClass("test.implementation.loading.support.Trivial");
        ucl2.unregister();
    }

    public void testClassConflictBetweenMLets() throws Exception {
        String[] classes = new String[]{"test.implementation.loading.support.Start", "test.implementation.loading.support.StartMBean", "test.implementation.loading.support.Target", "test.implementation.loading.support.TargetMBean", "test.implementation.loading.support.AClass"};
        for (int i = 0; i < classes.length; ++i) {
            try {
                DefaultLoaderRepository.loadClass(classes[i]);
                LoaderRepositoryTEST.fail((String)("class " + classes[i] + " was already found in CL repository."));
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            MLet mlet1 = new MLet();
            MLet mlet2 = new MLet();
            ObjectName m1Name = new ObjectName(":name=mlet1");
            ObjectName m2Name = new ObjectName(":name=mlet2");
            server.registerMBean(mlet1, m1Name);
            server.registerMBean(mlet2, m2Name);
            server.invoke(m1Name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/implementation/loading/CCTest1.mlet"}, new String[]{String.class.getName()});
            server.invoke(m2Name, "getMBeansFromURL", new Object[]{"file:./output/etc/test/implementation/loading/CCTest2.mlet"}, new String[]{String.class.getName()});
            server.invoke(new ObjectName(":name=Start"), "startOp", new Object[]{AgentID.get((MBeanServer)server)}, new String[]{String.class.getName()});
        }
        catch (MBeanException e) {
            if (e.getTargetException() instanceof ReflectionException) {
                if (System.getProperty("jbossmx.loader.repository.class").equals("org.jboss.mx.loading.UnifiedLoaderRepository3")) {
                    throw e;
                }
            }
            throw e;
        }
    }
}

