/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.SecurityActions;

public class IdentityFactory {
    public static final String IDENTITY_CLASS = "org.jboss.security.identity.plugins.SimpleIdentity";
    public static final String PRINCIPAL_CLASS = "org.jboss.security.SimplePrincipal";
    public static final String GROUP_CLASS = "org.jboss.security.SimpleGroup";

    public static Principal createPrincipal(String name) throws Exception {
        Class<?> clazz = SecurityActions.getClass(PRINCIPAL_CLASS);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (Principal)ctr.newInstance(name);
    }

    public static Group createGroup(String name) throws Exception {
        Class<?> clazz = SecurityActions.getClass(GROUP_CLASS);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (Group)ctr.newInstance(name);
    }

    public static Identity createIdentity(String name) throws Exception {
        Class<?> clazz = SecurityActions.getClass(IDENTITY_CLASS);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (Identity)ctr.newInstance(name);
    }
}

