/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.principal;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectDNMapper
implements MappingProvider<Principal> {
    private static final Logger log = Logger.getLogger(SubjectDNMapper.class);
    private MappingResult<Principal> result;

    public void init(Map<String, Object> opt) {
    }

    public void setMappingResult(MappingResult<Principal> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, Principal principal) {
        if (contextMap == null) {
            throw new IllegalArgumentException("ContextMap is null");
        }
        X509Certificate[] certs = (X509Certificate[])contextMap.get("X509");
        if (certs != null) {
            SubjectDNMapping sdn = new SubjectDNMapping();
            principal = sdn.toPrinicipal(certs);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mapped to Principal:" + principal));
            }
        }
        this.result.setMappedObject((Object)principal);
    }
}

