/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.util.RecursionException;
import com.bluecast.xml.Entity;
import com.bluecast.xml.FatalParsingException;
import com.bluecast.xml.Piccolo;
import com.bluecast.xml.XMLInputReader;
import com.bluecast.xml.XMLReaderReader;
import com.bluecast.xml.XMLStreamReader;
import com.scenari.entitymap.GeneralEntitiesMap;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntityManager {
    public static final int GENERAL = 0;
    public static final int PARAMETER = 1;
    private Piccolo fParser;
    private EntityResolver resolver = null;
    private Map[] entityMaps = new HashMap[]{new HashMap(), new HashMap()};
    private Map entitiesByURI = new HashMap();
    protected GeneralEntitiesMap fDefaultGeneralMap = null;

    public EntityManager(Piccolo pParser) {
        this.fParser = pParser;
    }

    public void setResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public void setDefaultGeneralEntityMap(GeneralEntitiesMap pDefaultGeneralMap) {
        this.fDefaultGeneralMap = pDefaultGeneralMap;
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }

    public boolean putInternal(String name, String value, int type) {
        if (this.entityMaps[type].get(name) == null) {
            this.entityMaps[type].put(name, new Entry(value));
            return true;
        }
        return false;
    }

    public boolean putExternal(Entity context, String name, String pubID, String sysID, int type) throws MalformedURLException {
        if (this.entityMaps[type].get(name) == null) {
            if (this.fParser.fResolveDTDURIs) {
                sysID = EntityManager.resolveSystemID(context.getSystemID(), sysID);
            }
            Entry e = new Entry(pubID, sysID);
            this.entityMaps[type].put(name, e);
            if (pubID != null && pubID.length() > 0) {
                this.entitiesByURI.put(pubID, e);
            }
            this.entitiesByURI.put(sysID, e);
            return true;
        }
        return false;
    }

    public boolean putUnparsed(Entity context, String name, String pubID, String sysID, String ndata, int type) throws MalformedURLException {
        if (this.entityMaps[type].get(name) == null) {
            this.entityMaps[type].put(name, new Entry(pubID, sysID, ndata));
            return true;
        }
        return false;
    }

    public void clear() {
        this.entityMaps[0].clear();
        this.entityMaps[1].clear();
        this.entitiesByURI.clear();
    }

    public Entity getByName(String pName, int pType) {
        Entity vResult = (Entity)this.entityMaps[pType].get(pName);
        if (vResult == null && pType == 0 && this.fDefaultGeneralMap != null) {
            vResult = this.fDefaultGeneralMap.getEntity(pName);
        }
        return vResult;
    }

    public Entity getByID(Entity context, String pubID, String sysID) throws MalformedURLException {
        Entity result = null;
        if (this.fParser.fResolveDTDURIs) {
            sysID = EntityManager.resolveSystemID(context.getSystemID(), sysID);
        }
        if ((result = (Entity)this.entitiesByURI.get(sysID)) != null) {
            return result;
        }
        if (pubID != null && pubID.length() > 0 && (result = (Entity)this.entitiesByURI.get(pubID)) != null) {
            return result;
        }
        result = new Entry(pubID, sysID);
        if (pubID != null && pubID.length() > 0) {
            this.entitiesByURI.put(pubID, result);
        }
        this.entitiesByURI.put(sysID, result);
        return result;
    }

    public static String resolveSystemID(String contextSysID, String sysID) {
        if (contextSysID != null) {
            try {
                URL url = new URL(new URL(contextSysID), sysID);
                return url.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            URL url = new URL(sysID);
            return url.toString();
        }
        catch (Exception exception) {
            return sysID;
        }
    }

    private final class Entry
    implements Entity {
        boolean isOpen = false;
        char[] value;
        String pubID;
        String sysID;
        String ndata;
        XMLInputReader reader = null;
        boolean isStandalone = false;

        Entry(String value) {
            this.ndata = null;
            this.sysID = null;
            this.pubID = null;
            this.value = value.toCharArray();
        }

        Entry(String pubID, String sysID) {
            this(pubID, sysID, null);
        }

        Entry(String pubID, String sysID, String ndata) {
            this.pubID = pubID;
            this.sysID = sysID;
            this.ndata = ndata;
        }

        public void open() throws RecursionException, SAXException, IOException {
            if (this.ndata != null) {
                throw new FatalParsingException("Cannot reference entity; unknown NDATA type '" + this.ndata + "'");
            }
            if (this.isOpen) {
                throw new RecursionException();
            }
            if (!this.isInternal()) {
                InputStream in;
                Reader r;
                InputSource source;
                this.reader = EntityManager.this.resolver == null ? new XMLStreamReader(new URL(this.sysID).openStream()) : ((source = EntityManager.this.resolver.resolveEntity(this.pubID, this.sysID)) == null ? new XMLStreamReader(new URL(this.sysID).openStream()) : ((r = source.getCharacterStream()) != null ? new XMLReaderReader(r) : ((in = source.getByteStream()) != null ? new XMLStreamReader(in, source.getEncoding()) : new XMLStreamReader(new URL(source.getSystemId()).openStream(), source.getEncoding()))));
                this.isStandalone = this.reader.isXMLStandalone();
            }
            this.isOpen = true;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public void close() {
            this.isOpen = false;
            this.reader = null;
        }

        public String getSystemID() {
            return this.sysID;
        }

        public String getPublicID() {
            return this.pubID;
        }

        public boolean isStandalone() {
            return this.isStandalone;
        }

        public void setStandalone(boolean standalone) {
            this.isStandalone = standalone;
        }

        public boolean isInternal() {
            return this.sysID == null;
        }

        public boolean isParsed() {
            return this.ndata == null;
        }

        public String getDeclaredEncoding() {
            if (this.reader != null) {
                return this.reader.getXMLDeclaredEncoding();
            }
            return null;
        }

        public String getEffectiveEncoding() {
            if (this.reader != null) {
                return this.reader.getEffectiveEncoding();
            }
            return null;
        }

        public boolean isStandaloneDeclared() {
            if (this.reader != null) {
                return this.reader.isXMLStandaloneDeclared();
            }
            return false;
        }

        public String getXMLVersion() {
            if (this.reader != null) {
                return this.reader.getXMLVersion();
            }
            return null;
        }

        public Reader getReader() {
            if (this.isInternal()) {
                return new CharArrayReader(this.value);
            }
            return this.reader;
        }

        public String stringValue() {
            return new String(this.value);
        }

        public char[] charArrayValue() {
            return this.value;
        }
    }
}

