/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import com.bluecast.io.IllegalCharException;
import com.bluecast.xml.XMLDecoder;
import java.io.CharConversionException;

public final class ISO8859_1XMLDecoder
implements XMLDecoder {
    private boolean sawCR = false;

    public CharsetDecoder newCharsetDecoder() {
        return this.newXMLDecoder();
    }

    public XMLDecoder newXMLDecoder() {
        return new ISO8859_1XMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 1;
    }

    public void reset() {
        this.sawCR = false;
    }

    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        this.internalDecode(in_buf, in_off, in_len, out_buf, out_off, out_len, result, false);
    }

    public int decodeXMLDecl(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        return this.internalDecode(in_buf, in_off, in_len, out_buf, out_off, out_len, result, true);
    }

    private int internalDecode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result, boolean decodeDecl) throws CharConversionException {
        int i;
        int r = -2;
        int o = 0;
        block5: for (i = 0; i < in_len && o < out_len; ++i) {
            char c = (char)(0xFF & in_buf[in_off + i]);
            if (c >= ' ') {
                this.sawCR = false;
                out_buf[out_off + o++] = c;
                if (!decodeDecl || c != '<') continue;
                r = 0;
                break;
            }
            switch (c) {
                case '\n': {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case '\r': {
                    this.sawCR = true;
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case '\t': {
                    out_buf[out_off + o++] = 9;
                    continue block5;
                }
                default: {
                    if (decodeDecl) {
                        r = -1;
                        break block5;
                    }
                    throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c));
                }
            }
        }
        result[0] = i;
        result[1] = o;
        return r;
    }
}

