/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.IllegalCharException;
import com.bluecast.xml.XMLDecoder;
import com.bluecast.xml.XMLDecoderFactory;
import com.bluecast.xml.XMLInputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class XMLStreamReader
extends XMLInputReader {
    private static final int BYTE_BUFFER_SIZE = 8192;
    private XMLDecoder decoder;
    private int minBytesPerChar;
    private int maxBytesPerChar;
    private InputStream in;
    private int[] decodeResult = new int[2];
    private String encoding;
    private boolean useDeclaredEncoding;
    private boolean rewindDeclaration;
    private char[] cbuf = new char[100];
    private byte[] bbuf = new byte[8192];
    private int cbufPos;
    private int cbufEnd;
    private int bbufPos;
    private int bbufEnd;
    private boolean eofReached;
    private static final int MAX_XML_DECL_CHARS = 100;
    private FastStreamDecoder fastStreamDecoder = new FastStreamDecoder();
    private JavaStreamDecoder javaStreamDecoder = null;
    private XMLStreamDecoder activeStreamDecoder;

    public XMLStreamReader() {
    }

    public XMLStreamReader(InputStream in) throws IOException {
        this(in, null);
    }

    public XMLStreamReader(InputStream in, String encoding) throws IOException {
        this.reset(in, encoding);
    }

    public void reset(InputStream in, String encoding) throws IOException {
        super.resetInput();
        this.in = in;
        this.eofReached = false;
        this.useDeclaredEncoding = false;
        this.bbufEnd = 0;
        this.bbufPos = 0;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.activeStreamDecoder = this.fastStreamDecoder;
        this.fillByteBuffer();
        if (encoding != null) {
            this.encoding = encoding;
            if (this.encoding.equals("Unicode")) {
                this.encoding = this.guessEncoding();
                if (this.encoding == null || !this.encoding.equals("UnicodeLittle")) {
                    this.encoding = "UnicodeBig";
                }
            }
        } else {
            this.encoding = this.guessEncoding();
            if (this.encoding == null) {
                this.useDeclaredEncoding = true;
                this.encoding = "UTF-8";
            }
        }
        this.setEncoding(this.encoding);
        this.processXMLDecl();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.eofReached = true;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.bbufEnd = 0;
        this.bbufPos = 0;
        if (this.in != null) {
            this.in.close();
        }
    }

    public void reset() throws IOException {
        super.resetInput();
        this.in.reset();
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.bbufEnd = 0;
        this.bbufPos = 0;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new UnsupportedOperationException("mark() not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        return this.activeStreamDecoder.read();
    }

    public int read(char[] destbuf) throws IOException {
        return this.read(destbuf, 0, destbuf.length);
    }

    public int read(char[] destbuf, int off, int len) throws IOException {
        return this.activeStreamDecoder.read(destbuf, off, len);
    }

    public boolean ready() throws IOException {
        return this.activeStreamDecoder.ready();
    }

    public long skip(long n) throws IOException {
        return this.activeStreamDecoder.skip(n);
    }

    private void setEncoding(String encoding) throws IOException {
        try {
            this.encoding = encoding;
            this.decoder = XMLDecoderFactory.createDecoder(encoding);
            this.minBytesPerChar = this.decoder.minBytesPerChar();
            this.maxBytesPerChar = this.decoder.maxBytesPerChar();
        }
        catch (UnsupportedEncodingException e) {
            if (this.javaStreamDecoder == null) {
                this.javaStreamDecoder = new JavaStreamDecoder();
            }
            this.activeStreamDecoder = this.javaStreamDecoder;
        }
        this.activeStreamDecoder.reset();
    }

    public String getEffectiveEncoding() {
        return this.encoding;
    }

    private int fillByteBuffer() throws IOException {
        int bytesLeft = this.bbufEnd - this.bbufPos;
        if (bytesLeft > 0 && this.bbufPos > 0) {
            System.arraycopy(this.bbuf, this.bbufPos, this.bbuf, 0, bytesLeft);
        }
        this.bbufPos = 0;
        this.bbufEnd = bytesLeft;
        int bytesAvailable = this.in.available();
        if (bytesAvailable == 0) {
            bytesAvailable = 1;
        }
        int bytesToRead = Math.min(8192 - this.bbufEnd, bytesAvailable);
        int bytesRead = 0;
        if (this.bbufEnd < 8192 && (bytesRead = this.in.read(this.bbuf, this.bbufEnd, bytesToRead)) != -1) {
            this.bbufEnd += bytesRead;
        }
        if (bytesRead == -1) {
            this.eofReached = true;
        }
        return bytesRead;
    }

    private String guessEncoding() {
        if (this.bbufEnd < 4) {
            return null;
        }
        switch (this.bbuf[0]) {
            case -17: {
                if (this.bbuf[1] == -69 && this.bbuf[2] == -65) {
                    this.bbufPos = 3;
                    return "UTF-8";
                }
                return null;
            }
            case 60: {
                switch (this.bbuf[1]) {
                    case 63: {
                        if (this.bbuf[2] == 120 && this.bbuf[3] == 109) {
                            this.useDeclaredEncoding = true;
                            return "UTF-8";
                        }
                        return null;
                    }
                    case 0: {
                        if (this.bbuf[2] == 63 && this.bbuf[3] == 0) {
                            return "UnicodeLittleUnmarked";
                        }
                        if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                            return "UCS-4";
                        }
                        return null;
                    }
                }
                return null;
            }
            case -2: {
                if (this.bbuf[1] == -1) {
                    if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                        this.bbufPos = 4;
                        return "UCS-4";
                    }
                    this.bbufPos = 2;
                    return "UnicodeBig";
                }
                return null;
            }
            case -1: {
                if (this.bbuf[1] == -2) {
                    if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                        this.bbufPos = 4;
                        return "UCS-4";
                    }
                    this.bbufPos = 2;
                    return "UnicodeLittle";
                }
                return null;
            }
            case 0: {
                switch (this.bbuf[1]) {
                    case 0: {
                        if (this.bbuf[2] == -2 && this.bbuf[3] == -1) {
                            this.bbufPos = 4;
                            return "UCS-4";
                        }
                        if (this.bbuf[2] == -1 && this.bbuf[3] == -2) {
                            this.bbufPos = 4;
                            return "UCS-4";
                        }
                        if (this.bbuf[2] == 60 && this.bbuf[3] == 0 || this.bbuf[2] == 0 && this.bbuf[3] == 60) {
                            return "UCS-4";
                        }
                        return null;
                    }
                    case 60: {
                        if (this.bbuf[2] == 0 && this.bbuf[3] == 63) {
                            return "UnicodeBigUnmarked";
                        }
                        if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                            return "UCS-4";
                        }
                        return null;
                    }
                }
                return null;
            }
            case 76: {
                if (this.bbuf[1] == 111 && this.bbuf[2] == -89 && this.bbuf[3] == -108) {
                    this.useDeclaredEncoding = true;
                    return "Cp037";
                }
                return null;
            }
        }
        this.useDeclaredEncoding = true;
        return null;
    }

    private void processXMLDecl() throws IOException {
        int cbufEndTemp;
        int initialBBufPos = this.bbufPos;
        int r = this.decoder.decodeXMLDecl(this.bbuf, this.bbufPos, this.bbufEnd - this.bbufPos, this.cbuf, this.cbufPos, this.cbuf.length - this.cbufPos, this.decodeResult);
        int bbufPosTemp = this.bbufPos + this.decodeResult[0];
        for (cbufEndTemp = this.decodeResult[1]; r == -2 && !this.eofReached && cbufEndTemp < this.cbuf.length; cbufEndTemp += this.decodeResult[1]) {
            Thread.yield();
            this.fillByteBuffer();
            r = this.decoder.decodeXMLDecl(this.bbuf, bbufPosTemp, this.bbufEnd - bbufPosTemp, this.cbuf, this.cbufPos + cbufEndTemp, this.cbuf.length - cbufEndTemp, this.decodeResult);
            bbufPosTemp += this.decodeResult[0];
        }
        this.parseXMLDeclaration(this.cbuf, 0, cbufEndTemp);
        String declaredEncoding = this.getXMLDeclaredEncoding();
        if (this.useDeclaredEncoding && declaredEncoding != null && !declaredEncoding.equalsIgnoreCase(this.encoding)) {
            cbufEndTemp = 0;
            this.cbufPos = 0;
            this.bbufPos = initialBBufPos;
            this.decoder.reset();
            this.setEncoding(declaredEncoding);
        }
    }

    private class JavaStreamDecoder
    implements XMLStreamDecoder {
        private Reader reader;
        char[] oneCharBuffer = new char[1];
        boolean sawCR;

        public void reset() throws IOException {
            this.sawCR = false;
            if (XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos > 0) {
                PushbackInputStream pbIn = new PushbackInputStream(XMLStreamReader.this.in, XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos);
                pbIn.unread(XMLStreamReader.this.bbuf, XMLStreamReader.this.bbufPos, XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos);
                this.reader = new InputStreamReader((InputStream)pbIn, XMLStreamReader.this.encoding);
            } else {
                this.reader = new InputStreamReader(XMLStreamReader.this.in, XMLStreamReader.this.encoding);
            }
        }

        public int read() throws IOException {
            int c;
            do {
                if ((c = this.read(this.oneCharBuffer, 0, 1)) <= 0) continue;
                return this.oneCharBuffer[0];
            } while (c >= 0);
            return c;
        }

        public int read(char[] destbuf, int off, int len) throws IOException {
            int numChars = this.reader.read(destbuf, off, len);
            int outpos = off;
            if (numChars < 0) {
                return numChars;
            }
            block5: for (int i = 0; i < numChars; ++i) {
                int inpos = i + off;
                char c = destbuf[inpos];
                if (c >= ' ') {
                    if (c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                        this.sawCR = false;
                        if (inpos != outpos) {
                            destbuf[outpos] = c;
                        }
                        ++outpos;
                        continue;
                    }
                    throw new IllegalCharException("Illegal XML Character: 0x" + Integer.toHexString(c));
                }
                switch (c) {
                    case '\n': {
                        if (this.sawCR) {
                            this.sawCR = false;
                            continue block5;
                        }
                        destbuf[outpos++] = 10;
                        continue block5;
                    }
                    case '\r': {
                        this.sawCR = true;
                        destbuf[outpos++] = 10;
                        continue block5;
                    }
                    case '\t': {
                        destbuf[outpos++] = 9;
                        continue block5;
                    }
                    default: {
                        System.out.println("Char: " + c + " [" + c + "]");
                        throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c));
                    }
                }
            }
            return outpos - off;
        }

        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        public long skip(long n) throws IOException {
            long skipped;
            for (skipped = 0L; skipped < n; skipped += (long)XMLStreamReader.this.cbufEnd) {
                XMLStreamReader.this.cbufEnd = this.read(XMLStreamReader.this.cbuf, 0, (int)Math.min(n, 100L));
                if (XMLStreamReader.this.cbufEnd > 0) {
                    continue;
                }
                return skipped;
            }
            return skipped;
        }
    }

    private class FastStreamDecoder
    implements XMLStreamDecoder {
        public void reset() {
        }

        public int read() throws IOException {
            if (XMLStreamReader.this.cbufEnd - XMLStreamReader.this.cbufPos > 0) {
                return XMLStreamReader.this.cbuf[XMLStreamReader.this.cbufPos++];
            }
            XMLStreamReader.this.cbufPos = (XMLStreamReader.this.cbufEnd = 0);
            XMLStreamReader.this.cbufEnd = this.read(XMLStreamReader.this.cbuf, XMLStreamReader.this.cbufPos, 100);
            if (XMLStreamReader.this.cbufEnd > 0) {
                return XMLStreamReader.this.cbuf[XMLStreamReader.this.cbufPos++];
            }
            return -1;
        }

        public int read(char[] destbuf, int off, int len) throws IOException {
            int numToRead;
            int charsRead = 0;
            if (XMLStreamReader.this.cbufEnd - XMLStreamReader.this.cbufPos > 0 && (numToRead = Math.min(XMLStreamReader.this.cbufEnd - XMLStreamReader.this.cbufPos, len)) > 0) {
                System.arraycopy(XMLStreamReader.this.cbuf, XMLStreamReader.this.cbufPos, destbuf, off, numToRead);
                charsRead += numToRead;
                XMLStreamReader.this.cbufPos += numToRead;
            }
            if (charsRead < len) {
                if (XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos < XMLStreamReader.this.maxBytesPerChar) {
                    XMLStreamReader.this.fillByteBuffer();
                    if (XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos < XMLStreamReader.this.minBytesPerChar) {
                        return charsRead <= 0 && XMLStreamReader.this.eofReached ? -1 : charsRead;
                    }
                }
                XMLStreamReader.this.decoder.decode(XMLStreamReader.this.bbuf, XMLStreamReader.this.bbufPos, XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos, destbuf, off + charsRead, len - charsRead, XMLStreamReader.this.decodeResult);
                XMLStreamReader.this.bbufPos += XMLStreamReader.this.decodeResult[0];
                charsRead += XMLStreamReader.this.decodeResult[1];
            }
            return charsRead == 0 && XMLStreamReader.this.eofReached ? -1 : charsRead;
        }

        public boolean ready() throws IOException {
            return XMLStreamReader.this.cbufEnd - XMLStreamReader.this.cbufPos > 0 || XMLStreamReader.this.bbufEnd - XMLStreamReader.this.bbufPos > XMLStreamReader.this.maxBytesPerChar || XMLStreamReader.this.in.available() > 0;
        }

        public long skip(long n) throws IOException {
            long skipped = 0L;
            if (XMLStreamReader.this.cbufEnd - XMLStreamReader.this.cbufPos > 0) {
                skipped = Math.min((long)XMLStreamReader.this.cbufEnd - (long)XMLStreamReader.this.cbufPos, n);
                XMLStreamReader.this.cbufPos = (int)((long)XMLStreamReader.this.cbufPos + skipped);
            }
            while (skipped < n) {
                XMLStreamReader.this.cbufPos = 0;
                XMLStreamReader.this.cbufEnd = this.read(XMLStreamReader.this.cbuf, 0, 100);
                if (XMLStreamReader.this.cbufEnd > 0) {
                    XMLStreamReader.this.cbufPos = (int)Math.min((long)XMLStreamReader.this.cbufEnd, n - skipped);
                    skipped += (long)XMLStreamReader.this.cbufPos;
                    continue;
                }
                XMLStreamReader.this.cbufEnd = 0;
                return skipped;
            }
            return skipped;
        }
    }

    private static interface XMLStreamDecoder {
        public int read() throws IOException;

        public int read(char[] var1, int var2, int var3) throws IOException;

        public boolean ready() throws IOException;

        public long skip(long var1) throws IOException;

        public void reset() throws IOException;
    }
}

