/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.i.ihmcms.serv;

import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.service.viewdav.DialogViewDav;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.HWebdavCodes;
import com.scenari.m.co.dialog.webdav.IHWebdavResource;
import com.scenari.m.co.dialog.webdav.WResultatError;
import com.scenari.m.co.dialog.webdav.WResultatPropfind;
import com.scenari.m.co.service.sourcedav.HSourceDavResource;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.fields.FieldsCollectorBuilder;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.SrcFeatureFields;
import com.scenari.src.feature.history.SrcFeatureHistory;
import com.scenari.src.feature.versions.SrcFeatureVersions;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.syntax.json.JsonSerializer;
import eu.scenari.uimoz.SenderHttpResponseBase;
import eu.scenari.universe.execframe.httpservlet.ISenderHttpResponse;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SenderViewDav
extends SenderHttpResponseBase {
    public static String sDefaultFieldKeys = "basis*item";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSendDialogResult(IHDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        DialogViewDav vDialog = (DialogViewDav)pDialog;
        Object vRes = vDialog.hGetPageResultatDav();
        if (vRes instanceof WResultatPropfind) {
            SenderViewDav.hSetContentType(pResp, "text/plain; charset=UTF-8");
            Writer vWriter = SenderViewDav.hGetWriterUTF8(pResp);
            try {
                String vFieldKeys;
                HSourceDavResource vResItem;
                boolean vOnlySpaces = pReq.getParameter("onlySpaces") != null;
                List vList = ((WResultatPropfind)vRes).hGetListRessources();
                if (vOnlySpaces) {
                    int i = 1;
                    while (i < vList.size()) {
                        vResItem = (HSourceDavResource)vList.get(i);
                        if (HQCode.hValidUriSpace(vResItem.hGetUriInRoot(), true) == 0) {
                            ++i;
                            continue;
                        }
                        vList.remove(i);
                    }
                }
                if ((vFieldKeys = pReq.getParameter("fields")) == null) {
                    vFieldKeys = sDefaultFieldKeys;
                }
                IFieldsCollector vFields = FieldsCollectorBuilder.newFieldsCollector(vFieldKeys);
                String vHist = pReq.getParameter("history");
                int vHistCount = 0;
                if (vHist != null && vHist.length() > 0) {
                    vHistCount = Integer.parseInt(vHist);
                }
                String vVersionsParam = pReq.getParameter("versions");
                boolean vVersions = false;
                if (vVersionsParam != null) {
                    vVersions = Integer.parseInt(vVersionsParam) == 1;
                }
                JsonSerializer vJsonWriter = new JsonSerializer(vWriter);
                vResItem = (HSourceDavResource)vList.get(0);
                vJsonWriter.startObject();
                this.writeResJson(vJsonWriter, vFields, vResItem, vHistCount, vVersions);
                vJsonWriter.key("nbr");
                vJsonWriter.valNumber(vList.size());
                if (vDialog.hGetRequestDepth() > 0) {
                    vJsonWriter.key("ch");
                    vJsonWriter.startArray();
                    vList.remove(0);
                    Collections.sort(vList, IHWebdavResource.COMPARATOR_ON_DISPLAYNAME);
                    for (int i = 0; i < vList.size(); ++i) {
                        vResItem = (HSourceDavResource)vList.get(i);
                        vJsonWriter.startObject();
                        this.writeResJson(vJsonWriter, vFields, vResItem, vHistCount, vVersions);
                        vJsonWriter.key("nbr");
                        vJsonWriter.valNumber(1);
                        vJsonWriter.endObject();
                    }
                    vJsonWriter.endArray();
                }
                vJsonWriter.endObject();
            }
            finally {
                vWriter.close();
            }
        }
        if (vRes instanceof WResultatError) {
            WResultatError vErrorRes = (WResultatError)vRes;
            if (vErrorRes.hGetLogMessage() != null) {
                pResp.setStatus(vErrorRes.hGetError());
                IXmlWriter vXmlWriter = SenderViewDav.hGetXmlWriterUTF8(pResp, true);
                try {
                    vErrorRes.hGetLogMessage().writeAsXmlFormat(vXmlWriter, true);
                }
                finally {
                    vXmlWriter.close();
                }
                LogMgr.publishMessage(vErrorRes.hGetLogMessage());
            } else {
                pResp.sendError(vErrorRes.hGetError(), HWebdavCodes.hGetStatusText(vErrorRes.hGetError()));
            }
        } else if (vRes instanceof ISenderHttpResponse) {
            ((ISenderHttpResponse)vRes).sendDialogResult(vDialog, pReq, pResp);
        } else {
            throw new Exception("Send result failed. Unknown type: " + vRes);
        }
    }

    protected void writeResJson(JsonSerializer pJson, IFieldsCollector pFieldCollector, HSourceDavResource pResItem, int pHistoCount, boolean pVersions) throws Exception {
        ISrcNode vNode = pResItem.hGetSource();
        this.writeSrcNodeJson(pJson, pFieldCollector, vNode);
        this.writeResJsonOldData(pJson, pResItem);
        if (pHistoCount > 0) {
            pJson.key("histo");
            pJson.startArray();
            List<ISrcNode> vHistoEntries = SrcFeatureHistory.getHistoryNodes(vNode);
            if (vHistoEntries != null) {
                int l = Math.min(vHistoEntries.size(), pHistoCount);
                for (int i = 0; i < l; ++i) {
                    ISrcNode vSrcNode = vHistoEntries.get(i);
                    pJson.startObject();
                    this.writeSrcNodeJson(pJson, pFieldCollector, vSrcNode);
                    pJson.endObject();
                }
            }
            pJson.endArray();
        }
        if (pVersions) {
            pJson.key("vers");
            pJson.startArray();
            List<ISrcNode> vVersions = SrcFeatureVersions.getNetVersionNodes(vNode);
            if (vVersions != null) {
                for (ISrcNode vSrcNode : vVersions) {
                    pJson.startObject();
                    this.writeSrcNodeJson(pJson, pFieldCollector, vSrcNode);
                    pJson.endObject();
                }
            }
            pJson.endArray();
        }
    }

    private void writeSrcNodeJson(JsonSerializer pJson, IFieldsCollector pFieldCollector, ISrcNode pNode) throws Exception {
        SrcFeatureFields.fillFields(pNode, pFieldCollector);
        pFieldCollector.startIterate();
        String vKey = pFieldCollector.nextDataKey();
        while (vKey != null) {
            Object vValue = pFieldCollector.getData(vKey);
            if (vValue != null) {
                pJson.key(vKey);
                pJson.val(vValue);
            }
            vKey = pFieldCollector.nextDataKey();
        }
        pFieldCollector.resetDatas();
    }

    protected void writeResJsonOldData(JsonSerializer pJson, HSourceDavResource pResItem) throws Exception {
        ISrcNode vSrcNode = pResItem.hGetSource();
        pJson.key("ty");
        pJson.valString(this.getType(vSrcNode, vSrcNode.getContentStatus()));
        pJson.key("nm");
        pJson.valString(vSrcNode.getSrcName());
    }

    private String getType(ISrcNode pNode, int pStatusNode) throws Exception {
        switch (WspSrcUtil.getWspNodeType(pNode.getSrcUri())) {
            case wsp: {
                return "wsp";
            }
            case space: {
                return "space";
            }
            case item: {
                if (pStatusNode == 2) {
                    return "itemmulti";
                }
                return "itemmono";
            }
            case resource: {
                if (pStatusNode == 2) {
                    return "folder";
                }
                return "res";
            }
        }
        return null;
    }
}

