/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.facet.chain;

import bsh.Interpreter;
import com.scenari.m.bdp.facet.Facet;
import com.scenari.m.bdp.facet.IFacet;
import com.scenari.m.bdp.facet.IFacetCache;
import com.scenari.m.bdp.facet.SourceFacet;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.ISgnModule;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.src.fs.basic.FsBasicFactory;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class FacetChain
extends Facet {
    protected List fChain = new ArrayList(3);
    protected boolean fCheckAutoMultiRes = false;
    protected HTransformParams fSourceParams = null;
    protected String fContentTypeOutput = null;

    public FacetChain(IHItemType pItemType, String pCdModule, String pRegExpSgn) {
        super(pItemType, pCdModule, pRegExpSgn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISrcNode getFacet(IWspSrc pSrcItem, String pIdSubItem, HTransformParams pParams) throws Exception {
        ISrcNode vResult = null;
        IHWorkspace vWsp = pSrcItem.getWorkspace();
        IHItemDef vItemDef = pIdSubItem != null ? (IHItemDef)pSrcItem.getAspect(IWspSrc.ITEM_ASPECT_TYPE) : pSrcItem.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
        IFacetCache vFacetCache = vWsp.getFacetCache(pSrcItem, pIdSubItem, pParams);
        if (vFacetCache.isUpToDate()) {
            File vFileRes = vFacetCache.getFileCache();
            if (this.fContentTypeOutput == null) return FsBasicFactory.newNodeFromCanonicalFile(vFileRes);
            return new SourceFacet(FsBasicFactory.newNodeFromCanonicalFile(vFileRes), -99L, this.fContentTypeOutput);
        }
        try {
            Step vStep;
            if (this.fSourceParams != null && this.fSourceParams.hGetTransformType().equals("facet")) {
                IHItemType vItemType = this.hGetItemType();
                ISgnModule vSgnModule = vItemType.hGetSgnModule(this.fSourceParams.hGetValueParam("facet"), pIdSubItem != null ? ((IHItem)vItemDef).hGetSubItemSgn(pIdSubItem) : vItemDef.hGetSignature());
                if (vSgnModule == null) throw LogMgr.newException("Facette non disponible " + this.fSourceParams + " pour l'item : " + pSrcItem + " " + pIdSubItem, new String[0]);
                if (!(vSgnModule instanceof IFacet)) throw LogMgr.newException("Facette non disponible " + this.fSourceParams + " pour l'item : " + pSrcItem + " " + pIdSubItem, new String[0]);
                vResult = ((IFacet)vSgnModule).getFacet(pSrcItem, pIdSubItem, this.fSourceParams);
            } else {
                HTransformParams vParams = this.fSourceParams;
                String vPathFile = SrcFeatureAlternateUrl.getFilePath(pSrcItem);
                if (vPathFile != null) {
                    vResult = FsBasicFactory.newNodeFromPath(vPathFile);
                    if (vParams == null && this.fCheckAutoMultiRes && vResult.getContentStatus() == 2) {
                        vResult = vResult.findNodeChild(vResult.getSrcName());
                    }
                } else {
                    vResult = pSrcItem;
                    if (vParams == null && this.fCheckAutoMultiRes && vResult.getContentStatus() == 2) {
                        vResult = vResult.findNodeChild(vResult.getSrcName());
                    }
                }
            }
            int vLastStep = this.fChain.size() - (pParams.hGetNextTransform() != null ? 0 : 1);
            for (int i = 0; i < vLastStep; ++i) {
                vStep = (Step)this.fChain.get(i);
                vResult = vStep.execStep(this, vItemDef, vResult, null, vFacetCache);
            }
            if (this.fChain.size() > 0) {
                File vFileRes = vFacetCache.getFileCache();
                if (pParams.hGetNextTransform() != null) {
                    this.execNextTransforms(pParams.hGetNextTransform(), vResult, vFileRes);
                } else {
                    vStep = (Step)this.fChain.get(vLastStep);
                    vStep.execStep(this, vItemDef, vResult, vFileRes, vFacetCache);
                }
                vFacetCache.saveCache();
                vResult = FsBasicFactory.newNodeFromCanonicalFile(vFileRes);
            } else {
                File vFileRes = vFacetCache.getFileCache();
                SrcFeatureStreams.writeTo(vResult, new FileOutputStream(vFileRes), true);
                vFacetCache.saveCache();
                vResult = FsBasicFactory.newNodeFromCanonicalFile(vFileRes);
            }
            if (this.fContentTypeOutput == null) return vResult;
            return new SourceFacet(vResult, -99L, this.fContentTypeOutput);
        }
        catch (Exception e) {
            vFacetCache.cancelCache();
            throw e;
        }
        catch (Throwable e) {
            vFacetCache.cancelCache();
            throw LogMgr.newException(e.toString(), new String[0]);
        }
    }

    protected void xSetSourceParams(String pSourceParams) throws Exception {
        if (pSourceParams != null) {
            this.fSourceParams = HTransformParams.hNewParamsTransformByQueryString(pSourceParams, "UTF-8", "facet");
        }
    }

    protected void xSetCheckAutoMultiRes(String pValue) {
        this.fCheckAutoMultiRes = pValue != null && pValue.equals("true");
    }

    protected void xSetContentType(String pValue) {
        this.fContentTypeOutput = pValue;
    }

    protected void xAddXslStep(Templates pStep) {
        this.fChain.add(new XslStep(pStep));
    }

    protected void xAddTransformStep(String pTransformParams) {
        try {
            this.fChain.add(new TransformStep(HTransformParams.hNewParamsTransformByQueryString(pTransformParams, "UTF-8")));
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Echec au parsing de " + pTransformParams, new String[0]);
        }
    }

    protected void xAddBeanshellStep(String pScript) {
        this.fChain.add(new BeanshellStep(pScript));
    }

    public static class BeanshellStep
    implements Step {
        protected String fBeanshellScript = null;
        protected Step fBeanshellStep = null;

        public BeanshellStep(String pBeanshellScript) {
            this.fBeanshellScript = pBeanshellScript;
        }

        public ISrcNode execStep(FacetChain pFacet, IHItemDef pItem, ISrcNode pSource, File pDest, IFacetCache pFacetCache) throws Exception {
            return this.xGetStep().execStep(pFacet, pItem, pSource, pDest, pFacetCache);
        }

        protected synchronized Step xGetStep() throws Exception {
            if (this.fBeanshellStep == null) {
                Interpreter vInterpreter = new Interpreter();
                vInterpreter.eval(this.fBeanshellScript);
                this.fBeanshellStep = (Step)vInterpreter.getInterface(Step.class);
                this.fBeanshellScript = null;
            }
            return this.fBeanshellStep;
        }
    }

    public static class TransformStep
    implements Step {
        protected HTransformParams fParams = null;

        public TransformStep(HTransformParams pParams) {
            this.fParams = pParams;
        }

        public ISrcNode execStep(FacetChain pFacet, IHItemDef pItem, ISrcNode pSource, File pDest, IFacetCache pFacetCache) throws Exception {
            IHTransformer vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(this.fParams);
            if (vTransformer != null) {
                Object vSrc = null;
                Object vRes = null;
                OutputStreamBlob vStream = null;
                String vFileSrc = SrcFeatureAlternateUrl.getFilePath(pSource);
                if (vFileSrc != null) {
                    vSrc = vTransformer.hIsSrcAllowed(File.class, this.fParams) ? new File(vFileSrc) : pSource.newInputStream(false);
                } else if (vTransformer.hIsSrcAllowed(InputStream.class, this.fParams)) {
                    vSrc = pSource.newInputStream(false);
                } else {
                    throw LogMgr.newException("TODO source = stream \u00e0 passer en file...", new String[0]);
                }
                if (pDest != null) {
                    vRes = vTransformer.hIsResAllowed(File.class, this.fParams) ? pDest : new FileInputStream(pDest);
                } else if (vTransformer.hIsResAllowed(OutputStream.class, this.fParams)) {
                    vStream = new OutputStreamBlob();
                    vRes = vStream;
                } else {
                    File vDstFileTemp = File.createTempFile("scFacetChain", vTransformer.hGetFileExtension(this.fParams));
                    vDstFileTemp.deleteOnExit();
                    vRes = vDstFileTemp;
                }
                vTransformer.hTransform(vSrc, vRes, this.fParams);
                if (pDest != null) {
                    return null;
                }
                if (vStream != null) {
                    return new SrcNodeOneShot(vStream.getInputStream(true), vStream.getLength(), System.currentTimeMillis(), "text/xml");
                }
                return FsBasicFactory.newNodeFromCanonicalFile((File)vRes);
            }
            if (pDest != null) {
                return pSource;
            }
            return null;
        }
    }

    public static class XslStep
    implements Step {
        protected Templates fXsl = null;

        public XslStep(Templates pXsl) {
            this.fXsl = pXsl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISrcNode execStep(FacetChain pFacet, IHItemDef pItem, ISrcNode pSource, File pDest, IFacetCache pFacetCache) throws Exception {
            XMLReader vReader;
            OutputStreamBlob vStream;
            block5: {
                StreamResult vOut;
                vStream = null;
                if (pDest != null) {
                    vOut = new StreamResult(new FileOutputStream(pDest));
                } else {
                    vStream = new OutputStreamBlob();
                    vOut = new StreamResult(vStream);
                }
                Transformer vTransf = this.fXsl.newTransformer();
                vTransf.setParameter("facet", pFacet);
                vTransf.setParameter("item", pItem);
                vTransf.setParameter("facetCache", pFacetCache);
                vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                try {
                    vTransf.transform(new SAXSource(vReader, new InputSource(pSource.newInputStream(false))), vOut);
                    if (pDest == null) break block5;
                    ISrcNode iSrcNode = null;
                    Object var12_12 = null;
                    HPoolXmlReader.hGet().hFreeXmlReader(vReader);
                    return iSrcNode;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    HPoolXmlReader.hGet().hFreeXmlReader(vReader);
                    throw throwable;
                }
            }
            SrcNodeOneShot srcNodeOneShot = new SrcNodeOneShot(vStream.getInputStream(true), vStream.getLength(), System.currentTimeMillis(), "text/xml");
            Object var12_13 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vReader);
            return srcNodeOneShot;
        }
    }

    public static interface Step {
        public ISrcNode execStep(FacetChain var1, IHItemDef var2, ISrcNode var3, File var4, IFacetCache var5) throws Exception;
    }
}

