/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.facet.outline;

import com.scenari.m.bdp.facet.Facet;
import com.scenari.m.bdp.facet.outline.IFacetOutline;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.src.ISrcNode;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import com.scenari.xsldom.xalan.serialize.SerializerToXML;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.wsp.repos.WspUri;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FacetOutline
extends Facet
implements IFacetOutline {
    protected Templates fXsl = null;

    public FacetOutline(IHItemType pItemType, String pCdModule, String pRegExpSgn) {
        super(pItemType, pCdModule, pRegExpSgn);
    }

    public ISrcNode getFacet(IWspSrc pSrcItem, String pIdSubItem, HTransformParams pQueryString) throws Exception {
        String vSgn;
        OutputStreamBlob vBuf = new OutputStreamBlob();
        String vDepthStr = pQueryString.hGetValueParam("depth");
        int vDepth = -1;
        if (vDepthStr != null && vDepthStr.length() > 0) {
            vDepth = Integer.parseInt(vDepthStr);
        }
        Properties vProps = new Properties();
        vProps.put("method", "xml");
        vProps.put("encoding", "UTF-8");
        SerializerMergeDoc vSer = new SerializerMergeDoc();
        vSer.init(vBuf, vProps);
        ArrayList<Object> vStackCycleGuard = new ArrayList<Object>();
        vStackCycleGuard.add(pSrcItem);
        vStackCycleGuard.add(pIdSubItem);
        AttributesImpl vAtts = new AttributesImpl();
        vSer.startDocument();
        vSer.startElement("", "outline", "outline", vAtts);
        vAtts.addAttribute("", "uri", "uri", "CDATA", WspUri.buildFragmentUri(pSrcItem.getSrcUri(), pIdSubItem));
        IHItemDef vItemDef = pIdSubItem != null ? (IHItemDef)pSrcItem.getAspect(IWspSrc.ITEM_ASPECT_TYPE) : pSrcItem.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
        String string = vSgn = pIdSubItem != null ? ((IHItem)vItemDef).hGetSubItemSgn(pIdSubItem) : vItemDef.hGetSignature();
        if (vSgn != null) {
            vAtts.addAttribute("", "sgn", "sgn", "CDATA", vSgn);
        }
        vAtts.addAttribute("", "st", "st", "CDATA", HCharSeqUtil.hGetIntToString(vItemDef.hGetStatus()));
        vSer.startElement("", "item", "item", vAtts);
        this.writeOutline(vSer, vItemDef, pIdSubItem, true, pQueryString, vDepth, vStackCycleGuard);
        vSer.endElement("", "item", "item");
        vSer.endElement("", "outline", "outline");
        vSer.endDocument();
        vSer.flush();
        vSer.flushWriter();
        vBuf.close();
        return new SrcNodeOneShot(vBuf.getInputStream(true), vBuf.getLength(), System.currentTimeMillis(), "text/xml");
    }

    public void writeOutline(ContentHandler pWriter, IHItemDef pItemDef, String pIdSubItem, boolean pIncludeTitle, HTransformParams pQueryString, int pDepth, List pStackCycleGuard) throws Exception {
        IHWorkspace vWsp = pItemDef.hGetWorkspace();
        IHItemDef vItem = pItemDef;
        if (pIdSubItem != null && pIdSubItem.length() > 0 && !(pItemDef instanceof IHItem)) {
            vItem = vWsp.hGetItem(pItemDef.getUri(), null);
        }
        if (vItem != null) {
            Transformer vTransf = this.fXsl.newTransformer();
            vTransf.setParameter("pOutlineContext", new OutlineContext(vItem, this, pQueryString, pStackCycleGuard, pDepth, pWriter));
            if (pIncludeTitle) {
                vTransf.setParameter("pIncludeTitle", Boolean.TRUE);
            }
            vTransf.setParameter("pItem", pItemDef);
            if (pIdSubItem != null && pIdSubItem.length() > 0) {
                vTransf.setParameter("pIdSubItem", pIdSubItem);
            }
            InputStream vSream = vWsp.hGetContentAccess().hReadStream(pItemDef, null, null, null);
            vTransf.transform(new StreamSource(vSream), new SAXResult(pWriter));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OutlineContext {
        protected FacetOutline fFacet;
        protected IHItemDef fItemStarter;
        protected HTransformParams fQueryString;
        protected List fStackCycleGuard;
        protected int fDepth;
        protected ContentHandler fSerializer;

        public OutlineContext(IHItemDef pItemStarter, FacetOutline pFacet, HTransformParams pQueryString, List pStackCycleGuard, int pDepth, ContentHandler pSerializer) {
            this.fFacet = pFacet;
            this.fItemStarter = pItemStarter;
            this.fQueryString = pQueryString;
            this.fStackCycleGuard = pStackCycleGuard;
            this.fDepth = pDepth;
            this.fSerializer = pSerializer;
        }

        public int getDepth() {
            return this.fDepth;
        }

        public IHItemDef getItemStarter() {
            return this.fItemStarter;
        }

        public FacetOutline getFacet() {
            return this.fFacet;
        }

        public HTransformParams getQueryString() {
            return this.fQueryString;
        }

        public List<IWspSrc> getStackCycleGuard() {
            return this.fStackCycleGuard;
        }
    }

    public static class SerializerMergeDoc
    extends SerializerToXML {
        protected int fDocumentCounter = 0;

        public void endDocument() throws SAXException {
            --this.fDocumentCounter;
            if (this.fDocumentCounter == 0) {
                super.endDocument();
            }
        }

        public void startDocument() throws SAXException {
            if (this.fDocumentCounter == 0) {
                super.startDocument();
            }
            ++this.fDocumentCounter;
        }
    }
}

