/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.facet.replacemainstream;

import com.scenari.m.bdp.facet.Facet;
import com.scenari.m.bdp.facet.IFacetCache;
import com.scenari.m.bdp.facet.SourceFacet;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.relocate.SrcFeatureRelocate;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.helpers.util.SrcNodeFrontEnd;
import com.scenari.src.helpers.util.SrcServerMultiSources;
import eu.scenari.fw.log.LogMgr;
import java.io.File;

public class FacetReplaceMainStream
extends Facet {
    public FacetReplaceMainStream(IHItemType pItemType, String pCdModule, String pRegExpSgn) {
        super(pItemType, pCdModule, pRegExpSgn);
    }

    public ISrcNode getFacet(IWspSrc pSrcItem, String pIdSubItem, HTransformParams pParams) throws Exception {
        HTransformParams vNext;
        ISrcNode vResult = pSrcItem;
        String[] vFiles = pParams.hGetValues("file");
        String vUriRes = "/" + pSrcItem.getSrcName();
        for (int i = 0; i < vFiles.length; ++i) {
            ISrcNode vReplaceF = pSrcItem.findNodeChild(vFiles[i]);
            if (vReplaceF.getContentStatus() == -1) continue;
            SrcServerMultiSources vServer = new SrcServerMultiSources();
            vServer.addOverlay(vUriRes, SrcFeatureRelocate.relocateAsRoot(pSrcItem));
            vServer.addOverlay(vUriRes, SrcFeatureRelocate.relocateAsRoot(vReplaceF));
            vServer.setOverlaysLocked(true);
            vResult = new SrcNodeFrontEnd(vServer, vUriRes);
            break;
        }
        if ((vNext = pParams.hGetNextTransform()) != null) {
            File vFileRes;
            IFacetCache vFacetCache = pSrcItem.getWorkspace().getFacetCache(pSrcItem, pIdSubItem, pParams);
            if (vFacetCache.isUpToDate()) {
                vFileRes = vFacetCache.getFileCache();
                vResult = new SourceFacet(FsMiniFactory.newNodeFromPath(vFileRes.getCanonicalPath(), true), -99L, "");
            } else {
                try {
                    vFileRes = vFacetCache.getFileCache();
                    this.execNextTransforms(vNext, vResult, vFileRes);
                    vFacetCache.saveCache();
                    vResult = FsMiniFactory.newNodeFromCanonicalFile(vFileRes, true);
                }
                catch (Exception e) {
                    vFacetCache.cancelCache();
                    throw e;
                }
                catch (Throwable e) {
                    vFacetCache.cancelCache();
                    throw LogMgr.newException(e.toString(), new String[0]);
                }
            }
        }
        return vResult;
    }
}

