/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item;

public class HQCode {
    public static final String SCNS = "http://www.utc.fr/ics/scenari/v3/core";
    public static char SPACES_SEPARATOR = (char)47;
    public static final char ITEM_POINT = '.';
    public static final char IDSUBITEM_SEPARATOR = '#';
    public static final char URI_SEPARATOR = '/';
    public static final int VALID_STRING_OK = 0;
    public static final int VALID_STRING_TOO_LONG = -1;
    public static final int VALID_STRING_CHAR_NOT_ALLOWED = -2;
    public static final int VALID_STRING_NULL = -3;
    private static char[] CODE_CHAR_NOT_ALLOWED = new char[]{'$', '\\', '/', '>', '<', '|', '?', ':', '*', '\"', ';'};
    private static char[] CODE_CHAR_SYSTEM = new char[]{'~'};
    private static char[] SPACE_CHAR_NOT_ALLOWED = new char[]{'$', '\\', '>', '<', '|', '?', ':', '*', '\"', ';', '.'};
    private static char[] SPACE_CHAR_SYSTEM = new char[]{'~'};
    protected String fSpace = null;
    protected String fCode = null;

    public HQCode() {
    }

    public HQCode(String pSpace, String pCode) {
        this.fSpace = pSpace;
        this.fCode = pCode;
    }

    public final String hGetCode() {
        return this.fCode;
    }

    public final String hGetSpace() {
        return this.fSpace;
    }

    public String getUri() {
        return HQCode.hGetUri(this.fSpace, this.fCode);
    }

    public static final String hGetUri(String pSpace) {
        return "/".concat(pSpace);
    }

    public static final String hGetUri(String pSpace, String pCode) {
        if (pSpace == null || pSpace.length() == 0) {
            return "/".concat(pCode);
        }
        return new StringBuilder(pSpace.length() + pCode.length() + 2).append('/').append(pSpace).append('/').append(pCode).toString();
    }

    public static final int hValidCode(String pCode, boolean pSystemCharsAllowed) {
        int vLength;
        if (pCode == null || (vLength = pCode.length()) == 0) {
            return -3;
        }
        if (vLength > HQCode.hGetMaxLengthCode()) {
            return -1;
        }
        if (pCode.charAt(0) == '.') {
            return -2;
        }
        char[] vNotAllowed = HQCode.hGetCharNotAllowedInCode();
        int vLenghtNotAllowed = vNotAllowed.length;
        for (int i = 0; i < vLength; ++i) {
            for (int iArr = 0; iArr < vLenghtNotAllowed; ++iArr) {
                if (pCode.charAt(i) != vNotAllowed[iArr]) continue;
                return -2;
            }
        }
        if (!pSystemCharsAllowed) {
            for (char vSystemChar : HQCode.hGetCharSystemInCode()) {
                for (int i = 0; i < vLength; ++i) {
                    if (pCode.charAt(i) != vSystemChar) continue;
                    return -2;
                }
            }
        }
        return 0;
    }

    public static final int hValidSpace(String pSpace, boolean pSystemCharsAllowed) {
        int vLength;
        if (pSpace == null || (vLength = pSpace.length()) == 0) {
            return -3;
        }
        if (vLength > HQCode.hGetMaxLengthSpace()) {
            return -1;
        }
        if (pSpace.charAt(0) == SPACES_SEPARATOR) {
            return -2;
        }
        char[] vArr = HQCode.hGetCharNotAllowedInSpace();
        int vLenghtArr = vArr.length;
        for (int i = 0; i < vLength; ++i) {
            char vCar = pSpace.charAt(i);
            for (int iArr = 0; iArr < vLenghtArr; ++iArr) {
                if (vCar != vArr[iArr]) continue;
                return -2;
            }
            if (vCar != SPACES_SEPARATOR || i >= vLength - 1 || pSpace.charAt(i + 1) != SPACES_SEPARATOR) continue;
            return -2;
        }
        if (!pSystemCharsAllowed) {
            for (char vSystemChar : HQCode.hGetCharSystemInSpace()) {
                for (int i = 0; i < vLength; ++i) {
                    if (pSpace.charAt(i) != vSystemChar) continue;
                    return -2;
                }
            }
        }
        return 0;
    }

    public static final int hValidSpacePart(String pSpace, boolean pSystemCharsAllowed) {
        int vRes = HQCode.hValidSpace(pSpace, pSystemCharsAllowed);
        if (vRes == 0 && pSpace.indexOf(SPACES_SEPARATOR) >= 0) {
            return -2;
        }
        return vRes;
    }

    public static final int hValidUriItem(String pUri, boolean pSystemCharsAllowed) {
        int vLength;
        if (pUri == null || (vLength = pUri.length()) == 0) {
            return -3;
        }
        if (pUri.charAt(0) != '/') {
            return -2;
        }
        char[] vNotAllowed = HQCode.hGetCharNotAllowedInSpace();
        int vLenghtNotAllowed = vNotAllowed.length;
        char[] vSystemChars = HQCode.hGetCharSystemInSpace();
        int vLenghtSystemChar = vSystemChars.length;
        int vLastSlash = 0;
        int vLastPoint = -1;
        for (int i = 1; i < vLength; ++i) {
            int iArr;
            char vC = pUri.charAt(i);
            if (vC == '/') {
                if (vLastPoint >= 0) {
                    return -2;
                }
                if (vLastSlash == i - 1) {
                    return -2;
                }
                vLastSlash = i;
                continue;
            }
            if (vC == '.') {
                if (vLastPoint == i - 1) {
                    return -2;
                }
                if (vLastSlash == i - 1) {
                    return -2;
                }
                vLastPoint = i;
                continue;
            }
            for (iArr = 0; iArr < vLenghtNotAllowed; ++iArr) {
                if (vC != vNotAllowed[iArr]) continue;
                return -2;
            }
            if (pSystemCharsAllowed) continue;
            for (iArr = 0; iArr < vLenghtSystemChar; ++iArr) {
                if (vC != vSystemChars[iArr]) continue;
                return -2;
            }
        }
        return 0;
    }

    public static final int hValidUriSpace(String pUri, boolean pSystemCharsAllowed) {
        int vLength;
        if (pUri == null || (vLength = pUri.length()) == 0) {
            return -3;
        }
        if (pUri.charAt(0) != '/') {
            return -2;
        }
        char[] vNotAllowed = HQCode.hGetCharNotAllowedInSpace();
        int vLenghtNotAllowed = vNotAllowed.length;
        char[] vSystemChars = HQCode.hGetCharSystemInSpace();
        int vLenghtSystemChar = vSystemChars.length;
        int vLastSlash = 0;
        for (int i = 1; i < vLength; ++i) {
            int iArr;
            char vC = pUri.charAt(i);
            if (vC == '/') {
                if (vLastSlash == i - 1) {
                    return -2;
                }
                vLastSlash = i;
                continue;
            }
            if (vC == '.') {
                return -2;
            }
            for (iArr = 0; iArr < vLenghtNotAllowed; ++iArr) {
                if (vC != vNotAllowed[iArr]) continue;
                return -2;
            }
            if (pSystemCharsAllowed) continue;
            for (iArr = 0; iArr < vLenghtSystemChar; ++iArr) {
                if (vC != vSystemChars[iArr]) continue;
                return -2;
            }
        }
        return 0;
    }

    public static final int hGetMaxLengthCode() {
        return 200;
    }

    public static final int hGetMaxLengthSpace() {
        return 2000;
    }

    public static final char[] hGetCharNotAllowedInCode() {
        return CODE_CHAR_NOT_ALLOWED;
    }

    public static final char[] hGetCharNotAllowedInSpace() {
        return SPACE_CHAR_NOT_ALLOWED;
    }

    public static final char[] hGetCharSystemInCode() {
        return CODE_CHAR_SYSTEM;
    }

    public static final char[] hGetCharSystemInSpace() {
        return SPACE_CHAR_SYSTEM;
    }

    public static final void hBuildUri(StringBuilder pBuf, String pSpace, String pCode) {
        pBuf.append('/');
        pBuf.append(pSpace);
        pBuf.append('/');
        pBuf.append(pCode);
    }

    public static final void hBuildUri(StringBuilder pBuf, String pSpace, String pCode, String pUriRes, String pIdSubItem) {
        pBuf.append('/');
        pBuf.append(pSpace);
        pBuf.append('/');
        pBuf.append(pCode);
        if (pUriRes != null) {
            pBuf.append(pUriRes);
        }
        if (pIdSubItem != null) {
            pBuf.append('#');
            pBuf.append(pIdSubItem);
        }
    }

    public static final String hGetUri(String pSpace, String pCode, String pUriRes, String pIdSubItem) {
        int vLen = 5 + pSpace.length() + pCode.length();
        if (pUriRes != null) {
            vLen += pUriRes.length();
        }
        if (pIdSubItem != null) {
            vLen += pIdSubItem.length();
        }
        StringBuilder vBuf = new StringBuilder(vLen);
        HQCode.hBuildUri(vBuf, pSpace, pCode, pUriRes, pIdSubItem);
        return vBuf.toString();
    }

    public static final String hGetWspCdFromUri(String pUri) {
        int vEnd = pUri.indexOf(47);
        if (vEnd > 0) {
            return pUri.substring(0, vEnd);
        }
        return pUri;
    }

    public static final String hGetSpaceFromUri(String pUri) {
        int vStart = pUri.indexOf(47) + 1;
        if (vStart <= 0) {
            return "";
        }
        int vEnd = pUri.indexOf(46, vStart);
        if (vEnd < 0) {
            return pUri.substring(vStart);
        }
        return (vEnd = pUri.lastIndexOf(47, vEnd)) < vStart ? "" : pUri.substring(vStart, vEnd);
    }

    public static final String hGetCodeFromUri(String pUri) {
        int vStart = pUri.indexOf(46);
        if (vStart < 0) {
            return null;
        }
        int vEnd = pUri.indexOf(47, vStart);
        vStart = pUri.lastIndexOf(47, vStart) + 1;
        if (vEnd > 0) {
            return pUri.substring(vStart, vEnd);
        }
        vEnd = pUri.indexOf(35, vStart);
        if (vEnd > 0) {
            return pUri.substring(vStart, vEnd);
        }
        return pUri.substring(vStart);
    }

    public static final String hGetUriResFromUri(String pUri) {
        int vStart = pUri.indexOf(46);
        if (vStart < 0) {
            return null;
        }
        if ((vStart = pUri.indexOf(47, vStart)) < 0) {
            return null;
        }
        int vEnd = pUri.lastIndexOf(35);
        return vEnd < 0 ? pUri.substring(vStart) : pUri.substring(vStart, vEnd);
    }

    public static final String hGetIdSubItemFromUri(String pUri) {
        int vStart = pUri.lastIndexOf(35);
        return vStart > 0 ? pUri.substring(vStart + 1) : null;
    }

    public static final HQCode hCreate(String pUri) {
        HQCode vRes = new HQCode();
        int vStart = pUri.indexOf(47) + 1;
        int vEnd = pUri.indexOf(46, vStart);
        if (vEnd < 0) {
            vRes.fSpace = pUri.substring(vStart);
            return vRes;
        }
        vEnd = pUri.lastIndexOf(47, vEnd);
        vRes.fSpace = pUri.substring(vStart, vEnd);
        vRes.fCode = pUri.substring(vEnd + 1);
        return vRes;
    }
}

