/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.base;

import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHAttr;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHProblem;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.base.HProblem;
import com.scenari.m.bdp.item.base.XAttr;
import com.scenari.m.bdp.item.base.XAttrDate;
import com.scenari.m.bdp.item.base.XAttrLString;
import com.scenari.m.bdp.item.base.XAttrLink;
import com.scenari.m.bdp.item.base.XAttrNumber;
import com.scenari.m.bdp.item.base.XAttrRef;
import com.scenari.m.bdp.item.base.XAttrString;
import com.scenari.m.bdp.item.base.XAttrText;
import com.scenari.m.bdp.item.base.XAttrXml;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.s.fw.util.xml.HSaxHandlerToXml;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.serializer.simple.XmlWriterAppendable;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.collections.CollectionUtil;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HItem
extends HItemDefVers
implements IHItem {
    public static SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static int sMaxNbContentProblems = 10;
    protected ArrayList fAttrs = new ArrayList();
    protected ArrayList fSubItems = null;
    protected HProblem fFirstContentProblem = null;
    protected int fCountContentProblems = 0;
    protected IHItemType fItemType = null;

    public HItem(IHWorkspace pWSp, String pUri) {
        super(pWSp, pUri);
    }

    public HItem(IHWorkspace pWSp, String pSpace, String pCode) {
        super(pWSp);
        this.fSpace = pSpace;
        this.fCode = pCode;
        this.fUri = HQCode.hGetUri(this.fSpace, this.fCode);
    }

    public HItem(IHWorkspace pWSp, String pUri, String pSpace, String pCode) {
        super(pWSp);
        this.fUri = pUri;
        this.fSpace = pSpace;
        this.fCode = pCode;
    }

    public final IHItemType hGetItemType() {
        return this.fItemType;
    }

    public String hGetSignature() {
        try {
            return this.fSignature != null ? this.fSignature : this.fItemType.hGetItemTypeSignature();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
            return null;
        }
    }

    public final int hCountAttrs() throws Exception {
        return this.fAttrs.size();
    }

    public final IHAttr hGetAttr(String pSpace, String pName) throws Exception {
        for (int i = 0; i < this.fAttrs.size(); ++i) {
            IHAttr vAttr = (IHAttr)this.fAttrs.get(i);
            if (!vAttr.hGetSpace().equals(pSpace) || !vAttr.hGetName().equals(pName)) continue;
            return vAttr;
        }
        return null;
    }

    public final Iterator hGetAttrs() throws Exception {
        return this.fAttrs.iterator();
    }

    public final IHProblem hGetContentProblemByCode(String pCode) {
        if (pCode != null) {
            HProblem vPb = this.fFirstContentProblem;
            while (vPb != null) {
                if (pCode.equals(vPb.hGetCode())) {
                    return vPb;
                }
                vPb = vPb.fNext;
            }
        }
        return null;
    }

    public final Iterator hGetContentProblems() throws Exception {
        return this.fFirstContentProblem != null ? this.fFirstContentProblem.wIterator() : CollectionUtil.emptyIterator();
    }

    public final Iterator hGetAllProblems() throws Exception {
        return new ProblemsIt();
    }

    public final void hSetItemType(IHItemType pItemType) throws Exception {
        if (pItemType == null) {
            this.fItemType = null;
            this.fUriSs = URI_NULL;
        } else {
            this.fItemType = pItemType;
            this.fUriSs = pItemType.getUri();
        }
    }

    public final IHAttr hAddAttr(String pType, String pSpace, String pName) throws Exception {
        XAttr vAttr = null;
        if ("String".equals(pType)) {
            vAttr = new XAttrString(this, pSpace, pName);
        } else if ("Ref".equals(pType)) {
            vAttr = new XAttrRef(this, pSpace, pName);
        } else if ("Link".equals(pType)) {
            vAttr = new XAttrLink(this, pSpace, pName);
        } else if ("Date".equals(pType)) {
            vAttr = new XAttrDate(this, pSpace, pName);
        } else if ("Number".equals(pType)) {
            vAttr = new XAttrNumber(this, pSpace, pName);
        } else if ("Xml".equals(pType)) {
            vAttr = new XAttrXml(this, pSpace, pName);
        } else if ("Text".equals(pType)) {
            vAttr = new XAttrXml(this, pSpace, pName);
        } else if ("ListString".equals(pType)) {
            vAttr = new XAttrXml(this, pSpace, pName);
        } else {
            throw LogMgr.newException("Le type d'attribut '" + pType + "' est inconnu.", new String[0]);
        }
        this.fAttrs.add(vAttr);
        return vAttr;
    }

    public final IHProblem hAddContentError(String pCode, String pMessage, String pContent) {
        HProblem vProblem = new HProblem("Error", pCode, pMessage, pContent);
        if (this.fCountContentProblems < sMaxNbContentProblems) {
            vProblem.fNext = this.fFirstContentProblem;
            this.fFirstContentProblem = vProblem;
            ++this.fCountContentProblems;
            if (this.fCountContentProblems == sMaxNbContentProblems) {
                HProblem vProblem2 = new HProblem("Warning", "system.toomanyproblems", "De nombreux probl\u00e8mes ont \u00e9t\u00e9 identifi\u00e9s. La liste a \u00e9t\u00e9 tronqu\u00e9e.", null);
                vProblem2.fNext = this.fFirstContentProblem;
                this.fFirstContentProblem = vProblem2;
                ++this.fCountContentProblems;
            }
        } else {
            HProblem vPbPrec = null;
            HProblem vPb = this.fFirstContentProblem.fNext;
            for (int i = 0; i < sMaxNbContentProblems; ++i) {
                if (vPb.hGetType() == "Warning") {
                    if (vPbPrec == null) {
                        this.fFirstContentProblem = vProblem;
                    } else {
                        vPbPrec = vProblem;
                    }
                    vProblem.fNext = vPb.fNext;
                }
                vPbPrec = vPb;
                vPb = this.fFirstContentProblem.fNext;
            }
        }
        return vProblem;
    }

    public final IHProblem hAddContentWarning(String pCode, String pMessage, String pContent) {
        HProblem vProblem = new HProblem("Warning", pCode, pMessage, pContent);
        if (this.fCountContentProblems < sMaxNbContentProblems) {
            vProblem.fNext = this.fFirstContentProblem;
            this.fFirstContentProblem = vProblem;
            ++this.fCountContentProblems;
            if (this.fCountContentProblems == sMaxNbContentProblems) {
                HProblem vProblem2 = new HProblem("Warning", "system.toomanyproblems", "De nombreux probl\u00e8mes ont \u00e9t\u00e9 identifi\u00e9s. La liste a \u00e9t\u00e9 tronqu\u00e9e.", null);
                vProblem2.fNext = this.fFirstContentProblem;
                this.fFirstContentProblem = vProblem2;
                ++this.fCountContentProblems;
            }
        }
        return vProblem;
    }

    public final int hRemoveAttr(String pSpace, String pName) throws Exception {
        int vResult = 0;
        int i = 0;
        while (i < this.fAttrs.size()) {
            IHAttr vAttr = (IHAttr)this.fAttrs.get(i);
            if (vAttr.hGetName().equals(pName) && vAttr.hGetSpace().equals(pSpace)) {
                this.fAttrs.remove(i);
                ++vResult;
                continue;
            }
            ++i;
        }
        return vResult;
    }

    public final void hRemoveContentProblems() throws Exception {
        this.fFirstContentProblem = null;
        this.fCountContentProblems = 0;
    }

    public final ContentHandler hCreateSaxContentHandler() {
        return new HItemSaxHandler();
    }

    public final void hWriteItem(Writer pWriter) throws Exception {
        XmlWriterAppendable vXmlWriter = new XmlWriterAppendable(pWriter);
        vXmlWriter.writeStartTag("item");
        vXmlWriter.writeAttribute("uri", this.getUri());
        vXmlWriter.writeAttribute("status", HCharSeqUtil.hGetIntToString(this.fStatus));
        if (this.fTitle != null && this.fTitle.length() > 0) {
            vXmlWriter.writeAttribute("ti", this.fTitle);
        }
        if (this.fSignature != null && this.fSignature.length() > 0) {
            vXmlWriter.writeAttribute("sgn", this.fSignature);
        }
        if (this.fUsr != null) {
            vXmlWriter.writeAttribute("usr", this.fUsr);
        }
        if (this.hGetItemType() != null) {
            vXmlWriter.writeAttribute("uriSs", this.hGetItemType().getUriSs());
        }
        vXmlWriter.writeEndOpenTag();
        for (int i = 0; i < this.fAttrs.size(); ++i) {
            XAttr vAttr = (XAttr)this.fAttrs.get(i);
            vAttr.hWriteXml(vXmlWriter);
        }
        if (this.fFirstContentProblem != null) {
            vXmlWriter.writeOpenTag("cPbs");
            HProblem vPb = this.fFirstContentProblem;
            while (vPb != null) {
                vPb.hWriteXml(vXmlWriter);
                vPb = vPb.fNext;
            }
            vXmlWriter.writeCloseTag("cPbs");
        }
        vXmlWriter.writeCloseTag("item");
    }

    public static final XMLReader xGetXmlReader() throws Exception {
        return HPoolXmlReader.hGet().hGetXmlReader(false, false);
    }

    public static final void xFreeXmlReader(XMLReader pReader) {
        HPoolXmlReader.hGet().hFreeXmlReader(pReader);
    }

    public String toString() {
        return "<item uri=\"" + this.getUri() + "\"/>";
    }

    public void hAddSubItem(String pId, String pSignature) {
        if (this.fSubItems == null) {
            this.fSubItems = new ArrayList();
        }
        this.fSubItems.add(pId);
        this.fSubItems.add(pSignature.intern());
    }

    public String hGetSubItemSgn(String pId) throws Exception {
        if (this.fSubItems == null) {
            return null;
        }
        if (pId == null) {
            return this.hGetSignature();
        }
        for (int i = 0; i < this.fSubItems.size(); i += 2) {
            if (!((String)this.fSubItems.get(i)).equals(pId)) continue;
            return (String)this.fSubItems.get(i + 1);
        }
        return null;
    }

    public Iterator hGetSubItems() throws Exception {
        return this.fSubItems == null ? CollectionUtil.EMPTY_ITERATOR : this.fSubItems.iterator();
    }

    public int hCountSubItems() throws Exception {
        return this.fSubItems == null ? 0 : this.fSubItems.size() / 2;
    }

    protected class HItemSaxHandler
    extends DefaultHandler {
        protected String fCurrentCategTag = null;
        protected HProblem fCurrentProblem = null;
        protected XAttr fCurrentAttr = null;
        protected StringBuilder fBuf = new StringBuilder();
        protected ContentHandler fCurrentContentHandler = null;
        protected int fDepthInCurrentContentHandler = 0;

        public void characters(char[] pChar, int pStart, int pLength) throws SAXException {
            if (this.fDepthInCurrentContentHandler > 0) {
                this.fCurrentContentHandler.characters(pChar, pStart, pLength);
            } else {
                this.fBuf.append(pChar, pStart, pLength);
            }
        }

        public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
            try {
                if (this.fDepthInCurrentContentHandler > 1) {
                    this.fCurrentContentHandler.endElement(pNamespaceURI, pLocalName, pQName);
                    --this.fDepthInCurrentContentHandler;
                } else if (!"item".equals(pLocalName)) {
                    if ("params".equals(pLocalName)) {
                        this.fCurrentAttr.hSetParamsRel(this.fBuf.substring(0));
                        this.fDepthInCurrentContentHandler = 0;
                    } else if ("pb".equals(pLocalName)) {
                        this.fCurrentProblem.wSetContent(this.fBuf.substring(0));
                        this.fCurrentProblem = null;
                    } else if ("attrStr".equals(pLocalName)) {
                        this.fCurrentAttr.hSetStringValue(this.fBuf.substring(0));
                        this.fCurrentAttr = null;
                    } else if ("attrNum".equals(pLocalName)) {
                        this.fCurrentAttr.hSetStringValue(this.fBuf.substring(0));
                        this.fCurrentAttr = null;
                    } else if ("attrDate".equals(pLocalName)) {
                        this.fCurrentAttr.hSetStringValue(this.fBuf.substring(0));
                        this.fCurrentAttr = null;
                    } else if ("attrXml".equals(pLocalName)) {
                        this.fCurrentAttr.hSetStringValue(this.fBuf.substring(0));
                        this.fCurrentAttr = null;
                        this.fDepthInCurrentContentHandler = 0;
                    } else if ("attrTxt".equals(pLocalName)) {
                        this.fCurrentAttr.hSetStringValue(this.fBuf.substring(0));
                        this.fCurrentAttr = null;
                    } else if ("attrLStr".equals(pLocalName)) {
                        this.fCurrentAttr.hSetStringValue(this.fBuf.substring(0));
                        this.fCurrentAttr = null;
                        this.fDepthInCurrentContentHandler = 0;
                    } else if ("attrRef".equals(pLocalName)) {
                        this.fCurrentAttr = null;
                    } else if ("attrLink".equals(pLocalName)) {
                        this.fCurrentAttr = null;
                    } else if ("title".equals(pLocalName)) {
                        HItem.this.fTitle = this.fBuf.substring(0);
                    } else if ("signature".equals(pLocalName)) {
                        HItem.this.xSetSignature(this.fBuf.substring(0));
                    }
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
            if (this.fDepthInCurrentContentHandler > 0) {
                this.fCurrentContentHandler.startElement(pNamespaceURI, pLocalName, pQName, pAtts);
                ++this.fDepthInCurrentContentHandler;
            } else if ("item".equals(pLocalName)) {
                String vComment;
                String vVersion;
                String vSgn;
                String vVal = null;
                String vUri = pAtts.getValue("uri");
                if (vUri != null) {
                    HItem.this.setUri(vUri);
                }
                String vTitle = pAtts.getValue("ti");
                if (HItem.this.fTitle != null) {
                    HItem.this.fTitle = vTitle;
                }
                if ((vSgn = pAtts.getValue("sgn")) != null) {
                    HItem.this.xSetSignature(vSgn);
                }
                String vUser = pAtts.getValue("usr");
                if (HItem.this.fUsr != null) {
                    HItem.this.fUsr = vUser;
                }
                if ((vVal = pAtts.getValue("status")) != null && vVal.length() > 0) {
                    try {
                        HItem.this.fStatus = Short.parseShort(vVal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((vVal = pAtts.getValue("mDt")) != null && vVal.length() > 0) {
                    try {
                        HItem.this.fModifDt = sDateFormat.parse(vVal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((vVersion = pAtts.getValue("vrs")) != null) {
                    HItem.this.fVersion = vVersion;
                }
                if ((vComment = pAtts.getValue("vrsCom")) != null) {
                    HItem.this.fComment = pAtts.getValue("vrsCom");
                }
            } else if ("attrStr".equals(pLocalName)) {
                this.fCurrentAttr = new XAttrString(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                HItem.this.fAttrs.add(this.fCurrentAttr);
                this.fCurrentCategTag = "attrStr";
                this.fBuf.setLength(0);
            } else if ("attrNum".equals(pLocalName)) {
                this.fCurrentAttr = new XAttrNumber(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                HItem.this.fAttrs.add(this.fCurrentAttr);
                this.fCurrentCategTag = "attrNum";
                this.fBuf.setLength(0);
            } else if ("attrDate".equals(pLocalName)) {
                this.fCurrentAttr = new XAttrDate(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                HItem.this.fAttrs.add(this.fCurrentAttr);
                this.fCurrentCategTag = "attrDate";
                this.fBuf.setLength(0);
            } else if ("attrXml".equals(pLocalName)) {
                this.fCurrentAttr = new XAttrXml(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                HItem.this.fAttrs.add(this.fCurrentAttr);
                this.fCurrentCategTag = "attrXml";
                this.fBuf.setLength(0);
                if (this.fCurrentContentHandler == null) {
                    this.fCurrentContentHandler = new HSaxHandlerToXml(this.fBuf);
                }
                this.fDepthInCurrentContentHandler = 1;
            } else if ("attrLStr".equals(pLocalName)) {
                this.fCurrentAttr = new XAttrLString(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                HItem.this.fAttrs.add(this.fCurrentAttr);
                this.fCurrentCategTag = "attrLStr";
                this.fBuf.setLength(0);
                if (this.fCurrentContentHandler == null) {
                    this.fCurrentContentHandler = new HSaxHandlerToXml(this.fBuf);
                }
                this.fDepthInCurrentContentHandler = 1;
            } else if ("attrTxt".equals(pLocalName)) {
                this.fCurrentAttr = new XAttrText(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                HItem.this.fAttrs.add(this.fCurrentAttr);
                this.fCurrentCategTag = "attrTxt";
                this.fBuf.setLength(0);
            } else if ("attrRef".equals(pLocalName)) {
                XAttrRef vAttr = new XAttrRef(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                String vUri = pAtts.getValue("refUri");
                if (vUri == null) {
                    vUri = pAtts.getValue("refUii");
                }
                if (vUri != null) {
                    try {
                        vAttr.setRefUri(vUri);
                    }
                    catch (Exception e) {
                        try {
                            vAttr.setRefUri(null);
                        }
                        catch (Exception ee) {}
                    }
                } else {
                    LogMgr.publishException("refUri not specified.", new String[0]);
                }
                HItem.this.fAttrs.add(vAttr);
                this.fCurrentAttr = vAttr;
                this.fCurrentCategTag = "attrRef";
                this.fBuf.setLength(0);
            } else if ("attrLink".equals(pLocalName)) {
                XAttrLink vAttr = new XAttrLink(HItem.this, pAtts.getValue("ns"), pAtts.getValue("nm"));
                String vUri = pAtts.getValue("refUri");
                if (vUri == null) {
                    vUri = pAtts.getValue("refUii");
                }
                if (vUri != null) {
                    try {
                        vAttr.setRefUri(vUri);
                    }
                    catch (Exception e) {
                        try {
                            vAttr.setRefUri(null);
                        }
                        catch (Exception ee) {}
                    }
                } else {
                    LogMgr.publishException("refUri not specified.", new String[0]);
                }
                HItem.this.fAttrs.add(vAttr);
                this.fCurrentAttr = vAttr;
                this.fCurrentCategTag = "attrLink";
                this.fBuf.setLength(0);
            } else if ("subItem".equals(pLocalName)) {
                HItem.this.hAddSubItem(pAtts.getValue("id"), pAtts.getValue("signature"));
            } else if ("params".equals(pLocalName)) {
                this.fBuf.setLength(0);
                if (this.fCurrentContentHandler == null) {
                    this.fCurrentContentHandler = new HSaxHandlerToXml(this.fBuf);
                }
                this.fDepthInCurrentContentHandler = 1;
            } else if ("pbs".equals(pLocalName)) {
                this.fCurrentCategTag = "pbs";
            } else if ("cPbs".equals(pLocalName)) {
                this.fCurrentCategTag = "cPbs";
            } else if ("pb".equals(pLocalName)) {
                String vType = pAtts.getValue("typ");
                this.fCurrentProblem = "Warning".equals(vType) ? new HProblem("Warning", pAtts.getValue("cd"), pAtts.getValue("msg"), null) : new HProblem("Error", pAtts.getValue("cd"), pAtts.getValue("msg"), null);
                if (this.fCurrentAttr != null && this.fCurrentAttr instanceof XAttrLink) {
                    XAttrLink vAttr = (XAttrLink)this.fCurrentAttr;
                    this.fCurrentProblem.fNext = vAttr.fFirstProblem;
                    vAttr.fFirstProblem = this.fCurrentProblem;
                } else if (this.fCurrentCategTag == "cPbs") {
                    this.fCurrentProblem.fNext = HItem.this.fFirstContentProblem;
                    HItem.this.fFirstContentProblem = this.fCurrentProblem;
                    ++HItem.this.fCountContentProblems;
                }
                this.fBuf.setLength(0);
            } else if ("title".equals(pLocalName)) {
                this.fBuf.setLength(0);
                this.fCurrentCategTag = "title";
            } else if ("signature".equals(pLocalName)) {
                this.fBuf.setLength(0);
                this.fCurrentCategTag = "signature";
            }
        }
    }

    protected class ProblemsIt
    implements Iterator {
        private int fStep = 100000000;
        private Iterator fCurrentIt = null;
        private Object fNext = null;

        public ProblemsIt() {
            this.xSetNext();
        }

        public boolean hasNext() {
            return this.fNext != null;
        }

        public Object next() {
            if (this.fNext == null) {
                throw new NoSuchElementException();
            }
            Object vNext = this.fNext;
            this.xSetNext();
            return vNext;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void xSetNext() {
            if (this.fCurrentIt != null && this.fCurrentIt.hasNext()) {
                this.fNext = this.fCurrentIt.next();
            } else {
                this.fCurrentIt = null;
                block1 : switch (this.fStep) {
                    case 100000000: {
                        if (HItem.this.fFirstContentProblem != null) {
                            this.fStep = 100000001;
                            this.fCurrentIt = HItem.this.fFirstContentProblem.wIterator();
                            if (this.fCurrentIt.hasNext()) {
                                this.fNext = this.fCurrentIt.next();
                                break;
                            }
                        }
                    }
                    default: {
                        while (this.fStep < HItem.this.fAttrs.size()) {
                            IHAttr vAttr = (IHAttr)HItem.this.fAttrs.get(this.fStep);
                            if (vAttr.hGetTypeAttr() == "Ref" || vAttr.hGetTypeAttr() == "Link") {
                                try {
                                    this.fCurrentIt = vAttr.hGetProblems();
                                    if (this.fCurrentIt.hasNext()) {
                                        this.fNext = this.fCurrentIt.next();
                                        break block1;
                                    }
                                    this.fCurrentIt = null;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++this.fStep;
                        }
                        this.fNext = null;
                        break;
                    }
                }
            }
        }
    }
}

