/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.src.ISrcNode;
import com.scenari.src.search.ISearchResultRow;
import eu.scenari.fw.log.LogMgr;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalItemsMgr {
    protected HWorkspaceFs fWsp;
    protected String[] fUrisToCheck;
    protected int fUrisToCheckCount;

    public ExternalItemsMgr(HWorkspaceFs pWsp) {
        this.fWsp = pWsp;
        this.fUrisToCheck = new String[32];
        this.fUrisToCheckCount = 0;
    }

    public void addExternalItem(String pUri) {
        assert (Thread.holdsLock(this.fWsp));
        if (this.fUrisToCheckCount == this.fUrisToCheck.length) {
            String[] vNewArray = new String[this.fUrisToCheck.length + 128];
            System.arraycopy(this.fUrisToCheck, 0, vNewArray, 0, this.fUrisToCheckCount);
            this.fUrisToCheck = vNewArray;
        }
        this.fUrisToCheck[this.fUrisToCheckCount++] = pUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<IWspSrc> getExternalsItemsInUse() {
        HWorkspaceFs hWorkspaceFs = this.fWsp;
        synchronized (hWorkspaceFs) {
            int vCount = this.fUrisToCheckCount;
            for (int i = 0; i < vCount; ++i) {
                try {
                    this.fWsp.xGetItemCache(this.fUrisToCheck[i]);
                    continue;
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
        }
        this.executeGc();
        TreeMap<ISrcNode, WspSrcNodeItem> vMap = new TreeMap<ISrcNode, WspSrcNodeItem>(ISearchResultRow.COMPARATOR_SRCNODE);
        HWorkspaceFs hWorkspaceFs2 = this.fWsp;
        synchronized (hWorkspaceFs2) {
            int vCount = this.fUrisToCheckCount;
            for (int i = 0; i < vCount; ++i) {
                try {
                    WspSrcNodeItem vWspSrcNode;
                    XItemCache vItem = this.fWsp.xGetItemCacheIfInMem(this.fUrisToCheck[i]);
                    if (vItem == null || (vWspSrcNode = vItem.getDatas().getWspSrcNodeItem()) == null) continue;
                    vMap.put(vWspSrcNode, vWspSrcNode);
                    continue;
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
        }
        return vMap.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeGc() {
        HWorkspaceFs hWorkspaceFs = this.fWsp;
        synchronized (hWorkspaceFs) {
            if (this.fUrisToCheckCount == 0) {
                return;
            }
            boolean[] vHasParentRef = new boolean[this.fUrisToCheckCount];
            HashSet<String> vLinkedUriMarked = new HashSet<String>();
            for (int i = 0; i < this.fUrisToCheckCount; ++i) {
                if (this.fUrisToCheck[i] == null || vHasParentRef[i]) continue;
                if (vLinkedUriMarked.contains(this.fUrisToCheck[i])) {
                    vHasParentRef[i] = true;
                    continue;
                }
                try {
                    XItemCache vItemCache = this.fWsp.xGetItemCacheIfInMem(this.fUrisToCheck[i]);
                    if (vItemCache == null) {
                        this.fUrisToCheck[i] = null;
                        continue;
                    }
                    XItemCache.XLink vPointer = vItemCache.fFirstPointer;
                    while (vPointer != null && vPointer.fItem.isExternalItem()) {
                        vPointer = vPointer.fNextPointer;
                    }
                    if (vPointer == null) continue;
                    vHasParentRef[i] = true;
                    this.markLinkedItems(vLinkedUriMarked, vItemCache);
                    continue;
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
            int vNextOffset = 0;
            for (int i = 0; i < this.fUrisToCheckCount; ++i) {
                if (this.fUrisToCheck[i] == null) continue;
                if (vHasParentRef[i]) {
                    this.fUrisToCheck[vNextOffset++] = this.fUrisToCheck[i];
                    continue;
                }
                try {
                    XItemCache vItemCache = this.fWsp.xGetItemCacheIfInMem(this.fUrisToCheck[i]);
                    if (vItemCache == null) continue;
                    vItemCache.hRemove(true, -1);
                    continue;
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Remove extrenal item failed : " + this.fUrisToCheck[i], new String[0]);
                }
            }
            if (vNextOffset < this.fUrisToCheck.length - 256) {
                String[] vNewArray = new String[vNextOffset + 128];
                System.arraycopy(this.fUrisToCheck, 0, vNewArray, 0, vNextOffset);
                this.fUrisToCheck = vNewArray;
            }
            this.fUrisToCheckCount = vNextOffset;
        }
    }

    protected void markLinkedItems(HashSet<String> pLinkedUriMarked, XItemCache pItemCache) {
        if (pItemCache.fAttrs == null) {
            return;
        }
        for (int k = 0; k < pItemCache.fAttrs.length; k += 4) {
            XItemCache vPtdItem;
            if (pItemCache.fAttrs[k] != "Ref" && pItemCache.fAttrs[k] != "Link" || (vPtdItem = ((XItemCache.XLink)pItemCache.fAttrs[k + 3]).fPtd) == null || !pLinkedUriMarked.add(vPtdItem.getUri())) continue;
            this.markLinkedItems(pLinkedUriMarked, vPtdItem);
        }
    }
}

