/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.facet.IFacet;
import com.scenari.m.bdp.facet.IFacetCache;
import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.fs.TransfCacheMgr;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.module.ISgnModule;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcNode;
import java.io.File;

public class FacetCache
implements IFacetCache {
    protected TransfCacheMgr fCacheMgr;
    protected XItemCache fItem;
    protected TransfCacheMgr.CacheDef fCachDef;
    protected File fFileCache;
    protected StringBuilder fNewDef;
    protected File fOldFile = null;

    public FacetCache(TransfCacheMgr pCacheMgr, XItemCache pItem, TransfCacheMgr.CacheDef pCachDef) {
        this.fCacheMgr = pCacheMgr;
        this.fItem = pItem;
        this.fCachDef = pCachDef;
    }

    public File getFileCache() throws Exception {
        return this.fFileCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate() throws Exception {
        TransfCacheMgr.CacheDef cacheDef = this.fCachDef;
        synchronized (cacheDef) {
            block9: while (true) {
                switch (this.fCachDef.fStatus) {
                    case 1: {
                        int vStartName = this.fCachDef.fDef.lastIndexOf(9);
                        this.fFileCache = new File(this.fCacheMgr, this.fCachDef.fDef.substring(vStartName + 1));
                        break block9;
                    }
                    case 0: {
                        try {
                            this.fFileCache = File.createTempFile("fac", "", this.fCacheMgr);
                        }
                        catch (Exception e) {
                            this.fCacheMgr.mkdirs();
                            this.fFileCache = File.createTempFile("fac", "", this.fCacheMgr);
                        }
                        this.fCachDef.fStatus = (short)2;
                        this.fNewDef = new StringBuilder(this.fCachDef.fDef.length() + 128);
                        this.fNewDef.append(this.fCachDef.fDef);
                        return false;
                    }
                    default: {
                        Thread.sleep(200L);
                        continue block9;
                    }
                }
                break;
            }
            boolean vOk = true;
            int vPrevTab = 0;
            int vNextTab = this.fCachDef.fDef.indexOf(9);
            while ((vNextTab = this.fCachDef.fDef.indexOf(9, vPrevTab = vNextTab + 1)) >= 0 && this.fCachDef.fDef.indexOf(9, vNextTab) >= 0) {
                String vSpace = this.fCachDef.fDef.substring(vPrevTab, vNextTab);
                vPrevTab = vNextTab + 1;
                vNextTab = this.fCachDef.fDef.indexOf(9, vPrevTab);
                String vCode = this.fCachDef.fDef.substring(vPrevTab, vNextTab);
                vPrevTab = vNextTab + 1;
                vNextTab = this.fCachDef.fDef.indexOf(9, vPrevTab);
                String vIdSubItem = this.fCachDef.fDef.substring(vPrevTab, vNextTab);
                vPrevTab = vNextTab + 1;
                vNextTab = this.fCachDef.fDef.indexOf(9, vPrevTab);
                String vFacetParams = this.fCachDef.fDef.substring(vPrevTab, vNextTab);
                vPrevTab = vNextTab + 1;
                vNextTab = this.fCachDef.fDef.indexOf(9, vPrevTab);
                String vTime = this.fCachDef.fDef.substring(vPrevTab, vNextTab);
                if (vFacetParams.length() == 0) {
                    HItemDefVers vItem = this.fItem.getWsp().hGetItemDefVers(vSpace, vCode, null);
                    if (vItem.hGetModifDt().getTime() == Long.parseLong(vTime)) continue;
                    vOk = false;
                    break;
                }
                String vUri = HQCode.hGetUri(vSpace, vCode);
                IHItem vItem = this.fItem.getWsp().hGetItem(vUri, null);
                if (vItem == null) {
                    vOk = false;
                    break;
                }
                String vSgn = vIdSubItem.length() > 0 ? vItem.hGetSubItemSgn(vIdSubItem) : vItem.hGetSignature();
                HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vFacetParams, "UTF-8");
                String vFacetName = vParams.hGetValueParam("facet");
                ISgnModule vModule = vItem.hGetItemType().hGetSgnModule(vFacetName, vSgn);
                if (vModule == null || vModule instanceof IFacet) {
                    vOk = false;
                    break;
                }
                ISrcNode vSrc = ((IFacet)vModule).getFacet(this.fItem.getSource(), vIdSubItem.length() > 0 ? vIdSubItem : null, vParams);
                if (vSrc != null && vSrc.getLastModifWithChildren() == Long.parseLong(vTime)) continue;
                vOk = false;
                break;
            }
            if (!vOk) {
                this.fCachDef.fStatus = (short)2;
                this.fOldFile = this.fFileCache;
                this.fFileCache = File.createTempFile("fac", "", this.fCacheMgr);
                int vTab = this.fCachDef.fDef.indexOf(9);
                this.fNewDef = new StringBuilder(vTab + 128);
                this.fNewDef.append(this.fCachDef.fDef.substring(0, vTab));
            }
            return vOk;
        }
    }

    public void saveCache() throws Exception {
        this.fCachDef.fDef = this.fNewDef.toString();
        if (this.fOldFile == null) {
            this.fCacheMgr.saveNewCacheDef(this.fCachDef, this.fFileCache);
        } else {
            this.fCacheMgr.saveCacheDef(this.fCachDef, this.fFileCache);
            try {
                this.fOldFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancelCache() {
        this.fCachDef.fStatus = this.fOldFile == null ? (short)0 : 1;
        try {
            this.fFileCache.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addDependance(IHItemDef pItem, String pIdSubItem, HTransformParams pFacetParams, long pLastUpdt) throws Exception {
        this.fNewDef.append('\t');
        this.fNewDef.append(pItem.hGetSpace());
        this.fNewDef.append('\t');
        this.fNewDef.append(pItem.hGetCode());
        this.fNewDef.append('\t');
        if (pIdSubItem != null) {
            this.fNewDef.append(pIdSubItem);
        }
        this.fNewDef.append('\t');
        if (pFacetParams != null) {
            this.fNewDef.append(pFacetParams);
        }
        this.fNewDef.append('\t');
        this.fNewDef.append(pLastUpdt);
    }
}

