/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.IHAttr;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HRepositoryFsBase;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.itemcontent.IHContentAccess;
import com.scenari.m.bdp.itemcontent.IHResource;
import com.scenari.m.bdp.itemcontent.IHResourceDef;
import com.scenari.m.bdp.itemcontent.base.XResource;
import com.scenari.m.bdp.module.rename.HRenamingPlan;
import com.scenari.m.bdp.module.rename.IHModuleRename;
import com.scenari.m.bdp.transaction.IHTransaction;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.random.SrcFeatureRandom;
import com.scenari.src.feature.rights.SrcFeatureRights;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class HContentAccessFs
implements IHContentAccess {
    protected HRepositoryFsBase fRepos = null;

    public static void transformFileToFolder(ISrcNode pSource, String pNewUriRes) throws Exception {
        ISrcNode vParent = SrcFeaturePaths.findNodeByPath(pSource, "..", false);
        ISrcNode vTmpFolder = SrcFeatureRandom.newRandomFolder(vParent, "tmp", "");
        if (vTmpFolder != null) {
            try {
                ISrcNode vNewUriRes = SrcFeaturePaths.findNodeByPath(vTmpFolder, pNewUriRes, false);
                SrcFeatureCopyMove.move(pSource, vNewUriRes);
                SrcFeatureCopyMove.move(vTmpFolder, pSource);
            }
            catch (Exception e) {
                vTmpFolder.removeSrc();
                throw e;
            }
        }
    }

    public HContentAccessFs(HRepositoryFsBase pRepository) {
        this.fRepos = pRepository;
    }

    public final InputStream hReadStream(IHItemDef pItemDef, String pUriRes, HTransformParams pTransforms, IHTransaction pTransaction) throws Exception {
        XItemCache vItem = this.xGetItemCache(pItemDef);
        if (vItem == null) {
            return null;
        }
        if (pTransforms == null) {
            ISrcNode vElem = WspSrcUtil.findSrcNodeFromItemUriRes(vItem.getSource(), pUriRes);
            return vElem.newInputStream(false);
        }
        WspSrcNodeItem vSrc = pUriRes == null || pUriRes.length() == 0 ? vItem.getSource() : SrcFeaturePaths.findNodeByPath(vItem.getSource(), this.xGetPathFromUriRes(pUriRes), false);
        int vSrcStatus = vSrc.getContentStatus();
        File vFile = vItem.getDatas().transformAsStream(vSrc, vSrcStatus == 2, pTransforms, null);
        if (vFile != null) {
            return new BufferedInputStream(new FileInputStream(vFile));
        }
        return null;
    }

    public final String hGetUrlFileFormat(IHItemDef pItemDef, String pUriRes, HTransformParams pTransforms, IHTransaction pTransaction) throws Exception {
        XItemCache vItem = this.xGetItemCache(pItemDef);
        if (vItem == null) {
            return null;
        }
        WspSrcNodeItem vItemSrc = vItem.getSource();
        if (pTransforms == null) {
            ISrcContent vElem = !this.isUriResDefined(pUriRes) ? vItemSrc : SrcFeaturePaths.findContentByPath(vItemSrc, this.xGetPathFromUriRes(pUriRes), false);
            return SrcFeatureAlternateUrl.getFilePath(vElem);
        }
        WspSrcNodeItem vSrc = pUriRes == null || pUriRes.length() == 0 ? vItemSrc : SrcFeaturePaths.findNodeByPath(vItemSrc, this.xGetPathFromUriRes(pUriRes), false);
        int vSrcStatus = vSrc.getContentStatus();
        File vFile = vItem.getDatas().transformAsStream(vSrc, vSrcStatus == 2, pTransforms, null);
        return vFile != null ? vFile.getCanonicalPath() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IHResourceDef hGetResourceDef(IHItemDef pItemDef, String pUriRes, HTransformParams pTransforms, IHTransaction pTransaction) throws Exception {
        XResource vRes = null;
        XItemCache vItem = this.xGetItemCache(pItemDef);
        if (vItem == null) {
            return null;
        }
        WspSrcNodeItem vItemSrc = vItem.getSource();
        if (pTransforms == null) {
            ISrcNode vSource;
            if (this.isUriResDefined(pUriRes)) {
                if (pUriRes.charAt(pUriRes.length() - 1) == '/') {
                    vSource = SrcFeaturePaths.findNodeByPath(vItemSrc, pUriRes.substring(1, pUriRes.length() - 1), false);
                    if (vSource.getContentStatus() != 2) return null;
                    vRes = new XResource();
                    vRes.hSetUriRes(vSource.getSrcUri().substring(vItemSrc.getSrcUri().length()).concat("/"));
                    vRes.hSetIsFolder(true);
                } else {
                    vSource = SrcFeaturePaths.findNodeByPath(vItemSrc, this.xGetPathFromUriRes(pUriRes), false);
                    if (vSource.getContentStatus() != 1) return null;
                    vRes = new XResource();
                    vRes.hSetUriRes(vSource.getSrcUri().substring(vItemSrc.getSrcUri().length()));
                }
            } else {
                vSource = vItemSrc;
                vRes = new XResource();
                vRes.hSetUriRes(".");
                vRes.hSetIsFolder(vSource.getContentStatus() == 2);
            }
            vRes.hSetUriItem(pItemDef.getUri());
            if (!vRes.hIsFolder()) {
                vRes.hSetLastModif(new Date(vSource.getLastModif()));
                vRes.hSetLength(vSource.getContentSize());
            } else {
                vRes.hSetLastModif(new Date(vSource.getLastModifWithChildren()));
            }
            vRes.hSetRights(SrcFeatureRights.getAllowedRights(vSource));
            return vRes;
        } else {
            WspSrcNodeItem vSrc = pUriRes == null || pUriRes.length() == 0 ? vItemSrc : SrcFeaturePaths.findNodeByPath(vItemSrc, this.xGetPathFromUriRes(pUriRes), false);
            int vSrcStatus = vSrc.getContentStatus();
            File vFile = vItem.getDatas().transformAsStream(vSrc, vSrcStatus == 2, pTransforms, null);
            vRes = new XResource();
            vRes.hSetUriRes(pUriRes);
            vRes.hSetUriItem(pItemDef.getUri());
            vRes.hSetLastModif(new Date(vItemSrc.getLastModifWithChildren()));
            vRes.hSetIsFolder(vFile.isDirectory());
            if (vRes.hIsFolder()) return vRes;
            vRes.hSetLength((int)vFile.length());
        }
        return vRes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IHResource hGetResource(IHItemDef pItemDef, String pUriRes, HTransformParams pTransforms, IHTransaction pTransaction) throws Exception {
        XResource vRes = null;
        XItemCache vItem = this.xGetItemCache(pItemDef);
        WspSrcNodeItem vItemSrc = vItem.getSource();
        if (vItem == null) {
            return null;
        }
        if (pTransforms == null) {
            ISrcNode vSource;
            if (this.isUriResDefined(pUriRes)) {
                if (pUriRes.charAt(pUriRes.length() - 1) == '/') {
                    vSource = SrcFeaturePaths.findNodeByPath(vItemSrc, pUriRes.substring(1, pUriRes.length() - 1), false);
                    if (vSource.getContentStatus() != 2) return null;
                    vRes = new XResource();
                    vRes.hSetUriRes(vSource.getSrcUri().substring(vItemSrc.getSrcUri().length()).concat("/"));
                } else {
                    vSource = SrcFeaturePaths.findNodeByPath(vItemSrc, this.xGetPathFromUriRes(pUriRes), false);
                    if (vSource.getContentStatus() != 1) return null;
                    vRes = new XResource();
                    vRes.hSetUriRes(vSource.getSrcUri().substring(vItemSrc.getSrcUri().length()));
                }
            } else {
                vSource = vItemSrc;
                vRes = new XResource();
                vRes.hSetUriRes(".");
            }
            vRes.hSetUriItem(pItemDef.getUri());
            vRes.hSetIsFolder(vSource.getContentStatus() == 2);
            if (!vRes.hIsFolder()) {
                vRes.hSetLastModif(new Date(vSource.getLastModif()));
                vRes.hSetLength(vSource.getContentSize());
                vRes.hSetInputStream(vSource.newInputStream(false));
                if (vRes.hGetUriRes() == ".") {
                    vRes.hSetContentType(vItemSrc.getContentType());
                    return vRes;
                } else {
                    vRes.hSetContentType(MimeMgr.getDefaultMimeMgr().searchMimeFromUrl(vRes.hGetUriRes()));
                }
                return vRes;
            } else {
                vRes.hSetLastModif(new Date(vSource.getLastModifWithChildren()));
            }
            return vRes;
        } else {
            WspSrcNodeItem vSrc = pUriRes == null || pUriRes.length() == 0 ? vItemSrc : SrcFeaturePaths.findNodeByPath(vItemSrc, this.xGetPathFromUriRes(pUriRes), false);
            int vSrcStatus = vSrc.getContentStatus();
            File vFile = vItem.getDatas().transformAsStream(vSrc, vSrcStatus == 2, pTransforms, null);
            vRes = new XResource();
            vRes.hSetUriRes(pUriRes);
            vRes.hSetUriItem(pItemDef.getUri());
            vRes.hSetLastModif(new Date(vItemSrc.getLastModifWithChildren()));
            vRes.hSetIsFolder(vFile.isDirectory());
            if (vRes.hIsFolder()) return vRes;
            vRes.hSetLength((int)vFile.length());
            vRes.hSetInputStream(new BufferedInputStream(new FileInputStream(vFile)));
            HTransformParams vLastTransform = pTransforms.hGetLastTransform();
            IHTransformer vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vLastTransform);
            vRes.hSetContentType(vTransformer.hGetMimeType(vLastTransform));
        }
        return vRes;
    }

    protected final int xAddResourceDef(List pListToAppend, ISrcNode pSource, String pUriItem, String pUri, int pDepth) throws Exception {
        int vNb = 0;
        int vStatus = pSource.getContentStatus();
        if (vStatus > -1) {
            XResource vRes = new XResource();
            vRes.hSetUriItem(pUri);
            vRes.hSetLastModif(new Date(pSource.getLastModifWithChildren()));
            if (vStatus == 2) {
                vRes.hSetUriRes(pSource.getSrcUri().substring(pUriItem.length()).concat("/"));
                vRes.hSetIsFolder(true);
            } else {
                vRes.hSetLength(pSource.getContentSize());
                vRes.hSetUriRes(pSource.getSrcUri().substring(pUriItem.length()));
            }
            vRes.hSetRights(SrcFeatureRights.getAllowedRights(pSource));
            pListToAppend.add(vRes);
            ++vNb;
            if (vStatus == 2 && --pDepth > 0) {
                ArrayList<ISrcNode> vChilds = new ArrayList<ISrcNode>();
                pSource.listChildrenNodes(vChilds);
                for (int i = 0; i < vChilds.size(); ++i) {
                    ISrcNode vSrcChild = (ISrcNode)vChilds.get(i);
                    vNb += this.xAddResourceDef(pListToAppend, vSrcChild, pUriItem, pUri, pDepth);
                }
            }
        }
        return vNb;
    }

    public final int hListUriRes(List pListToAppend, IHItemDef pItemDef, String pPrefixUri, boolean pDirectChildsOnly, IHTransaction pTransaction) throws Exception {
        XItemCache vItem = this.xGetItemCache(pItemDef);
        if (vItem == null) {
            return 0;
        }
        ISrcNode vSource = vItem.getSource();
        String vUriItem = vSource.getSrcUri();
        if (this.isUriResDefined(pPrefixUri)) {
            vSource = SrcFeaturePaths.findNodeByPath(vItem.getSource(), this.xGetPathFromUriRes(pPrefixUri), false);
        }
        return this.xListUriRes(pListToAppend, vSource, vUriItem, pDirectChildsOnly ? 0 : Integer.MAX_VALUE);
    }

    protected final int xListUriRes(List pListToAppend, ISrcNode pSource, String pUriItem, int pDepth) throws Exception {
        int vNb = 0;
        ArrayList<ISrcNode> vChilds = new ArrayList<ISrcNode>();
        pSource.listChildrenNodes(vChilds);
        for (int i = 0; i < vChilds.size(); ++i) {
            ISrcNode vSrcChild = (ISrcNode)vChilds.get(i);
            int vStatus = vSrcChild.getContentStatus();
            if (vStatus == 1) {
                pListToAppend.add(vSrcChild.getSrcUri().substring(pUriItem.length()));
                ++vNb;
                continue;
            }
            if (vStatus != 2) continue;
            pListToAppend.add(vSrcChild.getSrcUri().substring(pUriItem.length()).concat("/"));
            ++vNb;
            if (pDepth <= 0) continue;
            vNb += this.xListUriRes(pListToAppend, vSrcChild, pUriItem, pDepth - 1);
        }
        return vNb;
    }

    public final void hWrite(IHItem pItem, String pUriRes, InputStream pContent, IHTransaction pTransaction) throws Exception {
        XItemCache vItem = this.xGetItemCache(pItem);
        WspSrcNodeItem vItemSource = vItem.getSource();
        WspSrcNodeItem vSource = (WspSrcNodeItem)WspSrcUtil.findSrcNodeFromItemUriRes(vItemSource, pUriRes);
        ISrcNode vSubSource = vSource.getSubSrcNode();
        int vStatus = vSubSource.getContentStatus();
        if (vStatus == -2) {
            throw new Exception("Conflict uri : " + vSubSource.getSrcUri());
        }
        if (vStatus == 1 && pContent == null) {
            vSubSource.removeSrc();
        } else if (vStatus == 2 && pContent != null) {
            vSubSource.removeSrc();
        }
        if (pContent != null) {
            if (SrcFeatureIds.getOrCreateSrcId(vSubSource) != null) {
                pContent = this.replaceUriById(pItem, vSource, pContent);
            }
            SrcFeatureStreams.writeFrom(vSubSource, pContent);
        } else {
            vSubSource.createAsFolder();
        }
    }

    protected String xGetPathFromUriRes(String pUriRes) {
        return pUriRes.charAt(0) == '/' ? pUriRes.substring(1) : pUriRes;
    }

    public boolean hTransformItem2MultiRes(IHItemDef pItemDef, IHTransaction pTransaction, String pNewUriRes) throws Exception {
        XItemCache vItem = this.xGetItemCache(pItemDef);
        if (vItem == null) {
            throw LogMgr.newException("l'id '" + pItemDef + "' est inconnu.", new String[0]);
        }
        ISrcNode vSource = vItem.getSource().getSubSrcNode();
        int vStatus = vSource.getContentStatus();
        if (vStatus == 1) {
            HContentAccessFs.transformFileToFolder(vSource, pNewUriRes);
            return true;
        }
        return false;
    }

    protected boolean isUriResDefined(String pUriRes) {
        return pUriRes != null && pUriRes.length() > 1 && pUriRes.charAt(0) == '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XItemCache xGetItemCache(IHItemDef pItemDef) throws Exception {
        IHWorkspace iHWorkspace = pItemDef.hGetWorkspace();
        synchronized (iHWorkspace) {
            IWspSrc vNode = pItemDef.getSrcNode();
            if (vNode != null) {
                return ((WspSrcNodeItem)vNode).xGetItemCacheData().getItemCache();
            }
            return ((HWorkspaceFs)pItemDef.hGetWorkspace()).xGetOrCreateItemCache(pItemDef.getUri(), false);
        }
    }

    protected InputStream replaceUriById(IHItem pItem, ISrcNode pTarget, InputStream pContent) throws Exception {
        IByteStream vStream;
        IHModuleRename vRenameModule;
        boolean vFoundUris = false;
        if (pItem.hCountAttrs() > 0) {
            Iterator vIterator = pItem.hGetAttrs();
            while (vIterator.hasNext()) {
                IWspSrc vPointed;
                String vId;
                IHAttr vAttr = (IHAttr)vIterator.next();
                if (vAttr.hGetTypeAttr() != "Link" && vAttr.hGetTypeAttr() != "Ref" || SrcFeatureIds.isSrcId(vAttr.getRefUri()) || (vId = SrcFeatureIds.getOrCreateSrcId(vPointed = pItem.hGetWorkspace().findNodeByUri(vAttr.getRefUri()))) == null) continue;
                vAttr.setRefUri(vId);
                vFoundUris = true;
            }
        }
        if (vFoundUris && (vRenameModule = pItem.hGetItemType().hGetModuleRename()) != null && (vStream = vRenameModule.renameStream(new IdReplacement(pTarget), new SrcNodeOneShot(pTarget.getSrcUri(), pContent, -1, -1L, null), pTarget)) != null) {
            pContent = vStream.getInputStream(true);
        }
        return pContent;
    }

    public static class IdReplacement
    extends HRenamingPlan {
        protected ISrcNode fSrcFrom = null;

        public IdReplacement(ISrcNode pSrcFrom) {
            this.fSrcFrom = pSrcFrom;
        }

        public String getNewRefUri(String pOldRefUri) {
            try {
                String vNewRefUri;
                ISrcContent vPointed;
                if (!SrcFeatureIds.isSrcId(pOldRefUri) && (vPointed = this.fSrcFrom.findContentByUri(pOldRefUri)) != null && (vNewRefUri = SrcFeatureIds.getSrcId(vPointed)) != null) {
                    return vNewRefUri;
                }
                return pOldRefUri;
            }
            catch (Exception e) {
                LogMgr.publishException(e);
                return pOldRefUri;
            }
        }

        public boolean isInPlan(String pRefUri) {
            return false;
        }
    }
}

