/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.fs.HRepositoryFsBase;
import com.scenari.m.bdp.item.fs.WspHandler;
import com.scenari.m.bdp.item.fs.WspHandlerMaster;
import com.scenari.m.bdp.item.fs.WspHandlerSlave;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.s.fw.utils.HDouble;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.fs.basic.FsBasicFactory;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mem.IMemoryOwner;
import eu.scenari.fw.mem.MemoryMgr;
import eu.scenari.fw.util.collections.SecuredBag;
import eu.scenari.wsp.pack.IPackMgr;
import eu.scenari.wsp.provider.IWspDefListener;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.provider.IWspProvider;
import eu.scenari.wsp.provider.WspDefEvent;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.IWspHandler;
import eu.scenari.wsp.repos.IWspHandlerListener;
import eu.scenari.wsp.repos.WspHandlerEvent;
import eu.scenari.wsp.repos.wsptype.WspOption;
import eu.scenari.wsp.repos.wsptype.WspType;
import eu.scenari.wsp.repos.wsptype.WspTypeContentHandler;
import eu.scenari.wsp.res.IResListerner;
import eu.scenari.wsp.res.IResMgr;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class HRepositoryFs2
extends HRepositoryFsBase
implements IRepository,
IWspDefListener,
IResListerner,
IMemoryOwner {
    public static String sTransformCachePath = "transformCache";
    public static String sPrivateDataPath = "privData";
    public static boolean sAllowDynamicExternalSource = true;
    public static int sGCInterval = 30000;
    public static int sFreeMem_minPriority = 2;
    public static int sFreeMem_AgeForMinPriority = 86400000;
    public static int sFreeMem_AgeForMaxPriority = 600000;
    protected boolean fModeAllItemsLoaded = false;
    protected boolean fCheckUpdateItems = true;
    protected boolean fSharedWspType = true;
    protected List<IWspHandler> fListWspMaster = new ArrayList<IWspHandler>();
    protected HDouble fLoadWspTypeLock = new HDouble(0.0);
    protected List<IWspHandler> fListWsp = new ArrayList<IWspHandler>();
    protected int fWspMasterCounterId = 1;
    protected ISrcNode fFolderSsOfSs = null;
    protected IResMgr fResMgr = null;
    protected IPackMgr fPackMgr = null;
    protected SecuredBag<IWspHandlerListener> fListeners = new SecuredBag();
    protected GCThread fGCThread = new GCThread();

    public HRepositoryFs2(IWUnivers pUniverse) {
        super(pUniverse);
        MemoryMgr.registerMemoryOwner(this);
    }

    public IHWorkspace getWsp(String pCode, boolean pForceToLoad) throws Exception {
        WspHandler vWspHandler = this.getWspHandler(pCode, pForceToLoad);
        if (vWspHandler == null) {
            return null;
        }
        if (pForceToLoad) {
            return vWspHandler.getWsp();
        }
        return vWspHandler.getWspIfAvailable();
    }

    public void initRepos(String pInternDataFolder, IResMgr pResMgr, IPackMgr pPackMgr, String pSsOfSsFolder, IWspProvider pWspProvider, String pTransfCacheFolder, boolean pModeAllItensLoaded, boolean pCheckUpdateItems, boolean pSharedWspType) throws Exception {
        this.fModeAllItemsLoaded = pModeAllItensLoaded;
        this.fCheckUpdateItems = pCheckUpdateItems;
        this.fSharedWspType = pSharedWspType;
        this.fResMgr = pResMgr;
        this.fResMgr.addLocalResListener(this);
        this.fPackMgr = pPackMgr;
        if (this.fPackMgr != null) {
            this.fPackMgr.setUpdtResMgr(this.fResMgr);
            this.fPackMgr.initPackMgr();
        }
        this.fWspProvider = pWspProvider;
        pWspProvider.addWspDefListener(this, 0);
        this.fFolderSsOfSs = FsBasicFactory.newNodeFromPath(pSsOfSsFolder);
        this.fTransfCache = pTransfCacheFolder != null && pTransfCacheFolder.length() > 0 ? new File(pTransfCacheFolder) : new File(pInternDataFolder, sTransformCachePath);
        this.fTransfCache.mkdirs();
        this.fPrivateData = new File(pInternDataFolder, sPrivateDataPath);
        this.fPrivateData.mkdirs();
    }

    public void setServerMode(boolean pServerMode) {
        this.fServerMode = pServerMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WspHandler getWspHandler(String pCode, boolean pForceToLoad) throws Exception {
        WspHandler vWspHandler;
        int i;
        int vSize;
        List<IWspHandler> list;
        if (this.fSharedWspType && pCode.charAt(0) == '~') {
            list = this.fListWspMaster;
            synchronized (list) {
                vSize = this.fListWspMaster.size();
                for (i = 0; i < vSize; ++i) {
                    vWspHandler = (WspHandler)this.fListWspMaster.get(i);
                    if (!vWspHandler.getCode().equals(pCode)) continue;
                    return vWspHandler;
                }
            }
        }
        list = this.fListWsp;
        synchronized (list) {
            vSize = this.fListWsp.size();
            for (i = 0; i < vSize; ++i) {
                vWspHandler = (WspHandler)this.fListWsp.get(i);
                if (!vWspHandler.getCode().equals(pCode)) continue;
                vWspHandler.fLastUsed = System.currentTimeMillis();
                return vWspHandler;
            }
        }
        if (!pForceToLoad) {
            return null;
        }
        IWspDefinition vWspDef = this.fWspProvider.getWspDefinition(pCode);
        if (vWspDef != null) {
            WspHandler vWspResult = this.fSharedWspType ? new WspHandlerSlave(this, vWspDef) : new WspHandler(this, vWspDef);
            List<IWspHandler> list2 = this.fListWsp;
            synchronized (list2) {
                int vSize2 = this.fListWsp.size();
                for (int i2 = 0; i2 < vSize2; ++i2) {
                    WspHandler vWspHandler2 = (WspHandler)this.fListWsp.get(i2);
                    if (!vWspHandler2.getCode().equals(pCode)) continue;
                    vWspHandler2.fLastUsed = System.currentTimeMillis();
                    return vWspHandler2;
                }
                this.fListWsp.add(vWspResult);
                if (sTrace.isEnabled()) {
                    sTrace.publishDebug("WspHandler loading : %s", pCode);
                }
            }
            vWspResult.fLastUsed = System.currentTimeMillis();
            return vWspResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unloadRepository() throws Exception {
        MemoryMgr.unregisterMemoryOwner(this);
        List<IWspHandler> list = this.fListWsp;
        synchronized (list) {
            for (IWspHandler vWspHandler : this.fListWsp) {
                ((WspHandler)vWspHandler).unload();
            }
            this.fListWsp.clear();
        }
        this.fListWsp = null;
        if (this.fSharedWspType) {
            list = this.fListWspMaster;
            synchronized (list) {
                for (IWspHandler vWspHandler : this.fListWspMaster) {
                    ((WspHandler)vWspHandler).unload();
                }
                this.fListWspMaster.clear();
            }
            this.fListWspMaster = null;
        }
    }

    public void addWspHandlerListener(IWspHandlerListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeWspHandlerListener(IWspHandlerListener pListener) {
        this.fListeners.remove(pListener);
    }

    public IResMgr getResMgr() {
        return this.fResMgr;
    }

    public IPackMgr getPackMgr() {
        return this.fPackMgr;
    }

    public WspType parseWspType(InputStream pInput) throws Exception {
        return this.xLoadWspType(new SrcNodeOneShot(pInput));
    }

    protected WspType xLoadWspType(IWspDefinition pWspDef) throws Exception {
        WspTypeContentHandler vHanlder = new WspTypeContentHandler(this.fResMgr);
        pWspDef.readWspMeta(vHanlder);
        return vHanlder.getWspType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WspType xLoadWspType(ISrcContent pSource) throws Exception {
        WspTypeContentHandler vHandler = new WspTypeContentHandler(this.fResMgr);
        XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            vHandler.initSaxHandlerForRoot(vReader);
            InputStream vWspTypeIn = pSource.newInputStream(false);
            if (vWspTypeIn == null) {
                throw LogMgr.newException("WspType not found : " + pSource, new String[0]);
            }
            vReader.parse(new InputSource(vWspTypeIn));
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vReader);
        }
        return vHandler.getWspType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WspHandlerMaster xGetWspMaster(WspType pWspType) {
        WspHandlerMaster vWspResult = null;
        List<IWspHandler> list = this.fListWspMaster;
        synchronized (list) {
            for (int i = 0; i < this.fListWspMaster.size(); ++i) {
                vWspResult = (WspHandlerMaster)this.fListWspMaster.get(i);
                if (!vWspResult.getWspType().isSameMaster(pWspType)) continue;
                return vWspResult;
            }
            vWspResult = new WspHandlerMaster(this, "~".concat(Integer.toString(this.fWspMasterCounterId++)), pWspType);
            this.fListWspMaster.add(vWspResult);
        }
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("WspHandlerMaster loaded : %s", vWspResult.getCode());
        }
        vWspResult.getWsp();
        return vWspResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int xCleanupWspMaster(WspHandler pWspMaster) {
        int vUnloadedItems = 0;
        if (pWspMaster != null && this.xIsMasterUnloadable(pWspMaster)) {
            if (sTrace.isEnabled()) {
                sTrace.publishDebug("WspHandlerMaster unloaded (no slave) : %s", pWspMaster.getCode());
            }
            vUnloadedItems = pWspMaster.unload();
            List<IWspHandler> list = this.fListWspMaster;
            synchronized (list) {
                for (int j = 0; j < this.fListWspMaster.size(); ++j) {
                    if (this.fListWspMaster.get(j) != pWspMaster) continue;
                    this.fListWspMaster.remove(j);
                    break;
                }
            }
        }
        return vUnloadedItems;
    }

    protected boolean xIsMasterUnloadable(WspHandler pMaster) {
        while (true) {
            try {
                for (WspHandlerSlave wspHandlerSlave : this.fListWsp) {
                    if (wspHandlerSlave.fWspMaster != pMaster) continue;
                    return false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return true;
    }

    protected void xFireWspHandlerEvent(IWspHandler pWsp, String pTypeEvent) {
        WspHandlerEvent vEvent = new WspHandlerEvent(pTypeEvent, pWsp);
        for (IWspHandlerListener vWspHandlerListener : this.fListeners.asFrozenList()) {
            vWspHandlerListener.onWspHandlerEvent(vEvent);
        }
    }

    protected void ensureGCThreadRunning() {
        if (!this.fGCThread.isAlive()) {
            this.fGCThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWspDefEvent(WspDefEvent pEvent, int pOrder) {
        String vType = pEvent.getEventType();
        if (vType == WspDefEvent.TYPE_DELETED) {
            List<IWspHandler> list = this.fListWsp;
            synchronized (list) {
                String vWspCode = pEvent.getWspDefinition().getWspCode();
                for (int i = 0; i < this.fListWsp.size(); ++i) {
                    IWspHandler vWspHandler = this.fListWsp.get(i);
                    if (!vWspHandler.getCode().equals(vWspCode)) continue;
                    WspHandler vWspMaster = null;
                    if (this.fSharedWspType) {
                        vWspMaster = ((WspHandlerSlave)vWspHandler).fWspMaster;
                    }
                    ((WspHandler)vWspHandler).delete();
                    this.fListWsp.remove(i);
                    if (sTrace.isEnabled()) {
                        sTrace.publishDebug("WspHandler unloaded (wspDef deleted) : %s", vWspCode);
                    }
                    this.xCleanupWspMaster(vWspMaster);
                    return;
                }
            }
        }
        if (vType == WspDefEvent.TYPE_PROPERTIES_UPDATED) {
            List<IWspHandler> list = this.fListWsp;
            synchronized (list) {
                String vWspCode = pEvent.getWspDefinition().getWspCode();
                for (IWspHandler vWspHandler : this.fListWsp) {
                    if (!vWspHandler.getCode().equals(vWspCode)) continue;
                    vWspHandler.reload(pEvent.getWspDefinition());
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onLocalResUpdate(IResListerner.LocalResEventType pLocalResEventType, String pKey, ScVersion pVersion) {
        switch (pLocalResEventType) {
            case startSession: {
                HDouble hDouble = this.fLoadWspTypeLock;
                synchronized (hDouble) {
                    this.fLoadWspTypeLock.hIncreaseOne();
                    break;
                }
            }
            case endSession: {
                HDouble hDouble = this.fLoadWspTypeLock;
                synchronized (hDouble) {
                    if (this.fLoadWspTypeLock.hGet() > 0.0) {
                        this.fLoadWspTypeLock.hDecreaseOne();
                    }
                    if (this.fLoadWspTypeLock.hGet() == 0.0) {
                        this.fLoadWspTypeLock.notifyAll();
                    }
                    break;
                }
            }
            case addedLocalRes: {
                if (this.fSharedWspType) {
                    List<IWspHandler> list = this.fListWspMaster;
                    synchronized (list) {
                        for (int k = 0; k < this.fListWspMaster.size(); ++k) {
                            IWspHandler vWspHandlerMaster = this.fListWspMaster.get(k);
                            WspType vWspType = vWspHandlerMaster.getWspType();
                            if (vWspType == null || !this.xCheckIfResUsable(vWspType, pKey, pVersion)) continue;
                            if (sTrace.isEnabled()) {
                                sTrace.publishDebug("WspHandlerMaster unloaded (updated res) : %s", vWspHandlerMaster.getCode());
                            }
                            while (true) {
                                try {
                                    Iterator<IWspHandler> vIt = this.fListWsp.iterator();
                                    while (vIt.hasNext()) {
                                        WspHandlerSlave vWspSlave = (WspHandlerSlave)vIt.next();
                                        if (vWspSlave.fWspMaster != vWspHandlerMaster) continue;
                                        if (sTrace.isEnabled()) {
                                            sTrace.publishDebug("WspHandlerSlave unloaded (updated res) : %s", vWspSlave.getCode());
                                        }
                                        vWspSlave.unload();
                                        vIt.remove();
                                    }
                                }
                                catch (ConcurrentModificationException e) {
                                    continue;
                                }
                                break;
                            }
                            ((WspHandler)vWspHandlerMaster).unload();
                            this.fListWspMaster.remove(k--);
                        }
                        break;
                    }
                }
                List<IWspHandler> list = this.fListWsp;
                synchronized (list) {
                    for (int k = 0; k < this.fListWsp.size(); ++k) {
                        IWspHandler vWspHandler = this.fListWsp.get(k);
                        WspType vWspType = vWspHandler.getWspType();
                        if (vWspType == null || !this.xCheckIfResUsable(vWspType, pKey, pVersion)) continue;
                        if (sTrace.isEnabled()) {
                            sTrace.publishDebug("WspHandler unloaded (updated res) : %s", vWspHandler.getCode());
                        }
                        ((WspHandler)vWspHandler).unload();
                        this.fListWsp.remove(k--);
                    }
                    break;
                }
            }
        }
        return true;
    }

    protected boolean xCheckIfResUsable(WspType pWspType, String pKey, ScVersion pVersion) {
        if (pWspType.getWspUpdateRes() != null && pWspType.getWspUpdateRes().getKey().equals(pKey)) {
            ScVersion vCurrentVersion = pWspType.getWspVersion();
            ScVersion vMaxVersion = new ScVersion(vCurrentVersion.toString());
            if (pWspType.getLocalAutoUpdate().equals("minor")) {
                vMaxVersion.setVersion(vCurrentVersion.getMajorVersion(), vCurrentVersion.getMediumVersion());
            } else if (pWspType.getLocalAutoUpdate().equals("medium")) {
                vMaxVersion.setVersion(vCurrentVersion.getMajorVersion());
            } else if (pWspType.getLocalAutoUpdate().equals("major")) {
                vMaxVersion.setVersionUndefined();
            } else if (pWspType.getLocalAutoUpdate().equals("always")) {
                vMaxVersion.setVersionUndefined();
            }
            if (pVersion.isContainedIn(vMaxVersion, vCurrentVersion)) {
                return true;
            }
        }
        if (pWspType.getOptions() != null) {
            for (int i = 0; i < pWspType.getOptions().size(); ++i) {
                WspOption vOpt = pWspType.getOptions().get(i);
                if (!this.xCheckIfResUsable(vOpt, pKey, pVersion)) continue;
                return true;
            }
        }
        return false;
    }

    public long freeMemory(int pPriority) throws Exception {
        if (pPriority < sFreeMem_minPriority) {
            return 0L;
        }
        long vAge = sFreeMem_AgeForMaxPriority + (sFreeMem_AgeForMinPriority - sFreeMem_AgeForMaxPriority) / (10 - sFreeMem_minPriority) * (10 - pPriority);
        long vThreshold = System.currentTimeMillis() - vAge;
        long vBytes = 0L;
        try {
            try {
                Iterator<IWspHandler> vIt = this.fListWsp.iterator();
                while (vIt.hasNext()) {
                    WspHandler vWspHandler = (WspHandler)vIt.next();
                    if (vWspHandler == null) continue;
                    if (vWspHandler.fLastUsed < vThreshold) {
                        WspHandler vWspMaster;
                        WspHandler wspHandler = vWspMaster = vWspHandler instanceof WspHandlerSlave ? ((WspHandlerSlave)vWspHandler).fWspMaster : null;
                        if (sTrace.isEnabled()) {
                            sTrace.publishDebug("WspHandler unloaded (free memory) : %s", vWspHandler.getCode());
                        }
                        vBytes += (long)(vWspHandler.unload() * 500 + 5000);
                        vIt.remove();
                        vBytes += (long)(this.xCleanupWspMaster(vWspMaster) * 10000);
                        continue;
                    }
                    IHWorkspace vWsp = vWspHandler.getWspIfAvailable();
                    if (vWsp == null || !(vWsp instanceof IMemoryOwner)) continue;
                    vBytes += ((IMemoryOwner)((Object)vWsp)).freeMemory(pPriority);
                }
            }
            catch (ConcurrentModificationException e) {
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        return vBytes;
    }

    protected class GCThread
    extends Thread {
        public GCThread() {
            this.setDaemon(true);
            this.setName("Scenari workspaces GC");
        }

        public void run() {
            while (true) {
                try {
                    try {
                        for (IWspHandler vWspHandler : HRepositoryFs2.this.fListWsp) {
                            IHWorkspace vWsp = vWspHandler.getWspIfAvailable();
                            if (vWsp == null) continue;
                            vWsp.executeGC();
                        }
                    }
                    catch (ConcurrentModificationException e) {
                    }
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
                try {
                    Thread.sleep(sGCInterval);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

