/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.facet.IFacetCache;
import com.scenari.m.bdp.item.HItemDef;
import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HItemDefVersNet;
import com.scenari.m.bdp.item.HItemDefVersRes;
import com.scenari.m.bdp.item.HItemUpdatesEvent;
import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemUpdatesListener;
import com.scenari.m.bdp.item.IHReqItNet;
import com.scenari.m.bdp.item.IHReqItNetBase;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.base.HItem;
import com.scenari.m.bdp.item.fs.ExternalItemsMgr;
import com.scenari.m.bdp.item.fs.FacetCache;
import com.scenari.m.bdp.item.fs.HRepositoryFsBase;
import com.scenari.m.bdp.item.fs.HReqItNetBase;
import com.scenari.m.bdp.item.fs.TransfCacheMgr;
import com.scenari.m.bdp.item.fs.WspHistory;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.item.fs.XTransactionFs;
import com.scenari.m.bdp.itemcontent.IHContentAccess;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.itemtype.fs.HItemTypeFs;
import com.scenari.m.bdp.module.identif.HTreatIdentif;
import com.scenari.m.bdp.module.rename.IHModuleRename;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.m.bdp.module.save.HStreamHandler;
import com.scenari.m.bdp.transaction.IHTransaction;
import com.scenari.m.co.user.IHActorMgr;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.ThreadUser;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.fw.utils.HIntArrayList;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.relocate.SrcFeatureRelocate;
import com.scenari.src.feature.search.ISearchAspect;
import com.scenari.src.feature.search.SrcFeatureSearch;
import com.scenari.src.helpers.walkers.SrcIteratorNode;
import com.scenari.src.search.ISearchExecutor;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mem.IMemoryOwner;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.util.collections.CouplesObjectObject;
import eu.scenari.fw.util.collections.SecuredBag;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.repos.IRepository;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HWorkspaceFs
implements IHWorkspace,
ISrcServer,
ISearchAspect,
IMemoryOwner {
    public static int STATUS_ALL_ITEM_LOADED_NO = 1;
    public static int STATUS_ALL_ITEM_LOADED_WORKING = 2;
    public static int STATUS_ALL_ITEM_LOADED_OK = 3;
    public static final String URI_ADMIN_SPACE = "/~system";
    public static final String URI_SS_OF_SS = "/~system/root.ss.xml";
    public static final String ATTR_REF_NAME_SSPARENT = "ssParent";
    protected IWspDefinition fWspDefinition = null;
    protected HRepositoryFsBase fRepos = null;
    protected File fTransfCache = null;
    protected ISrcNode fPrivateData = null;
    protected boolean fCheckUpdateItems = true;
    protected Map<String, XItemCache> fItemsByUri = new HashMap<String, XItemCache>(256);
    protected Map<String, XItemCache> fItemsById = new HashMap<String, XItemCache>();
    protected IWspSrc fWspSrcNode = null;
    protected ISrcNode fSubSrcNode = null;
    protected HashMap<String, IHItemType> fItemTypesByUri = null;
    protected CouplesObjectObject<String, IHItemUpdatesListener> fItemUpdtListeners = new CouplesObjectObject(256);
    protected SecuredBag<IHItemUpdatesListener> fAllItemsListeners = new SecuredBag();
    protected volatile int fStatusItemLoaded = STATUS_ALL_ITEM_LOADED_NO;
    protected IHActorMgr fActorMgr = null;
    protected ISrcNode fFolderGeneration = null;
    protected WspHistory fWspHistory = new WspHistory();
    protected boolean fFireDiscoveredItems = false;
    protected List<ISearchExecutor> fSearchExecutors = new ArrayList<ISearchExecutor>(3);
    protected ExternalItemsMgr fExternalItemsMgr = null;

    public HWorkspaceFs(HRepositoryFsBase pRepository, IWspDefinition pWspDef) {
        this.fRepos = pRepository;
        this.fWspDefinition = pWspDef;
    }

    @Override
    public IWspDefinition getWspDefinition() {
        return this.fWspDefinition;
    }

    @Override
    public synchronized IHItem hGetItem(String pUri, IHTransaction pTransaction) throws Exception {
        XItemCache vCache = this.xGetItemCache(pUri);
        if (vCache != null) {
            return vCache.hCreateItemFromCache();
        }
        return null;
    }

    @Override
    public synchronized HItemDef hGetItemDef(String pUri, IHTransaction pTransaction) throws Exception {
        XItemCache vItemCache = this.xGetItemCache(pUri);
        if (vItemCache != null) {
            return vItemCache.hCreateItemDefFromCache();
        }
        return null;
    }

    @Override
    public synchronized HItemDef hGetItemDef(String pSpace, String pCode, IHTransaction pTransaction) throws Exception {
        XItemCache vItemCache = this.xGetItemCache(HQCode.hGetUri(pSpace, pCode));
        if (vItemCache != null) {
            return vItemCache.hCreateItemDefFromCache();
        }
        return null;
    }

    @Override
    public synchronized HItemDefVers hGetItemDefVers(String pSpace, String pCode, IHTransaction pTransaction) throws Exception {
        XItemCache vItemCache = this.xGetItemCache(HQCode.hGetUri(pSpace, pCode));
        if (vItemCache != null) {
            return vItemCache.hCreateItemDefVersFromCache();
        }
        return null;
    }

    @Override
    public synchronized HItemDefVersNet hGetItemDefVersNet(String pSrcUri, IHReqItNet[] pRequests, int pDepth, IHTransaction pTransaction) throws Exception {
        HItemDefVersNet vResult = null;
        XItemCache vItemCache = this.xGetItemCache(pSrcUri);
        if (vItemCache != null) {
            HItemDefVersNet.WNetContext vNetContext = new HItemDefVersNet.WNetContext(this);
            HItemDefVersNet vItNetCurrent = vResult = vItemCache.hCreateItemDefVersNetFromCache(vNetContext);
            XItemCache vItemCacheCurrent = vItemCache;
            int vDepthCurrent = 0;
            ArrayList<String> vIdToTreat = new ArrayList<String>(32);
            HIntArrayList vDepths = new HIntArrayList(32);
            do {
                if (pDepth == 0 || ++vDepthCurrent < pDepth) {
                    for (int i = 0; i < pRequests.length; ++i) {
                        ((HReqItNetBase)pRequests[i]).xAddPointers(vItNetCurrent, vItemCacheCurrent);
                    }
                }
                HItemDefVersNet.HPointer vPointer = vItNetCurrent.fFirstPointer;
                while (vPointer != null) {
                    int i;
                    List vList = vNetContext.hGetListItemDefVersNet();
                    int vSize = vList.size();
                    for (i = 0; i < vSize; ++i) {
                        HItemDefVersNet vItNetAlreadyTreated = (HItemDefVersNet)vList.get(i);
                        if (vItNetAlreadyTreated.fUri != vPointer.fUriDest) continue;
                        i = -1;
                        break;
                    }
                    if (i >= 0) {
                        vSize = vIdToTreat.size();
                        for (i = 0; i < vSize; i += 2) {
                            String vUri = (String)vIdToTreat.get(i);
                            if (!vUri.equals(vPointer.fUriDest)) continue;
                            i = -1;
                            break;
                        }
                        if (i >= 0) {
                            vIdToTreat.add(vPointer.fUriDest);
                            vDepths.addInt(vDepthCurrent);
                        }
                    }
                    vPointer = vPointer.fNextPointer;
                }
                vItemCacheCurrent = null;
                while (vIdToTreat.size() > 0 && vItemCacheCurrent == null) {
                    vDepthCurrent = vDepths.removeInt(vDepths.size() - 1);
                    vItemCacheCurrent = this.xGetItemCache((String)vIdToTreat.remove(vIdToTreat.size() - 1));
                    if (vItemCacheCurrent == null) continue;
                    vItNetCurrent = vItemCacheCurrent.hCreateItemDefVersNetFromCache(vNetContext);
                }
            } while (vItemCacheCurrent != null);
        }
        return vResult;
    }

    @Override
    public synchronized HItemDefVersRes hGetItemDefVersRes(String pUri, IHTransaction pTransaction) throws Exception {
        XItemCache vItemCache = this.xGetItemCache(pUri);
        if (vItemCache != null) {
            return vItemCache.hCreateItemDefVersResFromCache();
        }
        return null;
    }

    @Override
    public synchronized HItemDefVersRes hGetItemDefVersRes(String pSpace, String pCode, IHTransaction pTransaction) throws Exception {
        XItemCache vItemCache = this.xGetItemCache(HQCode.hGetUri(pSpace, pCode));
        if (vItemCache != null) {
            return vItemCache.hCreateItemDefVersResFromCache();
        }
        return null;
    }

    @Override
    public IHItem createItem(IHItemType pType, String pUri) throws Exception {
        HItem vItem = new HItem(this, pUri);
        vItem.hSetItemType(pType);
        return vItem;
    }

    @Override
    public synchronized IFacetCache getFacetCache(IWspSrc pSrcItem, String pIdSubItem, HTransformParams pFacetParams) throws Exception {
        XItemCache vItem = ((WspSrcNodeItem)pSrcItem).xGetItemCacheData().getItemCache();
        if (vItem != null) {
            TransfCacheMgr vCacheMgr = vItem.xGetCacheMgr();
            String vKeyCache = pIdSubItem != null ? pIdSubItem + ' ' + pFacetParams.hGetQueryStringFromThis() : pFacetParams.hGetQueryStringFromThis();
            TransfCacheMgr.CacheDef vCacheDef = vCacheMgr.getCacheDef(vKeyCache);
            FacetCache vFacetCache = new FacetCache(vCacheMgr, vItem, vCacheDef);
            return vFacetCache;
        }
        return null;
    }

    public synchronized void hSetModeLoadAllItems(boolean pModeLoadedItemExhaustive) throws Exception {
        if (pModeLoadedItemExhaustive) {
            if (this.fStatusItemLoaded == STATUS_ALL_ITEM_LOADED_OK) {
                return;
            }
            boolean vOld = this.fFireDiscoveredItems;
            try {
                this.fFireDiscoveredItems = false;
                this.fStatusItemLoaded = STATUS_ALL_ITEM_LOADED_WORKING;
                this.xLoadAllItems("");
                while (true) {
                    try {
                        for (XItemCache vItemCache : this.fItemsByUri.values()) {
                            vItemCache.hLinkIfNeeded();
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        continue;
                    }
                    break;
                }
                this.fStatusItemLoaded = STATUS_ALL_ITEM_LOADED_OK;
            }
            catch (Exception e) {
                this.fStatusItemLoaded = STATUS_ALL_ITEM_LOADED_NO;
                throw e;
            }
            finally {
                this.fFireDiscoveredItems = vOld;
            }
        } else {
            this.fStatusItemLoaded = STATUS_ALL_ITEM_LOADED_NO;
        }
    }

    @Override
    public synchronized void hSaveItem(IHItem pItem, IHTransaction pTransaction, int pClientId) throws Exception {
        XItemCache vItemCache = this.xGetOrCreateItemCache(pItem.getUri(), false);
        if (vItemCache == null) {
            throw new Exception("item uri '" + pItem.getUri() + "' is not allowed.");
        }
        vItemCache.hSaveInCache(pItem, true, pClientId);
        if (pTransaction == null) {
            vItemCache.hCommit(pItem);
        } else {
            ((XTransactionFs)pTransaction).addItemToCommit(vItemCache, pItem);
        }
    }

    @Override
    public ISrcServer getPrivateDataFolder(String pSrcUri) throws Exception {
        ISrcNode vPrivFolder;
        ISrcServer vFolderFromProvider = this.getWspDefinition().getPrivateDataFolder(pSrcUri);
        if (vFolderFromProvider != null) {
            return vFolderFromProvider;
        }
        switch (WspSrcUtil.getWspNodeType(pSrcUri)) {
            case item: {
                vPrivFolder = this.fPrivateData.findNodeByUri(pSrcUri);
                break;
            }
            case resource: {
                vPrivFolder = this.fPrivateData.findNodeByUri(WspSrcUtil.extractItemUri(pSrcUri));
                break;
            }
            default: {
                vPrivFolder = this.fPrivateData.findNodeByUri(pSrcUri).findNodeChild(".priv");
            }
        }
        IUser vUser = ThreadUser.getUser();
        if (vUser != null && !vUser.isAnonymous()) {
            vPrivFolder = vPrivFolder.findNodeChild(vUser.getAccount());
        }
        return SrcFeatureRelocate.relocateAsRoot(vPrivFolder);
    }

    @Override
    public IHItemType hGetItemType(String pUriSs) throws Exception {
        return this.fItemTypesByUri.get(pUriSs);
    }

    @Override
    public Iterator hGetItemTypes() throws Exception {
        return this.fItemTypesByUri.values().iterator();
    }

    @Override
    public IHTransaction hTransactionOpen() throws Exception {
        return new XTransactionFs(this);
    }

    @Override
    public void hTransactionCommit(IHTransaction pTransaction) throws Exception {
        ((XTransactionFs)pTransaction).hCommit();
    }

    @Override
    public void hTransactionRollback(IHTransaction pTransaction) throws Exception {
        ((XTransactionFs)pTransaction).hRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItemUpdatesListener(String pIdItem, IHItemUpdatesListener pListener) {
        CouplesObjectObject<String, IHItemUpdatesListener> couplesObjectObject = this.fItemUpdtListeners;
        synchronized (couplesObjectObject) {
            this.fItemUpdtListeners.addCoupleIfNotExist(pIdItem, pListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItemUpdatesListener(String pUriItem, IHItemUpdatesListener pListener) {
        CouplesObjectObject<String, IHItemUpdatesListener> couplesObjectObject = this.fItemUpdtListeners;
        synchronized (couplesObjectObject) {
            this.fItemUpdtListeners.removeByKeyAndValue(pUriItem, pListener);
        }
    }

    @Override
    public void addItemUpdatesListener(IHItemUpdatesListener pListener) {
        this.fAllItemsListeners.add(pListener);
    }

    @Override
    public void removeItemUpdatesListener(IHItemUpdatesListener pListener) {
        this.fAllItemsListeners.remove(pListener);
    }

    public int hGetStatusItemLoaded() {
        return this.fStatusItemLoaded;
    }

    @Override
    public boolean hCheckRight(IUser pUser, String pRight) {
        if (this.fActorMgr == null) {
            return true;
        }
        try {
            if (pUser.isSuperAdmin()) {
                return true;
            }
            return this.fActorMgr.hIsUserRole(pUser.getAccount(), pRight);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
            return true;
        }
    }

    @Override
    public IRepository hGetRepository() {
        return this.fRepos;
    }

    @Override
    public String hGetCodeWorkspace() {
        return this.fWspDefinition.getWspCode();
    }

    @Override
    public String hGetTitleWorkspace() throws Exception {
        return this.fWspDefinition.getWspTitle();
    }

    @Override
    public String hGetDescriptionWorkspace() throws Exception {
        return null;
    }

    @Override
    public ISrcNode hGetFolderGeneration() {
        return this.fFolderGeneration;
    }

    @Override
    public ISrcNode hGetFolderSource() {
        return this.fSubSrcNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refreshUri(String pUri) throws Exception {
        switch (WspSrcUtil.getWspNodeType(pUri)) {
            case resource: {
                pUri = WspSrcUtil.extractItemUri(pUri);
            }
            case item: {
                boolean vOld = this.fFireDiscoveredItems;
                try {
                    this.fFireDiscoveredItems = true;
                    XItemCache vItemCache = this.xGetItemCacheIfInMem(pUri);
                    if (vItemCache != null) {
                        String vNewId;
                        String vOldId = vItemCache.getId();
                        vItemCache.refresh(false);
                        if (vOldId == null || (vNewId = vItemCache.getId()) != null && vNewId.equals(vOldId)) break;
                        XItemCache vNewItemCache = this.xGetItemCacheById(vOldId, false);
                        vItemCache.xRelinkOnMovedId(vNewItemCache);
                        if (vNewItemCache == null) break;
                        vNewItemCache.refresh(false);
                        break;
                    }
                    this.xGetItemCache(pUri);
                    break;
                }
                finally {
                    this.fFireDiscoveredItems = vOld;
                }
            }
        }
    }

    @Override
    public IByteStream applyRenamingPlanOnStream(IHRenamingPlan pRenamingPlan, ISrcNode pSrc) throws Exception {
        int vStatus = pSrc.getContentStatus();
        if (vStatus == -1) {
            return null;
        }
        InputStream vInputStream = vStatus == 1 ? pSrc.newInputStream(false) : null;
        HStreamHandler vStream = vInputStream != null ? new HStreamHandler(vInputStream) : null;
        IHItemType vItemType = HTreatIdentif.findItemType(this, pSrc.getSrcUri(), null, vStream);
        if (vItemType == null) {
            return null;
        }
        IHModuleRename vRenameModule = vItemType.hGetModuleRename();
        if (vRenameModule == null) {
            return null;
        }
        return vRenameModule.renameStream(pRenamingPlan, pSrc, pSrc);
    }

    @Override
    public IWspSrc findNodeByUri(String pUri) throws Exception {
        if (pUri == null || pUri.length() == 0) {
            return this.fWspSrcNode;
        }
        if (pUri.charAt(0) != '/') {
            throw new Exception("Uri not well formed : " + pUri);
        }
        return (IWspSrc)this.fWspSrcNode.findNodeByUri(pUri);
    }

    @Override
    public void listExecutors(List<ISearchExecutor> pListToAppend) throws Exception {
        pListToAppend.addAll(this.fSearchExecutors);
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return this.findNodeByUri(pUri);
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition == ISearchAspect.TYPE) {
            return this;
        }
        return null;
    }

    @Override
    public final IHReqItNet hCreateReqItemNet(Class pInterface) throws Exception {
        if (pInterface == IHReqItNetBase.class) {
            return new HReqItNetBase();
        }
        return null;
    }

    @Override
    public IHContentAccess hGetContentAccess() throws Exception {
        return this.fRepos.fContentAccess;
    }

    public String toString() {
        String vTitle = null;
        try {
            vTitle = this.hGetTitleWorkspace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vTitle != null) {
            return "<workspace code=\"" + this.hGetCodeWorkspace() + "\" title=\"" + vTitle + "\"/>";
        }
        return "<workspace code=\"" + this.hGetCodeWorkspace() + "\"/>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long freeMemory(int pPriority) throws Exception {
        if (pPriority < 9) {
            return 0L;
        }
        int vItemCachesRemoved = 0;
        HWorkspaceFs hWorkspaceFs = this;
        synchronized (hWorkspaceFs) {
            Iterator<XItemCache> vIt = this.fItemsByUri.values().iterator();
            while (vIt.hasNext()) {
                XItemCache vCacheItem = vIt.next();
                if (vCacheItem.fStatusItem != -1 || vCacheItem.fFirstPointer != null || vCacheItem.getDatasIfExist() != null) continue;
                vIt.remove();
                vCacheItem.fStatusItem = XItemCache.STATUS_INTERNAL_REMOVED;
                ++vItemCachesRemoved;
            }
        }
        return vItemCachesRemoved * 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeGC() {
        ExternalItemsMgr vExternalItemsMgr;
        HWorkspaceFs hWorkspaceFs = this;
        synchronized (hWorkspaceFs) {
            vExternalItemsMgr = this.fExternalItemsMgr;
        }
        if (vExternalItemsMgr != null) {
            vExternalItemsMgr.executeGc();
        }
    }

    public synchronized ExternalItemsMgr getExternalItemsMgr() {
        return this.fExternalItemsMgr;
    }

    protected synchronized void wUnload() {
        if (this.fItemTypesByUri != null) {
            for (IHItemType vItemType : this.fItemTypesByUri.values()) {
                vItemType.wRemove();
            }
        }
    }

    protected XItemCache xGetItemCache(String pUri) throws Exception {
        assert (Thread.holdsLock(this));
        XItemCache vResult = this.fItemsByUri.get(pUri);
        if (vResult == null) {
            if (HQCode.hValidUriItem(pUri, true) != 0) {
                return null;
            }
            ISrcNode vSrcNode = this.fSubSrcNode.findNodeByUri(pUri);
            if (vSrcNode.getContentStatus() != -1) {
                vResult = new XItemCache(this, vSrcNode);
                this.fItemsByUri.put(pUri, vResult);
                vResult.refresh(true);
            }
        } else {
            vResult.refresh(true);
        }
        return vResult;
    }

    protected XItemCache xGetItemCacheIfInMem(String pUri) throws Exception {
        assert (Thread.holdsLock(this));
        return this.fItemsByUri.get(pUri);
    }

    protected XItemCache xGetItemCacheById(String pSrcId, boolean pRefresh) throws Exception {
        ISrcNode vSrcNode;
        assert (Thread.holdsLock(this));
        XItemCache vResult = this.fItemsById.get(pSrcId);
        if (vResult == null && (vSrcNode = SrcFeatureIds.findNodeById(this.fSubSrcNode, pSrcId)) != null) {
            String vSrcId = SrcFeatureIds.getSrcId(vSrcNode);
            if (vSrcId != null && vSrcId.equals(pSrcId)) {
                vResult = new XItemCache(this, vSrcNode);
                this.fItemsByUri.put(vSrcNode.getSrcUri(), vResult);
                if (!pRefresh) {
                    vResult.setId(vSrcId);
                }
            } else if (vSrcId != null) {
                return this.xGetItemCacheById(vSrcId, pRefresh);
            }
        }
        if (pRefresh && vResult != null) {
            String vId = vResult.fId;
            vResult.refresh(true);
            if (!(vId == null || vResult.fId != null && vResult.fId.equals(vId))) {
                return this.xGetItemCacheById(pSrcId, pRefresh);
            }
        }
        return vResult;
    }

    protected XItemCache xGetOrCreateItemCache(ISrcNode pSubSrcNode) throws Exception {
        assert (Thread.holdsLock(this));
        XItemCache vResult = this.fItemsByUri.get(pSubSrcNode.getSrcUri());
        if (vResult == null) {
            vResult = new XItemCache(this, pSubSrcNode);
            this.fItemsByUri.put(pSubSrcNode.getSrcUri(), vResult);
        }
        vResult.refresh(true);
        return vResult;
    }

    protected XItemCache xGetOrCreateItemCache(String pUri, boolean pRefresh) throws Exception {
        assert (Thread.holdsLock(this));
        XItemCache vResult = this.fItemsByUri.get(pUri);
        if (vResult == null) {
            if (HQCode.hValidUriItem(pUri, true) != 0) {
                return null;
            }
            ISrcNode vSrcNode = this.fSubSrcNode.findNodeByUri(pUri);
            vResult = new XItemCache(this, vSrcNode);
            this.fItemsByUri.put(pUri, vResult);
            if (!pRefresh) {
                vResult.setId(vSrcNode);
            }
        }
        if (pRefresh) {
            vResult.refresh(true);
        }
        return vResult;
    }

    protected void xRemoveItemFromCache(XItemCache pItemCache) {
        assert (Thread.holdsLock(this));
        this.fItemsByUri.remove(pItemCache.fUri);
        if (pItemCache.fId != null) {
            this.fItemsById.remove(pItemCache.fId);
        }
    }

    protected void xUpdateItemType(XItemCache pItemCache, IHItemType pNewItemType) throws Exception {
        try {
            boolean vWillBeItemType;
            IHItemType vPreviousItemType = this.hGetItemType(pItemCache.getUri());
            boolean bl = vWillBeItemType = pNewItemType != null ? pNewItemType.hIsDerivedFrom(URI_SS_OF_SS) : false;
            if (vPreviousItemType != null || vWillBeItemType) {
                if (vPreviousItemType != null && !vWillBeItemType) {
                    this.xRemoveItemTypeFromMem(vPreviousItemType);
                } else if (vPreviousItemType == null && vWillBeItemType) {
                    HItemTypeFs vItemType = new HItemTypeFs(this, pItemCache.hCreateItemFromCache(), this.xGetContentOverlay(pItemCache.getUri()));
                    this.fItemTypesByUri.put(vItemType.getUri(), vItemType);
                } else {
                    HItemTypeFs vNew = new HItemTypeFs(this, pItemCache.hCreateItemFromCache(), this.xGetContentOverlay(pItemCache.getUri()));
                    this.fItemTypesByUri.put(vNew.getUri(), vNew);
                    for (IHItemType vItemType : this.fItemTypesByUri.values()) {
                        if (!vItemType.hIsDerivedFrom(vPreviousItemType.getUri()) || vItemType == vNew) continue;
                        vItemType.wReset();
                    }
                }
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la mise \u00e0 jours de cette feuille de stockage.", new String[0]);
        }
    }

    protected String[] xGetContentOverlay(String pSsUri) {
        return null;
    }

    protected void xRemoveItemTypeFromMem(IHItemType pOldItemType) throws Exception {
        for (IHItemType vElem : this.fItemTypesByUri.values()) {
            if (pOldItemType == vElem || !vElem.hIsDerivedFrom(pOldItemType.getUri())) continue;
            vElem.wReset();
        }
        this.fItemTypesByUri.remove(pOldItemType.getUri());
        pOldItemType.wRemove();
    }

    protected File xGetTransfCacheOfSpace(String pSpace) {
        return new File(this.fTransfCache, pSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void xFireEventItemRemoved(XItemCache pItemCache, IHTransaction pTrans, int pClientId) {
        this.fWspHistory.pushEntry(pItemCache.getUri(), (byte)2, pClientId);
        Object[] vListeners = null;
        String vUri = pItemCache.fUri;
        CouplesObjectObject<String, IHItemUpdatesListener> couplesObjectObject = this.fItemUpdtListeners;
        synchronized (couplesObjectObject) {
            vListeners = this.fItemUpdtListeners.getValuesByKey(vUri);
        }
        List<IHItemUpdatesListener> vAllItemsListeners = this.fAllItemsListeners.asFrozenList();
        if (vListeners == null && vAllItemsListeners.size() <= 0) return;
        HItemUpdatesEvent vEvent = new HItemUpdatesEvent((IHWorkspace)this, vUri, pTrans, pClientId);
        for (IHItemUpdatesListener vListener : vAllItemsListeners) {
            vListener.hItemUpdated(vEvent);
        }
        if (vListeners == null) return;
        for (int i = 0; i < vListeners.length; ++i) {
            CouplesObjectObject<String, IHItemUpdatesListener> couplesObjectObject2 = this.fItemUpdtListeners;
            synchronized (couplesObjectObject2) {
                this.fItemUpdtListeners.removeByKeyAndValue(vUri, (IHItemUpdatesListener)vListeners[i]);
            }
            ((IHItemUpdatesListener)vListeners[i]).hItemUpdated(vEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xFireEventItemUpdated(IHItem pItem, IHTransaction pTrans, int pClientId) {
        this.fWspHistory.pushEntry(pItem.getUri(), (byte)1, pClientId);
        Object[] vListeners = null;
        CouplesObjectObject<String, IHItemUpdatesListener> couplesObjectObject = this.fItemUpdtListeners;
        synchronized (couplesObjectObject) {
            vListeners = this.fItemUpdtListeners.getValuesByKey(pItem.getUri());
        }
        List<IHItemUpdatesListener> vAllItemsListeners = this.fAllItemsListeners.asFrozenList();
        if (vListeners != null || vAllItemsListeners.size() > 0) {
            HItemUpdatesEvent vEvent = new HItemUpdatesEvent((IHWorkspace)this, pItem, pTrans, pClientId);
            for (IHItemUpdatesListener vListener : vAllItemsListeners) {
                vListener.hItemUpdated(vEvent);
            }
            for (int i = 0; i < vListeners.length; ++i) {
                ((IHItemUpdatesListener)vListeners[i]).hItemUpdated(vEvent);
            }
            vEvent.fTrans = null;
        }
    }

    protected void xFireEventItemStatus(XItemCache pItemCache) {
        this.fWspHistory.pushEntry(pItemCache.getUri(), (byte)3, -1);
    }

    protected void xLoadAllItems(String pUriFolder) throws Exception {
        SrcIteratorNode vSrcIt = new SrcIteratorNode(this.findNodeByUri(pUriFolder));
        ISrcNode vNode = vSrcIt.nextNode();
        while (vNode != null) {
            if (vSrcIt.getCurrentNode().getClass() == WspSrcNodeItem.class) {
                vNode = vSrcIt.nextSiblingOrUncle();
                continue;
            }
            if (vNode.getAspect(SrcFeatureSearch.SKIP_SCANNING_FOLDER_ASPECTTYPE) == Boolean.TRUE) {
                vNode = vSrcIt.nextSiblingOrUncle();
                continue;
            }
            vNode = vSrcIt.nextNode();
        }
    }

    protected void xDeleteAllPrivateData(String pSrcUri) throws Exception {
        if (this.fPrivateData != null) {
            this.fPrivateData.findNodeByUri(pSrcUri).removeSrc();
        }
    }

    protected ExternalItemsMgr xGetOrCreateExternalItemsMgr() {
        assert (Thread.holdsLock(this));
        if (this.fExternalItemsMgr == null) {
            this.fExternalItemsMgr = new ExternalItemsMgr(this);
            this.fRepos.ensureGCThreadRunning();
        }
        return this.fExternalItemsMgr;
    }
}

