/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.IHProblem;
import com.scenari.m.bdp.item.base.HItem;
import com.scenari.m.bdp.item.fs.HRepositoryFsBase;
import com.scenari.m.bdp.item.fs.HSystemSpaceDef;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeRoot;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.item.fs.XSsOverlay;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.itemtype.fs.HItemTypeFs;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.helpers.util.SrcNodeFrontEndRestrictRights;
import com.scenari.src.helpers.util.SrcServerMultiSources;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.wsp.provider.IWspDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HWspMaster
extends HWorkspaceFs {
    protected List<XSsOverlay> fListSsOverlays = null;
    protected SrcServerMultiSources fSrcServerMultiSources = null;

    public HWspMaster(HRepositoryFsBase pRepository, IWspDefinition pWspDef) {
        super(pRepository, pWspDef);
    }

    protected final synchronized void wInitMaster(ISrcNode pFolderSsOfSs, List pSystemSpacesDef, List<XSsOverlay> pListSsOverlay) throws Exception {
        this.fItemTypesByUri = new HashMap();
        this.fListSsOverlays = pListSsOverlay;
        this.fSrcServerMultiSources = new SrcServerMultiSources();
        this.fSubSrcNode = new SrcNodeFrontEndRestrictRights(this.fSrcServerMultiSources, "", 3);
        this.fWspSrcNode = new WspSrcNodeRoot(this, this.fSubSrcNode);
        this.xInitSystemSpaces(pFolderSsOfSs, pSystemSpacesDef, false);
        SrcFeatureRefresh.refresh(this.fSubSrcNode);
        this.fSrcServerMultiSources.setOverlaysLocked(true);
        this.hSetModeLoadAllItems(true);
        Iterator vIt = this.hGetItemTypes();
        while (vIt.hasNext()) {
            IHItemType vItemType = (IHItemType)vIt.next();
            if (vItemType.hGetCompilStatus() == 1) continue;
            Iterator vItErr = vItemType.hGetCompilProblems();
            while (vItErr.hasNext()) {
                IHProblem vPb = (IHProblem)vItErr.next();
                String vMess = vItemType.getUri() + " compilation " + vPb.hGetType() + " :\n" + vPb.hGetMessage() + (vPb.hGetContent() != null ? "\n" + vPb.hGetContent() : "");
                LogMgr.publishTrace(vMess, ILogMsg.LogType.Warning, new String[0]);
            }
        }
    }

    protected void xInitSystemSpaces(ISrcNode pFolderSsOfSs, List pSystemSpacesDef, boolean pCheckReadOnnly) throws Exception {
        HItem vSS = new HItem(this, "/~system/root.ss.xml");
        HItemTypeFs vItemType = new HItemTypeFs(this, vSS, this.xGetContentOverlay("/~system/root.ss.xml"));
        vSS.hSetItemType(vItemType);
        vSS.fStatus = 1;
        vSS.fUri = "/~system/root.ss.xml";
        this.fItemTypesByUri.put("/~system/root.ss.xml", vItemType);
        this.fSrcServerMultiSources.addOverlay("/~system", pFolderSsOfSs);
        XItemCache vItemCache = this.xGetOrCreateItemCache("/~system/root.ss.xml", false);
        vSS.fSrcNode = vItemCache.getSource();
        vItemCache.hSaveInCache(vSS, false, -1);
        vItemCache.hCommit(vSS);
        for (int j = 0; j < pSystemSpacesDef.size(); ++j) {
            HSystemSpaceDef vSystemSpaceDef = (HSystemSpaceDef)pSystemSpacesDef.get(j);
            if (!this.xIsSystemSpaceInWsp(vSystemSpaceDef)) continue;
            String vUri = vSystemSpaceDef.getSpace().length() > 0 ? "/".concat(vSystemSpaceDef.getSpace()) : "";
            ISrcServer vServer = pCheckReadOnnly && vSystemSpaceDef.isReadOnly() ? new SrcNodeFrontEndRestrictRights(vSystemSpaceDef.getSource(), "", 3) : vSystemSpaceDef.getSource();
            if (vSystemSpaceDef.isOverwriteMode()) {
                this.fSrcServerMultiSources.addOverwrite(vUri, vServer);
                continue;
            }
            this.fSrcServerMultiSources.addOverlay(vUri, vServer);
        }
    }

    protected boolean xIsSystemSpaceInWsp(HSystemSpaceDef pSystemSpaceDef) {
        return pSystemSpaceDef.getSpace().startsWith("~");
    }

    protected boolean xIsSystemSpaceSearchable(HSystemSpaceDef pSystemSpaceDef) {
        return !pSystemSpaceDef.getSpace().startsWith("~");
    }

    @Override
    protected String[] xGetContentOverlay(String pSsUri) {
        ArrayList<String> vOverlays = null;
        if (this.fListSsOverlays != null) {
            for (XSsOverlay vOverlay : this.fListSsOverlays) {
                if (!vOverlay.fSsUri.equals(pSsUri)) continue;
                if (vOverlays == null) {
                    vOverlays = new ArrayList<String>();
                }
                vOverlays.add(vOverlay.fContentOverlay);
            }
        }
        if (vOverlays == null) {
            return null;
        }
        String[] vResult = new String[vOverlays.size()];
        vOverlays.toArray(vResult);
        return vResult;
    }
}

