/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.fs.HRepositoryFs2;
import com.scenari.m.bdp.item.fs.HSystemSpaceDef;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.HWspStandAlone;
import com.scenari.m.bdp.item.fs.WspMigrator;
import com.scenari.m.bdp.item.fs.WspTypeUpdater;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.co.user.HActorMgrInMem;
import com.scenari.m.co.user.IUser;
import com.scenari.s.fw.utils.HDouble;
import com.scenari.serializer.simple.XmlWriterAppendable;
import com.scenari.src.ISrcNode;
import com.scenari.src.fs.basic.FsBasicFactory;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.fs.mini.FsMiniSrcNode;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.wsp.pack.IPackMgr;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.repos.IWspHandler;
import eu.scenari.wsp.repos.WspHandlerEvent;
import eu.scenari.wsp.repos.wsptype.WspOption;
import eu.scenari.wsp.repos.wsptype.WspType;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.res.IResMgr;
import eu.scenari.wsp.res.IResMgrHolder;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class WspHandler
implements IResMgrHolder,
IWspHandler {
    protected IWspDefinition fWspDefinition = null;
    protected IResMgr fUpdtMgrWsp = null;
    protected HActorMgrInMem fActorMgr = null;
    protected WspType fWspType = null;
    protected volatile int fStatusWsp = 0;
    protected Throwable fExceptionOnLoad = null;
    protected HWorkspaceFs fWsp;
    protected WspMigrator fMigrator = null;
    protected volatile List fListDownloads = null;
    protected boolean fNeedSaveWspType = false;
    protected boolean fNeedMigration = false;
    protected boolean fWspLoaded = false;
    protected Thread fThreadWorking = null;
    protected HRepositoryFs2 fRepos;
    protected long fLastUsed = 0L;

    public WspHandler(HRepositoryFs2 pRepos, IWspDefinition pWspDef) {
        this.fRepos = pRepos;
        this.fWspDefinition = pWspDef;
        this.fUpdtMgrWsp = this.fRepos.fResMgr;
    }

    public String getCode() {
        return this.fWspDefinition.getWspCode();
    }

    public IWspDefinition getWspDefinition() {
        return this.fWspDefinition;
    }

    public boolean isMigrationNeeded() {
        return this.fNeedMigration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        int vStatus = this.fStatusWsp;
        if (vStatus == 2) {
            boolean vOk = true;
            for (int i = 0; i < this.fListDownloads.size(); ++i) {
            }
            if (vOk) {
                WspHandler wspHandler = this;
                synchronized (wspHandler) {
                    this.xActivateWsp();
                    vStatus = this.fStatusWsp;
                }
            }
        }
        return vStatus;
    }

    public HRepositoryFs2 getRepository() {
        return this.fRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HWorkspaceFs getWsp() {
        block10: while (true) {
            switch (this.getStatus()) {
                case 3: {
                    return this.fWsp;
                }
                case 1: {
                    if (this.fThreadWorking == Thread.currentThread()) {
                        return this.fWsp;
                    }
                    WspHandler wspHandler = this;
                    synchronized (wspHandler) {
                        while (this.fStatusWsp == 1) {
                            try {
                                this.wait();
                            }
                            catch (Exception exception) {}
                        }
                        continue block10;
                    }
                }
                case 0: {
                    this.xLoadWspHandler();
                    continue block10;
                }
            }
            break;
        }
        return null;
    }

    public IHWorkspace getWspIfAvailable() {
        return this.getStatus() == 3 ? this.fWsp : null;
    }

    public List getListDownloads() {
        return this.fListDownloads;
    }

    public IWspHandler.IWspTypeUpdater newWspTypeUpdater(WspType pWspType) {
        if (this.fStatusWsp == 0) {
            this.xLoadWspHandler();
        }
        return new WspTypeUpdater(this, pWspType);
    }

    public synchronized void removeCache() {
        File vCache = new File(this.fRepos.fTransfCache, this.getCode());
        XItemCache.deleteFiles(vCache);
    }

    public synchronized int unload() {
        this.xWaitForStableStatus();
        int vUnloadedItems = this.fWsp != null ? this.fWsp.fItemsByUri.size() : 0;
        this.xSetWspUnloaded(0);
        this.fListDownloads = null;
        this.fNeedSaveWspType = false;
        this.fNeedMigration = false;
        this.fWspType = null;
        return vUnloadedItems;
    }

    public synchronized void delete() {
        this.xSetWspUnloaded(-1);
        this.removeCache();
        File vPrivData = new File(this.fRepos.fPrivateData, this.getCode());
        XItemCache.deleteFiles(vPrivData);
    }

    public ISrcNode getContentRoot() throws Exception {
        if (this.fWspType.getContentRootSrcSystem() != null) {
            this.fWspType.getContentRootSrcSystem().setOwner(this);
            ISrcNode vRoot = this.fWspType.getContentRootSrcSystem().getStartSrcNode();
            if (vRoot != null) {
                return vRoot;
            }
        }
        return this.fWspDefinition.getSrcRootContent();
    }

    public ISrcNode getFolderGeneration() throws Exception {
        return this.fWspDefinition.getSrcRootGen();
    }

    public IResMgr getResMgr() {
        return this.fUpdtMgrWsp;
    }

    public WspType getWspType() {
        return this.fWspType;
    }

    public Throwable getExceptionOnLoad() {
        return this.fExceptionOnLoad;
    }

    public synchronized void reload(IWspDefinition pNewDef) {
        if (this.fThreadWorking != null && this.fThreadWorking == Thread.currentThread()) {
            return;
        }
        this.unload();
        this.fWspDefinition = pNewDef;
        this.xLoadWspHandler();
    }

    protected void xWaitForStableStatus() {
        assert (Thread.holdsLock(this));
        while (true) {
            switch (this.getStatus()) {
                case -1: 
                case 0: 
                case 3: {
                    assert (this.fThreadWorking == null);
                    return;
                }
                case 1: 
                case 2: 
                case 4: {
                    if (this.fThreadWorking == Thread.currentThread()) {
                        return;
                    }
                    int vNewStatus = this.fStatusWsp;
                    while (vNewStatus == 1 || vNewStatus == 2 || vNewStatus == 4) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                    return;
                }
            }
        }
    }

    protected void xCreateWsp() {
        this.fWsp = new HWspStandAlone(this.fRepos, this.fWspDefinition);
        this.fWsp.fCheckUpdateItems = this.fRepos.fCheckUpdateItems;
        this.fWsp.fActorMgr = this.fActorMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void xLoadWspHandler() {
        if (this.fStatusWsp != 0) {
            return;
        }
        this.fThreadWorking = Thread.currentThread();
        this.fStatusWsp = 1;
        this.notifyAll();
        try {
            this.xCreateWsp();
            if (this.fWspType == null) {
                HDouble hDouble = this.fRepos.fLoadWspTypeLock;
                synchronized (hDouble) {
                    while (this.fRepos.fLoadWspTypeLock.hGet() != 0.0) {
                        try {
                            this.fRepos.fLoadWspTypeLock.wait();
                        }
                        catch (Exception exception) {}
                    }
                    this.fWspType = this.fRepos.xLoadWspType(this.fWspDefinition);
                    this.fWspType = this.xCheckLocalAutoUdate(this.fWspType);
                }
            }
            this.xActivateWsp();
            if (this.fWsp != null && this.fRepos.fModeAllItemsLoaded) {
                this.fWsp.hSetModeLoadAllItems(true);
            }
        }
        catch (Throwable e) {
            this.xSetWspUnloaded(-1);
            this.fExceptionOnLoad = e;
            LogMgr.publishException(e, "Loading workspace %s failed.", this.getCode());
        }
    }

    protected WspType xCheckLocalAutoUdate(WspType pWspType) throws Exception {
        WspType vNewWspType = pWspType;
        if (vNewWspType.getLocalAutoUpdate() != null) {
            ScVersion vCurrentVersion = vNewWspType.getWspVersion();
            ScVersion vMaxVersion = new ScVersion(vCurrentVersion.toString());
            if (vNewWspType.getLocalAutoUpdate().equals("minor")) {
                vMaxVersion.setVersion(vCurrentVersion.getMajorVersion(), vCurrentVersion.getMediumVersion());
            } else if (vNewWspType.getLocalAutoUpdate().equals("medium")) {
                vMaxVersion.setVersion(vCurrentVersion.getMajorVersion());
            } else if (vNewWspType.getLocalAutoUpdate().equals("major")) {
                vMaxVersion.setVersionUndefined();
            } else if (vNewWspType.getLocalAutoUpdate().equals("always")) {
                vMaxVersion.setVersionUndefined();
                vCurrentVersion = ScVersion.UNDEFINED_VERSION;
            }
            IRes vNewRes = this.fUpdtMgrWsp.searchLocalRes(vNewWspType.getWspUpdateRes().getKey(), vMaxVersion, vNewWspType.getWspVersion());
            while (vNewRes != null && (vCurrentVersion.equals(ScVersion.UNDEFINED_VERSION) || vNewRes.getVersion().compareTo(vNewWspType.getWspVersion()) > 0)) {
                IPackMgr vPackMgr = this.fRepos.getPackMgr();
                if (vPackMgr != null && vPackMgr.findRes(vNewWspType.getWspUpdateRes().getKey(), vNewRes.getVersion(), vNewRes.getVersion()) == null) {
                    vMaxVersion = vNewRes.getVersion().getPreviousVersion();
                    vNewRes = this.fUpdtMgrWsp.searchLocalRes(vNewWspType.getWspUpdateRes().getKey(), vMaxVersion, vNewWspType.getWspVersion());
                    continue;
                }
                if (vNewRes == null) continue;
                FsMiniSrcNode vNewWspTypeFolder = FsMiniFactory.newNodeFromCanonicalFile(vNewRes.getLocalFile().getCanonicalFile(), true);
                vNewWspType = this.fRepos.xLoadWspType(vNewWspTypeFolder.findNodeChild("wsptype.xml"));
                vNewWspType.setWspVersion(vNewRes.getVersion());
                boolean vNeedMigration = false;
                vNeedMigration = vNewWspType.getLocalAutoUpdate().equals("minor") ? WspMigrator.isMigrationNeededFromTo(pWspType, vNewWspType, vNewWspTypeFolder) : WspMigrator.isMigrationNeededTo(pWspType.getWspTypeRoot(), vNewWspType, vNewWspTypeFolder);
                if (vNeedMigration) {
                    this.fNeedMigration = true;
                    return pWspType;
                }
                vNewWspType.setOptions(pWspType.getOptions());
                this.fNeedSaveWspType = true;
            }
        }
        if (vNewWspType.getOptions() != null) {
            for (int i = 0; i < vNewWspType.getOptions().size(); ++i) {
                WspOption vOpt = vNewWspType.getOptions().get(i);
                WspType vNew = this.xCheckLocalAutoUdate(vOpt);
                if (this.fNeedMigration) {
                    return pWspType;
                }
                if (vNew == null || vOpt == vNew) continue;
                vNewWspType.getOptions().set(i, (WspOption)vNew);
                this.fNeedSaveWspType = true;
            }
        }
        return vNewWspType;
    }

    protected void xActivateWsp() {
        assert (Thread.holdsLock(this));
        try {
            int vDownloads = this.fListDownloads != null ? this.fListDownloads.size() : 0;
            ArrayList vListSpaceDefs = new ArrayList();
            this.xLoadSystemSpaces(this.fWspType, vListSpaceDefs);
            if (vDownloads == (this.fListDownloads != null ? this.fListDownloads.size() : 0)) {
                ((HWspStandAlone)this.fWsp).wInitStandAlone(this.getContentRoot(), this.fRepos.fFolderSsOfSs, this.getFolderGeneration(), vListSpaceDefs, new File(this.fRepos.fTransfCache, this.getCode()), new File(this.fRepos.fPrivateData, this.getCode()), this.xFillOverlaysSs(this.fWspType, new ArrayList()));
                if (this.fNeedSaveWspType) {
                    this.xSaveWspType(this.fWspType);
                }
                this.xSetWspLoaded();
            } else assert (this.fStatusWsp == 2);
        }
        catch (Throwable e) {
            this.xSetWspUnloaded(-1);
            this.fExceptionOnLoad = e;
            LogMgr.publishException(e, "Loading workspace %s failed.", this.getCode());
        }
    }

    protected void xSetWspLoaded() {
        assert (Thread.holdsLock(this));
        this.fStatusWsp = 3;
        this.fThreadWorking = null;
        this.notifyAll();
        this.fRepos.xFireWspHandlerEvent(this, WspHandlerEvent.TYPE_LOADED);
        this.fWspLoaded = true;
    }

    protected void xSetWspUnloaded(int pNewStatus) {
        assert (Thread.holdsLock(this));
        this.fStatusWsp = pNewStatus;
        this.fThreadWorking = null;
        this.notifyAll();
        this.fWsp = null;
        if (this.fWspLoaded) {
            this.fRepos.xFireWspHandlerEvent(this, WspHandlerEvent.TYPE_UNLOADED);
            this.fWspLoaded = false;
        }
    }

    protected List xFillOverlaysSs(WspType pWspType, List pList) {
        List<WspOption> vListOptions;
        if (pWspType.getOverlaysSs() != null) {
            pList.addAll(pWspType.getOverlaysSs());
        }
        if ((vListOptions = pWspType.getOptions()) != null) {
            for (int i = 0; i < vListOptions.size(); ++i) {
                this.xFillOverlaysSs(vListOptions.get(i), pList);
            }
        }
        return pList;
    }

    protected void xLoadSystemSpaces(WspType pWspType, List pListSpaceDefs) throws Exception {
        List vListSpaces = pWspType.getSystemSpaces();
        for (int i = 0; i < vListSpaces.size(); ++i) {
            WspType.SystemSpace vSSpace = (WspType.SystemSpace)vListSpaces.get(i);
            if (vSSpace.fRes != null) {
                IRes vLocalRes = vSSpace.fRes.getAvailableRes();
                if (vLocalRes != null) {
                    HSystemSpaceDef vSpaceDef = new HSystemSpaceDef();
                    vSpaceDef.setSpace(vSSpace.fSpace);
                    vSpaceDef.setSource(FsBasicFactory.newNodeFromCanonicalFile(vLocalRes.getLocalFile().getCanonicalFile()));
                    vSpaceDef.setNeedPreload(!vSSpace.fOptional);
                    vSpaceDef.setOverwriteMode(vSSpace.fOverwrite);
                    pListSpaceDefs.add(vSpaceDef);
                    continue;
                }
                if (vSSpace.fOptional) continue;
                throw LogMgr.newException("La ressource '%s' est manquante.", vSSpace.fRes.toString());
            }
            if (vSSpace.fSourceSystem == null) continue;
            HSystemSpaceDef vSpaceDef = new HSystemSpaceDef();
            vSpaceDef.setSpace(vSSpace.fSpace);
            vSSpace.fSourceSystem.setOwner(this);
            vSpaceDef.setSource(vSSpace.fSourceSystem.getSrcServer());
            vSpaceDef.setNeedPreload(!vSSpace.fOptional);
            vSpaceDef.setReadOnly(vSSpace.fReadOnly);
            vSpaceDef.setOverwriteMode(vSSpace.fOverwrite);
            pListSpaceDefs.add(vSpaceDef);
        }
        List<WspOption> vListOptions = pWspType.getOptions();
        if (vListOptions != null) {
            for (int i = 0; i < vListOptions.size(); ++i) {
                WspType vWspOption = vListOptions.get(i);
                this.xLoadSystemSpaces(vWspOption, pListSpaceDefs);
            }
        }
    }

    protected void xAddToDownloads(IRes pResToDownload) {
        if (this.fStatusWsp != 2) {
            this.fThreadWorking = Thread.currentThread();
            this.fStatusWsp = 2;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xSaveWspType(WspType pWspType) throws Exception {
        try {
            this.removeCache();
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Cleanup caches failed.", new String[0]);
        }
        OutputStreamBlob vStream = new OutputStreamBlob();
        OutputStreamWriter vWriter = new OutputStreamWriter((OutputStream)vStream, "UTF-8");
        try {
            XmlWriterAppendable vXmlWriter = new XmlWriterAppendable(vWriter);
            vXmlWriter.writeHeaderXml("UTF-8");
            pWspType.writeXml(vXmlWriter);
        }
        finally {
            ((Writer)vWriter).close();
        }
        this.fWspDefinition.writeWspMeta(vStream.getInputStream(true));
        this.fNeedSaveWspType = false;
    }

    protected synchronized boolean xStartMigration(WspMigrator pMigrator) {
        if (this.fStatusWsp != 3) {
            return false;
        }
        this.fMigrator = pMigrator;
        this.fThreadWorking = Thread.currentThread();
        this.fStatusWsp = 4;
        this.notifyAll();
        return true;
    }

    protected synchronized void xMigrationFailed() {
        this.fStatusWsp = 3;
        this.fThreadWorking = null;
        this.notifyAll();
    }

    protected synchronized void xMigrationDone() {
        this.fStatusWsp = 3;
        this.fThreadWorking = null;
        this.notifyAll();
    }

    public boolean checkRight(IUser pUser, String pRight) {
        if (this.fActorMgr == null) {
            return true;
        }
        try {
            if (pUser.isSuperAdmin()) {
                return true;
            }
            return this.fActorMgr.hIsUserRole(pUser.getAccount(), pRight);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
            return true;
        }
    }
}

