/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import eu.scenari.wsp.repos.IWspWatcher;

public class WspHistory {
    public static int sStackSize = 128;
    public static int sStacksCount = 12;
    public static long sTimeoutHisto = 120000L;
    protected int fOffsetFirstStack = 0;
    protected StackEntries fFirstStack = null;
    protected int fCurrentStackIdx = 0;
    protected StackEntries fCurrentStack = this.fFirstStack = new StackEntries();
    protected int fCurrentFreeEntryIdx = 0;

    public synchronized void pushEntry(String pUri, byte pUpdtType, int pClientId) {
        if (this.fCurrentStackIdx >= 2) {
            int vStacksToRemove = 0;
            long vLimit = System.currentTimeMillis() - sTimeoutHisto;
            StackEntries vStack = this.fFirstStack;
            while (vStack != this.fCurrentStack && vStack.fTimeLastEntry < vLimit) {
                ++vStacksToRemove;
                vStack = vStack.fNextStack;
            }
            if (vStacksToRemove == 0 && this.fCurrentStackIdx == sStacksCount - 1 && this.fCurrentFreeEntryIdx == sStackSize - 1) {
                vStacksToRemove = 1;
            }
            if (vStacksToRemove > 0) {
                for (int i = 0; i < vStacksToRemove; ++i) {
                    this.fFirstStack = this.fFirstStack.fNextStack;
                }
                this.fOffsetFirstStack += vStacksToRemove;
                this.fCurrentStackIdx -= vStacksToRemove;
            }
        }
        this.fCurrentStack.setEntry(this.fCurrentFreeEntryIdx++, pUri, pUpdtType, pClientId);
        if (this.fCurrentFreeEntryIdx == sStackSize) {
            this.fCurrentStack.fTimeLastEntry = System.currentTimeMillis();
            this.fCurrentFreeEntryIdx = 0;
            ++this.fCurrentStackIdx;
            this.fCurrentStack = this.fCurrentStack.fNextStack = new StackEntries();
        }
    }

    public synchronized StackMarker createStackMarker() {
        return new StackMarker(this.fCurrentStackIdx + this.fOffsetFirstStack, this.fCurrentFreeEntryIdx, this.hashCode());
    }

    public synchronized StackMarker createStackMarkerFromStart() throws IWspWatcher.OutOfWatchException {
        if (this.fOffsetFirstStack > 0) {
            throw IWspWatcher.OUTOFWATCH_CONNLOST;
        }
        return new StackMarker(this.fOffsetFirstStack, 0, this.hashCode());
    }

    public synchronized StackEntries getStackEntries(StackMarker pMarker) throws IWspWatcher.OutOfWatchException {
        if (pMarker.fWspIdentifier != this.hashCode()) {
            throw IWspWatcher.OUTOFWATCH_WSPLOST;
        }
        return this.getStackEntries(pMarker.fPublicStackIdx);
    }

    public synchronized StackEntries getStackEntries(int pPublicIdxStack) throws IWspWatcher.OutOfWatchException {
        int vIdx = pPublicIdxStack - this.fOffsetFirstStack;
        if (vIdx == this.fCurrentStackIdx) {
            return this.fCurrentStack;
        }
        if (vIdx < 0) {
            throw IWspWatcher.OUTOFWATCH_CONNLOST;
        }
        if (vIdx > this.fCurrentStackIdx) {
            return null;
        }
        StackEntries vStack = this.fFirstStack;
        for (int i = 0; i < vIdx; ++i) {
            vStack = vStack.fNextStack;
        }
        return vStack;
    }

    public synchronized int countEntriesInStack(StackEntries pStack) {
        if (pStack == this.fCurrentStack) {
            return this.fCurrentFreeEntryIdx;
        }
        return sStacksCount;
    }

    public synchronized boolean isEntryFilled(StackEntries pStack, int pOffset) {
        if (pStack != this.fCurrentStack) {
            return true;
        }
        return this.fCurrentFreeEntryIdx > pOffset;
    }

    public static class StackMarker {
        protected int fPublicStackIdx;
        protected int fEntryIdx;
        protected int fWspIdentifier;

        public StackMarker(int pPublicStackIdx, int pEntryIdx, int pWspIdentifier) {
            this.fPublicStackIdx = pPublicStackIdx;
            this.fEntryIdx = pEntryIdx;
            this.fWspIdentifier = pWspIdentifier;
        }
    }

    public static class StackEntries {
        public long fTimeLastEntry = 0L;
        public String[] fUri;
        public byte[] fUpdtType;
        public int[] fClientId;
        public StackEntries fNextStack = null;

        public StackEntries() {
            int vSize = sStackSize;
            this.fUri = new String[vSize];
            this.fUpdtType = new byte[vSize];
            this.fClientId = new int[vSize];
        }

        public void setEntry(int pIdx, String pUri, byte pUpdtType, int pClientId) {
            this.fUri[pIdx] = pUri;
            this.fUpdtType[pIdx] = pUpdtType;
            this.fClientId[pIdx] = pClientId;
        }
    }
}

