/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.fs.WspHandler;
import com.scenari.m.bdp.item.fs.WspTypeUpdater;
import com.scenari.m.co.ant.MigrateXslTask;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.fs.mini.FsMiniFactory;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.LogMsg;
import eu.scenari.wsp.repos.wsptype.WspOption;
import eu.scenari.wsp.repos.wsptype.WspType;
import eu.scenari.wsp.res.IRes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class WspMigrator
implements Runnable {
    public static final String PREFIXFOLDER_UPDTTO = "updtTo_";
    public static final String PREFIXFOLDER_MIGRFROM = "migrFrom_";
    public static final String PREFIXFOLDER_MIGRTO = "migrTo_";
    protected WspHandler fWspHandler = null;
    protected WspTypeUpdater fWspTypeUpdater = null;
    protected boolean fThroughAllOptions = true;
    protected ILogMsg fErrorLog = null;
    protected File fLog = null;

    public static boolean isMigrationNeededTo(WspType pOldWspType, WspType pNewWspType, ISrcNode pNewWspTypeSrc) {
        try {
            if (pOldWspType == null || pNewWspTypeSrc == null) {
                return false;
            }
            if (WspMigrator.isMigrationNeededFromTo(pOldWspType, pNewWspType, pNewWspTypeSrc)) {
                return true;
            }
            List<WspOption> vOldOpts = pOldWspType.getOptions();
            if (vOldOpts != null) {
                for (int i = 0; i < vOldOpts.size(); ++i) {
                    if (!WspMigrator.isMigrationNeededTo(vOldOpts.get(i), pNewWspType, pNewWspTypeSrc)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Look for migration needed failed.", new String[0]);
            return false;
        }
    }

    public static boolean isMigrationNeededFromTo(WspType pOldWspType, WspType pNewWspType, ISrcNode pNewWspTypeSrc) throws Exception {
        try {
            String vOldUri;
            if (pOldWspType == null || pNewWspTypeSrc == null) {
                return false;
            }
            String string = vOldUri = pOldWspType.getKey() != null ? pOldWspType.getKey() : pOldWspType.getUri();
            if (vOldUri != null) {
                if (vOldUri.equals(pNewWspType.getKey())) {
                    if (pOldWspType.getWspVersion().compareTo(pNewWspType.getWspVersion()) >= 0) {
                        return false;
                    }
                    List<String> vListMig = pNewWspTypeSrc.listChildrenNames(null, 2);
                    if (vListMig == null) {
                        return false;
                    }
                    for (int i = 0; i < vListMig.size(); ++i) {
                        String vMigr = vListMig.get(i);
                        if (!vMigr.startsWith(PREFIXFOLDER_UPDTTO) || new ScVersion(vMigr.substring(PREFIXFOLDER_UPDTTO.length())).compareTo(pOldWspType.getWspVersion()) <= 0) continue;
                        return true;
                    }
                } else {
                    String vPath = PREFIXFOLDER_MIGRFROM.concat(vOldUri);
                    return SrcFeaturePaths.findContentByPath(pNewWspTypeSrc, vPath, false).getContentStatus() == 2;
                }
            }
            return false;
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Look for migration needed failed.", new String[0]);
            return false;
        }
    }

    public WspMigrator(WspTypeUpdater pWspTypeUpdater, boolean pThroughAllOptions) {
        this.fWspHandler = (WspHandler)pWspTypeUpdater.getWspHandler();
        this.fWspTypeUpdater = pWspTypeUpdater;
        this.fThroughAllOptions = pThroughAllOptions;
    }

    public void run() {
        try {
            if (this.fWspHandler.xStartMigration(this)) {
                this.fWspTypeUpdater.checkConcurrentUpdate();
                this.migrate();
                this.fWspHandler.xMigrationDone();
            }
        }
        catch (Throwable e) {
            this.fWspHandler.xMigrationFailed();
            this.fErrorLog = LogMgr.getMessage(e);
            return;
        }
        try {
            this.fWspTypeUpdater.switchToNewWspType();
        }
        catch (Throwable e) {
            this.fErrorLog = LogMgr.getMessage(e);
        }
    }

    public boolean isMigrationNeeded() {
        try {
            WspType vOldWspType = this.fWspTypeUpdater.getWspHandler().getWspType();
            if (this.fThroughAllOptions) {
                if (WspMigrator.isMigrationNeededTo(vOldWspType, this.fWspTypeUpdater.getNewWspType(), this.xGetSrcRes(this.fWspTypeUpdater.getNewWspType()))) {
                    return true;
                }
                List<WspOption> vNewOpts = this.fWspTypeUpdater.getNewWspType().getOptions();
                if (vNewOpts != null) {
                    for (int i = 0; i < vNewOpts.size(); ++i) {
                        WspType vOpt = vNewOpts.get(i);
                        if (!WspMigrator.isMigrationNeededTo(vOldWspType, vOpt, this.xGetSrcRes(vOpt))) continue;
                        return true;
                    }
                }
            } else if (WspMigrator.isMigrationNeededFromTo(vOldWspType, this.fWspTypeUpdater.getNewWspType(), this.xGetSrcRes(this.fWspTypeUpdater.getNewWspType()))) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Look for migration needed failed.", new String[0]);
            return false;
        }
    }

    public ILogMsg checkPreconditions() throws Exception {
        List<WspOption> vNewOpts;
        ILogMsg vMsg = this.migrateTo(this.fWspTypeUpdater.getWspHandler().getWspType(), this.fWspTypeUpdater.getNewWspType(), this.xGetSrcRes(this.fWspTypeUpdater.getNewWspType()), true, this.fThroughAllOptions);
        if (vMsg != null) {
            return vMsg;
        }
        if (this.fThroughAllOptions && (vNewOpts = this.fWspTypeUpdater.getNewWspType().getOptions()) != null) {
            for (int i = 0; i < vNewOpts.size(); ++i) {
                WspType vOpt = vNewOpts.get(i);
                vMsg = this.migrateTo(this.fWspTypeUpdater.getWspHandler().getWspType(), vOpt, this.xGetSrcRes(vOpt), true, this.fThroughAllOptions);
                if (vMsg == null) continue;
                return vMsg;
            }
        }
        return null;
    }

    protected void migrate() throws Exception {
        List<WspOption> vNewOpts;
        this.fLog = new File(SrcFeatureAlternateUrl.getFilePath(this.fWspHandler.getContentRoot().findNodeChild(".wspmigr" + new SimpleDateFormat("yyyyMMdd-HHmmss-SS").format(new Date(System.currentTimeMillis())) + ".log")));
        this.migrateTo(this.fWspTypeUpdater.getWspHandler().getWspType(), this.fWspTypeUpdater.getNewWspType(), this.xGetSrcRes(this.fWspTypeUpdater.getNewWspType()), false, this.fThroughAllOptions);
        if (this.fThroughAllOptions && (vNewOpts = this.fWspTypeUpdater.getNewWspType().getOptions()) != null) {
            for (int i = 0; i < vNewOpts.size(); ++i) {
                WspType vOpt = vNewOpts.get(i);
                this.migrateTo(this.fWspTypeUpdater.getWspHandler().getWspType(), vOpt, this.xGetSrcRes(vOpt), false, this.fThroughAllOptions);
            }
        }
    }

    protected ISrcNode xGetSrcRes(WspType pWspType) throws Exception {
        IRes vRes = pWspType.getWspUpdateRes();
        if (vRes == null) {
            return null;
        }
        if ((vRes = vRes.getAvailableRes()) == null) {
            return null;
        }
        File vFile = vRes.getLocalFile();
        if (vFile == null) {
            return null;
        }
        return FsMiniFactory.newNodeFromCanonicalFile(vFile.getCanonicalFile(), true);
    }

    protected ILogMsg migrateTo(WspType pOldWspType, WspType pNewWspType, ISrcNode pNewWspTypeSrc, boolean pCheckPreconditions, boolean pThroughAllOptions) throws Exception {
        List<WspOption> vOldOpts;
        if (pOldWspType == null || pNewWspTypeSrc == null) {
            return null;
        }
        ILogMsg vMsg = this.migrateFromTo(pOldWspType, pNewWspType, pNewWspTypeSrc, pCheckPreconditions);
        if (vMsg != null) {
            return vMsg;
        }
        if (pThroughAllOptions && (vOldOpts = pOldWspType.getOptions()) != null) {
            for (int i = 0; i < vOldOpts.size(); ++i) {
                vMsg = this.migrateTo(vOldOpts.get(i), pNewWspType, pNewWspTypeSrc, pCheckPreconditions, true);
                if (vMsg == null) continue;
                return vMsg;
            }
        }
        return null;
    }

    protected ILogMsg migrateFromTo(WspType pOldWspType, WspType pNewWspType, ISrcNode pNewWspTypeSrc, boolean pCheckBeforeMigr) throws Exception {
        block8: {
            Object[] vListFiles;
            File vWspTypRoot;
            String vOldUri;
            block9: {
                if (pOldWspType == null || pNewWspTypeSrc == null) {
                    return null;
                }
                String string = vOldUri = pOldWspType.getKey() != null ? pOldWspType.getKey() : pOldWspType.getUri();
                if (vOldUri == null) break block8;
                vWspTypRoot = (File)((Object)pNewWspTypeSrc);
                if (!vOldUri.equals(pNewWspType.getKey())) break block9;
                Object[] vListFiles2 = vWspTypRoot.list();
                if (vListFiles2 == null) break block8;
                Arrays.sort(vListFiles2);
                for (int i = 0; i < vListFiles2.length; ++i) {
                    ILogMsg vMsg;
                    Object vMigr = vListFiles2[i];
                    if (!((String)vMigr).startsWith(PREFIXFOLDER_UPDTTO) || new ScVersion(((String)vMigr).substring(PREFIXFOLDER_UPDTTO.length())).compareTo(pOldWspType.getWspVersion()) <= 0 || (vMsg = this.xExecuteMigration(new File(vWspTypRoot, (String)vMigr), pCheckBeforeMigr)) == null) continue;
                    return vMsg;
                }
                break block8;
            }
            String vPath = PREFIXFOLDER_MIGRFROM.concat(vOldUri);
            File vMigrFrom = new File(vWspTypRoot, vPath);
            ScVersion vCurrentVersion = pOldWspType.getWspVersion();
            while ((vListFiles = vMigrFrom.list()) != null) {
                Arrays.sort(vListFiles);
                Object vMigrTo = null;
                for (int i = 0; i < vListFiles.length; ++i) {
                    Object vMigr = vListFiles[i];
                    if (((String)vMigr).startsWith(PREFIXFOLDER_UPDTTO) && new ScVersion(((String)vMigr).substring(PREFIXFOLDER_UPDTTO.length())).compareTo(vCurrentVersion) > 0) {
                        ILogMsg vMsg = this.xExecuteMigration(new File(vMigrFrom, (String)vMigr), pCheckBeforeMigr);
                        if (vMsg == null) continue;
                        return vMsg;
                    }
                    if (!((String)vMigr).startsWith(PREFIXFOLDER_MIGRTO)) continue;
                    vMigrTo = vMigr;
                }
                if (vMigrTo == null) break;
                ILogMsg vMsg = this.xExecuteMigration(new File(vMigrFrom, (String)vMigrTo), pCheckBeforeMigr);
                if (vMsg != null) {
                    return vMsg;
                }
                String vUriMigrTo = ((String)vMigrTo).substring(PREFIXFOLDER_MIGRTO.length(), ((String)vMigrTo).lastIndexOf(95));
                if (vUriMigrTo.equals(pNewWspType.getKey())) {
                    vListFiles = vWspTypRoot.list();
                    if (vListFiles == null) break;
                    Arrays.sort(vListFiles);
                    for (int i = 0; i < vListFiles.length; ++i) {
                        Object vMigr = vListFiles[i];
                        if (!((String)vMigr).startsWith(PREFIXFOLDER_UPDTTO) || new ScVersion(((String)vMigr).substring(PREFIXFOLDER_UPDTTO.length())).compareTo(vCurrentVersion) <= 0 || (vMsg = this.xExecuteMigration(new File(vWspTypRoot, (String)vMigr), pCheckBeforeMigr)) == null) continue;
                        return vMsg;
                    }
                    break;
                }
                vMigrFrom = new File(vWspTypRoot, PREFIXFOLDER_MIGRFROM.concat(vUriMigrTo));
                vCurrentVersion = new ScVersion(((String)vMigrTo).substring(((String)vMigrTo).lastIndexOf(95) + 1));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ILogMsg xExecuteMigration(File pFolderMigr, boolean pCheckBeforeMigr) throws Exception {
        File vBuildScript = new File(pFolderMigr, "build.xml");
        if (!vBuildScript.exists()) return null;
        Project vProject = new Project();
        vProject.setCoreLoader(this.getClass().getClassLoader());
        vProject.addTaskDefinition("migrateXsl", MigrateXslTask.class);
        vProject.init();
        vProject.setBaseDir(pFolderMigr);
        ISrcNode vSrcRootContent = this.fWspHandler.getWspDefinition().getSrcRootContent();
        vProject.addReference("scenari.wsp.src", (Object)vSrcRootContent);
        String vFilePath = SrcFeatureAlternateUrl.getFilePath(vSrcRootContent);
        if (vFilePath != null) {
            vProject.setUserProperty("vWspRoot", vFilePath);
            vProject.setUserProperty("scenari.wsp.path", vFilePath);
        }
        if (pCheckBeforeMigr) {
            try {
                ProjectHelper.getProjectHelper();
                ProjectHelper.configureProject((Project)vProject, (File)vBuildScript);
                if (!vProject.getTargets().containsKey("check")) return null;
                vProject.executeTarget("check");
                return null;
            }
            catch (BuildException e) {
                return new LogMsg(e.getCause().getMessage(), new String[0]);
            }
            catch (Throwable e) {
                LogMgr.publishException("Execute build.xml file exception (check migration) :  " + e, new String[0]);
                return null;
            }
        }
        DefaultLogger vLogger = new DefaultLogger();
        PrintStream vStreamLog = new PrintStream(new FileOutputStream(this.fLog, true));
        try {
            vStreamLog.println();
            vStreamLog.println("####################################");
            vStreamLog.print(pFolderMigr.getParentFile().getName());
            vStreamLog.print(" / ");
            vStreamLog.println(pFolderMigr.getName());
            vStreamLog.println("####################################");
            vLogger.setOutputPrintStream(vStreamLog);
            vLogger.setErrorPrintStream(vStreamLog);
            vLogger.setMessageOutputLevel(2);
            vProject.addBuildListener((BuildListener)vLogger);
            ProjectHelper.getProjectHelper();
            ProjectHelper.configureProject((Project)vProject, (File)vBuildScript);
            vProject.executeTarget(vProject.getDefaultTarget());
            return null;
        }
        catch (Throwable e) {
            LogMgr.publishException("Execute build.xml file exception (migration) :  " + e, new String[0]);
            vStreamLog.println(e);
            return null;
        }
        finally {
            vStreamLog.close();
        }
    }
}

