/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.context.ContextBdp;
import com.scenari.m.bdp.facet.IFacet;
import com.scenari.m.bdp.item.HItemDef;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.ItemDataKeys;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeRes;
import com.scenari.m.bdp.item.fs.WspSrcNodeSpace;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.item.fs.XItemCacheData;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.ISgnModule;
import com.scenari.m.bdp.module.identif.HTreatIdentif;
import com.scenari.m.bdp.module.rename.HRenamingPlanItem;
import com.scenari.m.bdp.module.rename.HRenamingPlanSpace;
import com.scenari.m.bdp.module.rename.IHModuleRename;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.m.bdp.module.save.HStreamHandler;
import com.scenari.m.bdp.module.xul.HModuleXul;
import com.scenari.m.bdp.transaction.IHTransaction;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.ThreadUser;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.TransformContentException;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.cachedobjects.ICachedObjectAspect;
import com.scenari.src.feature.cachedobjects.SrcFeatureCachedObjects;
import com.scenari.src.feature.copymove.ICopyMoveAspect;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.fields.IFieldsUpdaterAspect;
import com.scenari.src.feature.history.IHistoryNodeAspect;
import com.scenari.src.feature.history.SrcFeatureHistory;
import com.scenari.src.feature.ids.IFindContentByIdAspect;
import com.scenari.src.feature.ids.IFindNodeByIdAspect;
import com.scenari.src.feature.ids.IFindUriByIdAspect;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.search.ISearchAspect;
import com.scenari.src.feature.search.SrcFeatureSearch;
import com.scenari.src.feature.streams.IWriteFromInputAspect;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.src.feature.transform.ITransformAsNodeAspect;
import com.scenari.src.feature.transform.ITransformAspect;
import com.scenari.src.feature.uris.SrcFeatureUris;
import com.scenari.src.feature.versions.INetVersionNodeAspect;
import com.scenari.src.feature.versions.SrcFeatureVersions;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.helpers.base.SrcContentWrapper;
import com.scenari.src.search.ISearchRequestEditable;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.LinkParents;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.InputStreamByteStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WspSrcNodeItem
extends SrcContentWrapper
implements ISrcNode,
IWspSrc,
IRefreshAspect,
ICachedObjectAspect,
IWriteFromInputAspect,
ICopyMoveAspect,
IAccessRightsAspect,
IFieldsProviderAspect,
IFindUriByIdAspect,
IFindContentByIdAspect,
IFindNodeByIdAspect,
ITransformAspect,
ITransformAsNodeAspect,
IHistoryNodeAspect,
INetVersionNodeAspect {
    protected XItemCacheData fItemCacheData;

    public WspSrcNodeItem(ISrcNode pSubSource, XItemCacheData pItemCache) {
        super(pSubSource);
        this.fItemCacheData = pItemCache;
    }

    @Override
    protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcNode.TYPE) {
            return this;
        }
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition == IWriteFromInputAspect.TYPE) {
            return this;
        }
        if (pDefinition == IAccessRightsAspect.TYPE) {
            return this;
        }
        if (pDefinition == ITEMDEF_ASPECT_TYPE) {
            return this.createItemDef();
        }
        if (pDefinition == ITEM_ASPECT_TYPE) {
            return this.createItem();
        }
        if (pDefinition == ISearchAspect.TYPE) {
            return this.fItemCacheData.getItemCache().getWsp();
        }
        if (pDefinition == WORKSPACE_ASPECT_TYPE) {
            return this.fItemCacheData.getItemCache().getWsp();
        }
        if (pDefinition == ITEMTYPE_ASPECT_TYPE) {
            return this.getItemType();
        }
        if (pDefinition == WSPSRC_ASPECT_TYPE) {
            return this;
        }
        if (pDefinition == ICopyMoveAspect.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureCachedObjects.DOM_ASPECT_TYPE) {
            return this;
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFindUriByIdAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFindContentByIdAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFindNodeByIdAspect.TYPE) {
            return this;
        }
        if (pDefinition == ITransformAspect.TYPE) {
            return this;
        }
        if (pDefinition == ITransformAsNodeAspect.TYPE) {
            return this;
        }
        if (pDefinition == IHistoryNodeAspect.TYPE && this.getSubSrcNode().getAspect(IHistoryNodeAspect.TYPE) != null) {
            return this;
        }
        if (pDefinition == INetVersionNodeAspect.TYPE && this.getSubSrcNode().getAspect(INetVersionNodeAspect.TYPE) != null) {
            return this;
        }
        return super.getAspectForThis(pDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HItemDef createItemDef() throws Exception {
        HWorkspaceFs hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
        synchronized (hWorkspaceFs) {
            return this.fItemCacheData.getItemCache().hCreateItemDefFromCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHItem createItem() throws Exception {
        HWorkspaceFs hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
        synchronized (hWorkspaceFs) {
            return this.fItemCacheData.getItemCache().hCreateItemFromCache();
        }
    }

    public String toString() {
        return "<wspSrcNodeItem uri='" + this.getSrcUri() + "'/>";
    }

    @Override
    public IWspSrc.WspNodeType getWspNodeType() {
        return IWspSrc.WspNodeType.item;
    }

    @Override
    public ISrcNode getSubSrcNode() {
        return (ISrcNode)this.fSubSrcContent;
    }

    @Override
    public IHWorkspace getWorkspace() {
        return this.fItemCacheData.fItemCache.getWsp();
    }

    protected ISrcNode xCreateSrcNodeRes(ISrcNode pSubSource) {
        return new WspSrcNodeRes(pSubSource, this.fItemCacheData);
    }

    public XItemCacheData xGetItemCacheData() {
        return this.fItemCacheData;
    }

    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        return this.xCreateSrcNodeRes(this.getSubSrcNode().findNodeChild(pChildName));
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return this.findNodeByUri(pUri);
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        if (SrcFeatureUris.isAncestorOrSameUri(this.getSrcUri(), pUri)) {
            if (this.getSrcUri().length() == pUri.length()) {
                return this;
            }
            return this.xCreateSrcNodeRes(this.getSubSrcNode().findNodeByUri(pUri));
        }
        return WspSrcUtil.findWspNodeByUri(this.fItemCacheData.getItemCache().getWsp(), pUri);
    }

    @Override
    public String findUriById(String pSrcId) throws Exception {
        return WspSrcUtil.findUriById(this.fItemCacheData.getItemCache().getWsp(), pSrcId);
    }

    @Override
    public ISrcContent findContentById(String pSrcId) throws Exception {
        return WspSrcUtil.findWspNodeById(this.fItemCacheData.getItemCache().getWsp(), pSrcId);
    }

    @Override
    public ISrcNode findNodeById(String pSrcId) throws Exception {
        return WspSrcUtil.findWspNodeById(this.fItemCacheData.getItemCache().getWsp(), pSrcId);
    }

    @Override
    public String getSrcName() {
        return this.getSubSrcNode().getSrcName();
    }

    @Override
    public String getSrcUri() {
        return this.getSubSrcNode().getSrcUri();
    }

    @Override
    public long getLastModif() throws Exception {
        return this.fItemCacheData.fItemCache.fMemLastModif;
    }

    @Override
    public long getLastModifWithChildren() throws Exception {
        return this.fItemCacheData.fItemCache.fMemLastModif;
    }

    @Override
    public List<String> listChildrenNames(List<String> pListToAppend, int pStatusChilds) throws Exception {
        List<String> vChList = this.getSubSrcNode().listChildrenNames(null, pStatusChilds);
        if (vChList == null) {
            return null;
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<String>(vChList.size());
        }
        int i = 0;
        while (i < vChList.size()) {
            String vChName = vChList.get(i);
            if (this.xValidChildName(vChName)) {
                pListToAppend.add(vChName);
            }
            ++i;
        }
        return pListToAppend;
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        List<ISrcNode> vChList = this.getSubSrcNode().listChildrenNodes(null);
        if (vChList == null) {
            return null;
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<ISrcNode>(vChList.size());
        }
        int i = 0;
        while (i < vChList.size()) {
            ISrcNode vCh = vChList.get(i);
            if (this.xValidChildName(vCh.getSrcName())) {
                pListToAppend.add(this.xCreateSrcNodeRes(vCh));
            }
            ++i;
        }
        return pListToAppend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        InputStream vIn = super.newInputStream(pEnsureBuffered);
        if (vIn == null && this.getContentStatus() == 2) {
            IHModule vModule = null;
            HWorkspaceFs hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
            synchronized (hWorkspaceFs) {
                IHItemType vItemType = this.fItemCacheData.getItemCache().getItemType();
                if (vItemType != null) {
                    vModule = vItemType.hGetModule("folderRenderer");
                }
            }
            if (vModule != null && vModule instanceof IFacet) {
                vIn = ((IFacet)vModule).getFacet(this, null, null).newInputStream(true);
            }
        }
        return vIn;
    }

    @Override
    public int getRights() throws Exception {
        return WspSrcUtil.getRights(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refresh() throws Exception {
        HWorkspaceFs vWsp = this.fItemCacheData.fItemCache.getWsp();
        if (!vWsp.fCheckUpdateItems) {
            return true;
        }
        HWorkspaceFs hWorkspaceFs = vWsp;
        synchronized (hWorkspaceFs) {
            XItemCache vItemCache = this.fItemCacheData.getItemCache();
            if (vItemCache.getInternalStatus() == XItemCache.STATUS_INTERNAL_REMOVED) {
                this.fItemCacheData = vItemCache.getWsp().xGetOrCreateItemCache(vItemCache.getUri(), true).getDatas();
                this.fSubSrcContent = this.fItemCacheData.getWspSrcNodeItem().fSubSrcContent;
            } else {
                vItemCache.refresh(true);
            }
        }
        return true;
    }

    @Override
    public Object getCachedObject(ISrcAspectDef<ICachedObjectAspect> pCacheDef, boolean pCheckUpdates) throws Exception {
        if (pCheckUpdates) {
            this.refresh();
        }
        if (pCacheDef == SrcFeatureCachedObjects.DOM_ASPECT_TYPE) {
            return this.fItemCacheData.getDom(this);
        }
        throw new Exception("CacheDef unknown.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSrc() throws Exception {
        ISrcNode vIISpaceTarget;
        boolean vResult = this.getSubSrcNode().removeSrc();
        HWorkspaceFs hWorkspaceFs = this.fItemCacheData.fItemCache.getWsp();
        synchronized (hWorkspaceFs) {
            if (vResult) {
                this.fItemCacheData.getItemCache().hRemove(true, ContextBdp.getThreadClient());
            } else {
                this.fItemCacheData.getItemCache().refresh(false);
            }
        }
        if (vResult && (vIISpaceTarget = this.findNodeByUri(WspSrcUtil.getIISpaceUri(this.getSrcUri()))).getContentStatus() == 2) {
            vIISpaceTarget.removeSrc();
        }
        return vResult;
    }

    @Override
    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        return new SrcFeatureStreams.RedirectOutpuStreamToWriteFrom(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFrom(InputStream pIn) throws Exception {
        HWorkspaceFs vWsp = this.fItemCacheData.getItemCache().getWsp();
        IHTransaction vTrans = vWsp.hTransactionOpen();
        try {
            IFieldsUpdaterAspect vFieldsUpdater = this.getSubSrcNode().getAspect(IFieldsUpdaterAspect.TYPE);
            try {
                HItemDef vItemDef;
                if (vFieldsUpdater != null) {
                    vFieldsUpdater.startUpdateFields();
                }
                HStreamHandler vStreamHandler = new HStreamHandler(pIn);
                HWorkspaceFs hWorkspaceFs = vWsp;
                synchronized (hWorkspaceFs) {
                    vItemDef = this.fItemCacheData.getItemCache().hCreateItemDefFromCache();
                }
                IHItemType vItemType = HTreatIdentif.findItemType(vWsp, this.getSrcUri(), null, vStreamHandler);
                if (vItemType == null) {
                    throw LogMgr.newException("L'item %s n'a pu \ufffdtre enregistr\ufffd car il n'a pu \ufffdtre associ\ufffd \ufffd aucun type d'item connu.", this.getSrcUri());
                }
                IUser vUser = ThreadUser.getUser();
                int vClientId = ContextBdp.getThreadClientInt();
                vItemType.hGetModuleSave().hSaveItem(vItemDef, this.xGetUriRes(), vStreamHandler, vUser != null ? vUser.getAccount() : null, vClientId, vTrans);
                vWsp.hTransactionCommit(vTrans);
            }
            finally {
                if (vFieldsUpdater != null) {
                    vFieldsUpdater.endUpdateFields();
                }
            }
        }
        catch (Exception e) {
            try {
                vWsp.hTransactionRollback(vTrans);
            }
            catch (Exception ee) {
                LogMgr.publishException((Throwable)ee, "Rollback wsp transaction failed: ", new String[0]);
            }
            throw e;
        }
    }

    @Override
    public boolean createAsFile() throws Exception {
        if (this.getSubSrcNode().createAsFile()) {
            this.fItemCacheData.getItemCache().reloadAfterUpdate(ContextBdp.getThreadClient());
            return true;
        }
        return false;
    }

    @Override
    public boolean createAsFolder() throws Exception {
        if (this.getSubSrcNode().createAsFolder()) {
            this.fItemCacheData.getItemCache().reloadAfterUpdate(ContextBdp.getThreadClient());
            return true;
        }
        return false;
    }

    @Override
    public void copyFrom(ISrcNode pFrom) throws Exception {
        IHItemDef vItemDefFrom;
        ISrcNode vIISpaceFrom = pFrom.findNodeByUri(WspSrcUtil.getIISpaceUri(pFrom.getSrcUri()));
        ISrcNode vIISpaceTarget = this.findNodeByUri(WspSrcUtil.getIISpaceUri(this.getSrcUri()));
        IHRenamingPlan vPreviousRenamingPlan = WspSrcUtil.getCurrentRenamingPlan();
        IHRenamingPlan vRenamingPlan = vPreviousRenamingPlan;
        if (vRenamingPlan == null) {
            HRenamingPlanSpace vIISpaceRenaming = new HRenamingPlanSpace(vIISpaceFrom, vIISpaceTarget);
            vRenamingPlan = new HRenamingPlanItem(pFrom.getSrcUri(), SrcFeatureIds.getSrcId(pFrom), this.getSrcUri(), SrcFeatureIds.getOrCreateSrcId(this.getSubSrcNode()), vIISpaceRenaming);
        }
        if ((vItemDefFrom = pFrom.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE)) == null) {
            SrcFeatureCopyMove.defaultCopy(pFrom, this);
        } else {
            IHItemType vItemTypeFrom = vItemDefFrom.hGetWorkspace().hGetItemType(vItemDefFrom.getUriSs());
            IHModuleRename vRenameModuleFrom = vItemTypeFrom.hGetModuleRename();
            if (vRenameModuleFrom != null) {
                IUser vUser = ThreadUser.getUser();
                int vClientId = ContextBdp.getThreadClientInt();
                IHItemDef vItemDefTo = this.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
                IFieldsUpdaterAspect vFieldsUpdater = this.getSubSrcNode().getAspect(IFieldsUpdaterAspect.TYPE);
                try {
                    if (vFieldsUpdater != null) {
                        vFieldsUpdater.startUpdateFields();
                    }
                    vRenameModuleFrom.hRenameItem(vRenamingPlan, vItemDefFrom, vItemDefTo, vUser, vClientId, null);
                }
                finally {
                    if (vFieldsUpdater != null) {
                        vFieldsUpdater.endUpdateFields();
                    }
                }
            } else {
                SrcFeatureCopyMove.defaultCopy(pFrom, this);
            }
        }
        if (vIISpaceFrom.getContentStatus() == 2) {
            try {
                if (vPreviousRenamingPlan == null) {
                    WspSrcUtil.setCurrentRenamingPlan(vRenamingPlan);
                }
                ((WspSrcNodeSpace)vIISpaceTarget).copySpaceFrom(vIISpaceFrom);
            }
            finally {
                if (vPreviousRenamingPlan == null) {
                    WspSrcUtil.setCurrentRenamingPlan(null);
                }
            }
        }
    }

    @Override
    public void moveFrom(ISrcNode pFrom) throws Exception {
        ICopyMoveAspect vSubCopyMove;
        String vIdFrom = SrcFeatureIds.getSrcId(pFrom);
        ICopyMoveAspect iCopyMoveAspect = vSubCopyMove = vIdFrom != null ? this.getSubSrcNode().getAspect(ICopyMoveAspect.TYPE) : null;
        if (vSubCopyMove != null) {
            IFieldsUpdaterAspect vFromFieldsUpdater = pFrom.getAspect(IFieldsUpdaterAspect.TYPE);
            IFieldsUpdaterAspect vTargetFieldsUpdater = this.getAspect(IFieldsUpdaterAspect.TYPE);
            try {
                if (vFromFieldsUpdater != null) {
                    vFromFieldsUpdater.startUpdateFields();
                }
                if (vTargetFieldsUpdater != null) {
                    vTargetFieldsUpdater.startUpdateFields();
                }
                try {
                    vSubCopyMove.moveFrom(pFrom);
                }
                finally {
                    this.xValidateItem(pFrom);
                    this.xValidateItem(this);
                }
            }
            finally {
                if (vFromFieldsUpdater != null) {
                    vFromFieldsUpdater.endUpdateFields();
                }
                if (vTargetFieldsUpdater != null) {
                    vTargetFieldsUpdater.endUpdateFields();
                }
            }
            String vIdTarget = SrcFeatureIds.getSrcId(this.getSubSrcNode());
            if (vIdTarget == null || !vIdFrom.equals(vIdTarget)) {
                this.xRenamePointers(pFrom.getSrcUri(), vIdFrom);
            } else {
                this.xRefreshPointers(pFrom.getSrcUri());
            }
        } else {
            IHItemDef vItemDefFrom = pFrom.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
            if (vItemDefFrom == null || vItemDefFrom.hGetWorkspace() != this.getWorkspace()) {
                SrcFeatureCopyMove.defaultMove(pFrom, this);
                return;
            }
            this.copyFrom(pFrom);
            this.xRenamePointers(pFrom.getSrcUri(), vIdFrom);
            pFrom.removeSrc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHItem xValidateItem(ISrcNode pSrc) {
        block12: {
            if (pSrc.getContentStatus() <= -1) {
                HWorkspaceFs vWspFromFs;
                IHWorkspace vWspFrom = pSrc.getAspect(IWspSrc.WORKSPACE_ASPECT_TYPE);
                if (vWspFrom == null || !(vWspFrom instanceof HWorkspaceFs)) break block12;
                HWorkspaceFs hWorkspaceFs = vWspFromFs = (HWorkspaceFs)vWspFrom;
                synchronized (hWorkspaceFs) {
                    XItemCache vItemCache = vWspFromFs.xGetItemCacheIfInMem(pSrc.getSrcUri());
                    if (vItemCache != null) {
                        int vClientId = ContextBdp.getThreadClientInt();
                        vItemCache.hRemove(true, vClientId);
                    }
                    break block12;
                }
            }
            IHItemDef vItemDefFrom = pSrc.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
            if (vItemDefFrom == null) break block12;
            InputStream vIn = pSrc.newInputStream(false);
            HStreamHandler vStreamHandler = vIn != null ? new HStreamHandler(vIn) : null;
            try {
                IHItemType vItemType = HTreatIdentif.findItemType(vItemDefFrom.hGetWorkspace(), pSrc.getSrcUri(), null, vStreamHandler);
                IUser vUser = ThreadUser.getUser();
                int vClientId = ContextBdp.getThreadClientInt();
                IHItem iHItem = vItemType.hGetModuleSave().hValidateItem(vItemDefFrom, vStreamHandler, vUser != null ? vUser.getAccount() : null, vClientId, null);
                if (vStreamHandler != null) {
                    vStreamHandler.hCloseAndPurgeCache();
                }
                return iHItem;
            }
            catch (Throwable throwable) {
                try {
                    if (vStreamHandler != null) {
                        vStreamHandler.hCloseAndPurgeCache();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
        }
        return null;
    }

    protected void xRenamePointers(String pUriFrom, String pIdFrom) throws Exception {
        ISearchRequestEditable vReq = SrcFeatureSearch.newRequest();
        vReq.setMainExpression(new LinkParents().setStartPath(pUriFrom));
        Iterator<ISearchResultRow> vIt = SrcFeatureSearch.execute(vReq, this.getWorkspace().findNodeByUri(""));
        if (vIt.hasNext()) {
            IUser vUser = ThreadUser.getUser();
            IHRenamingPlan vRenamingPlan = WspSrcUtil.getCurrentRenamingPlan();
            if (vRenamingPlan == null) {
                vRenamingPlan = new HRenamingPlanItem(pUriFrom, pIdFrom, this.getSrcUri(), SrcFeatureIds.getSrcId(this.getSubSrcNode()));
            }
            do {
                ISrcNode vSrcNode;
                if (vRenamingPlan.isInPlan((vSrcNode = vIt.next().getSrcNode()).getSrcUri()) || !vRenamingPlan.addUriDone(vSrcNode.getSrcUri())) continue;
                try {
                    IHModuleRename vModuleRename;
                    IHItemDef vItemDef = vSrcNode.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
                    IHItemType vItemType = this.getWorkspace().hGetItemType(vItemDef.getUriSs());
                    if (vItemType == null || (vModuleRename = vItemType.hGetModuleRename()) == null) continue;
                    IFieldsUpdaterAspect vFieldsUpdater = this.getSubSrcNode().getAspect(IFieldsUpdaterAspect.TYPE);
                    try {
                        if (vFieldsUpdater != null) {
                            vFieldsUpdater.startUpdateFields();
                        }
                        vModuleRename.hRenameItem(vRenamingPlan, vItemDef, vItemDef, vUser, -1, null);
                    }
                    finally {
                        if (vFieldsUpdater != null) {
                            vFieldsUpdater.endUpdateFields();
                        }
                    }
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec au recalcul du contenu d'un item pointeur d'un item renomm\ufffd.", new String[0]);
                }
            } while (vIt.hasNext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xRefreshPointers(String pUriFrom) throws Exception {
        ISearchRequestEditable vReq = SrcFeatureSearch.newRequest();
        vReq.setMainExpression(new LinkParents().setStartPath(pUriFrom));
        HWorkspaceFs vWsp = (HWorkspaceFs)this.getWorkspace();
        Iterator<ISearchResultRow> vIt = SrcFeatureSearch.execute(vReq, vWsp.findNodeByUri(""));
        while (vIt.hasNext()) {
            HWorkspaceFs hWorkspaceFs = vWsp;
            synchronized (hWorkspaceFs) {
                XItemCache vItemCache = vWsp.xGetOrCreateItemCache(vIt.next().getRowUri(), false);
                vItemCache.xUnlinkChilds();
                vItemCache.xLinkChilds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillFields(IFieldsCollector pFieldsToCollect) throws Exception {
        IFieldsProviderAspect vFieldsProvider = this.getSubSrcNode().getAspect(IFieldsProviderAspect.TYPE);
        if (vFieldsProvider != null) {
            vFieldsProvider.fillFields(pFieldsToCollect);
        }
        pFieldsToCollect.startIterate();
        HModuleXul vModule = null;
        String vDataKey = pFieldsToCollect.nextUnfilledDataKey();
        while (vDataKey != null) {
            if (vDataKey == ItemDataKeys.DATAKEY_TITLE) {
                pFieldsToCollect.setData(vDataKey, this.fItemCacheData.getItemCache().hGetTitle());
            } else {
                HWorkspaceFs hWorkspaceFs;
                if (vDataKey == ItemDataKeys.DATAKEY_ITEMSTATUS) {
                    hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
                    synchronized (hWorkspaceFs) {
                        pFieldsToCollect.setData(vDataKey, this.fItemCacheData.getItemCache().getPublicStatus());
                    }
                }
                if (vDataKey == ItemDataKeys.DATAKEY_ITEMSGN) {
                    pFieldsToCollect.setData(vDataKey, this.fItemCacheData.getItemCache().hGetSignature());
                } else if (vDataKey == ItemDataKeys.DATAKEY_UIPACK || vDataKey == ItemDataKeys.DATAKEY_UIMODEL) {
                    if (vModule == null) {
                        hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
                        synchronized (hWorkspaceFs) {
                            IHItemType vItemType = this.fItemCacheData.getItemCache().getItemType();
                            if (vItemType != null) {
                                vModule = (HModuleXul)vItemType.hGetModuleByClass(HModuleXul.class);
                            }
                        }
                    }
                    if (vModule != null) {
                        if (vDataKey == ItemDataKeys.DATAKEY_UIPACK) {
                            pFieldsToCollect.setData(vDataKey, vModule.hGetPackage(this.xGetUriRes()));
                        } else {
                            pFieldsToCollect.setData(vDataKey, vModule.hGetModel(this.xGetUriRes()));
                        }
                    }
                }
            }
            vDataKey = pFieldsToCollect.nextUnfilledDataKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IByteStream transform(HTransformParams pParams) throws TransformContentException, Exception {
        if (pParams.hGetTransformType().equals("facet")) {
            ISrcNode vSrc;
            ISgnModule vModule = null;
            HWorkspaceFs hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
            synchronized (hWorkspaceFs) {
                XItemCache vItemCache = this.fItemCacheData.getItemCache();
                IHItemType vItemType = vItemCache.getItemType();
                vModule = vItemType.hGetSgnModule(pParams.hGetValueParam("facet"), vItemCache.hGetSignature());
            }
            if (vModule != null && vModule instanceof IFacet && (vSrc = ((IFacet)vModule).getFacet(this, null, pParams)) != null && vSrc.getContentStatus() == 1) {
                return new InputStreamByteStream(vSrc.newInputStream(false));
            }
            return null;
        }
        File vResult = this.xGetItemCacheData().transformAsStream(this, this.getContentStatus() == 2, pParams, null);
        if (vResult == null) {
            return null;
        }
        return new InputStreamByteStream(new FileInputStream(vResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISrcNode transformAsNode(HTransformParams pParams) throws TransformContentException, Exception {
        if (pParams.hGetTransformType().equals("facet")) {
            ISgnModule vModule = null;
            HWorkspaceFs hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
            synchronized (hWorkspaceFs) {
                XItemCache vItemCache = this.fItemCacheData.getItemCache();
                IHItemType vItemType = vItemCache.getItemType();
                vModule = vItemType.hGetSgnModule(pParams.hGetValueParam("facet"), vItemCache.hGetSignature());
            }
            if (vModule != null && vModule instanceof IFacet) {
                return ((IFacet)vModule).getFacet(this, null, pParams);
            }
            return null;
        }
        File vResult = this.xGetItemCacheData().transformAsStream(this, this.getContentStatus() == 2, pParams, null);
        if (vResult == null) {
            return null;
        }
        return FsMiniFactory.newNodeFromCanonicalFile(vResult, true);
    }

    @Override
    public List<ISrcNode> getHistoryNodes() throws Exception {
        return SrcFeatureHistory.getHistoryNodes(this.getSubSrcNode());
    }

    @Override
    public ISrcNode getHistoryNode(String pRefUri) throws Exception {
        return SrcFeatureHistory.getHistoryNode(this.getSubSrcNode(), pRefUri);
    }

    @Override
    public List<ISrcNode> getNetVersionNodes() throws Exception {
        return SrcFeatureVersions.getNetVersionNodes(this.getSubSrcNode());
    }

    @Override
    public void createNetVersion(String pComment, Map<String, Object> pOptions) throws Exception {
        SrcFeatureVersions.createNetVersion(this.getSubSrcNode(), pComment, pOptions);
    }

    protected boolean xValidChildName(String pSrcName) throws Exception {
        return !pSrcName.equals(".svn");
    }

    protected String xGetUriRes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHItemType getItemType() throws Exception {
        HWorkspaceFs hWorkspaceFs = this.fItemCacheData.getItemCache().getWsp();
        synchronized (hWorkspaceFs) {
            return this.fItemCacheData.getItemCache().getItemType();
        }
    }
}

