/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeRes;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.module.rename.HRenamingPlanSpace;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.copymove.ICopyMoveAspect;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import com.scenari.src.feature.ids.IFindContentByIdAspect;
import com.scenari.src.feature.ids.IFindNodeByIdAspect;
import com.scenari.src.feature.ids.IFindUriByIdAspect;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.search.ISearchAspect;
import com.scenari.src.helpers.base.SrcNodeWrapper;
import eu.scenari.fw.util.collections.ListFilterBase;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WspSrcNodeSpace
extends SrcNodeWrapper
implements ISrcNode,
IWspSrc,
ICopyMoveAspect,
IAccessRightsAspect,
IFindUriByIdAspect,
IFindContentByIdAspect,
IFindNodeByIdAspect {
    protected HWorkspaceFs fWsp;

    public WspSrcNodeSpace(HWorkspaceFs pWsp, ISrcNode pSubSource) throws Exception {
        super(pSubSource);
        this.fWsp = pWsp;
    }

    @Override
    protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISearchAspect.TYPE) {
            return this.fWsp;
        }
        if (pDefinition == WORKSPACE_ASPECT_TYPE) {
            return this.fWsp;
        }
        if (pDefinition == WSPSRC_ASPECT_TYPE) {
            return this;
        }
        if (pDefinition == ICopyMoveAspect.TYPE) {
            return this;
        }
        if (pDefinition == IAccessRightsAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFindUriByIdAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFindContentByIdAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFindNodeByIdAspect.TYPE) {
            return this;
        }
        return super.getAspectForThis(pDefinition);
    }

    @Override
    public IHWorkspace getWorkspace() {
        return this.fWsp;
    }

    @Override
    public IWspSrc.WspNodeType getWspNodeType() {
        return IWspSrc.WspNodeType.space;
    }

    @Override
    public String getSrcName() {
        if (this.getSubSrcNode().getSrcUri().length() == 0) {
            return this.fWsp.hGetCodeWorkspace();
        }
        return this.getSubSrcNode().getSrcName();
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return this.findNodeByUri(pUri);
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        return WspSrcUtil.findWspNodeByUri(this.fWsp, pUri);
    }

    @Override
    public String findUriById(String pSrcId) throws Exception {
        return WspSrcUtil.findUriById(this.fWsp, pSrcId);
    }

    @Override
    public ISrcContent findContentById(String pSrcId) throws Exception {
        return WspSrcUtil.findWspNodeById(this.fWsp, pSrcId);
    }

    @Override
    public ISrcNode findNodeById(String pSrcId) throws Exception {
        return WspSrcUtil.findWspNodeById(this.fWsp, pSrcId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        boolean vIsItem;
        boolean bl = vIsItem = pChildName.indexOf(46) > 0;
        if (vIsItem && HQCode.hValidCode(pChildName, true) == 0) {
            HWorkspaceFs hWorkspaceFs = this.fWsp;
            synchronized (hWorkspaceFs) {
                return this.fWsp.xGetOrCreateItemCache(this.getSrcUri() + "/" + pChildName, true).getSource();
            }
        }
        if (HQCode.hValidSpacePart(pChildName, true) == 0) {
            return new WspSrcNodeSpace(this.fWsp, this.getSubSrcNode().findNodeChild(pChildName));
        }
        return ISrcNode.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) throws Exception {
        HWorkspaceFs hWorkspaceFs = this.fWsp;
        synchronized (hWorkspaceFs) {
            switch (WspSrcUtil.getWspNodeType(pSubSource.getSrcUri())) {
                case wsp: {
                    return this.fWsp.findNodeByUri("");
                }
                case space: {
                    return new WspSrcNodeSpace(this.fWsp, pSubSource);
                }
                case item: {
                    return this.fWsp.xGetOrCreateItemCache(pSubSource).getSource();
                }
                case resource: {
                    XItemCache vItemCache = this.fWsp.xGetOrCreateItemCache(WspSrcUtil.extractItemUri(pSubSource.getSrcUri()), true);
                    if (vItemCache != null) {
                        return new WspSrcNodeRes(pSubSource, vItemCache.getDatas());
                    }
                    return ISrcNode.NULL;
                }
            }
        }
        return ISrcNode.NULL;
    }

    @Override
    public List<String> listChildrenNames(List<String> pListToAppend, int pStatusChilds) throws Exception {
        List<String> vChList = this.getSubSrcNode().listChildrenNames(null, pStatusChilds);
        if (vChList == null) {
            return null;
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<String>(vChList.size());
        }
        for (int i = 0; i < vChList.size(); ++i) {
            String vChName = vChList.get(i);
            if (!this.xValidChildName(vChName)) continue;
            pListToAppend.add(vChName);
        }
        return pListToAppend;
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        List<ISrcNode> vChList = this.getSubSrcNode().listChildrenNodes(null);
        if (vChList == null) {
            return null;
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<ISrcNode>(vChList.size());
        }
        for (int i = 0; i < vChList.size(); ++i) {
            ISrcNode vCh = vChList.get(i);
            if (!this.xValidChildName(vCh.getSrcName())) continue;
            pListToAppend.add(this.xCreateSrcNode(vCh));
        }
        return pListToAppend;
    }

    protected boolean xValidChildName(String pSrcName) throws Exception {
        if (pSrcName.indexOf(46) >= 0) {
            return HQCode.hValidCode(pSrcName, true) == 0;
        }
        return HQCode.hValidSpacePart(pSrcName, true) == 0;
    }

    @Override
    public int getRights() throws Exception {
        return WspSrcUtil.getRights(this);
    }

    @Override
    public boolean createAsFile() throws Exception {
        return false;
    }

    @Override
    public boolean removeSrc() throws Exception {
        ListFilterBase<ISrcNode> vListCh = new ListFilterBase<ISrcNode>(){

            @Override
            public boolean add(ISrcNode pSrcNode) {
                try {
                    pSrcNode.removeSrc();
                }
                catch (Exception e) {
                    throw new TunneledException(e);
                }
                return true;
            }
        };
        this.listChildrenNodes((List<ISrcNode>)vListCh);
        boolean vResult = this.getSubSrcNode().removeSrc();
        if (vResult) {
            this.fWsp.xDeleteAllPrivateData(this.getSrcUri());
        }
        return vResult;
    }

    public String toString() {
        return "<wspSrcNodeSpace uri='" + this.getSrcUri() + "'/>";
    }

    @Override
    public void copyFrom(ISrcNode pFrom) throws Exception {
        if (WspSrcUtil.isIISpaceUri(this.getSrcUri())) {
            return;
        }
        this.copySpaceFrom(pFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySpaceFrom(ISrcNode pFrom) throws Exception {
        if (WspSrcUtil.getWspNodeType(pFrom.getSrcUri()) != IWspSrc.WspNodeType.space || pFrom.getAspect(IWspSrc.WORKSPACE_ASPECT_TYPE) == null) {
            SrcFeatureCopyMove.defaultCopy(pFrom, this);
            return;
        }
        IHRenamingPlan vRenamingPlan = WspSrcUtil.getCurrentRenamingPlan();
        try {
            if (vRenamingPlan == null) {
                WspSrcUtil.setCurrentRenamingPlan(new HRenamingPlanSpace(pFrom, this));
            }
            SrcFeatureCopyMove.defaultCopy(pFrom, this);
        }
        finally {
            if (vRenamingPlan == null) {
                WspSrcUtil.setCurrentRenamingPlan(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveFrom(ISrcNode pFrom) throws Exception {
        if (WspSrcUtil.getWspNodeType(pFrom.getSrcUri()) != IWspSrc.WspNodeType.space || pFrom.getAspect(IWspSrc.WORKSPACE_ASPECT_TYPE) == null) {
            SrcFeatureCopyMove.defaultMove(pFrom, this);
            return;
        }
        IHRenamingPlan vRenamingPlan = WspSrcUtil.getCurrentRenamingPlan();
        try {
            if (vRenamingPlan == null) {
                WspSrcUtil.setCurrentRenamingPlan(new HRenamingPlanSpace(pFrom, this));
            }
            SrcFeatureCopyMove.defaultMove(pFrom, this);
        }
        finally {
            if (vRenamingPlan == null) {
                WspSrcUtil.setCurrentRenamingPlan(null);
            }
        }
    }
}

