/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeRes;
import com.scenari.m.bdp.item.fs.WspSrcNodeSpace;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.ThreadUser;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.rights.SrcFeatureRights;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;

public class WspSrcUtil {
    public static final String IISPACE_NAME_PREFIX = "~i~";
    public static final String EXTERNAL_URI_PREFIX = "/~ext";
    protected static InheritableThreadLocal<IHRenamingPlan> sCurrentRenamingPlan = new InheritableThreadLocal();

    public static IHRenamingPlan getCurrentRenamingPlan() {
        return (IHRenamingPlan)sCurrentRenamingPlan.get();
    }

    public static void setCurrentRenamingPlan(IHRenamingPlan pCurrentRenamingPlan) {
        sCurrentRenamingPlan.set(pCurrentRenamingPlan);
    }

    public static IWspSrc.WspNodeType getWspNodeType(String pUri) {
        if (pUri.length() == 0) {
            return IWspSrc.WspNodeType.wsp;
        }
        int vOffsetPoint = pUri.indexOf(46);
        if (vOffsetPoint < 0) {
            return IWspSrc.WspNodeType.space;
        }
        int vOffsetSubRes = pUri.indexOf(47, vOffsetPoint + 1);
        if (vOffsetSubRes < 0) {
            return IWspSrc.WspNodeType.item;
        }
        return IWspSrc.WspNodeType.resource;
    }

    public static String extractItemUri(String pUriResource) {
        int vOffsetPoint = pUriResource.indexOf(46);
        int vOffsetSlash = pUriResource.indexOf(47, vOffsetPoint + 1);
        return pUriResource.substring(0, vOffsetSlash);
    }

    public static String extractItemUriRes(String pUriResource) {
        int vOffsetPoint = pUriResource.indexOf(46);
        int vOffsetSlash = pUriResource.indexOf(47, vOffsetPoint + 1);
        return pUriResource.substring(vOffsetSlash);
    }

    public static ISrcNode findSrcNodeFromItemUriRes(ISrcNode pItemSrcNode, String pUriRes) throws Exception {
        if (pUriRes == null || pUriRes.length() == 0 || pUriRes.equals(".")) {
            return pItemSrcNode;
        }
        String vPath = pUriRes.charAt(0) == '/' ? pUriRes.substring(1) : pUriRes;
        return SrcFeaturePaths.findNodeByPath(pItemSrcNode, vPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISrcNode findWspNodeByUri(HWorkspaceFs pWsp, String pUri) throws Exception {
        try {
            HWorkspaceFs hWorkspaceFs = pWsp;
            synchronized (hWorkspaceFs) {
                switch (WspSrcUtil.getWspNodeType(pUri)) {
                    case wsp: {
                        return pWsp.findNodeByUri("");
                    }
                    case space: {
                        return new WspSrcNodeSpace(pWsp, pWsp.hGetFolderSource().findNodeByUri(pUri));
                    }
                    case item: {
                        return pWsp.xGetOrCreateItemCache(pUri, true).getSource();
                    }
                    case resource: {
                        XItemCache vItemCache = pWsp.xGetOrCreateItemCache(WspSrcUtil.extractItemUri(pUri), true);
                        if (vItemCache != null) {
                            return new WspSrcNodeRes(pWsp.hGetFolderSource().findNodeByUri(pUri), vItemCache.getDatas());
                        }
                        return ISrcNode.NULL;
                    }
                }
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Impossible d'acc\u00e9der \u00e0 l'uri '%s'.", pUri);
        }
        return ISrcNode.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISrcNode findWspNodeById(HWorkspaceFs pWsp, String pId) throws Exception {
        HWorkspaceFs hWorkspaceFs = pWsp;
        synchronized (hWorkspaceFs) {
            XItemCache vItemCache = pWsp.xGetItemCacheById(pId, true);
            if (vItemCache != null) {
                return vItemCache.getSource();
            }
            return SrcFeatureIds.findNodeById(pWsp.hGetFolderSource(), pId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findUriById(HWorkspaceFs pWsp, String pId) throws Exception {
        HWorkspaceFs hWorkspaceFs = pWsp;
        synchronized (hWorkspaceFs) {
            XItemCache vItemCache = pWsp.xGetItemCacheById(pId, true);
            if (vItemCache != null) {
                return vItemCache.getUri();
            }
            return SrcFeatureIds.findUriById(pWsp.hGetFolderSource(), pId);
        }
    }

    public static int getRights(IWspSrc pWspNode) throws Exception {
        IUser vUser = ThreadUser.getUser();
        IHWorkspace vWsp = pWspNode.getWorkspace();
        if (vWsp.hCheckRight(vUser, "Write")) {
            return SrcFeatureRights.getAllowedRights(pWspNode.getSubSrcNode());
        }
        if (vWsp.hCheckRight(vUser, "Read")) {
            return 3 & SrcFeatureRights.getAllowedRights(pWspNode.getSubSrcNode());
        }
        return 0;
    }

    public static boolean isIISpaceUri(String pSrcUri) {
        int vOffset = pSrcUri.lastIndexOf(IISPACE_NAME_PREFIX);
        if (vOffset <= 0) {
            return false;
        }
        return pSrcUri.charAt(vOffset - 1) == '/' && pSrcUri.indexOf(47, vOffset + 1) < 0 && pSrcUri.indexOf(46, vOffset + 1) < 0;
    }

    public static String getIISpaceUri(String pItemSrcUri) {
        int vOffsetPoint = pItemSrcUri.indexOf(46);
        if (vOffsetPoint == -1) {
            return pItemSrcUri;
        }
        int vOffsetEndName = pItemSrcUri.indexOf(47, vOffsetPoint + 1);
        if (vOffsetEndName < 0) {
            vOffsetEndName = pItemSrcUri.length();
        }
        int vOffsetStartName = pItemSrcUri.lastIndexOf(47, vOffsetPoint) + 1;
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        if (vOffsetStartName > 0) {
            vBuf.append(pItemSrcUri, 0, vOffsetStartName);
        }
        vBuf.append(IISPACE_NAME_PREFIX);
        for (int i = vOffsetStartName; i < vOffsetEndName; ++i) {
            char vC = pItemSrcUri.charAt(i);
            vBuf.append(vC == '.' ? (char)'~' : (char)vC);
        }
        if (vOffsetEndName < pItemSrcUri.length()) {
            vBuf.append(pItemSrcUri, vOffsetEndName, pItemSrcUri.length());
        }
        return PoolBuffers.getStringAndFreeStringBuilder(vBuf);
    }

    public static String getIISpaceName(String pItemName) {
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        vBuf.append(IISPACE_NAME_PREFIX);
        int l = pItemName.length();
        for (int i = 0; i < l; ++i) {
            char vC = pItemName.charAt(i);
            vBuf.append(vC == '.' ? (char)'~' : (char)vC);
        }
        return PoolBuffers.getStringAndFreeStringBuilder(vBuf);
    }

    public static boolean isExternalUri(String pSrcUri) {
        return pSrcUri.startsWith(EXTERNAL_URI_PREFIX);
    }
}

