/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.fs.WspHandler;
import com.scenari.m.bdp.item.fs.WspMigrator;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.wsp.repos.IWspHandler;
import eu.scenari.wsp.repos.wsptype.WspType;

public class WspTypeUpdater
implements IWspHandler.IWspTypeUpdater {
    protected WspHandler fWspHandler = null;
    protected WspType fOldWspType = null;
    protected WspType fNewWspType = null;
    protected boolean fMinorUpdate = false;

    public WspTypeUpdater(WspHandler pWspHandler, WspType pNewWspType) {
        this.fWspHandler = pWspHandler;
        this.fOldWspType = pWspHandler.getWspType();
        this.fNewWspType = pNewWspType;
        if (this.fNewWspType == null) {
            this.findAutoUpdateVersion();
        }
    }

    public WspType getNewWspType() {
        return this.fNewWspType;
    }

    public IWspHandler getWspHandler() {
        return this.fWspHandler;
    }

    public boolean isMigrationNeeeded() throws Exception {
        if (this.fNewWspType == null) {
            return false;
        }
        this.checkConcurrentUpdate();
        return new WspMigrator(this, !this.fMinorUpdate).isMigrationNeeded();
    }

    public ILogMsg getPreconditionsForMigration() throws Exception {
        if (this.fNewWspType == null) {
            return null;
        }
        this.checkConcurrentUpdate();
        return new WspMigrator(this, !this.fMinorUpdate).checkPreconditions();
    }

    public void migrateAndSwitchToNewWspType() throws Exception {
        if (this.fNewWspType != null) {
            this.checkConcurrentUpdate();
            new Thread(new WspMigrator(this, !this.fMinorUpdate)).start();
        }
    }

    public void switchToNewWspType() throws Exception {
        if (this.fNewWspType != null) {
            this.fWspHandler.xSaveWspType(this.fNewWspType);
        }
    }

    protected void findAutoUpdateVersion() {
        this.fNewWspType = null;
        this.fMinorUpdate = true;
    }

    public void checkConcurrentUpdate() throws Exception {
        if (this.fOldWspType != this.fWspHandler.getWspType()) {
            throw new Exception("Concurrent wspType modification.");
        }
    }
}

