/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspHistory;
import com.scenari.s.fw.utils.HIntArrayList;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.IWspWatcher;

public class WspWatcher
implements IWspWatcher {
    protected IRepository fRepos;
    protected String fCdWsp;
    protected WspHistory.StackMarker fStackMarker = null;

    public WspWatcher(IRepository pRepos, String pCdWsp) {
        this.fRepos = pRepos;
        this.fCdWsp = pCdWsp;
        try {
            HWorkspaceFs vWsp = (HWorkspaceFs)this.fRepos.getWsp(this.fCdWsp, false);
            if (vWsp != null) {
                this.fStackMarker = vWsp.fWspHistory.createStackMarker();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getWspCd() {
        return this.fCdWsp;
    }

    public boolean hasNewUpdts(int pIdClientToExclude) throws IWspWatcher.OutOfWatchException {
        WspHistory vHisto = this.xGetWspHisto();
        if (vHisto == null) {
            return false;
        }
        WspHistory.StackMarker vMarker = this.xGetStackMarker(vHisto);
        if (vMarker != null) {
            try {
                WspHistory.StackEntries vStack = vHisto.getStackEntries(vMarker);
                int vPublicIdxStack = vMarker.fPublicStackIdx;
                int vStartIndex = vMarker.fEntryIdx;
                while (vStack != null) {
                    int vLen = vHisto.countEntriesInStack(vStack);
                    for (int i = vStartIndex; i < vLen; ++i) {
                        if (vStack.fClientId[i] == pIdClientToExclude) continue;
                        return true;
                    }
                    vStack = vHisto.getStackEntries(++vPublicIdxStack);
                    vStartIndex = 0;
                }
            }
            catch (IWspWatcher.OutOfWatchException e) {
                this.fStackMarker = vHisto.createStackMarker();
                throw e;
            }
        }
        return false;
    }

    public IWspWatcher.IDistinctUpdtIterator getNewDistinctUpdtSet(int pIdClientToExclude, int pMaxEntries) throws IWspWatcher.OutOfWatchException {
        DistinctUpdtIt vIt = new DistinctUpdtIt();
        vIt.xInit(pIdClientToExclude, pMaxEntries);
        return vIt;
    }

    protected WspHistory xGetWspHisto() throws IWspWatcher.OutOfWatchException {
        HWorkspaceFs vWsp = null;
        try {
            vWsp = (HWorkspaceFs)this.fRepos.getWsp(this.fCdWsp, false);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        if (vWsp != null) {
            return vWsp.fWspHistory;
        }
        if (this.fStackMarker != null) {
            this.fStackMarker = null;
            throw IWspWatcher.OUTOFWATCH_WSPLOST;
        }
        return null;
    }

    protected WspHistory.StackMarker xGetStackMarker(WspHistory pHisto) throws IWspWatcher.OutOfWatchException {
        if (this.fStackMarker == null && pHisto != null) {
            this.fStackMarker = pHisto.createStackMarker();
        }
        assert (pHisto != null || this.fStackMarker == null);
        return this.fStackMarker;
    }

    public class DistinctUpdtIt
    implements IWspWatcher.IDistinctUpdtIterator {
        protected WspHistory fWspHisto;
        protected WspHistory.StackEntries fCurrentStack = null;
        protected int fIdClientToExclude;
        protected int fCurrentEntryIdx = 0;
        protected int fEntriesToTreat = 0;
        protected byte fLastUpdtType;
        protected String fLastUri;
        protected HIntArrayList fEntriesToExclude = null;
        protected int fNextEntryToExclude = -1;

        public byte getUpdtType() {
            return this.fLastUpdtType;
        }

        public String getUri() {
            return this.fLastUri;
        }

        /*
         * Unable to fully structure code
         */
        public boolean nextUpdt() {
            vShiftExclusions = false;
            block0: while (true) {
                if (vShiftExclusions) {
                    vShiftExclusions = false;
                    this.xShiftExclusions();
                }
                if (this.fEntriesToTreat == 0) {
                    return false;
                }
                if (!this.fWspHisto.isEntryFilled(this.fCurrentStack, this.fCurrentEntryIdx)) {
                    return false;
                }
                vEntriesToTreatTemp = this.fEntriesToTreat;
                vStackTemp = this.fCurrentStack;
                vEntryIdxTemp = this.fCurrentEntryIdx++;
                vUriTemp = this.fCurrentStack.fUri[vEntryIdxTemp];
                vClientIdTemp = this.fCurrentStack.fClientId[vEntryIdxTemp];
                this.fLastUpdtType = this.fCurrentStack.fUpdtType[vEntryIdxTemp];
                this.fLastUri = this.fCurrentStack.fUri[vEntryIdxTemp];
                if (this.fCurrentEntryIdx == WspHistory.sStackSize) {
                    this.fCurrentStack = this.fCurrentStack.fNextStack;
                    ++WspWatcher.this.fStackMarker.fPublicStackIdx;
                    this.fCurrentEntryIdx = 0;
                    vShiftExclusions = true;
                }
                WspWatcher.this.fStackMarker.fEntryIdx = this.fCurrentEntryIdx;
                --this.fEntriesToTreat;
                if (this.fNextEntryToExclude == vEntryIdxTemp) {
                    if (this.fEntriesToExclude != null && this.fEntriesToExclude.size() > 0) {
                        this.fNextEntryToExclude = this.fEntriesToExclude.removeInt(0);
                        continue;
                    }
                    this.fNextEntryToExclude = -1;
                    continue;
                }
                if (vClientIdTemp == this.fIdClientToExclude && this.fIdClientToExclude != -1) continue;
                vOffsetStackEntryIdx = 0;
                while (vEntriesToTreatTemp > 0 && this.fWspHisto.isEntryFilled(vStackTemp, vEntryIdxTemp)) {
                    if (++vEntryIdxTemp == WspHistory.sStackSize) {
                        vStackTemp = vStackTemp.fNextStack;
                        vEntryIdxTemp = 0;
                        vOffsetStackEntryIdx += WspHistory.sStackSize;
                    }
                    --vEntriesToTreatTemp;
                    if (!vUriTemp.equals(vStackTemp.fUri[vEntryIdxTemp])) continue;
                    if (vStackTemp.fClientId[vEntryIdxTemp] != this.fIdClientToExclude || this.fIdClientToExclude == -1) ** break;
                    continue block0;
                    vNewStatus = vStackTemp.fUpdtType[vEntryIdxTemp];
                    if (this.fLastUpdtType == 3) {
                        this.fLastUpdtType = vNewStatus;
                    } else if (vNewStatus != 3) {
                        this.fLastUpdtType = vNewStatus;
                    }
                    if (this.fNextEntryToExclude == -1) {
                        this.fNextEntryToExclude = vOffsetStackEntryIdx + vEntryIdxTemp;
                        continue;
                    }
                    if (this.fEntriesToExclude == null) {
                        this.fEntriesToExclude = new HIntArrayList();
                    }
                    this.fEntriesToExclude.insertDistinctInOrder(vOffsetStackEntryIdx + vEntryIdxTemp);
                }
                break;
            }
            if (vShiftExclusions) {
                this.xShiftExclusions();
            }
            return true;
        }

        protected void xShiftExclusions() {
            if (this.fNextEntryToExclude != -1) {
                this.fNextEntryToExclude -= WspHistory.sStackSize;
                if (this.fEntriesToExclude != null) {
                    for (int i = 0; i < this.fEntriesToExclude.size(); ++i) {
                        this.fEntriesToExclude.setInt(i, this.fEntriesToExclude.getInt(i) - WspHistory.sStackSize);
                    }
                }
            }
        }

        protected void xInit(int pIdClientToExclude, int pMaxEntries) throws IWspWatcher.OutOfWatchException {
            this.fWspHisto = WspWatcher.this.xGetWspHisto();
            WspHistory.StackMarker vMarker = WspWatcher.this.xGetStackMarker(this.fWspHisto);
            this.fCurrentStack = this.fWspHisto.getStackEntries(vMarker);
            this.fCurrentEntryIdx = vMarker.fEntryIdx;
            this.fEntriesToTreat = pMaxEntries;
            this.fIdClientToExclude = pIdClientToExclude;
        }
    }
}

