/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.item.fs;

import com.scenari.m.bdp.item.HItemDef;
import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HItemDefVersNet;
import com.scenari.m.bdp.item.HItemDefVersRes;
import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHAttr;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHProblem;
import com.scenari.m.bdp.item.ItemDataKeys;
import com.scenari.m.bdp.item.base.HItem;
import com.scenari.m.bdp.item.fs.HContentAccessFs;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.TransfCacheMgr;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.item.fs.XItemCacheData;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.itemtype.fs.HItemTypeFs;
import com.scenari.m.bdp.module.identif.HTreatIdentif;
import com.scenari.m.bdp.module.save.HStreamHandler;
import com.scenari.m.bdp.module.save.IHModuleSave;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.fields.IFieldsUpdaterAspect;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.feature.rights.SrcFeatureRights;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XItemCache {
    public static long sElapseBetweenRefresh = 1500L;
    public static short STATUS_INTERNAL_NOTLINKED = (short)21;
    public static short STATUS_INTERNAL_ERROR = (short)22;
    public static short STATUS_INTERNAL_REMOVED = (short)-22;
    private HWorkspaceFs fWsp;
    private SoftReference<XItemCacheData> fExtraDatas = null;
    protected CharSequence fStrings = null;
    protected XLink fFirstPointer = null;
    protected String fUri = IHItem.URI_NULL;
    protected String fId = null;
    protected IHItemType fItemType = null;
    protected short fStatusItem = (short)-99;
    protected long fMemLastModif = -1L;
    protected CharSequence fTitle = null;
    protected String fSignature = null;
    protected String[] fSubItems = null;
    protected Object[] fAttrs = null;
    protected XProblem fFirstContentProblem = null;

    protected static boolean deleteFiles(File pFile) {
        File[] vFiles = pFile.listFiles();
        if (vFiles != null) {
            for (int i = 0; i < vFiles.length; ++i) {
                XItemCache.deleteFiles(vFiles[i]);
            }
        }
        return pFile.delete();
    }

    public XItemCache(HWorkspaceFs pWsp, ISrcNode pItemSrc) throws Exception {
        this.fWsp = pWsp;
        this.initDatas(pItemSrc);
        this.fUri = pItemSrc.getSrcUri();
        if (WspSrcUtil.isExternalUri(this.fUri)) {
            this.fWsp.xGetOrCreateExternalItemsMgr().addExternalItem(this.fUri);
        }
    }

    public WspSrcNodeItem getSource() throws Exception {
        return this.getDatas().getWspSrcNodeItem();
    }

    public String getUri() {
        return this.fUri;
    }

    public String getId() {
        return this.fId;
    }

    public String getUriSs() {
        return this.fItemType == null ? IHItem.URI_NULL : this.fItemType.getUri();
    }

    public HWorkspaceFs getWsp() {
        return this.fWsp;
    }

    public IHItemType getItemType() throws Exception {
        assert (Thread.holdsLock(this.getWsp()));
        if (this.fStatusItem == -99) {
            this.xLoadItemFromSource(false);
        }
        return this.fItemType;
    }

    public XLink getFirstPointer() {
        return this.fFirstPointer;
    }

    public HItemDef hCreateItemDefFromCache() throws Exception {
        HItemDef vItemDef = new HItemDef(this.getWsp(), this.fUri);
        vItemDef.fTitle = this.hGetTitle();
        vItemDef.fStatus = this.getPublicStatus();
        vItemDef.fSignature = this.hGetSignature();
        vItemDef.fUriSs = this.getUriSs();
        vItemDef.fSrcNode = this.getSource();
        return vItemDef;
    }

    public HItemDefVers hCreateItemDefVersFromCache() throws Exception {
        HItemDefVers vItemDef = new HItemDefVers(this.getWsp(), this.fUri);
        vItemDef.fTitle = this.hGetTitle();
        vItemDef.fStatus = this.getPublicStatus();
        vItemDef.fSignature = this.hGetSignature();
        vItemDef.fUriSs = this.getUriSs();
        WspSrcNodeItem vSrcNode = this.getSource();
        vItemDef.fModifDt = vSrcNode != null ? new Date(vSrcNode.getLastModifWithChildren()) : null;
        vItemDef.fSrcNode = vSrcNode;
        return vItemDef;
    }

    public HItemDefVersNet hCreateItemDefVersNetFromCache(HItemDefVersNet.WNetContext pNetContext) throws Exception {
        HItemDefVersNet vItemDef = new HItemDefVersNet(pNetContext, this.fUri);
        vItemDef.fStatus = this.getPublicStatus();
        vItemDef.fTitle = this.hGetTitle();
        vItemDef.fSignature = this.hGetSignature();
        vItemDef.fUriSs = this.getUriSs();
        WspSrcNodeItem vSrcNode = this.getSource();
        vItemDef.fModifDt = vSrcNode != null ? new Date(vSrcNode.getLastModif()) : null;
        vItemDef.fSrcNode = vSrcNode;
        return vItemDef;
    }

    public HItemDefVersRes hCreateItemDefVersResFromCache() throws Exception {
        HItemDefVersRes vItemDef = new HItemDefVersRes(this.getWsp(), this.fUri);
        vItemDef.fTitle = this.hGetTitle();
        vItemDef.fStatus = this.getPublicStatus();
        vItemDef.fSignature = this.hGetSignature();
        vItemDef.fUriSs = this.getUriSs();
        WspSrcNodeItem vSrcNode = this.getSource();
        if (vSrcNode != null) {
            vItemDef.fModifDt = new Date(vSrcNode.getLastModif());
            vItemDef.fIsFolder = vSrcNode.getContentStatus() == 2;
            vItemDef.fLength = !vItemDef.fIsFolder ? vSrcNode.getContentSize() : 0;
        }
        vItemDef.fSrcNode = vSrcNode;
        return vItemDef;
    }

    public IHItem hCreateItemFromCache() throws Exception {
        int i;
        HItem vItem = new HItem(this.getWsp(), this.getUri());
        vItem.fTitle = this.hGetTitle();
        vItem.fStatus = this.getPublicStatus();
        vItem.fSignature = this.hGetSignature();
        WspSrcNodeItem vSrcNode = this.getSource();
        vItem.fSrcNode = vSrcNode;
        vItem.fModifDt = vSrcNode != null ? new Date(vSrcNode.getLastModif()) : null;
        vItem.hSetItemType(this.fItemType);
        if (this.fSubItems != null) {
            for (i = 0; i < this.fSubItems.length; i += 2) {
                vItem.hAddSubItem(this.fSubItems[i], this.fSubItems[i + 1]);
            }
        }
        if (this.fAttrs != null) {
            i = 0;
            while (i < this.fAttrs.length) {
                IHAttr vAttr;
                if ((vAttr = vItem.hAddAttr((String)this.fAttrs[i++], this.xGetFieldAttr(i++), this.xGetFieldAttr(i++))).hGetTypeAttr() == "Link" || vAttr.hGetTypeAttr() == "Ref") {
                    XLink vLink = (XLink)this.fAttrs[i++];
                    vAttr.setRefUri(vLink.getRefUriPtd());
                    vAttr.hSetParamsRel(vLink.hGetParamsRel());
                    XProblem vPb = vLink.fFirstProblem;
                    while (vPb != null) {
                        if (vPb.fType == XProblem.ERROR) {
                            vAttr.hAddError(vPb.hGetCode(), vPb.hGetMessage(), vPb.hGetContent());
                        } else {
                            vAttr.hAddWarning(vPb.hGetCode(), vPb.hGetMessage(), vPb.hGetContent());
                        }
                        vPb = vPb.fNext;
                    }
                    continue;
                }
                vAttr.hSetStringValue(this.xGetFieldAttr(i++));
            }
        }
        XProblem vCPb = this.fFirstContentProblem;
        while (vCPb != null) {
            if (vCPb.fType == XProblem.ERROR) {
                vItem.hAddContentError(vCPb.hGetCode(), vCPb.hGetMessage(), vCPb.hGetContent());
            } else {
                vItem.hAddContentWarning(vCPb.hGetCode(), vCPb.hGetMessage(), vCPb.hGetContent());
            }
            vCPb = vCPb.fNext;
        }
        return vItem;
    }

    public Object[] hGetAttrs() throws Exception {
        if (this.fStatusItem == -99) {
            this.xLoadItemFromSource(false);
        }
        if (this.fStatusItem == STATUS_INTERNAL_NOTLINKED) {
            this.xLinkChilds();
        }
        if (this.fStatusItem == STATUS_INTERNAL_ERROR) {
            this.xLoadItemFromSource(true);
            if (this.fStatusItem == STATUS_INTERNAL_NOTLINKED) {
                this.xLinkChilds();
            }
            if (this.fStatusItem == STATUS_INTERNAL_ERROR) {
                throw LogMgr.newException("Erreur au chargement de l'item " + this, new String[0]);
            }
        }
        return this.fAttrs;
    }

    public String hGetCode() {
        return HQCode.hGetCodeFromUri(this.fUri);
    }

    public String hGetSignature() {
        return this.fSignature;
    }

    public String hGetSpace() {
        return HQCode.hGetSpaceFromUri(this.fUri);
    }

    public short getInternalStatus() throws Exception {
        assert (Thread.holdsLock(this.getWsp()));
        if (this.fStatusItem == -99) {
            this.xLoadItemFromSource(false);
        }
        if (this.fStatusItem == STATUS_INTERNAL_NOTLINKED) {
            this.xLinkChilds();
        }
        if (this.fStatusItem == STATUS_INTERNAL_ERROR) {
            this.xLoadItemFromSource(true);
            this.xLinkChilds();
            if (this.fStatusItem == STATUS_INTERNAL_ERROR) {
                throw LogMgr.newException("Erreur au chargement de l'item " + this, new String[0]);
            }
        }
        return this.fStatusItem;
    }

    public short getPublicStatus() throws Exception {
        short vStatus = this.getInternalStatus();
        return vStatus == STATUS_INTERNAL_REMOVED ? (short)-1 : (short)this.fStatusItem;
    }

    public void hLinkIfNeeded() throws Exception {
        if (this.fStatusItem == STATUS_INTERNAL_NOTLINKED) {
            this.xLinkChilds();
        }
    }

    public String hGetTitle() {
        if (this.fTitle == null) {
            return null;
        }
        this.fTitle = ((Object)this.fTitle).toString();
        return (String)this.fTitle;
    }

    public boolean hIsNull() throws Exception {
        if (this.fStatusItem == -99) {
            this.xLoadItemFromSource(false);
        }
        return this.fStatusItem <= -1;
    }

    public void refresh(boolean pCheckElapseBetweenRefresh) throws Exception {
        XItemCacheData vDatas = this.getDatas();
        if (pCheckElapseBetweenRefresh && vDatas.fLastRefresh > 0L && vDatas.fLastRefresh >= System.currentTimeMillis() - sElapseBetweenRefresh) {
            return;
        }
        ISrcNode vSrc = vDatas.getWspSrcNodeItem().getSubSrcNode();
        if (this.fStatusItem == -99) {
            this.setId(vSrc);
            this.xLoadItemFromSource(false, vSrc, vSrc.getLastModifWithChildren(), -1);
        } else {
            SrcFeatureRefresh.refresh(vSrc);
            long vLastUpdt = vSrc.getLastModifWithChildren();
            if (vLastUpdt != this.fMemLastModif) {
                this.setId(vSrc);
                this.xLoadItemFromSource(true, vSrc, vLastUpdt, -1);
            }
        }
        vDatas.fLastRefresh = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAfterUpdate(int pClientId) throws Exception {
        XItemCacheData vDatas = this.getDatas();
        ISrcNode vSrc = vDatas.getWspSrcNodeItem().getSubSrcNode();
        SrcFeatureRefresh.refresh(vSrc);
        long vLastUpdt = vSrc.getLastModifWithChildren();
        HWorkspaceFs hWorkspaceFs = this.getWsp();
        synchronized (hWorkspaceFs) {
            this.xLoadItemFromSource(true, vSrc, vLastUpdt, pClientId);
            vDatas.fLastRefresh = System.currentTimeMillis();
        }
    }

    public void hRemove(boolean pFireEventUpdated, int pClientId) throws Exception {
        if (this.fStatusItem <= -1 && this.fFirstPointer != null) {
            return;
        }
        if (pFireEventUpdated) {
            this.getWsp().xFireEventItemRemoved(this, null, pClientId);
        }
        this.xUnlinkChilds();
        if (this.fFirstPointer != null) {
            try {
                this.fStrings = "";
                this.fStatusItem = (short)-1;
                this.fItemType = null;
                this.fAttrs = null;
                this.fTitle = null;
                this.fFirstContentProblem = null;
                this.fMemLastModif = 0L;
            }
            catch (Exception e) {
                this.fStatusItem = STATUS_INTERNAL_ERROR;
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la suppression d'un item dans le cache.", new String[0]);
            }
            this.xValidPointers(true);
        } else {
            this.getWsp().xRemoveItemFromCache(this);
            this.fStatusItem = STATUS_INTERNAL_REMOVED;
        }
        this.xDeleteCaches();
        this.getWsp().xDeleteAllPrivateData(this.fUri);
    }

    public void hSaveInCache(IHItem pItem, boolean pFireEventUpdated, int pClientId) throws Exception {
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        try {
            int vCountAttr;
            this.xUnlinkChilds();
            this.fStrings = vBuf;
            this.fFirstContentProblem = null;
            this.fTitle = this.xGetCharSeq(vBuf, pItem.hGetTitle());
            this.fSignature = pItem.hGetSignature();
            this.fItemType = pItem.hGetItemType();
            int vCountSubItems = pItem.hCountSubItems();
            if (vCountSubItems > 0) {
                Iterator vItSubItems = pItem.hGetSubItems();
                this.fSubItems = new String[vCountSubItems *= 2];
                for (int i = 0; i < vCountSubItems; i += 2) {
                    this.fSubItems[i] = (String)vItSubItems.next();
                    this.fSubItems[i + 1] = (String)vItSubItems.next();
                }
            }
            if ((vCountAttr = pItem.hCountAttrs()) > 0) {
                if (this.fAttrs == null || this.fAttrs.length != (vCountAttr *= 4)) {
                    this.fAttrs = new Object[vCountAttr];
                }
                Iterator vIt = pItem.hGetAttrs();
                int vOffs = 0;
                while (vIt.hasNext()) {
                    IHAttr vAttr = (IHAttr)vIt.next();
                    String vType = vAttr.hGetTypeAttr();
                    this.fAttrs[vOffs++] = vType;
                    this.fAttrs[vOffs++] = vAttr.hGetSpace() == "" ? "" : vAttr.hGetSpace().intern();
                    this.fAttrs[vOffs++] = vAttr.hGetName().intern();
                    if (vType == "Ref" || vType == "Link") {
                        XLink vLink = vType == "Link" ? new XLink(this) : new XRef(this);
                        vLink.fRefUriPtd = vAttr.getRefUri();
                        vLink.fParam = this.xGetCharSeq(vBuf, vAttr.hGetParamsRel());
                        Iterator vItPb = vAttr.hGetProblems();
                        while (vItPb.hasNext()) {
                            IHProblem vPb = (IHProblem)vItPb.next();
                            XProblem vNewPb = new XProblem();
                            vNewPb.fType = vPb.hGetType() == "Error" ? XProblem.ERROR : XProblem.WARNING;
                            vNewPb.fCode = vPb.hGetCode();
                            vNewPb.fMessage = vPb.hGetMessage();
                            vNewPb.fContent = vPb.hGetContent();
                            vNewPb.fNext = vLink.fFirstProblem;
                            vLink.fFirstProblem = vNewPb;
                        }
                        this.fAttrs[vOffs++] = vLink;
                        continue;
                    }
                    this.fAttrs[vOffs++] = new XString(vBuf, vAttr.hGetStringValue());
                }
            } else {
                this.fAttrs = null;
            }
            Iterator vItCPbs = pItem.hGetContentProblems();
            while (vItCPbs.hasNext()) {
                IHProblem vPb = (IHProblem)vItCPbs.next();
                XProblem vNewPb = new XProblem();
                vNewPb.fType = vPb.hGetType() == "Error" ? XProblem.ERROR : XProblem.WARNING;
                vNewPb.fCode = this.xGetCharSeq(vBuf, vPb.hGetCode());
                vNewPb.fMessage = this.xGetCharSeq(vBuf, vPb.hGetMessage());
                vNewPb.fContent = this.xGetCharSeq(vBuf, vPb.hGetContent());
                vNewPb.fNext = this.fFirstContentProblem;
                this.fFirstContentProblem = vNewPb;
            }
            this.fStrings = vBuf.substring(0);
            this.fStatusItem = STATUS_INTERNAL_NOTLINKED;
            if (this.getWsp().fStatusItemLoaded == HWorkspaceFs.STATUS_ALL_ITEM_LOADED_OK) {
                this.xLinkChilds();
            }
            if (pFireEventUpdated) {
                this.getWsp().xFireEventItemUpdated(pItem, null, pClientId);
                this.xDeleteCaches();
            }
            this.xValidPointers(pFireEventUpdated);
            this.getWsp().xUpdateItemType(this, pItem.hGetItemType());
        }
        catch (Exception e) {
            this.fStrings = null;
            this.fTitle = null;
            this.fAttrs = null;
            this.fStatusItem = STATUS_INTERNAL_ERROR;
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec au stockage d'un item dans le cache. (" + pItem.toString() + ")", new String[0]);
        }
        finally {
            PoolBuffers.freeStringBuilder(vBuf);
        }
    }

    public void hCommit(IHItem pItem) throws Exception {
        XItemCacheData vItemData = this.getDatas();
        vItemData.fLastRefresh = System.currentTimeMillis();
        WspSrcNodeItem vWspSrcNode = vItemData.getWspSrcNodeItem();
        ISrcNode vSubSrcNode = vWspSrcNode.getSubSrcNode();
        this.fMemLastModif = vSubSrcNode.getLastModifWithChildren();
        IFieldsUpdaterAspect vFieldsUpdater = vSubSrcNode.getAspect(IFieldsUpdaterAspect.TYPE);
        if (vFieldsUpdater != null) {
            try {
                ((HItem)pItem).fSrcNode = vWspSrcNode;
                vFieldsUpdater.updateField(ItemDataKeys.DATAKEY_ITEMOBJECT, pItem);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Save item datas failed for : " + pItem.getUri(), new String[0]);
            }
        }
    }

    public void hRollback(IHItem pItem) throws Exception {
        this.fMemLastModif = -1L;
    }

    public void setId(ISrcNode pSrcNode) throws Exception {
        assert (Thread.holdsLock(this.getWsp()));
        this.setId(SrcFeatureIds.getOrCreateSrcId(pSrcNode));
    }

    public void setId(String pNewId) throws Exception {
        if (this.fId == null && pNewId == null) {
            return;
        }
        if (this.fId == null && pNewId != null) {
            this.getWsp().fItemsById.put(pNewId, this);
        } else if (pNewId == null) {
            this.getWsp().fItemsById.remove(this.fId);
        } else {
            if (pNewId.equals(this.fId)) {
                return;
            }
            Map<String, XItemCache> vMap = this.getWsp().fItemsById;
            vMap.remove(this.fId);
            vMap.put(pNewId, this);
        }
        this.fId = pNewId;
    }

    public XItemCacheData getDatas() throws Exception {
        XItemCacheData vDatas = this.fExtraDatas.get();
        if (vDatas == null) {
            vDatas = this.initDatas(this.getWsp().fSubSrcNode.findNodeByUri(this.fUri));
        }
        return vDatas;
    }

    public XItemCacheData getDatasIfExist() {
        return this.fExtraDatas.get();
    }

    protected XItemCacheData initDatas(ISrcNode pSource) {
        XItemCacheData vDatas = new XItemCacheData(this, pSource);
        this.fExtraDatas = new SoftReference<XItemCacheData>(vDatas);
        return vDatas;
    }

    public String toString() {
        return "<itemCache uri=\"" + this.getUri() + "\"/>";
    }

    public TransfCacheMgr xGetCacheMgr() throws Exception {
        return this.getDatas().getTransfCacheMgr();
    }

    protected XString xGetCharSeq(StringBuilder pBuf, String pValToAdd) {
        if (pValToAdd != null) {
            return new XString(pBuf, pValToAdd);
        }
        return null;
    }

    protected String xGetFieldAttr(int pIdx) {
        this.fAttrs[pIdx] = this.fAttrs[pIdx].toString();
        return (String)this.fAttrs[pIdx];
    }

    public int xGetIndexAttrPointer(XLink pPointer) {
        for (int vIdx = 3; vIdx < this.fAttrs.length; vIdx += 4) {
            if (this.fAttrs[vIdx] != pPointer) continue;
            return vIdx;
        }
        return -1;
    }

    public void xLinkChilds() throws Exception {
        assert (Thread.holdsLock(this.getWsp()));
        if (this.fAttrs != null) {
            for (int i = 0; i < this.fAttrs.length; i += 4) {
                if (this.fAttrs[i] != "Ref" && this.fAttrs[i] != "Link") continue;
                XLink vLink = (XLink)this.fAttrs[i + 3];
                String vRefUri = vLink.getRefUriPtd();
                XItemCache vItemPtd = SrcFeatureIds.isSrcId(vRefUri) ? this.getWsp().xGetItemCacheById(vRefUri, false) : this.getWsp().xGetOrCreateItemCache(vRefUri, false);
                vLink.setPtd(vItemPtd);
                if (vItemPtd != null) {
                    if (vItemPtd != this) {
                        vLink.fNextPointer = vItemPtd.fFirstPointer;
                        vItemPtd.fFirstPointer = vLink;
                    }
                    if (this.getWsp().hGetStatusItemLoaded() != HWorkspaceFs.STATUS_ALL_ITEM_LOADED_NO && this.isExternalItem()) {
                        vItemPtd.hLinkIfNeeded();
                    }
                }
                this.xValidAttr(this.xGetFieldAttr(i + 1), this.xGetFieldAttr(i + 2), vLink, vItemPtd);
            }
        }
        this.xComputeItemStatus();
    }

    protected void xRelinkOnMovedId(XItemCache pNewItem) {
        XLink vPointer = this.fFirstPointer;
        Object vPreviousPointer = null;
        while (vPointer != null) {
            XLink vNextPointer = vPointer.fNextPointer;
            if (vPointer.isRefById()) {
                if (vPreviousPointer != null) {
                    vPreviousPointer.fNextPointer = vNextPointer;
                } else {
                    this.fFirstPointer = vNextPointer;
                }
                vPointer.setPtd(pNewItem);
                if (pNewItem != null) {
                    XLink vOtherPointer = pNewItem.fFirstPointer;
                    pNewItem.fFirstPointer = vPointer;
                    vPointer.fNextPointer = vOtherPointer;
                } else {
                    vPointer.fNextPointer = null;
                }
            }
            vPointer = vNextPointer;
        }
    }

    protected void xLoadItemFromSource(boolean pFireEventUpdated) throws Exception {
        XItemCacheData vDatas = this.getDatas();
        ISrcNode vSrc = vDatas.getWspSrcNodeItem().getSubSrcNode();
        if (vSrc == null) {
            return;
        }
        long vLastModif = vSrc.getLastModifWithChildren();
        this.xLoadItemFromSource(pFireEventUpdated, vSrc, vLastModif, -1);
        vDatas.fLastRefresh = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xLoadItemFromSource(boolean pFireEventUpdated, ISrcNode pSrc, long pLastModif, int pClientId) throws Exception {
        assert (Thread.holdsLock(this.getWsp()));
        boolean vFireEventUpdated = pFireEventUpdated || this.getWsp().fFireDiscoveredItems;
        int vStatus = pSrc.getContentStatus();
        if (vStatus <= -1) {
            this.hRemove(vFireEventUpdated, pClientId);
            if (vStatus == -2) {
                this.fStatusItem = (short)-2;
            }
        } else {
            block16: {
                InputStream vInputStream = vStatus == 1 ? pSrc.newInputStream(false) : null;
                HStreamHandler vStream = vInputStream != null ? new HStreamHandler(vInputStream) : null;
                try {
                    HItemDef vCurrent = new HItemDef(this.getWsp(), this.fUri);
                    IHItemType vItemType = HTreatIdentif.findItemType(this.getWsp(), vCurrent.getUri(), null, vStream);
                    if (vItemType != null) {
                        if (vStatus == 1 && vItemType.hGetContentStatus() == 2 && SrcFeatureRights.isAllowed(pSrc, 72)) {
                            try {
                                vStream.hCloseAndPurgeCache();
                                vStream = null;
                                HContentAccessFs.transformFileToFolder(pSrc, pSrc.getSrcName());
                            }
                            catch (Exception e) {
                                LogMgr.publishException((Throwable)e, "File to folder transformation failed: %s", pSrc.getSrcUri());
                            }
                        }
                        IHModuleSave vModuleSave = vItemType.hGetModuleSave();
                        IHItem vNewItem = vModuleSave.hFillItem(vCurrent, null, vStream, null);
                        this.hSaveInCache(vNewItem, vFireEventUpdated, pClientId);
                        break block16;
                    }
                    this.fStatusItem = (short)3;
                    if (vFireEventUpdated) {
                        this.getWsp().xFireEventItemStatus(this);
                    }
                    this.xValidPointers(vFireEventUpdated);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec au traitement d'un item : " + this.getUri(), ILogMsg.LogType.Warning, new String[0]);
                    this.fStatusItem = (short)3;
                    if (vFireEventUpdated) {
                        this.getWsp().xFireEventItemStatus(this);
                    }
                    this.xValidPointers(vFireEventUpdated);
                }
                finally {
                    if (vStream != null) {
                        vStream.hCloseAndPurgeCache();
                    }
                }
            }
            this.fMemLastModif = pLastModif;
        }
    }

    protected void xComputeItemStatus() {
        boolean fHasWarning = this.fFirstContentProblem != null;
        XProblem vCPb = this.fFirstContentProblem;
        while (vCPb != null) {
            if (vCPb.fType == XProblem.ERROR) {
                this.fStatusItem = (short)3;
                return;
            }
            vCPb = vCPb.fNext;
        }
        if (this.fAttrs != null) {
            for (int i = 0; i < this.fAttrs.length; i += 4) {
                if (this.fAttrs[i] != "Ref" && this.fAttrs[i] != "Link") continue;
                XLink vLink = (XLink)this.fAttrs[i + 3];
                XProblem vPb = vLink.fFirstProblem;
                boolean bl = fHasWarning = fHasWarning || vPb != null;
                while (vPb != null) {
                    if (vPb.fType == XProblem.ERROR) {
                        this.fStatusItem = (short)3;
                        return;
                    }
                    vPb = vPb.fNext;
                }
            }
        }
        this.fStatusItem = (short)(fHasWarning ? 2 : 1);
    }

    protected void xDeleteCaches() {
        XItemCacheData vDatas = this.getDatasIfExist();
        if (vDatas != null) {
            vDatas.deleteCaches();
        } else {
            XItemCache.deleteFiles(new File(this.getWsp().fTransfCache, this.fUri));
        }
    }

    public void xUnlinkChilds() throws Exception {
        if (this.fAttrs == null || this.fStatusItem == STATUS_INTERNAL_NOTLINKED) {
            return;
        }
        block0: for (int i = 0; i < this.fAttrs.length; i += 4) {
            if (this.fAttrs[i] != "Ref" && this.fAttrs[i] != "Link") continue;
            XLink vLink = (XLink)this.fAttrs[i + 3];
            XItemCache vPtd = vLink.fPtd;
            if (vPtd == null) continue;
            XLink vPrec = null;
            XLink vCurr = vPtd.fFirstPointer;
            while (vCurr != null) {
                if (vCurr == vLink) {
                    if (vPrec != null) {
                        vPrec.fNextPointer = vCurr.fNextPointer;
                        continue block0;
                    }
                    vPtd.fFirstPointer = vCurr.fNextPointer;
                    continue block0;
                }
                vPrec = vCurr;
                vCurr = vCurr.fNextPointer;
            }
        }
    }

    public void xValidAttr(String pNameNs, String pName, XLink pLink, XItemCache pPtdItem) throws Exception {
        pLink.fFirstProblem = null;
        ((HItemTypeFs)this.fItemType).wValidLinks(pNameNs, pName, pLink, pPtdItem);
    }

    public void xValidPointers(boolean pFireEventUpdated) throws Exception {
        XLink vPointer = this.fFirstPointer;
        if (vPointer != null) {
            while (vPointer != null) {
                short vOldStatus = vPointer.fItem.fStatusItem;
                int vIdx = vPointer.fItem.xGetIndexAttrPointer(vPointer);
                vPointer.fItem.xValidAttr(vPointer.fItem.xGetFieldAttr(vIdx - 2), vPointer.fItem.xGetFieldAttr(vIdx - 1), vPointer, this);
                if (vPointer.fItem.fStatusItem != STATUS_INTERNAL_NOTLINKED) {
                    vPointer.fItem.xComputeItemStatus();
                    if (pFireEventUpdated && vOldStatus != vPointer.fItem.fStatusItem) {
                        this.getWsp().xFireEventItemStatus(vPointer.fItem);
                    }
                }
                vPointer = vPointer.fNextPointer;
            }
        }
    }

    public boolean isGarbageCollectableItem() {
        return WspSrcUtil.isExternalUri(this.fUri);
    }

    public boolean isExternalItem() {
        return WspSrcUtil.isExternalUri(this.fUri);
    }

    public class XString
    implements CharSequence {
        int fStart;
        int fLength;

        public XString(int pStart, int pLength) {
            this.fStart = pStart;
            this.fLength = pLength;
        }

        public XString(StringBuilder pBuf, String pValToAdd) {
            this.fStart = pBuf.length();
            this.fLength = pValToAdd.length();
            pBuf.append(pValToAdd);
        }

        public char charAt(int pIdx) {
            return XItemCache.this.fStrings.charAt(this.fStart + pIdx);
        }

        public int length() {
            return this.fLength;
        }

        public CharSequence subSequence(int pStart, int pEnd) {
            return XItemCache.this.fStrings.subSequence(pStart + this.fStart, pEnd + this.fStart);
        }

        public String toString() {
            return ((Object)XItemCache.this.fStrings.subSequence(this.fStart, this.fStart + this.fLength)).toString();
        }
    }

    public static class XRef
    extends XLink {
        public XRef(XItemCache pItem) {
            super(pItem);
        }
    }

    public static class XProblemSaxHandler
    extends DefaultHandler {
        protected XLink fLink = null;
        protected XProblem fCurrentPb = null;

        public XProblemSaxHandler(XLink pLink) {
            this.fLink = pLink;
        }

        public void characters(char[] pChar, int pStart, int pLength) throws SAXException {
            if (this.fCurrentPb != null) {
                this.fCurrentPb.fMessage = this.fCurrentPb.fMessage != null ? new StringBuilder(this.fCurrentPb.fMessage.length() + pLength).append((String)this.fCurrentPb.fMessage).append(pChar, pStart, pLength).toString() : new String(pChar, pStart, pLength);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.fCurrentPb = null;
        }

        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
            if (pLocalName.equals("pb")) {
                this.fCurrentPb = new XProblem();
                this.fCurrentPb.fType = "Warning".equals(pAttributes.getValue("typ")) ? XProblem.WARNING : XProblem.ERROR;
                this.fCurrentPb.fCode = pAttributes.getValue("cd");
                this.fCurrentPb.fMessage = pAttributes.getValue("msg");
                if (this.fLink.fFirstProblem == null) {
                    this.fLink.fFirstProblem = this.fCurrentPb;
                } else {
                    XProblem vLastPb = this.fLink.fFirstProblem;
                    while (vLastPb.fNext != null) {
                        vLastPb = vLastPb.fNext;
                    }
                    vLastPb.fNext = this.fCurrentPb;
                }
            }
        }
    }

    public static class XProblem {
        public static byte ERROR = 1;
        public static byte WARNING = (byte)2;
        public byte fType = 0;
        public CharSequence fCode = null;
        public CharSequence fMessage = null;
        public CharSequence fContent = null;
        public XProblem fNext = null;

        public String hGetCode() {
            if (this.fCode != null) {
                this.fCode = ((Object)this.fCode).toString();
            }
            return (String)this.fCode;
        }

        public String hGetContent() {
            if (this.fContent != null) {
                this.fContent = ((Object)this.fContent).toString();
            }
            return (String)this.fContent;
        }

        public String hGetMessage() {
            if (this.fMessage != null) {
                this.fMessage = ((Object)this.fMessage).toString();
            }
            return (String)this.fMessage;
        }

        public String hGetType() {
            if (this.fType == ERROR) {
                return "Error";
            }
            return "Warning";
        }
    }

    public static class XLink {
        public XItemCache fItem;
        public CharSequence fParam = null;
        public XProblem fFirstProblem = null;
        public String fRefUriPtd = null;
        public XItemCache fPtd = null;
        public XLink fNextPointer = null;

        public XLink(XItemCache pItem) {
            this.fItem = pItem;
        }

        public void addProblem(String pType, String pCode, String pMessage, String pContent) {
            XProblem vPb = new XProblem();
            vPb.fType = "Warning".equals(pType) ? XProblem.WARNING : XProblem.ERROR;
            vPb.fCode = pCode;
            vPb.fMessage = pMessage;
            vPb.fContent = pContent;
            if (this.fFirstProblem == null) {
                this.fFirstProblem = vPb;
            } else {
                XProblem vLastPb = this.fFirstProblem;
                while (vLastPb.fNext != null) {
                    vLastPb = vLastPb.fNext;
                }
                vLastPb.fNext = vPb;
            }
        }

        public String getRefUriPtd() {
            return this.fRefUriPtd;
        }

        public boolean isRefById() {
            return SrcFeatureIds.isSrcId(this.fRefUriPtd);
        }

        public String hGetParamsRel() {
            if (this.fParam != null) {
                this.fParam = ((Object)this.fParam).toString();
            }
            return (String)this.fParam;
        }

        public void setPtd(XItemCache pItemPtd) {
            this.fPtd = pItemPtd;
            if (pItemPtd != null) {
                if (this.fRefUriPtd.equals(pItemPtd.getUri())) {
                    this.fRefUriPtd = pItemPtd.getUri();
                } else if (this.fRefUriPtd.equals(pItemPtd.getId())) {
                    this.fRefUriPtd = pItemPtd.getId();
                }
            }
        }
    }
}

