/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.itemtype;

import com.scenari.m.bdp.item.HItemUpdatesEvent;
import com.scenari.m.bdp.item.IHAttr;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemUpdatesListener;
import com.scenari.m.bdp.item.IHProblem;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.base.HProblem;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.itemtype.XItemTypeSaxHandler;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.ISgnModule;
import com.scenari.m.bdp.module.identif.IHModuleIdentif;
import com.scenari.m.bdp.module.pres.IHModulePres;
import com.scenari.m.bdp.module.rename.IHModuleRename;
import com.scenari.m.bdp.module.save.HModuleSave;
import com.scenari.m.bdp.module.save.IHModuleSave;
import com.scenari.m.bdp.transaction.IHTransaction;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.collections.CollectionUtil;
import eu.scenari.wsp.repos.IRepository;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HItemType
implements IHItemType,
IHItemUpdatesListener {
    public static boolean sCompilInSynch = false;
    protected static ArrayList sPoolSaxParsers = new ArrayList();
    protected IHWorkspace fWsp = null;
    protected IHItem fItem = null;
    protected int fContentStatus = 1;
    protected String fCdModuleSave = null;
    protected String fCdModuleIdentif = null;
    protected String fCdModulePres = null;
    protected String fCdModuleRename = null;
    protected List fModules = null;
    protected boolean fModulesCheckComplete = false;
    protected IHModuleSave fModuleSave = null;
    protected IHModuleIdentif fModuleIdentif = null;
    protected IHModulePres fModulePres = null;
    protected IHModuleRename fModuleRename = null;
    protected List<String> fParents = null;
    protected String fItemTypeSignature = null;
    protected List fCompilProblems = null;
    protected List<String> fItemUsed = new ArrayList<String>();

    public HItemType(IHWorkspace pWsp, IHItem pItem) {
        this.fItem = pItem;
        this.fWsp = pWsp;
        if (sCompilInSynch) {
            this.xLoadItemType();
        }
    }

    @Override
    public final boolean hIsDerivedFrom(String pUri) throws Exception {
        if (pUri == null) {
            return false;
        }
        return this.xGetParents().contains(pUri);
    }

    protected final synchronized List<String> xGetParents() throws Exception {
        if (this.fParents == null) {
            this.fParents = new ArrayList<String>(3);
            this.fParents.add(this.fItem.getUri());
            Iterator vIt = this.fItem.hGetAttrs();
            while (vIt.hasNext()) {
                IHAttr vAttr = (IHAttr)vIt.next();
                if (vAttr.hGetTypeAttr() != "Ref" || !vAttr.hGetName().equals("ssParent")) continue;
                HItemType vItTyp = (HItemType)this.fWsp.hGetItemType(vAttr.getRefUri());
                if (vItTyp != null) {
                    this.fParents.addAll(vItTyp.xGetParents());
                    continue;
                }
                this.fParents.add(vAttr.getRefUri());
            }
        }
        return this.fParents;
    }

    @Override
    public final synchronized IHModule hGetModule(String pCodeModule) throws Exception {
        if (pCodeModule == null) {
            return null;
        }
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        int vMin = 0;
        int vMax = this.fModules.size() - 1;
        while (vMin <= vMax) {
            int vMid = vMin + vMax >> 1;
            IHModule vMidVal = (IHModule)this.fModules.get(vMid);
            int vCompare = vMidVal.hGetCodeModule().compareTo(pCodeModule);
            if (vCompare < 0) {
                vMin = vMid + 1;
                continue;
            }
            if (vCompare > 0) {
                vMax = vMid - 1;
                continue;
            }
            return vMidVal;
        }
        return null;
    }

    @Override
    public final synchronized ISgnModule hGetSgnModule(String pCodeModule, String pSignature) throws Exception {
        if (pCodeModule == null) {
            return null;
        }
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        int vMin = 0;
        int vMax = this.fModules.size() - 1;
        while (vMin <= vMax) {
            int vNewCert;
            int vMid = vMin + vMax >> 1;
            IHModule vMidVal = (IHModule)this.fModules.get(vMid);
            int vCompare = vMidVal.hGetCodeModule().compareTo(pCodeModule);
            if (vCompare < 0) {
                vMin = vMid + 1;
                continue;
            }
            if (vCompare > 0) {
                vMax = vMid - 1;
                continue;
            }
            int vCert = 0;
            ISgnModule vResult = null;
            int vCurIdx = vMid;
            do {
                if (!(vMidVal instanceof ISgnModule)) continue;
                vNewCert = ((ISgnModule)vMidVal).isMatchSgn(pSignature);
                if (vNewCert == Integer.MAX_VALUE) {
                    return (ISgnModule)vMidVal;
                }
                if (vNewCert <= vCert) continue;
                vResult = (ISgnModule)vMidVal;
            } while (vCurIdx != 0 && (vMidVal = (IHModule)this.fModules.get(--vCurIdx)).hGetCodeModule().equals(pCodeModule));
            vCurIdx = vMid + 1;
            do {
                if (!(vMidVal instanceof ISgnModule)) continue;
                vNewCert = ((ISgnModule)vMidVal).isMatchSgn(pSignature);
                if (vNewCert == Integer.MAX_VALUE) {
                    return (ISgnModule)vMidVal;
                }
                if (vNewCert <= vCert) continue;
                vResult = (ISgnModule)vMidVal;
            } while (vCurIdx != vMax && (vMidVal = (IHModule)this.fModules.get(++vCurIdx)).hGetCodeModule().equals(pCodeModule));
            return vResult;
        }
        return null;
    }

    @Override
    public final synchronized IHModule hGetModuleByClass(Class pClasseModule) throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        for (int i = 0; i < this.fModules.size(); ++i) {
            IHModule vModule = (IHModule)this.fModules.get(i);
            if (!pClasseModule.isAssignableFrom(vModule.getClass())) continue;
            return vModule;
        }
        return null;
    }

    @Override
    public final synchronized void hListModulesByClass(List pListToAppend, Class pClasseModule) throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        for (int i = 0; i < this.fModules.size(); ++i) {
            IHModule vModule = (IHModule)this.fModules.get(i);
            if (!pClasseModule.isAssignableFrom(vModule.getClass())) continue;
            pListToAppend.add(vModule);
        }
    }

    @Override
    public final synchronized IHModuleIdentif hGetModuleIdentif() throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        return this.fModuleIdentif;
    }

    @Override
    public final synchronized IHModuleSave hGetModuleSave() throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        return this.fModuleSave;
    }

    @Override
    public final synchronized IHModuleRename hGetModuleRename() throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        return this.fModuleRename;
    }

    @Override
    public final synchronized IHModulePres hGetModulePres() throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        return this.fModulePres;
    }

    @Override
    public int hGetContentStatus() throws Exception {
        return this.fContentStatus;
    }

    @Override
    public final synchronized String hGetItemTypeSignature() throws Exception {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        return this.fItemTypeSignature;
    }

    @Override
    public final boolean hIsWritable() {
        return this.fWsp != null;
    }

    @Override
    public final IRepository hGetRepository() {
        return this.fWsp.hGetRepository();
    }

    @Override
    public final IHWorkspace hGetWorkspace() {
        return this.fWsp;
    }

    @Override
    public final synchronized Iterator hGetCompilProblems() {
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        return this.fCompilProblems == null ? CollectionUtil.emptyIterator() : this.fCompilProblems.iterator();
    }

    @Override
    public final synchronized int hGetCompilStatus() {
        int i;
        if (this.fModules == null) {
            this.xLoadItemType();
        }
        if (!this.fModulesCheckComplete) {
            for (i = 0; i < this.fModules.size(); ++i) {
                IHModule vModule = (IHModule)this.fModules.get(i);
                vModule.wCheckCompilProblems();
            }
            this.fModulesCheckComplete = true;
        }
        if (this.fCompilProblems == null || this.fCompilProblems.size() == 0) {
            return 1;
        }
        for (i = 0; i < this.fCompilProblems.size(); ++i) {
            IHProblem vElem = (IHProblem)this.fCompilProblems.get(i);
            if (vElem.hGetType() != "Error") continue;
            return 3;
        }
        return 2;
    }

    @Override
    public final synchronized void hCompilAgain() {
        this.xReset();
        this.xLoadItemType();
    }

    @Override
    public void wSetModule(String pCodeModule, IHModule pModule) {
        int vMin = 0;
        int vMax = this.fModules.size() - 1;
        while (vMin <= vMax) {
            int vMid = vMin + vMax >> 1;
            int vCompare = ((IHModule)this.fModules.get(vMid)).hGetCodeModule().compareTo(pCodeModule);
            if (vCompare < 0) {
                vMin = vMid + 1;
                continue;
            }
            if (vCompare > 0) {
                vMax = vMid - 1;
                continue;
            }
            if (pModule instanceof ISgnModule) {
                this.fModules.add(vMid, pModule);
            } else {
                this.fModules.set(vMid, pModule);
            }
            return;
        }
        this.fModules.add(vMin, pModule);
    }

    @Override
    public void wAddCompilProblem(IHProblem pProblem) {
        if (this.fCompilProblems == null) {
            this.fCompilProblems = new ArrayList();
        }
        this.fCompilProblems.add(pProblem);
    }

    @Override
    public void wAddUsedItem(String pUriItem) {
        if (this.fWsp != null && !this.fItemUsed.contains(pUriItem)) {
            this.fItemUsed.add(pUriItem);
            this.fWsp.addItemUpdatesListener(pUriItem, this);
        }
    }

    @Override
    public void wRemove() {
        this.xReset();
    }

    @Override
    public void wReset() {
        this.xReset();
        if (sCompilInSynch) {
            this.xLoadItemType();
        }
    }

    @Override
    public void hItemUpdated(HItemUpdatesEvent pEvent) {
        this.xReset();
    }

    protected synchronized void xReset() {
        int i;
        if (this.fModules != null) {
            for (i = 0; i < this.fModules.size(); ++i) {
                IHModule vModule = (IHModule)this.fModules.get(i);
                vModule.wRemove();
            }
        }
        this.fModules = null;
        this.fModuleSave = null;
        this.fModuleIdentif = null;
        this.fModulePres = null;
        this.fModuleRename = null;
        this.fCompilProblems = null;
        this.fParents = null;
        this.fModulesCheckComplete = false;
        this.fCdModuleSave = null;
        this.fCdModuleIdentif = null;
        this.fCdModulePres = null;
        this.fCdModuleRename = null;
        for (i = 0; i < this.fItemUsed.size(); ++i) {
            String vId = this.fItemUsed.get(i);
            this.fWsp.removeItemUpdatesListener(vId, this);
        }
        this.fItemUsed.clear();
    }

    @Override
    public final String hGetCode() {
        return this.fItem.hGetCode();
    }

    @Override
    public final String hGetSpace() {
        return this.fItem.hGetSpace();
    }

    @Override
    public final String getUri() {
        return this.fItem.getUri();
    }

    @Override
    public final String getUriSs() {
        return this.fItem.getUriSs();
    }

    @Override
    public IWspSrc getSrcNode() {
        return this.fItem.getSrcNode();
    }

    @Override
    public final String hGetVersion() {
        return this.fItem.hGetVersion();
    }

    @Override
    public final String hGetVersionComment() {
        return this.fItem.hGetVersionComment();
    }

    @Override
    public final IHItemType hGetItemType() {
        return this.fItem.hGetItemType();
    }

    @Override
    public final List hGetItemTypeParents() throws Exception {
        return this.xGetParents();
    }

    @Override
    public final String hGetTitle() {
        return this.fItem.hGetTitle();
    }

    @Override
    public final String hGetSignature() {
        return this.fItem.hGetSignature();
    }

    @Override
    public final int hGetStatus() {
        return this.fItem.hGetStatus();
    }

    @Override
    public final String hGetUser() {
        return this.fItem.hGetUser();
    }

    @Override
    public final Date hGetModifDt() throws Exception {
        return this.fItem.hGetModifDt();
    }

    @Override
    public final IHAttr hGetAttr(String pSpace, String pName) throws Exception {
        return this.fItem.hGetAttr(pSpace, pName);
    }

    @Override
    public final int hCountAttrs() throws Exception {
        return this.fItem.hCountAttrs();
    }

    @Override
    public final Iterator hGetAttrs() throws Exception {
        return this.fItem.hGetAttrs();
    }

    @Override
    public final Iterator hGetAllProblems() throws Exception {
        return this.fItem.hGetAllProblems();
    }

    @Override
    public final IHProblem hGetContentProblemByCode(String pCode) {
        return this.fItem.hGetContentProblemByCode(pCode);
    }

    @Override
    public final Iterator hGetContentProblems() throws Exception {
        return this.fItem.hGetContentProblems();
    }

    @Override
    public final void hSetItemType(IHItemType pItemType) throws Exception {
        this.fItem.hSetItemType(pItemType);
    }

    @Override
    public final void hSetUser(String pUser) throws Exception {
        this.fItem.hSetUser(pUser);
    }

    @Override
    public final IHAttr hAddAttr(String pType, String pSpace, String pName) throws Exception {
        return this.fItem.hAddAttr(pType, pSpace, pName);
    }

    @Override
    public final int hRemoveAttr(String pSpace, String pName) throws Exception {
        return this.fItem.hRemoveAttr(pSpace, pName);
    }

    @Override
    public final IHProblem hAddContentError(String pCode, String pMessage, String pContent) {
        return this.fItem.hAddContentError(pCode, pMessage, pContent);
    }

    @Override
    public final IHProblem hAddContentWarning(String pCode, String pMessage, String pContent) {
        return this.fItem.hAddContentWarning(pCode, pMessage, pContent);
    }

    @Override
    public final void hRemoveContentProblems() throws Exception {
        this.fItem.hRemoveContentProblems();
    }

    @Override
    public final void hWriteItem(Writer pWriter) throws Exception {
        this.fItem.hWriteItem(pWriter);
    }

    @Override
    public final ContentHandler hCreateSaxContentHandler() {
        return this.fItem.hCreateSaxContentHandler();
    }

    @Override
    public void hAddSubItem(String pId, String pSignature) {
        this.fItem.hAddSubItem(pId, pSignature);
    }

    @Override
    public String hGetSubItemSgn(String pId) throws Exception {
        return this.fItem.hGetSubItemSgn(pId);
    }

    @Override
    public Iterator hGetSubItems() throws Exception {
        return this.fItem.hGetSubItems();
    }

    @Override
    public int hCountSubItems() throws Exception {
        return this.fItem.hCountSubItems();
    }

    protected void xLoadItemType() {
        this.fModules = new ArrayList(12);
        if (this.xLoadItemTypeParse(this, null)) {
            this.xLoadItemTypeEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean xLoadItemTypeParse(HItemType pItemTypeToLoad, IHTransaction pTrans) {
        block19: {
            if (this.fItem.hGetStatus() != 1 && this.fItem.hGetStatus() != 2) {
                pItemTypeToLoad.wAddCompilProblem(new HProblem("Error", "system.itemInvalide", "La feuille de stockage '" + this.getUri() + "' n'est pas dans un \u00e9tat valide.", null));
            } else {
                InputStream vStream = null;
                try {
                    boolean bl;
                    XMLReader vXmlReader;
                    block18: {
                        vXmlReader = HItemType.xGetXmlReader();
                        IHTransaction vTrans = pTrans != null ? pTrans : this.fWsp.hTransactionOpen();
                        try {
                            vStream = this.fWsp.hGetContentAccess().hReadStream(this.fItem, null, null, vTrans);
                            vXmlReader.setContentHandler(this.xCreateItemTypeSaxHanlder(vXmlReader, pItemTypeToLoad, vTrans));
                            vXmlReader.parse(new InputSource(vStream));
                            bl = true;
                            if (pTrans != null) break block18;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (pTrans == null) {
                                    this.fWsp.hTransactionCommit(vTrans);
                                }
                                HItemType.xFreeXmlReader(vXmlReader);
                                throw throwable;
                            }
                            catch (Exception e) {
                                pItemTypeToLoad.wAddCompilProblem(new HProblem("Error", "system.echecCompilation", "Echec \u00e0 la compilation de la feuille de stockage.", LogMgr.getMessage(e).readAsTextFormat(true)));
                                break block19;
                            }
                        }
                        this.fWsp.hTransactionCommit(vTrans);
                    }
                    HItemType.xFreeXmlReader(vXmlReader);
                    return bl;
                }
                finally {
                    if (vStream != null) {
                        try {
                            vStream.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        return false;
    }

    protected void xLoadItemTypeEnd() {
        try {
            IHModule vModule = this.hGetModule(this.fCdModuleIdentif);
            if (vModule != null) {
                if (vModule instanceof IHModuleIdentif) {
                    this.fModuleIdentif = (IHModuleIdentif)vModule;
                } else {
                    this.wAddCompilProblem(new HProblem("Warning", "system.compilItem.moduleIdentifUndefined", "Le module de code '" + this.fCdModuleIdentif + "' d\u00e9fini comme module d'identification par d\u00e9faut n'est pas de type 'identification'.", null));
                }
            }
            if (this.fCdModuleSave != null) {
                vModule = this.hGetModule(this.fCdModuleSave);
                if (vModule != null) {
                    if (vModule instanceof IHModuleSave) {
                        this.fModuleSave = (IHModuleSave)vModule;
                    } else {
                        this.wAddCompilProblem(new HProblem("Warning", "system.compilItem.moduleEnregError", "Le module de code '" + this.fCdModuleSave + "' d\u00e9fini comme module d'enregistrement par d\u00e9faut n'est pas de type 'enregistrement'.", null));
                    }
                } else if (this.fWsp != null) {
                    this.wAddCompilProblem(new HProblem("Warning", "system.compilItem.moduleEnregUndefined", "Le module de code '" + this.fCdModuleSave + "' d\u00e9fini comme module d'enregistrement par d\u00e9faut n'existe pas.", null));
                }
            } else {
                this.fModuleSave = new HModuleSave(this, "");
            }
            if (this.fCdModuleRename != null) {
                vModule = this.hGetModule(this.fCdModuleRename);
                if (vModule != null) {
                    if (vModule instanceof IHModuleRename) {
                        this.fModuleRename = (IHModuleRename)vModule;
                    } else {
                        this.wAddCompilProblem(new HProblem("Warning", "system.compilItem.moduleRenameUndefined", "Le module de code '" + this.fCdModuleRename + "' d\u00e9fini comme module de renommage par d\u00e9faut n'est pas de type 'Renommage'.", null));
                    }
                }
            } else {
                this.fModuleRename = (IHModuleRename)this.hGetModuleByClass(IHModuleRename.class);
            }
            if (this.fCdModulePres != null) {
                vModule = this.hGetModule(this.fCdModulePres);
                if (vModule != null) {
                    if (vModule instanceof IHModulePres) {
                        this.fModulePres = (IHModulePres)vModule;
                    } else {
                        this.wAddCompilProblem(new HProblem("Warning", "system.compilItem.modulePresUndefined", "Le module de code '" + this.fCdModulePres + "' d\u00e9fini comme module de pr\u00e9sentation par d\u00e9faut n'est pas de type 'Pr\u00e9sentation'.", null));
                    }
                }
            } else {
                this.fModulePres = (IHModulePres)this.hGetModuleByClass(IHModulePres.class);
            }
            for (int i = 0; i < this.fModules.size(); ++i) {
                vModule = (IHModule)this.fModules.get(i);
                vModule.wLinkModules();
            }
        }
        catch (Exception e) {
            this.wAddCompilProblem(new HProblem("Error", "system.echecCompilation", "Echec \u00e0 la compilation de la feuille de stockage.", LogMgr.getMessage(e).readAsTextFormat(true)));
        }
    }

    protected ContentHandler xCreateItemTypeSaxHanlder(XMLReader pXmlReader, HItemType pItemTypeToLoad, IHTransaction pTrans) {
        return new XItemTypeSaxHandler(pXmlReader, pItemTypeToLoad, pTrans);
    }

    public String toString() {
        return "<itemType>" + this.fItem + "</itemType>";
    }

    protected static final XMLReader xGetXmlReader() throws Exception {
        return HPoolXmlReader.hGet().hGetXmlReader(true, false);
    }

    protected static final void xFreeXmlReader(XMLReader pReader) {
        HPoolXmlReader.hGet().hFreeXmlReader(pReader);
    }

    protected void xSetItemTypeSgn(String pSgn) {
        this.fItemTypeSignature = pSgn != null ? pSgn.intern() : null;
    }

    public void setContentStatus(int pContentStatus) {
        this.fContentStatus = pContentStatus;
    }
}

