/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.itemtype.fs;

import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.base.HProblem;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.m.bdp.itemtype.HItemType;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.itemtype.fs.XItemTypeFsSaxHandler;
import com.scenari.m.bdp.transaction.IHTransaction;
import eu.scenari.fw.log.LogMgr;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class HItemTypeFs
extends HItemType {
    protected List<IValidPtr> fValidLinks = null;
    protected String[] fOverlaySs = null;

    public HItemTypeFs(IHWorkspace pWsp, IHItem pItem, String[] pOverlaySs) {
        super(pWsp, pItem);
        this.fOverlaySs = pOverlaySs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wValidLinks(String pNameNs, String pName, XItemCache.XLink pLink, XItemCache pPtdItem) throws Exception {
        HItemTypeFs hItemTypeFs = this;
        synchronized (hItemTypeFs) {
            if (this.fModules == null) {
                this.xLoadItemType();
            }
        }
        List<IValidPtr> vList = this.fValidLinks;
        if (vList != null) {
            for (IValidPtr vValidPtr : vList) {
                vValidPtr.validPtr(pNameNs, pName, pLink, pPtdItem);
            }
        }
    }

    public void wAddValidLink(IValidPtr pValidPtr) {
        if (this.fValidLinks == null) {
            this.fValidLinks = new ArrayList<IValidPtr>(6);
        }
        this.fValidLinks.add(pValidPtr);
    }

    protected synchronized void xReset() {
        this.fValidLinks = null;
        super.xReset();
    }

    protected ContentHandler xCreateItemTypeSaxHanlder(XMLReader pXmlReader, HItemType pItemTypeToLoad, IHTransaction pTrans) {
        return new XItemTypeFsSaxHandler(pXmlReader, pItemTypeToLoad, pTrans, pItemTypeToLoad == this);
    }

    protected void xLoadItemType() {
        this.fModules = new ArrayList(12);
        if (this.xLoadItemTypeParse(this, null)) {
            if (this.fOverlaySs != null && this.fOverlaySs.length > 0) {
                try {
                    XMLReader vXmlReader = HItemTypeFs.xGetXmlReader();
                    vXmlReader.setContentHandler(this.xCreateItemTypeSaxHanlder(vXmlReader, this, null));
                    for (String vOverlay : this.fOverlaySs) {
                        vXmlReader.parse(new InputSource(new StringReader(vOverlay)));
                    }
                    HItemTypeFs.xFreeXmlReader(vXmlReader);
                }
                catch (Exception e) {
                    this.wAddCompilProblem(new HProblem("Error", "system.echecCompilation", "Echec \u00e0 la compilation de la feuille de stockage.", LogMgr.getMessage(e).readAsTextFormat(true)));
                }
            }
            this.xLoadItemTypeEnd();
        }
    }

    public static class ValidPtrMatchSgn
    extends ValidPtrOnAttr {
        protected Pattern fRegexSgn = null;

        protected void xValidPtr(String pNameNs, String pName, XItemCache.XLink pLink, XItemCache pPtdItem) throws Exception {
            IHItemType vItemType;
            if (this.fRegexSgn == null) {
                return;
            }
            String vSgn = null;
            if (pPtdItem != null && (vSgn = pPtdItem.hGetSignature()) == null && (vItemType = pPtdItem.getItemType()) != null) {
                vSgn = vItemType.hGetItemTypeSignature();
            }
            if (vSgn == null || !this.fRegexSgn.matcher(vSgn).matches()) {
                this.xAddProblem(pLink);
            }
        }

        public void wSetRegexSgn(String pRegex) {
            if (pRegex == null || pRegex.length() == 0) {
                return;
            }
            this.fRegexSgn = Pattern.compile(pRegex);
        }
    }

    public static class ValidPtrIfNull
    extends ValidPtrOnAttr {
        protected void xValidPtr(String pNameNs, String pName, XItemCache.XLink pLink, XItemCache pPtdItem) throws Exception {
            if (pPtdItem == null || pPtdItem.hIsNull()) {
                this.xAddProblem(pLink);
            }
        }
    }

    public static abstract class ValidPtrOnAttr
    implements IValidPtr {
        protected String fNs = null;
        protected String fNm = null;
        protected Pattern fRegexNs = null;
        protected Pattern fRegexNm = null;
        protected String fPbType = null;
        protected String fPbCode = null;
        protected String fPbMsg = null;
        protected String fPbContent = null;

        public void validPtr(String pNameNs, String pName, XItemCache.XLink pLink, XItemCache pPtdItem) throws Exception {
            if (!(this.fNm == null || pName != null && this.fNm.equals(pName))) {
                return;
            }
            if (!(this.fNs == null || pNameNs != null && this.fNs.equals(pNameNs))) {
                return;
            }
            if (!(this.fRegexNm == null || pName != null && this.fRegexNm.matcher(pName).matches())) {
                return;
            }
            if (!(this.fRegexNs == null || pNameNs != null && this.fRegexNs.matcher(pNameNs).matches())) {
                return;
            }
            this.xValidPtr(pNameNs, pName, pLink, pPtdItem);
        }

        protected abstract void xValidPtr(String var1, String var2, XItemCache.XLink var3, XItemCache var4) throws Exception;

        protected void xAddProblem(XItemCache.XLink pLink) {
            pLink.addProblem(this.fPbType, this.fPbCode, this.fPbMsg, this.fPbContent);
        }

        public void wSetRegexNm(String pRegex) {
            if (pRegex == null || pRegex.length() == 0) {
                return;
            }
            this.fRegexNm = Pattern.compile(pRegex);
        }

        public void wSetRegexNs(String pRegex) {
            if (pRegex == null || pRegex.length() == 0) {
                return;
            }
            this.fRegexNs = Pattern.compile(pRegex);
        }
    }

    public static class ValidPtrParent
    implements IValidPtr {
        protected String fUriParent = null;
        protected HItemTypeFs fItemTypeFrom = null;

        public ValidPtrParent(HItemTypeFs pItemTypeFrom, String pUriParent) {
            this.fUriParent = pUriParent;
            this.fItemTypeFrom = pItemTypeFrom;
        }

        public void validPtr(String pNameNs, String pName, XItemCache.XLink pLink, XItemCache pPtdItem) throws Exception {
            HItemTypeFs vItemType = (HItemTypeFs)this.fItemTypeFrom.fWsp.hGetItemType(this.fUriParent);
            vItemType.wValidLinks(pNameNs, pName, pLink, pPtdItem);
        }
    }

    public static interface IValidPtr {
        public void validPtr(String var1, String var2, XItemCache.XLink var3, XItemCache var4) throws Exception;
    }
}

