/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.fulltext;

import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.HModule;
import com.scenari.m.bdp.module.fulltext.IModuleFullText;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import com.scenari.src.search.exp.FullText;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleFullTextXmlTransform
extends HModule
implements IModuleFullText {
    protected static HTransformParams sTransformParams = HTransformParams.hNewParamsTransformOfType("xml2fulltext");
    protected String fUriRes = null;

    public ModuleFullTextXmlTransform(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullText.FullTextResults match(IHItemDef pItemDef, String[] pWords, boolean pAddPreviews) throws Exception {
        ISrcNode vFromNode = this.fUriRes != null && this.fUriRes.length() > 0 ? SrcFeaturePaths.findNodeByPath(pItemDef.getSrcNode(), this.fUriRes.substring(1), false) : pItemDef.getSrcNode();
        ISrcNode vStreamToMatch = SrcFeatureTransform.transformAsNode(vFromNode, sTransformParams, false);
        if (vStreamToMatch == null || vStreamToMatch.getContentSize() == 0) {
            return null;
        }
        ByteBuffer vByteBuff = ByteBuffer.allocate(vStreamToMatch.getContentSize());
        InputStream vIn = vStreamToMatch.newInputStream(false);
        try {
            vIn.read(vByteBuff.array());
        }
        finally {
            vIn.close();
        }
        CharBuffer vCharBuff = vByteBuff.asCharBuffer();
        StringBuilder vRegexp = new StringBuilder();
        int vLast = pWords.length - 1;
        for (int i = 0; i <= vLast; ++i) {
            vRegexp.append(Pattern.quote(pWords[i]));
            if (i >= vLast) continue;
            vRegexp.append('|');
        }
        Pattern vPattern = Pattern.compile(vRegexp.toString(), 2);
        Matcher vMatcher = vPattern.matcher(vCharBuff);
        FullText.FullTextResults vResults = null;
        int vCount = 0;
        ArrayList<String> vPreviews = null;
        while (vMatcher.find()) {
            int vPrev;
            ++vCount;
            if (!pAddPreviews) continue;
            if (vPreviews == null) {
                vPreviews = new ArrayList<String>();
            }
            int vStart = vMatcher.start();
            for (int i = 0; i < 50 && (vPrev = vStart - 1) >= 0 && vCharBuff.charAt(vPrev) != '\n'; ++i) {
                vStart = vPrev;
            }
            int vEnd = vMatcher.end();
            for (int i = 0; i < 50 && vEnd != vCharBuff.capacity() && vCharBuff.charAt(vEnd) != '\n'; ++vEnd, ++i) {
            }
            String vPreviewStr = ((Object)vCharBuff.subSequence(vStart, vEnd)).toString();
            vPreviews.add(vPreviewStr);
        }
        if (vCount > 0) {
            vResults = new FullText.FullTextResults();
            vResults.setScore(vCount);
            vResults.setPreviews(vPreviews);
        }
        return vResults;
    }

    public void xSetUriRes(String pUriRes) {
        this.fUriRes = pUriRes;
    }
}

