/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.genpresc;

import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.base.HProblem;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.HModule;
import com.scenari.m.bdp.module.genpresc.IHModuleGenPresc;
import com.scenari.m.co.prescription.IWPrescription;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.univers.wsp.IContentMgrWsp;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.generator.ISkin;
import com.scenari.m.ge.generator.web.WebGenerator;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.relocate.SrcFeatureRelocate;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mem.IMemoryOwner;
import eu.scenari.fw.mem.MemoryMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class HModuleGenPrescWsp
extends HModule
implements IHModuleGenPresc,
IMemoryOwner {
    protected String fIntitule = null;
    protected String fUiiJeuFc = null;
    protected String fIhmGenerator = null;
    protected String fUiiIhm = null;
    protected Pattern fPatternCompRoot = null;
    protected Pattern fPatternCompTypeRoot = null;
    protected Class fClassGenerator = null;
    protected ArrayList fPoolGenerators = new ArrayList();
    protected boolean fIsInstanceItem = false;
    protected Map<String, ISkin> fSkins = null;

    public HModuleGenPrescWsp(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule);
    }

    public String getGeneratorCode() {
        return this.hGetCodeModule();
    }

    public String getGeneratorTitle() {
        return this.fIntitule;
    }

    public IWPrescription hGetPrescription(IHItemDef pItemContent) throws Exception {
        IWUnivers vUniverse = this.hGetItemType().hGetRepository().getUniverse();
        return ((IContentMgrWsp)vUniverse.hGetContenuMgr()).hGetPrescriptionWsp(this.hCreateUriFc(), this.hCreateUriCo(pItemContent), this.fPatternCompRoot, this.fPatternCompTypeRoot, this.getGeneratorTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenerator popGenerator() throws Exception {
        IGenerator vResult = null;
        ArrayList arrayList = this.fPoolGenerators;
        synchronized (arrayList) {
            int vSize = this.fPoolGenerators.size();
            if (vSize > 0) {
                vResult = (IGenerator)this.fPoolGenerators.remove(vSize - 1);
            } else {
                vResult = (IGenerator)this.fClassGenerator.newInstance();
                vResult.setPubRoot(SrcFeatureRelocate.relocateAsRoot(this.hGetItemType().hGetWorkspace().findNodeByUri(this.fUiiIhm)));
                vResult.setMapSkins(this.fSkins);
            }
        }
        return vResult;
    }

    public void freeGenerator(IGenerator pGenerator) {
        if (pGenerator != null) {
            try {
                pGenerator.reset();
                this.fPoolGenerators.add(pGenerator);
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }

    public boolean hIsItemInstance() {
        return this.fIsInstanceItem;
    }

    public String hCreateUriCo(IHItemDef pItem) throws Exception {
        String vWsp = pItem.hGetWorkspace().hGetCodeWorkspace();
        StringBuilder vBuf = new StringBuilder(pItem.getUri().length() + vWsp.length() + 1);
        vBuf.append('/');
        vBuf.append(vWsp);
        vBuf.append(pItem.getUri());
        return vBuf.toString();
    }

    public String hCreateUriFc() throws Exception {
        StringBuilder vBuf = new StringBuilder(this.fUiiJeuFc.length() + 48);
        vBuf.append('/');
        vBuf.append(this.hGetItemType().hGetWorkspace().hGetCodeWorkspace());
        vBuf.append(this.fUiiJeuFc);
        return vBuf.toString();
    }

    public void wLinkModules() {
        if (this.fIhmGenerator != null && this.fIhmGenerator.length() > 0) {
            try {
                this.fClassGenerator = Class.forName(this.fIhmGenerator);
            }
            catch (Throwable e) {
                this.fItemType.wAddCompilProblem(new HProblem("Error", "system.genpresc.generatornotfound", "La classe g\u00e9n\u00e9rateur '" + this.fIhmGenerator + "' d\u00e9finie dans le module '" + this.hGetCodeModule() + "' est introuvale.", LogMgr.getMessage(e).readAsTextFormat(true)));
            }
            if (this.fClassGenerator != null && !IGenerator.class.isAssignableFrom(this.fClassGenerator)) {
                this.fItemType.wAddCompilProblem(new HProblem("Error", "system.genpresc.classerror", "La classe '" + this.fIhmGenerator + "' d\u00e9finie dans le module '" + this.hGetCodeModule() + "' n'est pas de type g\u00e9n\u00e9rateur.", null));
            }
        }
        if (this.fClassGenerator == null) {
            this.fClassGenerator = WebGenerator.class;
        }
        MemoryMgr.registerMemoryOwner(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long freeMemory(int pPriority) throws Exception {
        long vResult = 0L;
        int vNbMax = 10 - pPriority;
        ArrayList arrayList = this.fPoolGenerators;
        synchronized (arrayList) {
            for (int i = this.fPoolGenerators.size() - 1; i >= vNbMax; --i) {
                this.fPoolGenerators.remove(i);
                vResult += 200000L;
            }
        }
        return vResult;
    }

    public void wRemove() {
        MemoryMgr.unregisterMemoryOwner(this);
    }

    public void xSetUiiJeuFc(String pUiiJeuFc) {
        this.fUiiJeuFc = pUiiJeuFc;
    }

    public void xSetIhmGenerator(String pIhmGenerator) {
        this.fIhmGenerator = pIhmGenerator;
    }

    public void xSetUiiIhm(String pUiiIhm) {
        this.fUiiIhm = pUiiIhm;
    }

    public void xSetIsInstanceItem(String pIsInstItem) {
        this.fIsInstanceItem = pIsInstItem != null && pIsInstItem.equals("true");
    }

    public void xSetPatternCompRoot(String pPattern) {
        if (pPattern != null) {
            this.fPatternCompRoot = Pattern.compile(pPattern);
        }
    }

    public void xSetPatternCompTypeRoot(String pPattern) {
        if (pPattern != null) {
            this.fPatternCompTypeRoot = Pattern.compile(pPattern);
        }
    }

    public Skin xAddSkin(String pCode, String pTitle, String pSkinUri, String pOwner) {
        if (this.fSkins == null) {
            this.fSkins = new HashMap<String, ISkin>();
        }
        Skin vSkin = new Skin(pCode, pTitle, pSkinUri, pOwner);
        this.fSkins.put(pCode, vSkin);
        return vSkin;
    }

    public class Skin
    implements ISkin {
        protected String fCode = null;
        protected String fTitle = null;
        protected String fSkinUri = null;
        protected String fOwner = null;

        public Skin(String pCode, String pTitle, String pSkinUri, String pOwner) {
            this.fCode = pCode;
            this.fTitle = pTitle;
            this.fSkinUri = pSkinUri;
            this.fOwner = pOwner;
        }

        public String getCode() {
            return this.fCode;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public String getSkinUri() {
            return this.fSkinUri;
        }

        public String getOwner() {
            return this.fOwner;
        }

        public ISrcNode getSkinSrc() throws Exception {
            return SrcFeatureRelocate.relocateAsRoot(HModuleGenPrescWsp.this.hGetItemType().hGetWorkspace().findNodeByUri(this.fSkinUri));
        }

        public void setSkinUri(String pSkinUri) {
            this.fSkinUri = pSkinUri;
        }
    }
}

