/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.identif;

import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.identif.IHModuleIdentif;
import com.scenari.m.bdp.module.save.HStreamHandler;
import com.scenari.xsldtm.xml.dtm.DTM;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTreatIdentif {
    public static TracePoint sTrace = TraceMgr.register(HTreatIdentif.class.getName(), "Trace l'identification d'un item.");

    public static final IHItemType findItemType(IHWorkspace pWsp, String pUri, String pContentType, HStreamHandler pStream) throws Exception {
        IHItemType vResult = null;
        try {
            String vName;
            ArrayList<XSol> vListItemTypes = null;
            boolean vSomeAreXmlType = false;
            String string = vName = pUri != null ? HQCode.hGetCodeFromUri(pUri) : null;
            block10: while (vListItemTypes == null) {
                try {
                    vListItemTypes = new ArrayList<XSol>(32);
                    Iterator vIt = pWsp.hGetItemTypes();
                    while (vIt.hasNext()) {
                        IHItemType vItemType = (IHItemType)vIt.next();
                        try {
                            IHModuleIdentif vIdentif = vItemType.hGetModuleIdentif();
                            if (vIdentif == null) continue;
                            int vMatch = vIdentif.hMatchName(pUri, vName, pContentType);
                            if (vMatch == Integer.MAX_VALUE) {
                                vResult = vItemType;
                                continue block10;
                            }
                            if (vMatch == 0) continue;
                            vListItemTypes.add(new XSol(vMatch, vItemType));
                            if (vSomeAreXmlType) continue;
                            vSomeAreXmlType = vIdentif.hIsXmlType();
                        }
                        catch (Exception e) {
                            if (!sTrace.isEnabled()) continue;
                            LogMgr.publishException((Throwable)e, "Anomalie lors de l'identification d'un item par son nom (" + pUri + ") dans le module : " + vItemType, new String[0]);
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    vListItemTypes = null;
                }
            }
            if (vResult == null && pStream != null && vSomeAreXmlType && vListItemTypes != null) {
                DTM vDtm = pStream.getDtm(pUri);
                if (vDtm != null) {
                    int vResMatch;
                    IHItemType vItemType;
                    XSol vSol;
                    int vElemRoot = vDtm.getFirstChild(vDtm.getDocument());
                    while (vElemRoot != -1 && vDtm.getNodeType(vElemRoot) != 1) {
                        vElemRoot = vDtm.getNextSibling(vElemRoot);
                    }
                    String vTagRoot = vDtm.getNodeName(vElemRoot);
                    String vTagRootNs = vDtm.getNamespaceURI(vElemRoot);
                    String vLocalName = vDtm.getLocalName(vElemRoot);
                    int i = 0;
                    while (i < vListItemTypes.size()) {
                        block36: {
                            vSol = (XSol)vListItemTypes.get(i);
                            vItemType = vSol.fItemType;
                            vResMatch = 0;
                            try {
                                vResMatch = vItemType.hGetModuleIdentif().hMatchXmlTagRoot(vTagRoot, vTagRootNs, vLocalName);
                            }
                            catch (Exception e) {
                                if (!sTrace.isEnabled()) break block36;
                                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'identification du type d'item par le tag racine de l'item " + pUri + " avec le module " + vItemType, new String[0]);
                            }
                        }
                        if (vResMatch == 0) {
                            vListItemTypes.remove(i);
                            continue;
                        }
                        if (vResMatch == Integer.MAX_VALUE) {
                            vResult = vItemType;
                            break;
                        }
                        if (vResMatch > vSol.fResultMatch) {
                            vSol.fResultMatch = vResMatch;
                        }
                        ++i;
                    }
                    if (vResult == null && vListItemTypes != null) {
                        i = 0;
                        while (i < vListItemTypes.size()) {
                            block37: {
                                vSol = (XSol)vListItemTypes.get(i);
                                vItemType = vSol.fItemType;
                                vResMatch = 0;
                                try {
                                    vResMatch = vItemType.hGetModuleIdentif().hMatchXpath(pStream.getXPathContext(), vDtm);
                                }
                                catch (Exception e) {
                                    if (!sTrace.isEnabled()) break block37;
                                    LogMgr.publishException((Throwable)e, "Echec \u00e0 l'execution de la requete XPath pour identifier l'item " + pUri + " avec le module " + vItemType, new String[0]);
                                }
                            }
                            if (vResMatch == 0) {
                                vListItemTypes.remove(i);
                                continue;
                            }
                            if (vResMatch == Integer.MAX_VALUE) {
                                vResult = vItemType;
                                break;
                            }
                            if (vResMatch > vSol.fResultMatch) {
                                vSol.fResultMatch = vResMatch;
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while (i < vListItemTypes.size()) {
                        XSol vSol = (XSol)vListItemTypes.get(i);
                        if (vSol.fItemType.hGetModuleIdentif().hIsXmlType()) {
                            vListItemTypes.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
            }
            if (vResult == null && pStream != null && vListItemTypes != null) {
                int i = 0;
                while (i < vListItemTypes.size()) {
                    XSol vSol = (XSol)vListItemTypes.get(i);
                    IHItemType vItemType = vSol.fItemType;
                    int vResMatch = vItemType.hGetModuleIdentif().hMatchStream(pStream.hGetCachedInputStream());
                    if (vResMatch == 0) {
                        vListItemTypes.remove(i);
                        continue;
                    }
                    if (vResMatch == Integer.MAX_VALUE) {
                        vResult = vItemType;
                        break;
                    }
                    if (vResMatch > vSol.fResultMatch) {
                        vSol.fResultMatch = vResMatch;
                    }
                    ++i;
                }
            }
            if (vResult == null && vListItemTypes != null && vListItemTypes.size() > 0) {
                int vIdxMax = 0;
                int vMaxRes = 0;
                for (int i = 0; i < vListItemTypes.size(); ++i) {
                    XSol vSol = (XSol)vListItemTypes.get(i);
                    if (vSol.fResultMatch <= vMaxRes) continue;
                    vIdxMax = i;
                    vMaxRes = vSol.fResultMatch;
                }
                vResult = ((XSol)vListItemTypes.get((int)vIdxMax)).fItemType;
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec lors de l'identification de l'item.", new String[0]);
        }
        if (vResult == null && sTrace.isEnabled()) {
            sTrace.publishError("Aucun type d'item trouv\u00e9 pour le fichier " + pUri + ".", new String[0]);
        }
        return vResult;
    }

    public static final List<IHItemType> findItemTypes(IHWorkspace pWsp, String pUri, String pContentType, HStreamHandler pStream) throws Exception {
        ArrayList<IHItemType> vResult = new ArrayList<IHItemType>();
        try {
            XSol vSol;
            String vName;
            ArrayList<XSol> vListSol = null;
            boolean vSomeAreXmlType = false;
            String string = vName = pUri != null ? HQCode.hGetCodeFromUri(pUri) : null;
            while (vListSol == null) {
                try {
                    vListSol = new ArrayList<XSol>(64);
                    Iterator vIt = pWsp.hGetItemTypes();
                    while (vIt.hasNext()) {
                        IHItemType vItemType = (IHItemType)vIt.next();
                        try {
                            int vMatch;
                            IHModuleIdentif vIdentif = vItemType.hGetModuleIdentif();
                            if (vIdentif == null || (vMatch = vIdentif.hMatchName(pUri, vName, pContentType)) == 0) continue;
                            vListSol.add(new XSol(vMatch, vItemType));
                            if (vSomeAreXmlType) continue;
                            vSomeAreXmlType = vIdentif.hIsXmlType();
                        }
                        catch (Exception e) {
                            if (!sTrace.isEnabled()) continue;
                            LogMgr.publishException((Throwable)e, "Anomalie lors de l'identification d'un item par son nom (" + pUri + ") dans le module : " + vItemType, new String[0]);
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    vListSol = null;
                }
            }
            if (pStream != null && vSomeAreXmlType) {
                DTM vDtm = pStream.getDtm(pUri);
                if (vDtm != null) {
                    int vResMatch;
                    IHItemType vItemType;
                    XSol vSol2;
                    int vElemRoot = vDtm.getFirstChild(vDtm.getDocument());
                    while (vElemRoot != -1 && vDtm.getNodeType(vElemRoot) != 1) {
                        vElemRoot = vDtm.getNextSibling(vElemRoot);
                    }
                    String vTagRoot = vDtm.getNodeName(vElemRoot);
                    String vTagRootNs = vDtm.getNamespaceURI(vElemRoot);
                    String vLocalName = vDtm.getLocalName(vElemRoot);
                    int i = 0;
                    while (i < vListSol.size()) {
                        block31: {
                            vSol2 = (XSol)vListSol.get(i);
                            vItemType = vSol2.fItemType;
                            vResMatch = 0;
                            try {
                                vResMatch = vItemType.hGetModuleIdentif().hMatchXmlTagRoot(vTagRoot, vTagRootNs, vLocalName);
                            }
                            catch (Exception e) {
                                if (!sTrace.isEnabled()) break block31;
                                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'identification du type d'item par le tag racine de l'item " + pUri + " avec le module " + vItemType, new String[0]);
                            }
                        }
                        if (vResMatch == 0) {
                            vListSol.remove(i);
                            continue;
                        }
                        if (vResMatch > vSol2.fResultMatch) {
                            vSol2.fResultMatch = vResMatch;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < vListSol.size()) {
                        block32: {
                            vSol2 = (XSol)vListSol.get(i);
                            vItemType = vSol2.fItemType;
                            vResMatch = 0;
                            try {
                                vResMatch = vItemType.hGetModuleIdentif().hMatchXpath(pStream.getXPathContext(), vDtm);
                            }
                            catch (Exception e) {
                                if (!sTrace.isEnabled()) break block32;
                                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'execution de la requete XPath pour identifier l'item " + pUri + " avec le module " + vItemType, new String[0]);
                            }
                        }
                        if (vResMatch == 0) {
                            vListSol.remove(i);
                            continue;
                        }
                        if (vResMatch > vSol2.fResultMatch) {
                            vSol2.fResultMatch = vResMatch;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < vListSol.size()) {
                        vSol = (XSol)vListSol.get(i);
                        if (vSol.fItemType.hGetModuleIdentif().hIsXmlType()) {
                            vListSol.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
            }
            if (pStream != null) {
                int i = 0;
                while (i < vListSol.size()) {
                    XSol vSol3 = (XSol)vListSol.get(i);
                    IHItemType vItemType = vSol3.fItemType;
                    int vResMatch = vItemType.hGetModuleIdentif().hMatchStream(pStream.hGetCachedInputStream());
                    if (vResMatch == 0) {
                        vListSol.remove(i);
                        continue;
                    }
                    if (vResMatch > vSol3.fResultMatch) {
                        vSol3.fResultMatch = vResMatch;
                    }
                    ++i;
                }
            }
            if (vListSol.size() > 0) {
                int i;
                int vMaxRes = 0;
                for (i = 0; i < vListSol.size(); ++i) {
                    vSol = (XSol)vListSol.get(i);
                    if (vSol.fResultMatch <= vMaxRes) continue;
                    vMaxRes = vSol.fResultMatch;
                }
                for (i = 0; i < vListSol.size(); ++i) {
                    vSol = (XSol)vListSol.get(i);
                    if (vSol.fResultMatch != vMaxRes) continue;
                    vResult.add(vSol.fItemType);
                }
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec lors de l'identification de l'item.", new String[0]);
        }
        return vResult;
    }

    public static final List<IHItemType> findAllItemTypes(IHWorkspace pWsp, String pUri, String pContentType, HStreamHandler pStream) throws Exception {
        ArrayList<IHItemType> vListItemTypes = null;
        try {
            String vName;
            boolean vSomeAreXmlType = false;
            String string = vName = pUri != null ? HQCode.hGetCodeFromUri(pUri) : null;
            while (vListItemTypes == null) {
                try {
                    vListItemTypes = new ArrayList<IHItemType>(64);
                    Iterator vIt = pWsp.hGetItemTypes();
                    while (vIt.hasNext()) {
                        IHItemType vItemType = (IHItemType)vIt.next();
                        try {
                            int vMatch;
                            IHModuleIdentif vIdentif = vItemType.hGetModuleIdentif();
                            if (vIdentif == null || (vMatch = vIdentif.hMatchName(pUri, vName, pContentType)) == 0) continue;
                            vListItemTypes.add(vItemType);
                            if (vSomeAreXmlType) continue;
                            vSomeAreXmlType = vIdentif.hIsXmlType();
                        }
                        catch (Exception e) {
                            if (!sTrace.isEnabled()) continue;
                            LogMgr.publishException((Throwable)e, "Anomalie lors de l'identification d'un item par son nom (" + pUri + ") dans le module : " + vItemType, new String[0]);
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    vListItemTypes = null;
                }
            }
            if (pStream != null && vSomeAreXmlType && vListItemTypes != null) {
                DTM vDtm = pStream.getDtm(pUri);
                if (vDtm != null) {
                    int vResMatch;
                    IHItemType vItemType;
                    int vElemRoot = vDtm.getFirstChild(vDtm.getDocument());
                    while (vElemRoot != -1 && vDtm.getNodeType(vElemRoot) != 1) {
                        vElemRoot = vDtm.getNextSibling(vElemRoot);
                    }
                    String vTagRoot = vDtm.getNodeName(vElemRoot);
                    String vTagRootNs = vDtm.getNamespaceURI(vElemRoot);
                    String vLocalName = vDtm.getLocalName(vElemRoot);
                    int i = 0;
                    while (i < vListItemTypes.size()) {
                        block25: {
                            vItemType = vListItemTypes.get(i);
                            vResMatch = 0;
                            try {
                                vResMatch = vItemType.hGetModuleIdentif().hMatchXmlTagRoot(vTagRoot, vTagRootNs, vLocalName);
                            }
                            catch (Exception e) {
                                if (!sTrace.isEnabled()) break block25;
                                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'identification du type d'item par le tag racine de l'item " + pUri + " avec le module " + vItemType, new String[0]);
                            }
                        }
                        if (vResMatch == 0) {
                            vListItemTypes.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < vListItemTypes.size()) {
                        block26: {
                            vItemType = vListItemTypes.get(i);
                            vResMatch = 0;
                            try {
                                vResMatch = vItemType.hGetModuleIdentif().hMatchXpath(pStream.getXPathContext(), vDtm);
                            }
                            catch (Exception e) {
                                if (!sTrace.isEnabled()) break block26;
                                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'execution de la requete XPath pour identifier l'item " + pUri + " avec le module " + vItemType, new String[0]);
                            }
                        }
                        if (vResMatch == 0) {
                            vListItemTypes.remove(i);
                            continue;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < vListItemTypes.size()) {
                        IHItemType vItemType = vListItemTypes.get(i);
                        if (vItemType.hGetModuleIdentif().hIsXmlType()) {
                            vListItemTypes.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
            }
            if (pStream != null && vListItemTypes != null) {
                int i = 0;
                while (i < vListItemTypes.size()) {
                    IHItemType vItemType = vListItemTypes.get(i);
                    int vResMatch = vItemType.hGetModuleIdentif().hMatchStream(pStream.hGetCachedInputStream());
                    if (vResMatch == 0) {
                        vListItemTypes.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec lors de l'identification de l'item.", new String[0]);
        }
        return vListItemTypes;
    }

    protected static class XSol {
        protected int fResultMatch;
        protected IHItemType fItemType;

        public XSol(int pResMath, IHItemType pItemType) {
            this.fResultMatch = pResMath;
            this.fItemType = pItemType;
        }

        public String toString() {
            return this.fItemType.getUri() + "(" + this.fResultMatch + ")";
        }
    }
}

