/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.rename;

import com.scenari.m.bdp.module.rename.HRenamingPlan;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.uris.SrcFeatureUris;
import eu.scenari.fw.log.LogMgr;

public class HRenamingPlanItem
extends HRenamingPlan {
    protected String fOldUri = null;
    protected String fOldId = null;
    protected String fNewUri = null;
    protected String fNewId = null;
    protected IHRenamingPlan fChainedRenamingPlan = null;

    public HRenamingPlanItem(String pOldUri, String pOldId, String pNewUri, String pNewId) {
        this(pOldUri, pOldId, pNewUri, pNewId, null);
    }

    public HRenamingPlanItem(String pOldUri, String pOldId, String pNewUri, String pNewId, IHRenamingPlan pChainedRenamingPlan) {
        this.fOldUri = pOldUri;
        this.fOldId = pOldId;
        this.fNewUri = pNewUri;
        this.fNewId = pNewId;
        this.fChainedRenamingPlan = pChainedRenamingPlan;
    }

    public String getNewRefUri(String pOldRefUri) {
        try {
            if (pOldRefUri == null || pOldRefUri.length() == 0) {
                return "";
            }
            if (SrcFeatureIds.isSrcId(pOldRefUri)) {
                if (this.fOldId != null && pOldRefUri.equals(this.fOldId)) {
                    if (this.fNewId != null) {
                        return this.fNewId;
                    }
                    return this.fNewUri;
                }
            } else if (pOldRefUri.equals(this.fOldUri)) {
                return this.fNewUri;
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        return this.fChainedRenamingPlan != null ? this.fChainedRenamingPlan.getNewRefUri(pOldRefUri) : pOldRefUri;
    }

    public boolean isInPlan(String pUri) {
        if (pUri == null) {
            return false;
        }
        if (SrcFeatureUris.isAncestorOrSameUri(this.fOldUri, pUri)) {
            return true;
        }
        return this.fChainedRenamingPlan != null ? this.fChainedRenamingPlan.isInPlan(pUri) : false;
    }
}

